/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ri.impl;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.constants.OIDConstants;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import java.io.IOException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestrictedIdentification {
    private static final byte[] FIRST_ID_TAG = new byte[]{-127};
    private static final byte[] SECOND_ID_TAG = new byte[]{-125};
    private static final String FIRST_KEY_TAG = "A0";
    private static final String SECOND_KEY_TAG = "A2";
    private EPA epaService = null;
    private SecurityInfos.RestrictedIdentificationInfo riInfo = null;
    private String expectedIDLength = null;
    private Log log;
    private byte[] firstID = null;
    private byte[] secondID = null;
    private boolean success = false;

    public RestrictedIdentification(EPA epaService, SecurityInfos.RestrictedIdentificationInfo riInfo) throws IllegalArgumentException, IOException {
        if (epaService == null || riInfo == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        this.epaService = epaService;
        this.riInfo = riInfo;
        this.log = LogFactory.getLog(RestrictedIdentification.class);
        OID oid = new OID(riInfo.getProtocol().getEncoded());
        if (oid.equals(OIDConstants.OID_RI_DH_SHA_1) || oid.equals(OIDConstants.OID_RI_ECDH_SHA_1)) {
            this.expectedIDLength = "18";
        } else if (oid.equals(OIDConstants.OID_RI_DH_SHA_224) || oid.equals(OIDConstants.OID_RI_ECDH_SHA_224)) {
            this.expectedIDLength = "20";
        } else if (oid.equals(OIDConstants.OID_RI_DH_SHA_256) || oid.equals(OIDConstants.OID_RI_ECDH_SHA_256)) {
            this.expectedIDLength = "24";
        }
    }

    public synchronized boolean executeRI(byte[] publicKey, byte[] publicKey2) throws IllegalArgumentException, IOException {
        if (!(publicKey != null && publicKey.length != 0 || publicKey2 != null && publicKey2.length != 0)) {
            throw new IllegalArgumentException("one of the two keys must contain something");
        }
        this.success = false;
        this.firstID = null;
        this.secondID = null;
        try {
            ASN1[] idData;
            ASN1 resASN1;
            Object dataFieldString = EPAUtil.makeTag("80", HexUtil.hexify(this.riInfo.getProtocol().getValue())) + EPAUtil.makeTag("84", HexUtil.hexify(this.riInfo.getParams().getKeyID().getValue()));
            CommandAPDU cmd = EPAUtil.commandFromString("002241 A4", (String)dataFieldString, EPAUtil.LENGTH_EXPECTED_NONE);
            ResponseAPDU decResponse = this.epaService.sendCommandAPDU(cmd);
            EPAUtil.logCommand(this.log, "MSE:Set AT for RI", cmd, decResponse);
            EPAUtil.checkResponse(decResponse, false);
            if (publicKey != null && publicKey.length > 0) {
                dataFieldString = EPAUtil.makeTag("7C", EPAUtil.makeTag(FIRST_KEY_TAG, HexUtil.hexify(publicKey)));
                cmd = EPAUtil.commandFromString("0086 00 00", (String)dataFieldString, this.expectedIDLength);
                decResponse = this.epaService.sendCommandAPDU(cmd);
                EPAUtil.logCommand(this.log, "General Authenticate for RI (first key)", cmd, decResponse);
                EPAUtil.checkResponse(decResponse, true);
                resASN1 = new ASN1(decResponse.data());
                idData = resASN1.getChildElementsByDTagBytes(FIRST_ID_TAG);
                if (idData == null || idData.length != 1) {
                    this.log.debug((Object)"RI not successful: no first ID received");
                    return false;
                }
                this.firstID = idData[0].getValue();
            }
            if (publicKey2 != null && publicKey2.length > 0) {
                dataFieldString = EPAUtil.makeTag("7C", EPAUtil.makeTag(SECOND_KEY_TAG, HexUtil.hexify(publicKey2)));
                cmd = EPAUtil.commandFromString("0086 00 00", (String)dataFieldString, this.expectedIDLength);
                decResponse = this.epaService.sendCommandAPDU(cmd);
                EPAUtil.logCommand(this.log, "General Authenticate for RI (second key)", cmd, decResponse);
                EPAUtil.checkResponse(decResponse, true);
                resASN1 = new ASN1(decResponse.data());
                idData = resASN1.getChildElementsByDTagBytes(SECOND_ID_TAG);
                if (idData == null || idData.length != 1) {
                    this.log.debug((Object)"RI not successful: no second ID received");
                    return false;
                }
                this.secondID = idData[0].getValue();
            }
            this.success = true;
        }
        catch (Exception e) {
            this.log.debug((Object)("RI not successful: Exception thrown - " + e.getMessage()));
            this.success = false;
        }
        return this.success;
    }

    public byte[] getFirstID() throws IllegalStateException {
        if (!this.success) {
            throw new IllegalStateException("RI not yet successfully run");
        }
        return this.firstID;
    }

    public byte[] getSecondID() throws IllegalStateException {
        if (!this.success) {
            throw new IllegalStateException("RI not yet successfully run");
        }
        return this.secondID;
    }
}

