/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.constants.OIDConstants;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.CryptoHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.KeyDerivationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.Crypto3DES;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.CryptoAES;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyDerivation3DES;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyDerivationAES128;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyDerivationAES192;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyDerivationAES256;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.ProtocolHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.ProtocolECDHGM;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimplePACETrustedChannelWithCAN {
    public static final String USE_CAN_KEY = HexUtil.hexify((byte)2);
    private static final byte[] ENCRYPTED_NONCE_TAG = new byte[]{-128};
    private static final String MAPPING_DATA_TO_CARD_TAG = "81";
    private static final byte[] MAPPING_DATA_FROM_CARD_TAG = new byte[]{-126};
    private static final String EPH_KEY_TO_CARD_TAG = "83";
    private static final byte[] EPH_KEY_FROM_CARD_TAG = new byte[]{-124};
    private static final String AUTH_TOKEN_TO_CARD_TAG = "85";
    private static final byte[] AUTH_TOKEN_FROM_CARD_TAG = new byte[]{-122};
    private CryptoHandler crypto = null;
    private KeyDerivationHandler kdh = null;
    private ProtocolHandler protocol = null;
    private static final Log log = LogFactory.getLog(SimplePACETrustedChannelWithCAN.class);
    private OID oid = null;
    private Integer id = null;
    private boolean success = false;
    private SecretKey macKey = null;
    private SecretKey encKey = null;

    public SimplePACETrustedChannelWithCAN() {
        log.debug((Object)"PACE object constructed");
    }

    private void prepareCrypto(SecurityInfos.GeneralDomainParameterInfo info, OID oid, int paceVersion, Integer id) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        AssertUtil.notNull(info, "domain parameters");
        AssertUtil.notNull(oid, "OID");
        if (paceVersion < 1 || paceVersion > 2) {
            throw new IllegalArgumentException("unknown PACE version requested: " + paceVersion);
        }
        this.oid = oid;
        this.id = id;
        this.initPACE(info, paceVersion);
    }

    private void initPACE(SecurityInfos.GeneralDomainParameterInfo info, int paceVersion) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        log.debug((Object)("Initializing PACE for version " + paceVersion + " and protocol " + this.oid));
        if (this.oid.equals(OIDConstants.OID_PACE_ECDH_GM_3DES_CBC_CBC)) {
            this.crypto = new Crypto3DES();
            this.kdh = new KeyDerivation3DES();
            this.protocol = new ProtocolECDHGM(info, this.oid, paceVersion);
        } else if (this.oid.equals(OIDConstants.OID_PACE_ECDH_GM_AES_CBC_CMAC_128)) {
            this.crypto = new CryptoAES(128);
            this.kdh = new KeyDerivationAES128();
            this.protocol = new ProtocolECDHGM(info, this.oid, paceVersion);
        } else if (this.oid.equals(OIDConstants.OID_PACE_ECDH_GM_AES_CBC_CMAC_192)) {
            this.crypto = new CryptoAES(192);
            this.kdh = new KeyDerivationAES192();
            this.protocol = new ProtocolECDHGM(info, this.oid, paceVersion);
        } else if (this.oid.equals(OIDConstants.OID_PACE_ECDH_GM_AES_CBC_CMAC_256)) {
            this.crypto = new CryptoAES(256);
            this.kdh = new KeyDerivationAES256();
            this.protocol = new ProtocolECDHGM(info, this.oid, paceVersion);
        }
    }

    public synchronized boolean executePACE(CardChannel cardChannel, SecurityInfos securityInfos, char[] canSecretData) throws IllegalStateException, IllegalArgumentException, Exception {
        this.preparePACE(cardChannel, securityInfos);
        log.debug((Object)"announce PACE domain parameters to be used to card (step 0.4)");
        Object dataFieldString = EPAUtil.makeTag("80", HexUtil.hexify(this.oid.getValue())) + EPAUtil.makeTag(EPH_KEY_TO_CARD_TAG, USE_CAN_KEY) + (this.id != null ? EPAUtil.makeTag("84", HexUtil.hexify(this.id)) : "");
        CommandAPDU mseATPace = EPAUtil.commandFromString("0022C1 A4", (String)dataFieldString, EPAUtil.LENGTH_EXPECTED_NONE);
        ResponseAPDU response = cardChannel.sendCommandAPDU(mseATPace);
        EPAUtil.logCommand(log, "MSE:Set AT for PACE", mseATPace, response);
        switch (SimplePACETrustedChannelWithCAN.checkForWarning(response)) {
            case 2: {
                log.debug((Object)"Warning: Retry counter 2");
                break;
            }
            case 1: {
                log.debug((Object)"Warning: Retry counter 1, password suspended - must resume first");
                break;
            }
            case 0: {
                log.debug((Object)"Warning: Retry counter 0, password blocked - must unblock first");
                throw new RetryCounterExpiredException("PIN", response.sw(), "PIN is blocked, must be unblocked first");
            }
        }
        log.debug((Object)"could request user to enter secret now (step 1.1)");
        dataFieldString = "";
        dataFieldString = EPAUtil.makeTag("7C", (String)dataFieldString);
        CommandAPDU encryptedNonce = EPAUtil.commandFromString("1086 00 00", (String)dataFieldString, "00");
        log.debug((Object)"request nonce from card (step 1.2)");
        response = cardChannel.sendCommandAPDU(encryptedNonce);
        EPAUtil.logCommand(log, "General Authenticate: Encrypted Nonce", encryptedNonce, response);
        EPAUtil.checkResponse(response, true);
        ASN1 respASN1 = new ASN1(response.data());
        ASN1[] respData = respASN1.getChildElementsByDTagBytes(ENCRYPTED_NONCE_TAG);
        if (respData == null || respData.length != 1) {
            log.debug((Object)"PACE not successful: encrypted nonce data missing");
            throw new InternalError("(PACE) no nonce received");
        }
        log.debug((Object)"derive key for nonce decryption (step 2.1)");
        SecretKey k = this.kdh.deriveCANKey(new String(canSecretData));
        log.debug((Object)"decrypt nonce (step 2.2)");
        byte[] nonce = this.crypto.decryptNonce(k, respData[0].getValue());
        log.debug((Object)"create data for mapping (step 2.3)");
        byte[] mappingData = this.protocol.initiateMapping();
        dataFieldString = HexUtil.hexify(mappingData);
        dataFieldString = EPAUtil.makeTag(MAPPING_DATA_TO_CARD_TAG, (String)dataFieldString);
        dataFieldString = EPAUtil.makeTag("7C", (String)dataFieldString);
        CommandAPDU mappingExchange = EPAUtil.commandFromString("1086 00 00", (String)dataFieldString, "00");
        log.debug((Object)"exchange data for mapping (steps 2.4 and 2.5)");
        response = cardChannel.sendCommandAPDU(mappingExchange);
        EPAUtil.logCommand(log, "General Authenticate: Map Nonce", mappingExchange, response);
        EPAUtil.checkResponse(response, true);
        respASN1 = new ASN1(response.data());
        respData = respASN1.getChildElementsByDTagBytes(MAPPING_DATA_FROM_CARD_TAG);
        if (respData == null || respData.length != 1) {
            log.debug((Object)"PACE not successful: mapping data missing");
            throw new InternalError("(PACE) no mapping data received");
        }
        byte[] ephemeralKey = this.protocol.generateEphemeralKey(respData[0].getValue(), nonce);
        dataFieldString = HexUtil.hexify(ephemeralKey);
        dataFieldString = EPAUtil.makeTag(EPH_KEY_TO_CARD_TAG, (String)dataFieldString);
        dataFieldString = EPAUtil.makeTag("7C", (String)dataFieldString);
        CommandAPDU keyAgreement = EPAUtil.commandFromString("1086 00 00", (String)dataFieldString, "00");
        log.debug((Object)"exchange ephemeral public keys (steps 3.4 and 3.5)");
        response = cardChannel.sendCommandAPDU(keyAgreement);
        EPAUtil.logCommand(log, "General Authenticate: Perform Key Agreement", keyAgreement, response);
        EPAUtil.checkResponse(response, true);
        respASN1 = new ASN1(response.data());
        respData = respASN1.getChildElementsByDTagBytes(EPH_KEY_FROM_CARD_TAG);
        if (respData == null || respData.length != 1) {
            log.debug((Object)"PACE not successful: ephemeral key data missing");
            throw new InternalError("(PACE) no ephemeral key received");
        }
        log.debug((Object)"generate shared secret (step 4.1)");
        byte[] sharedSecret = this.protocol.generateSharedSecret(respData[0].getValue());
        log.debug((Object)"derive MAC and encryption keys (step 4.2)");
        SecretKey macKey = this.kdh.deriveMACKey(sharedSecret, null);
        SecretKey encKey = this.kdh.deriveEncKey(sharedSecret, null);
        log.debug((Object)"build structure for ephemeral public key of card (step 4.3)");
        byte[] structure = this.protocol.buildStructure(response.data(), true);
        log.debug((Object)"perform MAC on structure (step 4.4)");
        byte[] mac = this.crypto.mac(macKey, structure);
        dataFieldString = HexUtil.hexify(mac);
        dataFieldString = EPAUtil.makeTag(AUTH_TOKEN_TO_CARD_TAG, (String)dataFieldString);
        dataFieldString = EPAUtil.makeTag("7C", (String)dataFieldString);
        CommandAPDU authenticateCommand = EPAUtil.commandFromString("0086 00 00", (String)dataFieldString, "00");
        log.debug((Object)"exchange MAC (steps 4.5 and 4.6)");
        response = cardChannel.sendCommandAPDU(authenticateCommand);
        EPAUtil.logCommand(log, "General Authenticate: Mutual Authentication", authenticateCommand, response);
        SimplePACETrustedChannelWithCAN.checkFinalResponse("CAN", response);
        respASN1 = new ASN1(response.data());
        respData = respASN1.getChildElementsByDTagBytes(AUTH_TOKEN_FROM_CARD_TAG);
        if (respData == null || respData.length != 1) {
            log.debug((Object)"PACE not successful: authentication token missing");
            throw new InternalError("PACE not successful: no authentication token received");
        }
        log.debug((Object)"verify MAC received from card");
        byte[] ownStructure = this.protocol.buildStructure(ephemeralKey, false);
        byte[] ownMac = this.crypto.mac(macKey, ownStructure);
        if (Arrays.equals(ownMac, respData[0].getValue())) {
            log.debug((Object)"PACE complete");
            this.encKey = encKey;
            this.macKey = macKey;
            this.success = true;
        } else {
            log.debug((Object)"PACE not successful: received MAC not matching own calculation");
            this.success = false;
        }
        return this.success;
    }

    private void preparePACE(CardChannel cardChannel, SecurityInfos cardAccess) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        SecurityInfos.GeneralDomainParameterInfo domParamInfo;
        if (cardAccess.getPrivilegedTerminalInfo() == null) {
            log.debug((Object)"ePA as defined in spec 2.03");
        } else {
            log.debug((Object)"ePA as defined in spec 2.04 and following");
        }
        List<SecurityInfos.PACEInfo> infoList = cardAccess.getPACEInfo();
        List<SecurityInfos.PACEDomainParameterInfo> domainParameterInfoList = cardAccess.getPACEDomainParameterInfo();
        if (infoList == null || infoList.size() == 0) {
            throw new IllegalStateException("Required data for PACE not available in EF.CardAccess");
        }
        SecurityInfos.PACEInfo info = EPA.selectPACE(infoList);
        if (info == null) {
            throw new IllegalStateException("Required data for PACE not available in EF.CardAccess");
        }
        ASN1 pID = info.getParameterID();
        Integer id = null;
        if (pID != null) {
            id = new BigInteger(pID.getValue()).intValue();
        }
        if ((domParamInfo = EPA.selectPACEDomainParameterInfo(domainParameterInfoList, id)) == null) {
            throw new IllegalStateException("Required data for PACE not available in EF.CardAccess");
        }
        OID protocolOID = new OID(info.getProtocol().getEncoded());
        int paceVersion = new BigInteger(info.getVersion().getValue()).intValue();
        this.prepareCrypto(domParamInfo, protocolOID, paceVersion, id);
    }

    public synchronized SecretKey getMacKey() throws IllegalStateException {
        if (!this.success) {
            throw new IllegalStateException("PACE not yet successfully executed");
        }
        return this.macKey;
    }

    public synchronized SecretKey getEncKey() {
        if (!this.success) {
            throw new IllegalStateException("PACE not yet successfully executed");
        }
        return this.encKey;
    }

    public synchronized byte[] getCardEphemeralPublicKey() throws IllegalStateException {
        if (!this.success) {
            throw new IllegalStateException("PACE not yet successfully executed");
        }
        return this.protocol.getCompressedCardEphemeralPublicKey();
    }

    private static int checkForWarning(ResponseAPDU response) throws IllegalArgumentException, IllegalStateException {
        if (response == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        if (response.sw1() == 99 && (response.sw2() & 0xFFFFFFF0) == -64) {
            return response.sw2() & 0xF;
        }
        if (response.sw1() != -112 || response.sw2() != 0) {
            throw new IllegalStateException("response code " + response.sw() + " - not 0x9000 or 0x63cX");
        }
        return 3;
    }

    protected static final void checkFinalResponse(String pinName, ResponseAPDU response) throws IllegalArgumentException, InternalError, WrongPinException {
        if (response == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        if (response.sw() == 36864) {
            if (response.data() == null || response.data().length == 0) {
                throw new InternalError("PACE failed: no data returned");
            }
            return;
        }
        if (response.sw1() == 99) {
            throw new WrongPinException(pinName, response.sw(), "PACE failed: wrong password entered");
        }
        throw new InternalError("PACE failed with unknown error");
    }
}

