/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.gov2.jca_provider.eccipher.ECUtils;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.CryptoHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.ProtocolHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.ProtocolECDHGM;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;

public class ProtocolECDHIM
extends ProtocolECDHGM
implements ProtocolHandler {
    private CryptoHandler crypto = null;
    private SecretKey randomKey = null;

    public ProtocolECDHIM(SecurityInfos.PACEDomainParameterInfo info, OID oid, CryptoHandler crypto, int paceVersion) throws IllegalArgumentException {
        super(info, oid, paceVersion);
        if (crypto == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        this.crypto = crypto;
        this.log = LogFactory.getLog(ProtocolECDHIM.class);
    }

    @Override
    public byte[] generateEphemeralKey(byte[] data, byte[] nonce) throws IllegalArgumentException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        byte[] encNonce = this.crypto.encrypt(this.randomKey, nonce);
        this.newBasePoint = this.mapToCurvePoint(encNonce);
        this.ecKeyPair = ECUtils.adjustKeyPair(this.kh.generateKeyPair((AlgorithmParameterSpec)new ECParameterSpec(this.ownPublicKey.getParameters().getCurve(), this.newBasePoint, this.ownPublicKey.getParameters().getN(), this.ownPublicKey.getParameters().getH())));
        this.ownPublicKey = (JCEECPublicKey)this.ecKeyPair.getPublic();
        byte[] retVal = this.ownPublicKey.getQ().getEncoded(false);
        this.log.debug((Object)("Using G~ as new base point, generating ephemeral key pair - new ephemeral public point:\n" + HexUtil.dump(retVal)));
        return retVal;
    }

    @Override
    public byte[] initiateMapping() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        this.randomKey = this.crypto.generateSecretKey();
        return this.randomKey.getEncoded();
    }

    private ECPoint mapToCurvePoint(byte[] data) throws IllegalArgumentException {
        return null;
    }
}

