/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.gov2.jca_provider.eccipher.ECUtils;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyHandlerEC;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.ProtocolHandler;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;

public class ProtocolECDHGM
implements ProtocolHandler {
    private SecurityInfos.GeneralDomainParameterInfo domParamInfo = null;
    private OID oid = null;
    private int paceVersion = 2;
    protected KeyHandlerEC kh = null;
    protected Log log;
    protected KeyPair ecKeyPair = null;
    protected JCEECPublicKey ownPublicKey = null;
    protected JCEECPublicKey cardPublicKey = null;
    protected ECPoint newBasePoint = null;

    public ProtocolECDHGM(SecurityInfos.GeneralDomainParameterInfo info, OID oid, int paceVersion) throws IllegalArgumentException {
        AssertUtil.notNull(info, "domain parameters");
        AssertUtil.notNull(oid, "OID");
        if (paceVersion < 1 || paceVersion > 2) {
            throw new IllegalArgumentException("unknown PACE version: " + paceVersion);
        }
        this.domParamInfo = info;
        this.oid = oid;
        this.paceVersion = paceVersion;
        this.log = LogFactory.getLog(ProtocolECDHGM.class);
        this.kh = new KeyHandlerEC();
    }

    @Override
    public byte[] buildStructure(byte[] data, boolean fromCard) throws IllegalArgumentException, IOException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        if (fromCard) {
            data = ByteUtil.subbytes(data, 4);
        }
        PublicKey key = this.kh.generateKeyFromBytes(this.ownPublicKey.getParameters(), data);
        return this.kh.convertPublicKey(key, this.oid, this.paceVersion == 1);
    }

    @Override
    public byte[] generateEphemeralKey(byte[] data, byte[] nonce) throws IllegalArgumentException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException, InvalidKeySpecException, IOException {
        if (data == null || data.length == 0 || nonce == null || nonce.length == 0) {
            throw new IllegalArgumentException("null or empty data / nonce not permitted");
        }
        this.log.debug((Object)"perform mapping (step 3.1)");
        JCEECPublicKey pub = (JCEECPublicKey)this.kh.generateKeyFromBytes(this.domParamInfo, data);
        ECPoint h = this.kh.calcSharedSecret((JCEECPrivateKey)this.ecKeyPair.getPrivate(), pub);
        this.log.debug((Object)"generate new domain parameters (step 3.2)");
        ECPoint g = this.ownPublicKey.getParameters().getG();
        BigInteger s = new BigInteger(ByteUtil.addLeadingZero(nonce));
        this.newBasePoint = h.add(g.multiply(s));
        this.log.debug((Object)"generate ephemeral key pair (step 3.3)");
        this.ecKeyPair = ECUtils.adjustKeyPair(this.kh.generateKeyPair((AlgorithmParameterSpec)new ECParameterSpec(this.ownPublicKey.getParameters().getCurve(), this.newBasePoint, this.ownPublicKey.getParameters().getN(), this.ownPublicKey.getParameters().getH())));
        this.ownPublicKey = (JCEECPublicKey)this.ecKeyPair.getPublic();
        byte[] retVal = this.ownPublicKey.getQ().getEncoded(false);
        return retVal;
    }

    @Override
    public byte[] generateSharedSecret(byte[] data) throws IllegalArgumentException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("null or empty data not permitted");
        }
        this.cardPublicKey = (JCEECPublicKey)this.kh.generateKeyFromBytes(this.ownPublicKey.getParameters(), data);
        return this.kh.agreeSharedSecret(this.ecKeyPair.getPrivate(), (PublicKey)this.cardPublicKey);
    }

    @Override
    public byte[] initiateMapping() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, IllegalArgumentException, NoSuchProviderException {
        this.ecKeyPair = ECUtils.adjustKeyPair(this.kh.generateKeyPair(this.domParamInfo));
        this.ownPublicKey = (JCEECPublicKey)this.ecKeyPair.getPublic();
        byte[] retVal = this.kh.ephemeralKeyBytes((PublicKey)this.ownPublicKey);
        return retVal;
    }

    @Override
    public byte[] getCompressedCardEphemeralPublicKey() throws IllegalStateException {
        if (this.cardPublicKey == null) {
            throw new IllegalStateException("ephemeral public key of card not yet present");
        }
        return this.kh.compressKey((PublicKey)this.cardPublicKey);
    }
}

