/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import de.bos_bremen.common.asn1.cvc.ECCVCertificate;
import de.bos_bremen.common.constants.OIDConstants;
import de.bos_bremen.gov2.jca_provider.eccipher.ECUtils;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.KeyHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;

public class KeyHandlerEC
implements KeyHandler {
    private KeyPairGenerator kpg = null;

    @Override
    public KeyPair generateKeyPair(SecurityInfos.GeneralDomainParameterInfo params) throws IllegalArgumentException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        if (params == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        org.bouncycastle.jce.spec.ECParameterSpec paramSpec = null;
        if (SecurityInfos.DomainParameterInfo.class.isInstance(params)) {
            SecurityInfos.AlgorithmIdentifier ai = ((SecurityInfos.DomainParameterInfo)params).getDomainParameter();
            paramSpec = OIDConstants.OID_STANDARDIZED_DOMAIN_PARAMETERS.equals(ai.getAlgorithm()) ? KeyHandlerEC.parameterSpecFromCurveID(new BigInteger(ai.getParameters().getValue()).intValue()) : KeyHandlerEC.parameterSpecFromAlgorithmIdentifier(((SecurityInfos.DomainParameterInfo)params).getDomainParameter(), org.bouncycastle.jce.spec.ECParameterSpec.class);
        } else if (SecurityInfos.StandardDomainParameterInfo.class.isInstance(params)) {
            paramSpec = KeyHandlerEC.parameterSpecFromCurveID(((SecurityInfos.StandardDomainParameterInfo)params).getdpiID());
        } else {
            throw new IllegalArgumentException("unknown domain parameter info");
        }
        return this.generateKeyPair((AlgorithmParameterSpec)paramSpec);
    }

    @Override
    public KeyPair generateKeyPair(ECCVCertificate cert) throws IllegalArgumentException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        AssertUtil.notNull(cert, "certificate");
        org.bouncycastle.jce.spec.ECParameterSpec paramSpec = KeyHandlerEC.parameterSpecFromCVC(cert, org.bouncycastle.jce.spec.ECParameterSpec.class);
        return this.generateKeyPair((AlgorithmParameterSpec)paramSpec);
    }

    @Override
    public KeyPair generateKeyPair(AlgorithmParameterSpec spec) throws IllegalArgumentException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        AssertUtil.notNull(spec, "spec");
        if (this.kpg == null) {
            this.kpg = KeyPairGenerator.getInstance("EC", "BC");
        }
        this.kpg.initialize(spec);
        return ECUtils.adjustKeyPair(this.kpg.genKeyPair());
    }

    @Override
    public PublicKey generateKeyFromBytes(SecurityInfos.GeneralDomainParameterInfo params, byte[] keyBytes) throws IllegalArgumentException, IOException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        if (params == null || keyBytes == null || keyBytes.length == 0) {
            throw new IllegalArgumentException("null or empty array not permitted");
        }
        org.bouncycastle.jce.spec.ECParameterSpec paramSpec = null;
        if (SecurityInfos.DomainParameterInfo.class.isInstance(params)) {
            SecurityInfos.AlgorithmIdentifier ai = ((SecurityInfos.DomainParameterInfo)params).getDomainParameter();
            paramSpec = OIDConstants.OID_STANDARDIZED_DOMAIN_PARAMETERS.equals(ai.getAlgorithm()) ? KeyHandlerEC.parameterSpecFromCurveID(new BigInteger(ai.getParameters().getValue()).intValue()) : KeyHandlerEC.parameterSpecFromAlgorithmIdentifier(((SecurityInfos.DomainParameterInfo)params).getDomainParameter(), org.bouncycastle.jce.spec.ECParameterSpec.class);
        } else if (SecurityInfos.StandardDomainParameterInfo.class.isInstance(params)) {
            paramSpec = KeyHandlerEC.parameterSpecFromCurveID(((SecurityInfos.StandardDomainParameterInfo)params).getdpiID());
        } else {
            throw new IllegalArgumentException("unknown domain parameter info");
        }
        return ECUtils.publicKey2JCEECPublicKey(this.generateKeyFromBytes(paramSpec, keyBytes));
    }

    public PublicKey generateKeyFromBytes(org.bouncycastle.jce.spec.ECParameterSpec paramSpec, byte[] keyBytes) throws IllegalArgumentException, IOException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        if (paramSpec == null || keyBytes == null || keyBytes.length == 0) {
            throw new IllegalArgumentException("null or empty array not permitted");
        }
        org.bouncycastle.math.ec.ECPoint point = paramSpec.getCurve().decodePoint(keyBytes);
        ECPublicKeySpec keySpec = new ECPublicKeySpec(point, paramSpec);
        KeyFactory kf = KeyFactory.getInstance("EC", "BC");
        return ECUtils.publicKey2JCEECPublicKey(kf.generatePublic((KeySpec)keySpec));
    }

    @Override
    public byte[] agreeSharedSecret(PrivateKey priv, PublicKey pub) throws IllegalArgumentException {
        JCEECPrivateKey ecPriv = ECUtils.privateKey2JCEECPrivateKey(priv);
        JCEECPublicKey ecPub = ECUtils.publicKey2JCEECPublicKey(pub);
        org.bouncycastle.math.ec.ECPoint sharedPoint = this.calcSharedSecret(ecPriv, ecPub).normalize();
        int trimLength = KeyHandlerEC.getOrderLength(ecPub.getParams());
        return ByteUtil.trimByteArray(sharedPoint.getAffineXCoord().toBigInteger().toByteArray(), trimLength);
    }

    public org.bouncycastle.math.ec.ECPoint calcSharedSecret(JCEECPrivateKey priv, JCEECPublicKey pub) throws IllegalArgumentException {
        if (priv == null || pub == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        return pub.getQ().multiply(priv.getD());
    }

    @Override
    public byte[] ephemeralKeyBytes(PublicKey key) throws IllegalArgumentException {
        return ECUtils.publicKey2JCEECPublicKey(key).getQ().getEncoded(false);
    }

    @Override
    public byte[] compressKey(PublicKey key) throws IllegalArgumentException {
        JCEECPublicKey lkey = ECUtils.publicKey2JCEECPublicKey(key);
        int trimLen = KeyHandlerEC.getOrderLength(lkey.getParams());
        return ByteUtil.trimByteArray(lkey.getQ().getAffineXCoord().toBigInteger().toByteArray(), trimLen);
    }

    @Override
    public byte[] compressKeyFromBytes(byte[] keyBytes) throws IllegalArgumentException {
        if (keyBytes == null || keyBytes.length == 0) {
            throw new IllegalArgumentException("null or empty array not permitted");
        }
        return ByteUtil.subbytes(keyBytes, 1, (keyBytes.length - 1) / 2 + 1);
    }

    @Override
    public byte[] convertPublicKey(PublicKey key, OID oid, boolean fullStructure) throws IllegalArgumentException {
        AssertUtil.notNull(oid, "OID");
        JCEECPublicKey ecKey = ECUtils.publicKey2JCEECPublicKey(key);
        ASN1 primeModulus = null;
        if (ecKey.getParameters().getCurve() instanceof ECCurve.Fp) {
            primeModulus = new ASN1(129, ByteUtil.removeLeadingZero(((ECCurve.Fp)ecKey.getParameters().getCurve()).getQ().toByteArray()));
        } else if (ecKey.getParameters().getCurve() instanceof SecP256R1Curve) {
            primeModulus = new ASN1(129, ByteUtil.removeLeadingZero(((SecP256R1Curve)ecKey.getParameters().getCurve()).getQ().toByteArray()));
        } else {
            throw new IllegalArgumentException("conversion of public key not possible, unsupported curve");
        }
        ASN1 firstCoefficient = new ASN1(130, ByteUtil.removeLeadingZero(ecKey.getParameters().getCurve().getA().toBigInteger().toByteArray()));
        ASN1 secondCoefficient = new ASN1(131, ByteUtil.removeLeadingZero(ecKey.getParameters().getCurve().getB().toBigInteger().toByteArray()));
        ASN1 basePoint = new ASN1(132, ecKey.getParameters().getG().getEncoded(false));
        ASN1 orderOfBasePoint = new ASN1(133, ByteUtil.removeLeadingZero(ecKey.getParameters().getN().toByteArray()));
        ASN1 publicPoint = new ASN1(134, ecKey.getQ().getEncoded(false));
        ASN1 cofactor = new ASN1(135, ByteUtil.removeLeadingZero(ecKey.getParameters().getH().toByteArray()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(oid.getEncoded());
            if (fullStructure) {
                baos.write(primeModulus.getEncoded());
                baos.write(firstCoefficient.getEncoded());
                baos.write(secondCoefficient.getEncoded());
                baos.write(basePoint.getEncoded());
                baos.write(orderOfBasePoint.getEncoded());
            }
            baos.write(publicPoint.getEncoded());
            if (fullStructure) {
                baos.write(cofactor.getEncoded());
            }
        }
        catch (IOException e) {
            return null;
        }
        return new ASN1(32585, baos.toByteArray()).getEncoded();
    }

    public static <T extends AlgorithmParameterSpec> T parameterSpecFromAlgorithmIdentifier(SecurityInfos.AlgorithmIdentifier ai, Class<T> requestedClass) throws IllegalArgumentException, IOException {
        AssertUtil.notNull(ai, "algorithm identifier");
        AssertUtil.notNull(requestedClass, "requested class");
        ASN1 params = ai.getParameters();
        BigInteger primeModulus = new BigInteger(ByteUtil.addLeadingZero(params.getChildElementsByTag(48)[0].getChildElementsByTag(2)[0].getValue()));
        BigInteger firstCoefficient = new BigInteger(ByteUtil.addLeadingZero(params.getChildElementsByTag(48)[1].getChildElementsByTag(4)[0].getValue()));
        BigInteger secondCoefficient = new BigInteger(ByteUtil.addLeadingZero(params.getChildElementsByTag(48)[1].getChildElementsByTag(4)[1].getValue()));
        byte[] pointBytes = params.getChildElementsByTag(4)[0].getValue();
        BigInteger orderOfBasePoint = new BigInteger(ByteUtil.addLeadingZero(params.getChildElementsByTag(2)[1].getValue()));
        BigInteger cofactor = new BigInteger(ByteUtil.addLeadingZero(params.getChildElementsByTag(2)[2].getValue()));
        return KeyHandlerEC.buildParameterSpec(primeModulus, firstCoefficient, secondCoefficient, pointBytes, orderOfBasePoint, cofactor, requestedClass);
    }

    public static <T extends AlgorithmParameterSpec> T parameterSpecFromCVC(ECCVCertificate cert, Class<T> requestedClass) throws IllegalArgumentException, IOException {
        AssertUtil.notNull(cert, "CVC");
        AssertUtil.notNull(requestedClass, "requested class");
        BigInteger primeModulus = new BigInteger(ByteUtil.addLeadingZero(cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_PRIME_MODULUS).getValue()));
        BigInteger firstCoefficient = new BigInteger(ByteUtil.addLeadingZero(cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_COEFFICIENT_A).getValue()));
        BigInteger secondCoefficient = new BigInteger(ByteUtil.addLeadingZero(cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_COEFFICIENT_B).getValue()));
        byte[] pointBytes = cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_BASE_POINT_G).getValue();
        BigInteger orderOfBasePoint = new BigInteger(ByteUtil.addLeadingZero(cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_ORDER_OF_BASE_POINT_R).getValue()));
        BigInteger cofactor = new BigInteger(ByteUtil.addLeadingZero(cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_CO_FACTOR_F).getValue()));
        return KeyHandlerEC.buildParameterSpec(primeModulus, firstCoefficient, secondCoefficient, pointBytes, orderOfBasePoint, cofactor, requestedClass);
    }

    private static <T extends AlgorithmParameterSpec> T buildParameterSpec(BigInteger primeModulus, BigInteger firstCoefficient, BigInteger secondCoefficient, byte[] pointBytes, BigInteger orderOfBasePoint, BigInteger cofactor, Class<T> requestedClass) throws IllegalArgumentException {
        AssertUtil.notNull(primeModulus, "prime modulus");
        AssertUtil.notNull(firstCoefficient, "first coefficient");
        AssertUtil.notNull(secondCoefficient, "second coefficient");
        AssertUtil.notNullOrEmpty(pointBytes, "bytes of point");
        AssertUtil.notNull(orderOfBasePoint, "order of base point");
        AssertUtil.notNull(cofactor, "cofactor");
        AssertUtil.notNull(requestedClass, "class");
        if (requestedClass.equals(ECParameterSpec.class)) {
            ECFieldFp field = new ECFieldFp(primeModulus);
            EllipticCurve curveSun = new EllipticCurve(field, firstCoefficient, secondCoefficient);
            ECCurve.Fp curveBouncy = new ECCurve.Fp(primeModulus, firstCoefficient, secondCoefficient);
            org.bouncycastle.math.ec.ECPoint pointBouncy = curveBouncy.decodePoint(pointBytes);
            ECPoint pointSun = new ECPoint(pointBouncy.getAffineXCoord().toBigInteger(), pointBouncy.getAffineYCoord().toBigInteger());
            return (T)new ECParameterSpec(curveSun, pointSun, orderOfBasePoint, cofactor.intValue());
        }
        if (requestedClass.equals(org.bouncycastle.jce.spec.ECParameterSpec.class)) {
            ECCurve.Fp curve = new ECCurve.Fp(primeModulus, firstCoefficient, secondCoefficient);
            org.bouncycastle.math.ec.ECPoint basePoint = curve.decodePoint(pointBytes);
            return (T)new org.bouncycastle.jce.spec.ECParameterSpec((ECCurve)curve, basePoint, orderOfBasePoint, cofactor);
        }
        throw new IllegalArgumentException("requested return class not implemented");
    }

    private static org.bouncycastle.jce.spec.ECParameterSpec parameterSpecFromCurveID(int id) throws IllegalArgumentException {
        if (id < 8 || id > 18) {
            throw new IllegalArgumentException("given curve ID currently not specified");
        }
        X9ECParameters x9Params = SecurityInfos.getDomainParameterMap().get(id);
        return new org.bouncycastle.jce.spec.ECParameterSpec(x9Params.getCurve(), x9Params.getG(), x9Params.getN(), x9Params.getH());
    }

    public static int getOrderLength(ECParameterSpec spec) throws IllegalArgumentException {
        AssertUtil.notNull(spec, "key parameter spec");
        BigInteger order = spec.getOrder();
        byte[] orderBytes = order.toByteArray();
        int trimLen = orderBytes.length;
        if (orderBytes[0] == 0 && ByteUtil.isBitSet(orderBytes[1], 7)) {
            --trimLen;
        }
        return trimLen;
    }
}

