/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.KeyDerivationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.AbstractKeyDerivation;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyDerivationAES256
extends AbstractKeyDerivation
implements KeyDerivationHandler {
    public KeyDerivationAES256() throws NoSuchAlgorithmException, NoSuchProviderException {
        super(MessageDigest.getInstance("SHA256", "BC"));
    }

    @Override
    SecretKey kdf(byte[] k, byte[] r, byte[] c) throws IllegalArgumentException {
        if (k == null || k.length == 0 || c == null || c.length != 4) {
            throw new IllegalArgumentException("null or empty array not permitted for k, c must be 4 bytes");
        }
        if (r != null) {
            k = ByteUtil.combine(k, r);
        }
        k = ByteUtil.combine(k, c);
        byte[] digestedK = this.digest.digest(k);
        return new SecretKeySpec(digestedK, "AES");
    }
}

