/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.KeyDerivationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.AbstractKeyDerivation;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyDerivation3DES
extends AbstractKeyDerivation
implements KeyDerivationHandler {
    public KeyDerivation3DES() throws NoSuchAlgorithmException, NoSuchProviderException {
        super(MessageDigest.getInstance("SHA1", "BC"));
    }

    @Override
    SecretKey kdf(byte[] k, byte[] r, byte[] c) throws IllegalArgumentException {
        if (k == null || k.length == 0 || c == null || c.length != 4) {
            throw new IllegalArgumentException("null or empty array not permitted for k, c must be 4 bytes");
        }
        if (r != null) {
            k = ByteUtil.combine(k, r);
        }
        k = ByteUtil.combine(k, c);
        byte[] digestedK = this.digest.digest(k);
        byte[] keyDataA = ByteUtil.subbytes(digestedK, 0, 8);
        byte[] keyDataB = ByteUtil.subbytes(digestedK, 8, 16);
        byte[] keyBytesComplete = ByteUtil.combine(keyDataA, ByteUtil.combine(keyDataB, keyDataA));
        return new SecretKeySpec(keyBytesComplete, "DESede");
    }
}

