/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl;

import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.CryptoHandler;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.macs.CMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class CryptoAES
implements CryptoHandler {
    private static final int SSC_LENGTH = 16;
    private SecretKey encKey = null;
    private Cipher cbcCipher = null;
    private Cipher ecbCipher = null;
    private SecretKey macKey = null;
    private Mac mac = null;
    private int keyLength;

    public CryptoAES(int keyLength) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new IllegalArgumentException("keyLength must be one of {128, 192, 256}");
        }
        this.keyLength = keyLength;
        this.cbcCipher = Cipher.getInstance("AES/CBC/NoPadding", "BC");
        this.ecbCipher = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        this.mac = new CMac((BlockCipher)new AESFastEngine(), 64);
    }

    @Override
    public byte[] decrypt(byte[] data, byte[] ssc) throws IllegalArgumentException, IllegalStateException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        if (data == null || data.length == 0 || ssc == null || ssc.length != 16) {
            throw new IllegalArgumentException("null or empty data not permitted, ssc must be 16 bytes long");
        }
        if (this.encKey == null) {
            throw new IllegalStateException("key not set, execution not possible");
        }
        this.ecbCipher.init(1, this.encKey);
        byte[] iv = this.ecbCipher.doFinal(ssc);
        this.cbcCipher.init(2, (Key)this.encKey, new IvParameterSpec(iv));
        return this.cbcCipher.doFinal(data);
    }

    @Override
    public byte[] decryptNonce(SecretKey key, byte[] data) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (key == null || data == null) {
            throw new IllegalArgumentException("null key or data not permitted");
        }
        if (data.length != this.ecbCipher.getBlockSize()) {
            throw new IllegalArgumentException("data length not matching block length of cipher");
        }
        this.ecbCipher.init(2, key);
        byte[] decNonce = this.ecbCipher.doFinal(data);
        return decNonce;
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] ssc) throws IllegalArgumentException, IllegalStateException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        if (data == null || data.length == 0 || ssc == null || ssc.length != 16) {
            throw new IllegalArgumentException("null or empty data not permitted, ssc must be 16 bytes long");
        }
        if (this.encKey == null) {
            throw new IllegalStateException("key not set, execution not possible");
        }
        this.ecbCipher.init(1, this.encKey);
        byte[] iv = this.ecbCipher.doFinal(ssc);
        this.cbcCipher.init(1, (Key)this.encKey, new IvParameterSpec(iv));
        return this.cbcCipher.doFinal(data);
    }

    @Override
    public byte[] mac(SecretKey key, byte[] data, int byteLength) throws IllegalArgumentException {
        if (key == null || data == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        if (byteLength < 1 || byteLength > 16) {
            throw new IllegalArgumentException("length of mac must be in range [1..16]");
        }
        AESFastEngine bc = new AESFastEngine();
        CMac m = new CMac((BlockCipher)bc, byteLength * 8);
        m.init((CipherParameters)new KeyParameter(key.getEncoded()));
        byte[] result = new byte[byteLength];
        m.update(data, 0, data.length);
        m.doFinal(result, 0);
        return result;
    }

    @Override
    public byte[] mac(SecretKey key, byte[] data) throws IllegalArgumentException {
        if (key == null || data == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        AESFastEngine bc = new AESFastEngine();
        CMac m = new CMac((BlockCipher)bc, 64);
        m.init((CipherParameters)new KeyParameter(key.getEncoded()));
        byte[] result = new byte[8];
        m.update(data, 0, data.length);
        m.doFinal(result, 0);
        return result;
    }

    @Override
    public byte[] mac(byte[] data) throws IllegalArgumentException, IllegalStateException {
        if (data == null) {
            throw new IllegalArgumentException("null or empty data not permitted");
        }
        if (this.macKey == null) {
            throw new IllegalStateException("key not set, execution not possible");
        }
        byte[] result = new byte[8];
        this.mac.update(data, 0, data.length);
        this.mac.doFinal(result, 0);
        return result;
    }

    @Override
    public void setEncryptionKey(SecretKey key) throws IllegalArgumentException {
        if (key == null || !key.getAlgorithm().equals("AES")) {
            throw new IllegalArgumentException("null or wrong algorithm not permitted");
        }
        this.encKey = key;
    }

    @Override
    public void setMACKey(SecretKey key) throws IllegalArgumentException {
        if (key == null || !key.getAlgorithm().equals("AES")) {
            throw new IllegalArgumentException("null or wrong algorithm not permitted");
        }
        this.macKey = key;
        this.mac.init((CipherParameters)new KeyParameter(this.macKey.getEncoded()));
    }

    @Override
    public SecretKey generateSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator gen = KeyGenerator.getInstance("AES");
        gen.init(this.keyLength);
        return gen.generateKey();
    }

    @Override
    public byte[] encrypt(SecretKey key, byte[] data) throws IllegalArgumentException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (key == null || data == null || data.length == 0) {
            throw new IllegalArgumentException("null or empty data not permitted");
        }
        this.ecbCipher.init(1, key);
        return this.ecbCipher.doFinal(data);
    }
}

