/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.CryptoHandler;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class Crypto3DES
implements CryptoHandler {
    private static final int SSC_LENGTH = 8;
    private static final IvParameterSpec DEFAULT_IV_PARAMETER_SPEC = new IvParameterSpec(new byte[8]);
    private SecretKey encKey = null;
    private Cipher cbcCipher = Cipher.getInstance("DESede/CBC/NoPadding", "BC");
    private Cipher ecbCipher = Cipher.getInstance("DESede/ECB/NoPadding", "BC");
    private SecretKey macKey = null;
    private Mac mac = Mac.getInstance("ISO9797ALG3MAC");

    @Override
    public byte[] decrypt(byte[] data, byte[] ssc) throws IllegalArgumentException, IllegalStateException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        if (data == null || data.length == 0 || ssc == null || ssc.length != 8) {
            throw new IllegalArgumentException("null or empty data not permitted, ssc must be 8 bytes long");
        }
        if (this.encKey == null) {
            throw new IllegalStateException("key not set, execution not possible");
        }
        this.cbcCipher.init(2, (Key)this.encKey, DEFAULT_IV_PARAMETER_SPEC);
        return this.cbcCipher.doFinal(data);
    }

    @Override
    public byte[] decryptNonce(SecretKey key, byte[] data) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (key == null || data == null) {
            throw new IllegalArgumentException("null key or data not permitted");
        }
        if (data.length != this.ecbCipher.getBlockSize()) {
            throw new IllegalArgumentException("data length not matching block length of cipher");
        }
        this.ecbCipher.init(2, key);
        byte[] decNonce = this.ecbCipher.doFinal(data);
        return decNonce;
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] ssc) throws IllegalArgumentException, IllegalStateException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        if (data == null || data.length == 0 || ssc == null || ssc.length != 8) {
            throw new IllegalArgumentException("null or empty data not permitted, ssc must be 8 bytes long");
        }
        if (this.encKey == null) {
            throw new IllegalStateException("key not set, execution not possible");
        }
        this.cbcCipher.init(1, (Key)this.encKey, DEFAULT_IV_PARAMETER_SPEC);
        return this.cbcCipher.doFinal(data);
    }

    @Override
    public byte[] mac(SecretKey key, byte[] data, int byteLength) throws InvalidKeyException, IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (byteLength < 1 || byteLength > 8) {
            throw new IllegalArgumentException("byteLength must be in range [1..8]");
        }
        return ByteUtil.subbytes(this.mac(key, data), 0, byteLength);
    }

    @Override
    public byte[] mac(SecretKey key, byte[] data) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null || data == null) {
            throw new IllegalArgumentException("null or empty data not permitted");
        }
        Mac mac = Mac.getInstance("ISO9797ALG3MAC");
        mac.init(key);
        return mac.doFinal(data);
    }

    @Override
    public byte[] mac(byte[] data) throws IllegalArgumentException, IllegalStateException {
        if (data == null) {
            throw new IllegalArgumentException("null or empty data not permitted");
        }
        if (this.macKey == null) {
            throw new IllegalStateException("key not set, execution not possible");
        }
        return this.mac.doFinal(data);
    }

    @Override
    public void setEncryptionKey(SecretKey key) throws IllegalArgumentException {
        if (key == null || !key.getAlgorithm().equals("DESede")) {
            throw new IllegalArgumentException("null or wrong algorithm not permitted");
        }
        this.encKey = key;
    }

    @Override
    public void setMACKey(SecretKey key) throws IllegalArgumentException, InvalidKeyException {
        if (key == null || !key.getAlgorithm().equals("DESede")) {
            throw new IllegalArgumentException("null or wrong algorithm not permitted");
        }
        this.macKey = key;
        this.mac.init(key);
    }

    @Override
    public SecretKey generateSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator gen = KeyGenerator.getInstance("DESede");
        return gen.generateKey();
    }

    @Override
    public byte[] encrypt(SecretKey key, byte[] data) throws IllegalArgumentException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (key == null || data == null || data.length == 0) {
            throw new IllegalArgumentException("null or empty data not permitted");
        }
        this.ecbCipher.init(1, key);
        return this.ecbCipher.doFinal(data);
    }
}

