/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl;

import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.KeyDerivationHandler;
import java.security.MessageDigest;
import javax.crypto.SecretKey;

abstract class AbstractKeyDerivation
implements KeyDerivationHandler {
    MessageDigest digest = null;

    AbstractKeyDerivation(MessageDigest md) {
        this.digest = md;
    }

    @Override
    public final SecretKey deriveEncKey(byte[] data, byte[] nonce) throws IllegalArgumentException {
        return this.kdf(data, nonce, KDF_ENC);
    }

    @Override
    public final SecretKey deriveMACKey(byte[] data, byte[] nonce) throws IllegalArgumentException {
        return this.kdf(data, nonce, KDF_MAC);
    }

    @Override
    public final SecretKey deriveMRZKey(String data) throws IllegalArgumentException {
        if (data == null || data.equals("")) {
            throw new IllegalArgumentException("null or empty data not permitted");
        }
        byte[] k = this.digest.digest(data.getBytes());
        return this.kdf(k, null, KDF_PI);
    }

    @Override
    public final SecretKey deriveCANKey(String data) throws IllegalArgumentException {
        return this.deriveCANPINPUKKey(data);
    }

    @Override
    public final SecretKey derivePINKey(String data) throws IllegalArgumentException {
        return this.deriveCANPINPUKKey(data);
    }

    @Override
    public final SecretKey derivePUKKey(String data) throws IllegalArgumentException {
        return this.deriveCANPINPUKKey(data);
    }

    private final SecretKey deriveCANPINPUKKey(String data) throws IllegalArgumentException {
        if (data == null || data.equals("")) {
            throw new IllegalArgumentException("null or empty data not permitted");
        }
        byte[] k = data.getBytes();
        return this.kdf(k, null, KDF_PI);
    }

    abstract SecretKey kdf(byte[] var1, byte[] var2, byte[] var3) throws IllegalArgumentException;
}

