/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ca.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.CryptoHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.KeyDerivationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.Crypto3DES;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.CryptoAES;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyDerivation3DES;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyDerivationAES128;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyDerivationAES192;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyDerivationAES256;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyHandlerEC;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.KeyHandler;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChipAuthentication {
    private static final String EPHEMERAL_PUBLIC_KEY_TO_CARD_TAG = "80";
    private static final byte[] NONCE_TAG_BYTE = new byte[]{-127};
    private static final byte[] AUTHENTICATION_TOKEN_TAG_BYTE = new byte[]{-126};
    private EPA epaService = null;
    private int caVersion = 0;
    private OID oid = null;
    private SecurityInfos.ChipAuthenticationDomainParameterInfo caDomParamInfo = null;
    private SecurityInfos.ChipAuthenticationPublicKeyInfo caPubKeyInfo = null;
    private SecurityInfos.PACEInfo paceInfo = null;
    private Log log;
    private KeyPair ephTACAKeyPair = null;
    private CryptoHandler crypto = null;
    private KeyDerivationHandler kdh = null;
    private KeyHandler kh = null;
    private SecretKey macKey = null;
    private SecretKey encKey = null;
    private byte[] nonce = null;
    private byte[] authenticationToken = null;
    private boolean success = false;

    public ChipAuthentication(EPA epaService, SecurityInfos.ChipAuthenticationInfo caInfo, SecurityInfos.ChipAuthenticationDomainParameterInfo caDomParamInfo, SecurityInfos.ChipAuthenticationPublicKeyInfo caPubKeyInfo, SecurityInfos.PACEInfo paceInfo) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchPaddingException, IOException, NoSuchProviderException {
        if (caInfo == null || caDomParamInfo == null || caPubKeyInfo == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        try {
            this.caVersion = caInfo.getVersion().getValue()[0];
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to construct CA: cannot read version");
        }
        if (this.caVersion < 1 || this.caVersion > 2) {
            throw new IllegalArgumentException("Unable to construct CA: unknown version");
        }
        this.oid = new OID(caInfo.getProtocol().getEncoded());
        this.epaService = epaService;
        this.caDomParamInfo = caDomParamInfo;
        this.caPubKeyInfo = caPubKeyInfo;
        this.paceInfo = paceInfo;
        this.log = LogFactory.getLog(ChipAuthentication.class);
        this.initCA(caInfo);
    }

    public ChipAuthentication(SecurityInfos.ChipAuthenticationInfo caInfo, SecurityInfos.ChipAuthenticationDomainParameterInfo caDomParamInfo, SecurityInfos.ChipAuthenticationPublicKeyInfo caPubKeyInfo, SecurityInfos.PACEInfo paceInfo) throws IllegalArgumentException, IOException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        this(null, caInfo, caDomParamInfo, caPubKeyInfo, paceInfo);
    }

    private void initCA(SecurityInfos.ChipAuthenticationInfo info) throws IllegalArgumentException, IOException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        if (info == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        OID oid = new OID(info.getProtocol().getEncoded());
        this.log.debug((Object)("Initializing CA for protocol " + oid));
        if (oid.equals(SecurityInfos.OID_CA_ECDH_3DES_CBC_CBC)) {
            this.crypto = new Crypto3DES();
            this.kdh = new KeyDerivation3DES();
            this.kh = new KeyHandlerEC();
        } else if (oid.equals(SecurityInfos.OID_CA_ECDH_AES_CBC_CMAC_128)) {
            this.crypto = new CryptoAES(128);
            this.kdh = new KeyDerivationAES128();
            this.kh = new KeyHandlerEC();
        } else if (oid.equals(SecurityInfos.OID_CA_ECDH_AES_CBC_CMAC_192)) {
            this.crypto = new CryptoAES(192);
            this.kdh = new KeyDerivationAES192();
            this.kh = new KeyHandlerEC();
        } else if (oid.equals(SecurityInfos.OID_CA_ECDH_AES_CBC_CMAC_256)) {
            this.crypto = new CryptoAES(256);
            this.kdh = new KeyDerivationAES256();
            this.kh = new KeyHandlerEC();
        }
    }

    public synchronized boolean executeCARemote(byte[] terminalEphPublicKey) throws IllegalArgumentException, IllegalStateException, Exception {
        if (this.epaService == null) {
            throw new IllegalStateException("Unable to execute CA: no card service set");
        }
        AssertUtil.notNullOrEmpty(terminalEphPublicKey, "ephemeral public key of terminal");
        String dataFieldString = EPAUtil.makeTag(EPHEMERAL_PUBLIC_KEY_TO_CARD_TAG, HexUtil.hexify(this.oid.getValue()));
        CommandAPDU cmd = EPAUtil.commandFromString("002241 A4", dataFieldString, EPAUtil.LENGTH_EXPECTED_NONE);
        ResponseAPDU decResponse = this.epaService.sendCommandAPDU(cmd);
        EPAUtil.logCommand(this.log, "MSE:Set AT for CA", cmd, decResponse);
        try {
            EPAUtil.checkResponse(decResponse, false);
        }
        catch (Exception e) {
            throw new InternalError("(CA) MSE:Set AT failed:" + decResponse.sw());
        }
        dataFieldString = EPAUtil.makeTag("7C", EPAUtil.makeTag(EPHEMERAL_PUBLIC_KEY_TO_CARD_TAG, HexUtil.hexify(terminalEphPublicKey)));
        cmd = EPAUtil.commandFromString("0086 00 00", dataFieldString, "00");
        decResponse = this.epaService.sendCommandAPDU(cmd);
        EPAUtil.logCommand(this.log, "General Authenticate for CA", cmd, decResponse);
        try {
            if (this.caVersion == 1) {
                EPAUtil.checkResponse(decResponse, false);
            } else {
                EPAUtil.checkResponse(decResponse, true);
            }
        }
        catch (Exception e) {
            throw new InternalError("(CA) General Authenticate failed:" + decResponse.sw());
        }
        if (this.caVersion == 2) {
            ASN1 responseData = new ASN1(decResponse.data());
            ASN1[] nonceData = responseData.getChildElementsByDTagBytes(NONCE_TAG_BYTE);
            if (nonceData == null || nonceData.length != 1) {
                this.log.debug((Object)"CA not successful: no nonce received");
                throw new InternalError("(CA) no nonce received");
            }
            ASN1[] authTokenData = responseData.getChildElementsByDTagBytes(AUTHENTICATION_TOKEN_TAG_BYTE);
            if (authTokenData == null || authTokenData.length != 1) {
                this.log.debug((Object)"CA not successful: no authentication token received");
                throw new InternalError("(CA) no authentication token received");
            }
            this.nonce = nonceData[0].getValue();
            this.authenticationToken = authTokenData[0].getValue();
        }
        this.success = true;
        return this.success;
    }

    public synchronized boolean executeCALocal(KeyPair ephTACAKeyPair) throws IllegalStateException, IllegalArgumentException {
        if (this.epaService == null) {
            throw new IllegalStateException("Unable to execute CA: no card service set");
        }
        if (this.caVersion == 1 && ephTACAKeyPair != null) {
            throw new IllegalArgumentException("CA cannot be executed: in version 1, an ephemeral key pair must not be provided");
        }
        if (this.caVersion == 2 && ephTACAKeyPair == null) {
            throw new IllegalArgumentException("CA cannot be executed: in version 2, an ephemeral key pair established in TA must be provided");
        }
        try {
            this.ephTACAKeyPair = this.caVersion == 2 ? ephTACAKeyPair : this.kh.generateKeyPair(this.caDomParamInfo);
            String dataFieldString = EPAUtil.makeTag(EPHEMERAL_PUBLIC_KEY_TO_CARD_TAG, HexUtil.hexify(this.oid.getValue()));
            CommandAPDU cmd = EPAUtil.commandFromString("002241 A4", dataFieldString, EPAUtil.LENGTH_EXPECTED_NONE);
            ResponseAPDU decResponse = this.epaService.sendCommandAPDU(cmd);
            EPAUtil.logCommand(this.log, "MSE:Set AT for CA", cmd, decResponse);
            EPAUtil.checkResponse(decResponse, false);
            byte[] keyBytes = this.kh.ephemeralKeyBytes(this.ephTACAKeyPair.getPublic());
            dataFieldString = EPAUtil.makeTag("7C", EPAUtil.makeTag(EPHEMERAL_PUBLIC_KEY_TO_CARD_TAG, HexUtil.hexify(keyBytes)));
            cmd = EPAUtil.commandFromString("0086 00 00", dataFieldString, "00");
            decResponse = this.epaService.sendCommandAPDU(cmd);
            EPAUtil.logCommand(this.log, "General Authenticate for CA", cmd, decResponse);
            EPAUtil.checkResponse(decResponse, true);
            ASN1 responseData = new ASN1(decResponse.data());
            byte[] nonce = null;
            byte[] authToken = null;
            if (this.caVersion == 2) {
                ASN1[] nonceData = responseData.getChildElementsByDTagBytes(NONCE_TAG_BYTE);
                if (nonceData == null || nonceData.length != 1) {
                    this.log.debug((Object)"CA not successful: no nonce received");
                    return false;
                }
                nonce = nonceData[0].getValue();
                ASN1[] authTokenData = responseData.getChildElementsByDTagBytes(AUTHENTICATION_TOKEN_TAG_BYTE);
                if (authTokenData == null || authTokenData.length != 1) {
                    this.log.debug((Object)"CA not successful: no authentication token received");
                    return false;
                }
                authToken = authTokenData[0].getValue();
            }
            this.success = this.processResponse(this.ephTACAKeyPair, nonce, authToken);
        }
        catch (Exception e) {
            this.log.warn((Object)("CA not successful: Exception thrown - " + e.getMessage()));
            this.success = false;
        }
        return this.success;
    }

    public boolean processResponse(KeyPair tacaKeyPair, byte[] nonce, byte[] authToken) throws IOException, InvalidKeyException, IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        AssertUtil.notNull(tacaKeyPair, "key pair");
        AssertUtil.notNullOrEmpty(nonce, "nonce");
        AssertUtil.notNullOrEmpty(authToken, "authentication token");
        SecurityInfos.SubjectPublicKeyInfo keyInfo = this.caPubKeyInfo.getChipAuthenticationPublicKey();
        byte[] cardKeyBytes = ByteUtil.removeLeadingZero(keyInfo.getSubjectPublicKey().getValue());
        PublicKey chipKey = this.kh.generateKeyFromBytes(this.caDomParamInfo, cardKeyBytes);
        byte[] sharedBytes = this.kh.agreeSharedSecret(tacaKeyPair.getPrivate(), chipKey);
        this.encKey = this.kdh.deriveEncKey(sharedBytes, nonce);
        this.macKey = this.kdh.deriveMACKey(sharedBytes, nonce);
        if (this.caVersion == 2) {
            byte[] structure;
            byte[] mac;
            int paceVersion = 2;
            if (this.paceInfo != null) {
                paceVersion = new BigInteger(this.paceInfo.getVersion().getValue()).intValue();
            }
            if (!Arrays.equals(authToken, mac = this.crypto.mac(this.macKey, structure = this.kh.convertPublicKey(tacaKeyPair.getPublic(), this.oid, paceVersion == 1)))) {
                this.log.debug((Object)"CA not successful: could not verify MAC");
                this.success = false;
            } else {
                this.log.debug((Object)"CA successful: MAC ok");
                this.success = true;
            }
        } else {
            this.success = true;
        }
        return this.success;
    }

    public synchronized SecretKey getMacKey() throws IllegalStateException {
        if (!this.success) {
            throw new IllegalStateException("CA not yet successfully executed");
        }
        return this.macKey;
    }

    public synchronized SecretKey getEncKey() {
        if (!this.success) {
            throw new IllegalStateException("CA not yet successfully executed");
        }
        return this.encKey;
    }

    public synchronized KeyPair getEphTACAKeyPair() throws IllegalStateException {
        if (!this.success) {
            throw new IllegalStateException("CA not yet successfully executed");
        }
        return this.ephTACAKeyPair;
    }

    public synchronized byte[] getNonce() throws IllegalStateException {
        if (this.caVersion != 2) {
            throw new IllegalStateException("wrong CA version, must be 2");
        }
        if (!this.success) {
            throw new IllegalStateException("CA not yet successfully executed");
        }
        return this.nonce;
    }

    public synchronized byte[] getAuthenticationToken() throws IllegalStateException {
        if (this.caVersion != 2) {
            throw new IllegalStateException("wrong CA version, must be 2");
        }
        if (!this.success) {
            throw new IllegalStateException("CA not yet successfully executed");
        }
        return this.authenticationToken;
    }
}

