/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa;

import de.bos_bremen.basecard.terminal.pcsc.PaceCapabilities;
import de.bos_bremen.basecard.terminal.pcsc.PaceConstants;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardEvent;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.util.List;
import opencard.core.terminal.CardTerminal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PASignatureManager
implements CardListener {
    private static final Log LOG = LogFactory.getLog(PASignatureManager.class);
    private static PASignatureManager singletonInstance;
    private PAPrepareSignatureController paPrepareSignatureController = PAPrepareSignatureController.DEFAULT;

    public PAPrepareSignatureController getPaPrepareSignatureController() {
        return this.paPrepareSignatureController;
    }

    public synchronized void setPaPrepareSignatureController(PAPrepareSignatureController paPrepareSignatureController) {
        this.paPrepareSignatureController = paPrepareSignatureController == null ? PAPrepareSignatureController.DEFAULT : paPrepareSignatureController;
    }

    private PASignatureManager() {
        CardObjectRegistryImpl.getInstance().addCardListener(this);
    }

    public static synchronized PASignatureManager getManager() {
        if (singletonInstance == null) {
            singletonInstance = new PASignatureManager();
        }
        return singletonInstance;
    }

    @Override
    public void processEvent(CardEvent event) {
        GovCS govCS;
        Card card;
        if (0 == event.getType() && (card = event.getCard()) != null && (govCS = event.getCard().getCardService()) instanceof EPA && this.getESignReader(card.getTerminal().getCardTerminal()) != null && this.paPrepareSignatureController.preparePAForSigning()) {
            try {
                EPA pa = (EPA)event.getCard().getCardService();
                pa.prepareSignatureTerminal(this.paPrepareSignatureController.usePINForPACE());
            }
            catch (Throwable t) {
                this.paPrepareSignatureController.handlePrepareSigningFailure(t);
            }
        }
    }

    private PCSCCardTerminal getESignReader(CardTerminal terminal) {
        return this.getReader(terminal, PaceConstants.PaceCapabilityEnum.ESIGN);
    }

    private PCSCCardTerminal getReader(CardTerminal terminal, PaceConstants.PaceCapabilityEnum capability) {
        PCSCCardTerminal pcscCT = null;
        Pcsc20Features features = null;
        if (!PCSCCardTerminal.class.isInstance(terminal)) {
            return null;
        }
        pcscCT = (PCSCCardTerminal)terminal;
        features = pcscCT.getPcsc20Features();
        if (!features.isFeatureSupported(32)) {
            return null;
        }
        PaceCapabilities pc = features.getPaceCapabilities();
        if (pc == null) {
            return null;
        }
        List<PaceConstants.PaceCapabilityEnum> pcList = pc.getCapabilitiesList();
        if (pcList == null || pcList.size() == 0 || !pcList.contains(capability)) {
            return null;
        }
        return pcscCT;
    }

    public static interface PAPrepareSignatureController {
        public static final boolean PA_NEVER_PREPARE = false;
        public static final boolean PA_ALWAYS_PREPARE = true;
        public static final boolean PA_USE_PIN = true;
        public static final boolean PA_USE_CAN = false;
        public static final boolean DEFAULT_USE_PIN_FOR_PACE = true;
        public static final PAPrepareSignatureController PA_ALWAYS_PREPARE_FOR_SIGNING = new PAPrepareSignatureController(){

            @Override
            public boolean usePINForPACE() {
                return true;
            }

            @Override
            public boolean preparePAForSigning() {
                return true;
            }

            @Override
            public void handlePrepareSigningFailure(Throwable throwable) {
                LOG.debug((Object)("failed prepare PA for signine: " + throwable.getMessage()), throwable);
            }
        };
        public static final PAPrepareSignatureController PA_NEVER_PREPARE_FOR_SIGNING = new PAPrepareSignatureController(){

            @Override
            public boolean usePINForPACE() {
                return true;
            }

            @Override
            public boolean preparePAForSigning() {
                return false;
            }

            @Override
            public void handlePrepareSigningFailure(Throwable throwable) {
            }
        };
        public static final PAPrepareSignatureController DEFAULT = PA_ALWAYS_PREPARE_FOR_SIGNING;

        public boolean preparePAForSigning();

        public boolean usePINForPACE();

        public void handlePrepareSigningFailure(Throwable var1);
    }
}

