/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class EPAUtil {
    public static final String KDF_MODE_ENC = "00000001";
    public static final String KDF_MODE_MAC = "00000002";
    public static final String KDF_MODE_PI = "00000003";
    public static final byte PIN_ID_MRZ = 1;
    public static final byte PIN_ID_CAN = 2;
    public static final byte PIN_ID_PIN = 3;
    public static final byte PIN_ID_PUK = 4;
    public static final String COMMAND_CHAINING_ENABLED = "10";
    public static final String COMMAND_CHAINING_DISABLED = "00";
    public static final String MSE_INS = "22";
    public static final String MSE_SET_AT_PARAM_PACE = "C1 A4";
    public static final String MSE_SET_AT_PARAM_TA = "81 A4";
    public static final String MSE_SET_AT_PARAM_CA = "41 A4";
    public static final String MSE_SET_AT_PARAM_RI = "41 A4";
    public static final String MSE_SET_AT_OID_TAG = "80";
    public static final String MSE_SET_AT_PUBLIC_KEY_REFERENCE_TAG = "83";
    public static final String MSE_SET_AT_PRIVATE_KEY_REFERENCE_TAG = "84";
    public static final String MSE_SET_AT_EPHEMERAL_PUBLIC_KEY_TAG = "91";
    public static final String MSE_SET_DST_PARAM = "81 B6";
    public static final String MSE_SET_DST_PUBLIC_KEY_REFERENCE_TAG = "83";
    public static final String GENERAL_AUTHENTICATE_HEADER = "86 00 00";
    public static final String GA_DATA_TAG = "7C";
    public static final String EXTERNAL_AUTHENTICATE_HEADER = "82 00 00";
    public static final String GET_CHALLENGE_HEADER = "84 00 00";
    public static final String PSO_INS = "2A";
    public static final String PSO_VERIFY_CERT_PARAM = "00 BE";
    public static final String LENGTH_EXPECTED_MAX = "00";
    public static final String LENGTH_EXPECTED_NONE = null;
    public static final String PIN_CMD_CHANGE_HEADER = "002c0203";
    public static final String PIN_CMD_RESUME_HEADER = "002c0303";
    public static final String PIN_CMD_GET_RETRY_COUNT = "00200003";
    public static final String PIN_CMD_ACTIVATE = "00441003";
    public static final String PIN_CMD_DEACTIVATE = "00041003";
    public static final String CMD_SELECT_FILE_HEADER = "00a4020c";
    public static final String CLA_INS_READ = "00b0";

    public static ASN1 convertPublicKey(JCEECPublicKey key, byte[] oidBytes) throws IllegalArgumentException {
        if (key == null || oidBytes == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        ASN1 oid = new ASN1(6, oidBytes);
        ASN1 primeModulus = new ASN1(129, ((ECCurve.Fp)key.getParameters().getCurve()).getQ().toByteArray());
        ASN1 firstCoefficient = new ASN1(130, key.getParameters().getCurve().getA().toBigInteger().toByteArray());
        ASN1 secondCoefficient = new ASN1(131, key.getParameters().getCurve().getB().toBigInteger().toByteArray());
        ASN1 basePoint = new ASN1(132, key.getParameters().getG().getEncoded(false));
        ASN1 orderOfBasePoint = new ASN1(133, key.getParameters().getN().toByteArray());
        ASN1 publicPoint = new ASN1(134, key.getQ().getEncoded(false));
        ASN1 cofactor = new ASN1(135, key.getParameters().getH().toByteArray());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(oid.getEncoded());
            baos.write(primeModulus.getEncoded());
            baos.write(firstCoefficient.getEncoded());
            baos.write(secondCoefficient.getEncoded());
            baos.write(basePoint.getEncoded());
            baos.write(orderOfBasePoint.getEncoded());
            baos.write(publicPoint.getEncoded());
            baos.write(cofactor.getEncoded());
        }
        catch (IOException e) {
            return null;
        }
        return new ASN1(32585, baos.toByteArray());
    }

    public static byte[] convertPublicKey(ECCurve curve, ECPoint g, ECPoint y, BigInteger n, BigInteger h, OID oid) throws IllegalArgumentException {
        if (curve == null || g == null || y == null || h == null || n == null || oid == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        ASN1 primeModulus = new ASN1(129, ((ECCurve.Fp)curve).getQ().toByteArray());
        ASN1 firstCoefficient = new ASN1(130, curve.getA().toBigInteger().toByteArray());
        ASN1 secondCoefficient = new ASN1(131, curve.getB().toBigInteger().toByteArray());
        ASN1 basePoint = new ASN1(132, g.getEncoded(false));
        ASN1 orderOfBasePoint = new ASN1(133, n.toByteArray());
        ASN1 publicPoint = new ASN1(134, y.getEncoded(false));
        ASN1 cofactor = new ASN1(135, h.toByteArray());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(oid.getEncoded());
            baos.write(primeModulus.getEncoded());
            baos.write(firstCoefficient.getEncoded());
            baos.write(secondCoefficient.getEncoded());
            baos.write(basePoint.getEncoded());
            baos.write(orderOfBasePoint.getEncoded());
            baos.write(publicPoint.getEncoded());
            baos.write(cofactor.getEncoded());
        }
        catch (IOException e) {
            return null;
        }
        return new ASN1(32585, baos.toByteArray()).getEncoded();
    }

    public static ASN1 convertPublicKey(byte[] oidBytes, byte[] primeModulusBytes, byte[] firstCoefficientBytes, byte[] secondCoefficientBytes, byte[] basePointBytes, byte[] orderOfBasePointBytes, byte[] publicPointBytes, byte[] cofactorBytes) throws IllegalArgumentException {
        if (oidBytes == null || primeModulusBytes == null || firstCoefficientBytes == null || secondCoefficientBytes == null || basePointBytes == null || orderOfBasePointBytes == null || publicPointBytes == null || cofactorBytes == null) {
            throw new IllegalArgumentException("parameters not permitted as null");
        }
        ASN1 oid = new ASN1(6, oidBytes);
        ASN1 primeModulus = new ASN1(129, primeModulusBytes);
        ASN1 firstCoefficient = new ASN1(130, firstCoefficientBytes);
        ASN1 secondCoefficient = new ASN1(131, secondCoefficientBytes);
        ASN1 basePoint = new ASN1(132, basePointBytes);
        ASN1 orderOfBasePoint = new ASN1(133, orderOfBasePointBytes);
        ASN1 publicPoint = new ASN1(134, publicPointBytes);
        ASN1 cofactor = new ASN1(135, cofactorBytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(oid.getEncoded());
            baos.write(primeModulus.getEncoded());
            baos.write(firstCoefficient.getEncoded());
            baos.write(secondCoefficient.getEncoded());
            baos.write(basePoint.getEncoded());
            baos.write(orderOfBasePoint.getEncoded());
            baos.write(publicPoint.getEncoded());
            baos.write(cofactor.getEncoded());
        }
        catch (IOException e) {
            return null;
        }
        return new ASN1(32585, baos.toByteArray());
    }

    public static JCEECPublicKey createKeyFromASN1EPA(ASN1 keyData) throws IllegalArgumentException {
        KeyFactory factory;
        if (keyData == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        BigInteger primeModulus = null;
        BigInteger firstCoefficient = null;
        BigInteger secondCoefficient = null;
        byte[] basePointBytes = null;
        BigInteger orderOfBasePoint = null;
        byte[] publicPointBytes = null;
        BigInteger cofactor = null;
        try {
            primeModulus = new BigInteger(ByteUtil.addLeadingZero(keyData.getChildElementsByDTag(BigInteger.valueOf(129L))[0].getValue()));
            firstCoefficient = new BigInteger(ByteUtil.addLeadingZero(keyData.getChildElementsByDTag(BigInteger.valueOf(130L))[0].getValue()));
            secondCoefficient = new BigInteger(ByteUtil.addLeadingZero(keyData.getChildElementsByDTag(BigInteger.valueOf(131L))[0].getValue()));
            basePointBytes = keyData.getChildElementsByDTag(BigInteger.valueOf(132L))[0].getValue();
            orderOfBasePoint = new BigInteger(ByteUtil.addLeadingZero(keyData.getChildElementsByDTag(BigInteger.valueOf(133L))[0].getValue()));
            publicPointBytes = keyData.getChildElementsByDTag(BigInteger.valueOf(134L))[0].getValue();
            cofactor = new BigInteger(ByteUtil.addLeadingZero(keyData.getChildElementsByDTag(BigInteger.valueOf(135L))[0].getValue()));
        }
        catch (IOException e) {
            return null;
        }
        ECCurve.Fp curve = new ECCurve.Fp(primeModulus, firstCoefficient, secondCoefficient);
        ECPoint basePoint = curve.decodePoint(basePointBytes);
        ECPoint publicPoint = curve.decodePoint(publicPointBytes);
        ECParameterSpec paramSpec = new ECParameterSpec((ECCurve)curve, basePoint, orderOfBasePoint, cofactor);
        ECPublicKeySpec keySpec = new ECPublicKeySpec(publicPoint, paramSpec);
        try {
            factory = KeyFactory.getInstance("EC", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (NoSuchProviderException e) {
            return null;
        }
        JCEECPublicKey key = null;
        try {
            key = (JCEECPublicKey)factory.generatePublic((KeySpec)keySpec);
        }
        catch (InvalidKeySpecException e) {
            return null;
        }
        return key;
    }

    public static JCEECPublicKey createKeyFromASN1EPA(ASN1 keyData, ECParameterSpec paramSpec) throws IllegalArgumentException {
        KeyFactory factory;
        if (keyData == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        byte[] publicPointBytes = null;
        try {
            publicPointBytes = keyData.getChildElementsByDTag(BigInteger.valueOf(134L))[0].getValue();
        }
        catch (IOException e) {
            return null;
        }
        ECPoint publicPoint = paramSpec.getCurve().decodePoint(publicPointBytes);
        ECPublicKeySpec keySpec = new ECPublicKeySpec(publicPoint, paramSpec);
        try {
            factory = KeyFactory.getInstance("EC", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (NoSuchProviderException e) {
            return null;
        }
        JCEECPublicKey key = null;
        try {
            key = (JCEECPublicKey)factory.generatePublic((KeySpec)keySpec);
        }
        catch (InvalidKeySpecException e) {
            return null;
        }
        return key;
    }

    public static String makeTag(String tagHexString, String valueHexString) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(tagHexString, "hex string of tag");
        AssertUtil.notNull(valueHexString, "value string of tag");
        int valueLength = valueHexString.length() / 2;
        String additionalLength = valueLength > 255 ? "82" : (valueLength > 127 ? "81" : "");
        return tagHexString + additionalLength + HexUtil.hexify(valueHexString.length() / 2) + valueHexString;
    }

    public static CommandAPDU commandFromString(String header, String data, String expectedLength) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(header, "hex string of header");
        byte[] headerBytes = HexUtil.parse(header);
        byte[] dataBytes = null;
        byte[] elBytes = null;
        Object apduString = header;
        if (data != null) {
            apduString = (String)apduString + HexUtil.hexify((byte)(data.length() / 2)) + data;
            dataBytes = HexUtil.parse(data);
        }
        if (expectedLength != null) {
            apduString = (String)apduString + expectedLength;
            elBytes = ByteUtil.addLeadingZero(HexUtil.parse(expectedLength));
        }
        return new GISOCommandAPDU(headerBytes[0], (Byte)headerBytes[1], (Byte)headerBytes[2], (Byte)headerBytes[3], dataBytes, elBytes != null ? Integer.valueOf(new BigInteger(elBytes).intValue()) : null);
    }

    public static CommandAPDU commandFromString(String command) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(command, "hex string of command");
        return new CommandAPDU(HexUtil.parse(command));
    }

    public static void logCommand(Log log, String purpose, CommandAPDU command, ResponseAPDU response) throws IllegalArgumentException {
        if (log == null || command == null || response == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        log.debug((Object)((String)(purpose == null ? "" : "\nPurpose: " + purpose) + "\nCommand: " + command + "Response: " + response));
    }

    public static void checkResponse(ResponseAPDU response, boolean dataExpected) throws IllegalArgumentException, IllegalStateException {
        if (response == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        if (response.sw1() != -112 || response.sw2() != 0) {
            throw new IllegalStateException("response code not 0x9000");
        }
        if (dataExpected && response.data() == null) {
            throw new IllegalStateException("response data expected, but nothing present");
        }
        if (!dataExpected && response.data() != null) {
            throw new IllegalStateException("no response data expected, but something present");
        }
    }

    public static SecurityInfos extractFromCardSecurity(byte[] cardSecurity) throws IOException, IllegalArgumentException {
        AssertUtil.notNullOrEmpty(cardSecurity, "bytes of EF.CardSecurity");
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)cardSecurity);
        ASN1TaggedObject dto = (ASN1TaggedObject)seq.getObjectAt(1);
        SignedData signedData = new SignedData((ASN1Sequence)dto.getBaseObject());
        ASN1 octetString = new ASN1(signedData.getContentInfo().getContent().toASN1Primitive().getEncoded("DER"));
        SecurityInfos result = new SecurityInfos(octetString.getValue());
        result = (SecurityInfos)result.decode(result);
        return result;
    }
}

