/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa;

import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.common.pin.PinModifyParameters;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.terminal.BTerminalException;
import de.bos_bremen.basecard.terminal.pcsc.PaceConstants;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.basecard.terminal.pcsc.handler.Pcsc20PinStructureHandler;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerFactory;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.PinModifyStructure;
import de.bos_bremen.basecard.terminal.pcsc.impl.PaceInputData;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.AuthenticationTerminals;
import de.bos_bremen.common.asn1.cvc.CertificateHolderAuthorizationTemplate;
import de.bos_bremen.common.asn1.cvc.EIDConstants;
import de.bos_bremen.common.asn1.cvc.SignatureTerminals;
import de.bos_bremen.common.constants.OIDConstants;
import de.bos_bremen.common.system.LanguageEnum;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.common.system.SystemPropertyUtil;
import de.bos_bremen.gov2.jca_provider.ocf.CardTerminalManager;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFPinRelatedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.SecureCard;
import de.bos_bremen.gov2.jca_provider.ocf.WrongConfirmedNewPinException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CanPukRequestDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVConfiguration;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.SMCard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.SMGovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAPinManagementInterface;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ca.impl.ChipAuthentication;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PACE;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PaceInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PacePlusOutputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PacePlusResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TACAInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TACAOutputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TACAResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TerminalAuthentication;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.CardErrorUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.SecureMessaging;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AESKeyMaterialImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AESSecureMessagingImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.AESEncSSCIvParameterSpecImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import de.bos_bremen.java.pcsc.EnhancedJPCSCReaderState;
import de.bos_bremen.jni.JavaSystemBridge;
import de.bos_bremen.jni.OSInfo;
import de.bos_bremen.jni.pcsc.PCSCReaderState;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminal;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;

public class EPA
extends SMGovCS
implements SecureCard,
EIDConstants,
EPAPinManagementInterface,
SMCard {
    private static final byte[] AUTH_TOKEN_FROM_CARD_TAG = new byte[]{-122};
    private static final byte[] CAR1_FROM_CARD_TAG = new byte[]{-121};
    private static final byte[] CAR2_FROM_CARD_TAG = new byte[]{-120};
    public static final String FID_CARDACCESS = "011c";
    private static final String FID_CARDACCESS_OLD = "011e";
    public static final String FID_CARDSECURITY = "011d";
    private static final String FID_CVCA = "011c";
    private static final String FID_ESIGN_CA_CERT = "c000";
    private static final String FID_ESIGN_CERT = "c001";
    private static final String AID_ESIGN = "A000000167455349474E";
    private static final byte ID_ESIGN_PIN = -127;
    private static final String ID_ESIGN_KEY = "84";
    private static final String EPA_ISSUER = "EPA";
    private static final String CHAT_SIG_TERM = "7f4c0e060904007f000703010203530103";
    public static final int LENGTH_PUK = 10;
    public static final int LENGTH_CAN = 6;
    public static final int LENGTH_PIN_INIT = 5;
    public static final String PWD_NAME_PIN_SIG = "PIN.SIG";
    public static final String PWD_NAME_MRZ = "MRZ";
    public static final String PWD_NAME_CAN = "CAN";
    public static final String PWD_NAME_PIN = "PIN";
    public static final String PWD_NAME_PUK = "PUK";
    private static final Log log = LogFactory.getLog(EPA.class);
    private static final byte[][] HISTORICALS = new byte[][]{HexUtil.parse("4120004177d100009000"), HexUtil.parse("00009000"), HexUtil.parse("097877d40200009000"), HexUtil.parse("4120004177d18031f873f741e082"), HexUtil.parse("8031f873f741e0829000"), HexUtil.parse("0f7877d4028031f873f741e0829000"), HexUtil.parse("42000177d1"), HexUtil.parse("00000000000000"), HexUtil.parse("0000000000000000"), HexUtil.parse("9e08000000000000"), HexUtil.parse("e1f35e137783d577"), HexUtil.parse("e1f35e137783d500")};
    private SecurityInfos cardAccess = null;
    private byte[] rawCardSecurity = null;
    private SecurityInfos cardSecurity = null;
    private List<ASN1> carList = null;
    private SecureCard.SecurityProtocol securityProtocol = null;
    private String usedPwdPACE = null;
    private CertificateHolderAuthorizationTemplate usedChatPACE = null;
    private final List<SecureCard.SecurityProtocol> supportedProtocols = Arrays.asList(SecureCard.SecurityProtocol.EAC2_PACE, SecureCard.SecurityProtocol.EAC2_PACEPLUS, SecureCard.SecurityProtocol.EAC2_TACA);
    private boolean isTransactionLocked = false;
    private boolean secondPacePossible = false;
    private int idOfCard;
    private static final PacePlusResult SPECIAL_RESULT = new PacePlusResult(new PacePlusOutputParameters());
    private boolean unknownVersion = false;
    private boolean terminalResetSkipped = false;

    @Override
    protected String getOSName() {
        return "(V. 1.0)";
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        this.idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        CardApplication eidApplication = this.createEIDApplication(terminal, slotID, idOfMFApplication);
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.put(eidApplication);
        CardApplication eSignApplication = this.createESignApplication(terminal, slotID, idOfMFApplication);
        mfManager.put(eSignApplication);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.MF.getType(), fileEntryMF, (CardObjectManager)mfManager, (long)this.idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        long idOfPin01 = 2000001L;
        long idOfPin02 = idOfPin01 + 1L;
        byte pinID01 = 3;
        byte pinID02 = 2;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, PWD_NAME_PIN, idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, (long)this.idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, null);
        pin.setUseCardPinForAccessEnabled(true);
        CardPinImpl can = new CardPinImpl(Disposeable.NO_LOCK, PWD_NAME_CAN, idOfPin02, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, (long)this.idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID02, null);
        can.disableAllPinFunctions();
        can.setUseCardPinForAccessEnabled(true);
        mfApplication.putPin(pin);
        mfApplication.putPin(can);
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(this.idOfCard), this.idOfCard, Card.CardTypeEnum.NPA.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createESignApplication(Terminal terminal, int slotID, long idOfMFApplication) throws IllegalArgumentException {
        AssertUtil.notNull(terminal, "terminal");
        long idOfApplication = 1000002L;
        long idOfESignPIN = 2000003L;
        long idOfESignCertFile = 3000032L;
        long idOfESignCACertFile = 3000033L;
        long idOfESignKey = 4000001L;
        KeyID k01 = new KeyID(ID_ESIGN_KEY);
        byte pinID01 = -127;
        FileReference dirRefESIGN = new FileReference(4, AID_ESIGN);
        FileReference cerRef01 = new FileReference(2, FID_ESIGN_CERT);
        FileEntry fileEntry01 = new FileEntry(dirRefESIGN, cerRef01);
        FileReference cerRef02 = new FileReference(2, FID_ESIGN_CA_CERT);
        FileEntry fileEntry02 = new FileEntry(dirRefESIGN, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(this.idOfCard, idOfESignPIN, idOfESignCertFile, idOfESignKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(this.idOfCard, -1L, idOfESignCACertFile, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, PWD_NAME_PIN_SIG, idOfESignPIN, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfESignKey);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfESignCertFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, this.idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfESignKey);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerSigCA", idOfESignCACertFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, this.idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfESignKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry01, this.idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfESignCertFile, idOfESignPIN, k01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("ESignAppl", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager, (long)this.idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putPin(pin01);
        application.putFile(file01);
        application.putFile(file02);
        application.putKey(key01);
        return application;
    }

    private CardApplication createEIDApplication(Terminal terminal, int slotID, long idOfMFApplication) throws IllegalArgumentException {
        AssertUtil.notNull(terminal, "terminal");
        long idOfApplication = 1000001L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfFile05 = 3000005L;
        long idOfFile06 = 3000006L;
        long idOfFile07 = 3000007L;
        long idOfFile08 = 3000008L;
        long idOfFile09 = 3000009L;
        long idOfFile0a = 3000010L;
        long idOfFile0b = 3000011L;
        long idOfFile0c = 3000012L;
        long idOfFile0d = 3000013L;
        long idOfFile0e = 3000014L;
        long idOfFile0f = 3000015L;
        long idOfFile10 = 3000016L;
        long idOfFile11 = 3000017L;
        long idOfFile12 = 3000018L;
        long idOfFile13 = 3000019L;
        long idOfFile14 = 3000020L;
        long idOfFile15 = 3000021L;
        FileReference dirRef = new FileReference(4, "e80704007f00070302");
        FileReference fileRefDG01 = new FileReference(2, "0101");
        FileEntry fileEntryDG01 = new FileEntry(dirRef, fileRefDG01);
        FileReference fileRefDG02 = new FileReference(2, "0102");
        FileEntry fileEntryDG02 = new FileEntry(dirRef, fileRefDG02);
        FileReference fileRefDG03 = new FileReference(2, "0103");
        FileEntry fileEntryDG03 = new FileEntry(dirRef, fileRefDG03);
        FileReference fileRefDG04 = new FileReference(2, "0104");
        FileEntry fileEntryDG04 = new FileEntry(dirRef, fileRefDG04);
        FileReference fileRefDG05 = new FileReference(2, "0105");
        FileEntry fileEntryDG05 = new FileEntry(dirRef, fileRefDG05);
        FileReference fileRefDG06 = new FileReference(2, "0106");
        FileEntry fileEntryDG06 = new FileEntry(dirRef, fileRefDG06);
        FileReference fileRefDG07 = new FileReference(2, "0107");
        FileEntry fileEntryDG07 = new FileEntry(dirRef, fileRefDG07);
        FileReference fileRefDG08 = new FileReference(2, "0108");
        FileEntry fileEntryDG08 = new FileEntry(dirRef, fileRefDG08);
        FileReference fileRefDG09 = new FileReference(2, "0109");
        FileEntry fileEntryDG09 = new FileEntry(dirRef, fileRefDG09);
        FileReference fileRefDG0a = new FileReference(2, "010a");
        FileEntry fileEntryDG0a = new FileEntry(dirRef, fileRefDG0a);
        FileReference fileRefDG0b = new FileReference(2, "010b");
        FileEntry fileEntryDG0b = new FileEntry(dirRef, fileRefDG0b);
        FileReference fileRefDG0c = new FileReference(2, "010c");
        FileEntry fileEntryDG0c = new FileEntry(dirRef, fileRefDG0c);
        FileReference fileRefDG0d = new FileReference(2, "010d");
        FileEntry fileEntryDG0d = new FileEntry(dirRef, fileRefDG0d);
        FileReference fileRefDG0e = new FileReference(2, "010e");
        FileEntry fileEntryDG0e = new FileEntry(dirRef, fileRefDG0e);
        FileReference fileRefDG0f = new FileReference(2, "010f");
        FileEntry fileEntryDG0f = new FileEntry(dirRef, fileRefDG0f);
        FileReference fileRefDG10 = new FileReference(2, "0110");
        FileEntry fileEntryDG10 = new FileEntry(dirRef, fileRefDG10);
        FileReference fileRefDG11 = new FileReference(2, "0111");
        FileEntry fileEntryDG11 = new FileEntry(dirRef, fileRefDG11);
        FileReference fileRefDG12 = new FileReference(2, "0112");
        FileEntry fileEntryDG12 = new FileEntry(dirRef, fileRefDG12);
        FileReference fileRefDG13 = new FileReference(2, "0113");
        FileEntry fileEntryDG13 = new FileEntry(dirRef, fileRefDG13);
        FileReference fileRefDG14 = new FileReference(2, "0114");
        FileEntry fileEntryDG14 = new FileEntry(dirRef, fileRefDG14);
        FileReference fileRefDG15 = new FileReference(2, "0115");
        FileEntry fileEntryDG15 = new FileEntry(dirRef, fileRefDG15);
        CardFileImpl fileDG01 = new CardFileImpl(Disposeable.NO_LOCK, "dg01DocumentType", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG01, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG02 = new CardFileImpl(Disposeable.NO_LOCK, "dg02IssuingState", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG02, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG03 = new CardFileImpl(Disposeable.NO_LOCK, "dg03DateOfExpiry", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG03, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG04 = new CardFileImpl(Disposeable.NO_LOCK, "dg04GivenNames", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG04, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG05 = new CardFileImpl(Disposeable.NO_LOCK, "dg05FamilyNames", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG05, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG06 = new CardFileImpl(Disposeable.NO_LOCK, "dg06ReligousAndArtisticNames", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG06, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG07 = new CardFileImpl(Disposeable.NO_LOCK, "dg07AcademiceTitle", idOfFile07, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG07, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG08 = new CardFileImpl(Disposeable.NO_LOCK, "dg08DateOfBirth", idOfFile08, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG08, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG09 = new CardFileImpl(Disposeable.NO_LOCK, "dg09PlaceOfBirth", idOfFile09, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG09, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG0a = new CardFileImpl(Disposeable.NO_LOCK, "dg0aNationality", idOfFile0a, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG0a, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG0b = new CardFileImpl(Disposeable.NO_LOCK, "dg0bSec", idOfFile0b, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG0b, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG0c = new CardFileImpl(Disposeable.NO_LOCK, "dg0cOptionalDataR", idOfFile0c, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG0c, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG0d = new CardFileImpl(Disposeable.NO_LOCK, "dg0dRFU1", idOfFile0d, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG0d, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG0e = new CardFileImpl(Disposeable.NO_LOCK, "dg0eRFU2", idOfFile0e, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG0e, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG0f = new CardFileImpl(Disposeable.NO_LOCK, "dg0fRFU3", idOfFile0f, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG0f, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG10 = new CardFileImpl(Disposeable.NO_LOCK, "dg10RFU4", idOfFile10, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG10, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG11 = new CardFileImpl(Disposeable.NO_LOCK, "dg11PlaceOfResidence", idOfFile11, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG11, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG12 = new CardFileImpl(Disposeable.NO_LOCK, "dg12CommunityID", idOfFile12, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG12, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG13 = new CardFileImpl(Disposeable.NO_LOCK, "dg13ResidencePermitI", idOfFile13, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG13, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG14 = new CardFileImpl(Disposeable.NO_LOCK, "dg14ResidencePermitII", idOfFile14, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG14, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardFileImpl fileDG15 = new CardFileImpl(Disposeable.NO_LOCK, "dg15OptionalDataRW", idOfFile15, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDG15, (long)this.idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("e80704007f00070302", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntryDG02, (CardObjectManager)manager, (long)this.idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putFile(fileDG01);
        application.putFile(fileDG02);
        application.putFile(fileDG03);
        application.putFile(fileDG04);
        application.putFile(fileDG05);
        application.putFile(fileDG06);
        application.putFile(fileDG07);
        application.putFile(fileDG08);
        application.putFile(fileDG09);
        application.putFile(fileDG0a);
        application.putFile(fileDG0b);
        application.putFile(fileDG0c);
        application.putFile(fileDG0d);
        application.putFile(fileDG0e);
        application.putFile(fileDG0f);
        application.putFile(fileDG10);
        application.putFile(fileDG11);
        application.putFile(fileDG12);
        application.putFile(fileDG13);
        application.putFile(fileDG14);
        application.putFile(fileDG15);
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        cardTerminal = null;
        channel = null;
        try {
            applicant = new Object();
            channel = scheduler.allocateCardChannel(applicant, true);
            cardTerminal = scheduler.getSlotChannel().getCardTerminal();
            scheduler.releaseCardChannel(channel);
            channel = null;
            ** if (channel == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                EPA.log.debug((Object)"detecting CardTerminal failed", (Throwable)e);
                ** if (channel == null) goto lbl-1000
            }
            catch (Throwable var7_8) {
                if (channel != null) {
                    scheduler.releaseCardChannel(channel);
                }
                throw var7_8;
            }
lbl-1000:
            // 1 sources

            {
                scheduler.releaseCardChannel(channel);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            scheduler.releaseCardChannel(channel);
        }
lbl-1000:
        // 2 sources

        {
        }
        this.checkWorkaroundYosemiteT0(cardTerminal);
        EPA.log.debug((Object)"super.initialize...");
        super.initialize(scheduler, smartcard, blocking);
    }

    private Integer getCurrentProtocol(CardTerminal cardTerminal, boolean logDetails) {
        if (cardTerminal instanceof JPCSCCardTerminal) {
            if (logDetails) {
                log.debug((Object)"PC/SC terminal");
            }
            JPCSCCardTerminal pcscTerminal = (JPCSCCardTerminal)cardTerminal;
            PCSCReaderState cardStatus = null;
            try {
                cardStatus = pcscTerminal.getCardStatus(0L);
            }
            catch (Exception e) {
                if (logDetails) {
                    log.debug((Object)"failed get card status", (Throwable)e);
                }
                return null;
            }
            if (cardStatus instanceof EnhancedJPCSCReaderState) {
                if (logDetails) {
                    log.debug((Object)"enhanced PC/SC reader state");
                }
                EnhancedJPCSCReaderState enhancedCardStatus = (EnhancedJPCSCReaderState)cardStatus;
                int protocolValue = enhancedCardStatus.getProtocolValue();
                log.debug((Object)("current card protocol: T=" + (protocolValue - 1)));
                return protocolValue;
            }
            if (logDetails) {
                log.debug((Object)("reader state: " + cardStatus.getClass().getName()));
            }
        } else if (logDetails) {
            log.debug((Object)("terminal: " + cardTerminal.getClass().getName()));
        }
        return null;
    }

    private void checkWorkaroundYosemiteT0(CardTerminal cardTerminal) {
        try {
            log.debug((Object)("OS: " + SystemEnum.getCurrentSystem()));
            log.debug((Object)("OS-Group: " + SystemEnum.getCurrentSystem().getGroup()));
            if (SystemEnum.getCurrentSystem().getGroup() == SystemEnum.SystemGroup.MACOS) {
                log.debug((Object)"MacOS");
                Integer protocolValue = this.getCurrentProtocol(cardTerminal, true);
                if (protocolValue == null) {
                    log.debug((Object)"current protocol not detectable");
                    return;
                }
                if (protocolValue == 1) {
                    log.debug((Object)"PC/SC terminal");
                    JPCSCCardTerminal pcscTerminal = (JPCSCCardTerminal)cardTerminal;
                    log.debug((Object)"MacOS may run PA with T=0, signing impossible (Yosemite 10.10 only)");
                    log.debug((Object)"disconnect");
                    pcscTerminal.disconnect(0L, 0);
                    log.debug((Object)"reconnect with T=1");
                    protocolValue = this.getCurrentProtocol(cardTerminal, false);
                    log.debug((Object)("T=1, ok: " + (protocolValue != null && protocolValue == 2)));
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)"MacOS T=0 detection/card reconnection failed", (Throwable)e);
        }
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        ArrayList result = new ArrayList();
        return result.toArray(new OCFCertificateInfo[result.size()]);
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return null;
    }

    @Override
    protected byte[] getHistoricals() {
        return null;
    }

    @Override
    protected String getIssuerConstant() {
        return EPA_ISSUER;
    }

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel, int bytes) {
        return this.readIssuerFromATR(_channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        boolean transactionStarted = false;
        try {
            transactionStarted = CardTerminalManager.beginTransaction(this.ctReference);
            super.selectMasterFile(_channel);
            ResponseAPDU resp = _channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("00a4040c" + HexUtil.hexify("e80704007f00070302".length() / 2) + "e80704007f00070302")));
            if (resp.sw() == 27010 || resp.sw() == 36864) {
                super.selectMasterFile(_channel);
                if (this.unknownVersion) {
                    log.debug((Object)"this is a version of nPA yet unknown");
                }
                String string = EPA_ISSUER;
                return string;
            }
        }
        catch (CardTerminalException e) {
            log.debug((Object)("ignored error: " + e));
        }
        catch (ResponseCodeException e) {
            log.debug((Object)("ignored error: " + e));
        }
        finally {
            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
        }
        return null;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        for (byte[] hist : HISTORICALS) {
            if (!Arrays.equals(hist, _historicals)) continue;
            log.debug((Object)"card is known nPA version");
            return true;
        }
        this.unknownVersion = true;
        return true;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, CardPin pin) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException, PinDeactivatedException {
        if (pin.getPinID() == 3) {
            return this.getRetryCount();
        }
        String s = HexUtil.hexify(pin.getPinID());
        CommandAPDU cmd = EPAUtil.commandFromString("002000" + s, null, null);
        ResponseAPDU response = this.sendCommandAPDU(cmd);
        if (response.sw() == 27013) {
            throw new NotYetInitializedException(EPA.getPinName(pin), 27013, "PIN not initialized");
        }
        if (response.sw1() != 99 || (response.sw2() & 0xFFFFFFF0) != -64) {
            throw new ResponseCodeException("unexpected response when checking retry count: " + response.sw());
        }
        return response.sw2() & 0xF;
    }

    @Override
    public synchronized int getRetryCount(CardPin _pin) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        try {
            return this.getRetryCount(null, _pin);
        }
        catch (InvalidCardChannelException e) {
            return -1;
        }
        catch (CardTerminalException e) {
            return -1;
        }
        catch (ResponseCodeException e) {
            return -1;
        }
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException, PinDeactivatedException {
        return this.getRetryCount(_channel, _info.getPin());
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getAlias() != null && _info.getAlias().contains("card_at_terminal")) {
            return c;
        }
        c.add("SHA256");
        return c;
    }

    @Override
    public String getDisplayName() {
        return "Elektronischer Personalausweis";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PacePlusResult establishPaceChannelWithTerminal(PaceInputParameters paceParameters, boolean pacePlus) throws IllegalArgumentException, CardServiceException, CardTerminalException {
        PacePlusResult pacePlusResult;
        block38: {
            byte[] result;
            Object monitor;
            GovCHVDialog chvDialog;
            byte pinID;
            int rc;
            block36: {
                PacePlusResult pacePlusResult2;
                block37: {
                    AssertUtil.notNull(paceParameters, "parameters for PACE");
                    if (!PCSCCardTerminal.class.isInstance(this.ctReference)) {
                        return null;
                    }
                    if (!this.secondPacePossible) {
                        try {
                            PCSCCardTerminal pcscCT = (PCSCCardTerminal)this.ctReference;
                            if (CardTerminalManager.supportsReaderReset(pcscCT)) {
                                pcscCT.resetSlot(this.getSlotID());
                            } else {
                                if (this.terminalResetSkipped) {
                                    throw new CardTerminalException("reset unsupported by reader, reinsert card");
                                }
                                this.terminalResetSkipped = true;
                                log.debug((Object)("no reset possible for reader: " + pcscCT.getName() + ", "));
                            }
                            super.setSM(null);
                            this.sendCommandAPDU(this.createSelectMasterFile());
                        }
                        catch (CardTerminalException e) {
                            log.debug((Object)"reset of card failed", (Throwable)e);
                        }
                    }
                    SignatureTerminals.getOIDString();
                    PCSCCardTerminal reader = null;
                    boolean signature = false;
                    if (paceParameters.getTemplate() != null && paceParameters.getTemplate().getAccessRoleAndRights().isRole(SignatureTerminals.AccessRoleEnum.SIGNATURE_TERMINAL)) {
                        reader = this.getESignReader();
                        signature = true;
                    } else {
                        reader = this.getPACEReader();
                    }
                    if (reader == null) {
                        return null;
                    }
                    rc = -1;
                    boolean initMode = false;
                    try {
                        rc = this.getRetryCount();
                    }
                    catch (NotYetInitializedException e) {
                        initMode = true;
                        rc = e.getRetries();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String secretChoice = paceParameters.getSecretChoice();
                    pinID = 3;
                    boolean standardBehaviour = false;
                    if (PACE.USE_PIN_KEY.equals(secretChoice)) {
                        pinID = 3;
                    } else if (PACE.USE_CAN_KEY.equals(secretChoice)) {
                        pinID = 2;
                    } else if (PACE.USE_PUK_KEY.equals(secretChoice)) {
                        pinID = 4;
                    } else if (PACE.USE_MRZ_KEY.equals(secretChoice)) {
                        pinID = 1;
                    } else {
                        standardBehaviour = true;
                    }
                    chvDialog = null;
                    try {
                        chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
                        chvDialog.setParentWindow(this.parentWindow);
                    }
                    catch (InstantiationException ex) {
                        PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                        ppop.setRetryCounter(rc);
                        return new PacePlusResult(ppop, (Throwable)ex);
                    }
                    catch (IllegalAccessException ex) {
                        PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                        ppop.setRetryCounter(rc);
                        return new PacePlusResult(ppop, (Throwable)ex);
                    }
                    if (standardBehaviour && rc == 0) {
                        PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                        ppop.setRetryCounter(rc);
                        return new PacePlusResult(ppop, (Throwable)new RetryCounterExpiredException(PWD_NAME_PIN, 27011, APDUCommands.getVerifyErrorMsg(27011)));
                    }
                    monitor = null;
                    if (standardBehaviour && rc == 1) {
                        block34: {
                            PacePlusResult pacePlusResult3;
                            block35: {
                                PaceInputData pid = new PaceInputData(2, null, null, paceParameters.getCertificateDescription() != null ? paceParameters.getCertificateDescription().getEncoded() : null);
                                try {
                                    OCFCertificateInfo ocfCertInfo = new OCFCertificateInfo(this.getCardObject(), OCFCertificateInfo.Usage.EID_CAN, OCFCertificateInfo.ChainEntry.UNKNOWN);
                                    GovCHVConfiguration config = new GovCHVConfiguration(rc, BDialogMode.EID_CAN, this.getMinPINLength(null), this.getMaxPINLength(null), ocfCertInfo, this.createTerminalString(null), null, null, null, this.getClass());
                                    config.setShowPseudoDisplay(false);
                                    chvDialog.setConfiguration(config);
                                    monitor = chvDialog.showReaderMessage();
                                    byte[] result2 = reader.sendTerminalCommand(reader.getPcsc20Features().getExecutePACE().valueAsNumber(), pid.getEncoded());
                                    PacePlusResult ppResult = this.analyzeTerminalPaceResult(PWD_NAME_CAN, rc, result2, pacePlus);
                                    if (ppResult.getThrowable() == null) break block34;
                                    pacePlusResult3 = ppResult;
                                    if (monitor == null) break block35;
                                }
                                catch (Throwable throwable) {
                                    if (monitor != null) {
                                        chvDialog.hideReaderMessage(monitor);
                                    }
                                    monitor = null;
                                    throw throwable;
                                }
                                chvDialog.hideReaderMessage(monitor);
                            }
                            monitor = null;
                            return pacePlusResult3;
                        }
                        if (monitor != null) {
                            chvDialog.hideReaderMessage(monitor);
                        }
                        monitor = null;
                    }
                    try {
                        int maxLength;
                        int minLength;
                        OCFCertificateInfo ocfCertInfo = new OCFCertificateInfo(this.getCardObject(), pinID == 2 ? (rc == 1 ? OCFCertificateInfo.Usage.EID_CAN : (signature ? OCFCertificateInfo.Usage.ESIGN : OCFCertificateInfo.Usage.EID_CAN_NOT_FORCED)) : (pinID == 4 ? OCFCertificateInfo.Usage.EID_PUK : OCFCertificateInfo.Usage.EID), OCFCertificateInfo.ChainEntry.UNKNOWN);
                        int n = pinID == 2 ? 6 : (minLength = pinID == 4 ? 10 : this.getMinPINLength(null));
                        int n2 = pinID == 2 ? 6 : (maxLength = pinID == 4 ? 10 : this.getMaxPINLength(null));
                        GovCHVConfiguration config = new GovCHVConfiguration(rc, pinID == 2 ? BDialogMode.EID_CAN : (pinID == 4 ? BDialogMode.EID_PUK : (initMode ? BDialogMode.EID_INIT : BDialogMode.CARD_VERIFY)), minLength, maxLength, ocfCertInfo, this.createTerminalString(null), null, this.getMinPINLengthInit(null), this.getMaxPINLengthInit(null), this.getClass());
                        config.setShowPseudoDisplay(false);
                        chvDialog.setConfiguration(config);
                        monitor = chvDialog.showReaderMessage();
                        PaceInputData pid = new PaceInputData(pinID, paceParameters.getTemplate() != null ? paceParameters.getTemplate().getEncoded() : null, null, paceParameters.getCertificateDescription() != null ? paceParameters.getCertificateDescription().getEncoded() : null);
                        result = reader.sendTerminalCommand(reader.getPcsc20Features().getExecutePACE().valueAsNumber(), pid.getEncoded());
                        if (paceParameters.getTemplate() == null || !paceParameters.getTemplate().getAccessRoleAndRights().isRole(SignatureTerminals.AccessRoleEnum.SIGNATURE_TERMINAL) || !ByteUtil.equals(ByteUtil.subbytes(result, 0, 4), new byte[4])) break block36;
                        this.securityProtocol = SecureCard.SecurityProtocol.EAC2_TACA;
                        this.usedChatPACE = paceParameters.getTemplate();
                        this.usedPwdPACE = paceParameters.getSecretChoice();
                        pacePlusResult2 = SPECIAL_RESULT;
                        if (monitor == null) break block37;
                    }
                    catch (Throwable throwable) {
                        if (monitor != null) {
                            chvDialog.hideReaderMessage(monitor);
                        }
                        throw throwable;
                    }
                    chvDialog.hideReaderMessage(monitor);
                }
                return pacePlusResult2;
            }
            pacePlusResult = this.analyzeTerminalPaceResult(pinID == 2 ? PWD_NAME_CAN : (pinID == 4 ? PWD_NAME_PUK : PWD_NAME_PIN), rc, result, pacePlus);
            if (monitor == null) break block38;
            chvDialog.hideReaderMessage(monitor);
        }
        return pacePlusResult;
    }

    private PacePlusResult analyzeTerminalPaceResult(String pinName, Integer retryCount, byte[] result, boolean pacePlus) throws CardTerminalException {
        if (ArrayUtil.isNullOrEmpty(result) || result.length < 4) {
            throw new CardTerminalException("protocol failed at terminal - no response received (at least 4 bytes required containing execution result code");
        }
        byte[] code = ByteUtil.flip(ByteUtil.subbytes(result, 0, 4));
        if (!ByteUtil.equals(code, HexUtil.parse("00000000"))) {
            if (code[0] == -16 && code[1] >= 0 && code[1] < 7) {
                int sw = (code[2] + 256) % 256 * 256 + (code[3] + 256) % 256;
                if (code[2] == 99 && (code[3] & 0xFFFFFFF0) == -64) {
                    PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                    ppop.setRetryCounter(code[3] & 0xF);
                    return new PacePlusResult(ppop, (Throwable)new WrongPinException(pinName, sw, "protocol failed - wrong password entered: " + HexUtil.hexify(code)));
                }
                try {
                    super.evaluateVerifyPasswordResultCode(pinName, retryCount, sw);
                }
                catch (OCFPinRelatedException e) {
                    return new PacePlusResult(e);
                }
                return new PacePlusResult(new OCFException(sw, "protocol failed at terminal: " + HexUtil.hexify(code)));
            }
            if (code[0] == -16 && code[1] == 16 && code[2] == 0 && code[3] >= 1 && code[3] <= 2) {
                return new PacePlusResult(new OCFException(new BigInteger(code).intValue(), "protocol failed at terminal, card communication error: " + HexUtil.hexify(code)));
            }
            if (code[0] == -16 && code[1] == 32 && code[2] == 0) {
                if (code[3] == 1) {
                    return new PacePlusResult(new PinInputCancelledException(pinName, 25601, "user cancelled request"));
                }
                if (code[3] == 2) {
                    return new PacePlusResult(new PinInputTimeoutException(pinName, 25600, "user request not in time"));
                }
            }
            if (code[0] == -48 && code[1] == 0 && code[2] == 2 && code[3] >= 1 && code[3] <= 3) {
                return new PacePlusResult(new OCFException(new BigInteger(code).intValue(), "protocol failed at terminal, data input error: " + HexUtil.hexify(code)));
            }
            if (code[0] == -32 && code[1] == 0 && code[2] == 2 && code[3] >= 1 && code[3] <= 3) {
                return new PacePlusResult(new OCFException(new BigInteger(code).intValue(), "protocol failed at terminal, operation not supported: " + HexUtil.hexify(code)));
            }
            return new PacePlusResult(new OCFException(new BigInteger(code).intValue(), "protocol failed at terminal: " + HexUtil.hexify(code)));
        }
        byte[] lOutputBufferLength = ByteUtil.flip(ByteUtil.subbytes(result, 4, 6));
        int l = new BigInteger(1, lOutputBufferLength).intValue();
        byte[] responseData = ByteUtil.subbytes(result, 6);
        int offset = 0;
        byte[] responseSWmseAT = ByteUtil.subbytes(responseData, offset, offset + 2);
        byte[] lEFCardAccessLength = ByteUtil.flip(ByteUtil.subbytes(responseData, offset += 2, offset + 2));
        int lEFCardAccess = new BigInteger(1, lEFCardAccessLength).intValue();
        byte[] efCardAccess = ByteUtil.subbytes(responseData, offset += 2, offset + lEFCardAccess);
        byte lCAR = responseData[offset += lEFCardAccess];
        byte[] car = ByteUtil.subbytes(responseData, ++offset, offset + Math.abs(lCAR));
        byte lPreviousCAR = responseData[offset += Math.abs(lCAR)];
        byte[] previousCar = ByteUtil.subbytes(responseData, ++offset, offset + Math.abs(lPreviousCAR));
        byte[] lIDiccLength = ByteUtil.flip(ByteUtil.subbytes(responseData, offset += Math.abs(lPreviousCAR), offset + 2));
        int lIDicc = new BigInteger(1, lIDiccLength).intValue();
        byte[] idICC = ByteUtil.subbytes(responseData, offset += 2, offset + Math.abs(lIDicc));
        try {
            this.cardAccess = new SecurityInfos(efCardAccess);
            this.cardAccess = (SecurityInfos)this.cardAccess.decode(this.cardAccess);
        }
        catch (IOException e) {
            return new PacePlusResult(e);
        }
        PacePlusOutputParameters ppop = new PacePlusOutputParameters();
        ppop.setCardEphemeralPublicKey(idICC);
        ArrayList<ASN1> carList = new ArrayList<ASN1>();
        if (car != null && car.length > 0) {
            ASN1 car1 = new ASN1(CAR1_FROM_CARD_TAG, car);
            carList.add(car1);
        }
        if (previousCar != null && previousCar.length > 0) {
            ASN1 car2 = new ASN1(CAR2_FROM_CARD_TAG, previousCar);
            carList.add(car2);
        }
        ppop.setCertificationAuthorityReference(carList);
        if (carList.size() > 0) {
            this.carList = carList;
            if (pacePlus) {
                ppop.setChallenge(TerminalAuthentication.requestChallenge(this));
            }
        }
        if (pinName.equals(PWD_NAME_PIN)) {
            ppop.setRetryCounter(3);
        } else if (pinName.equals(PWD_NAME_CAN)) {
            ppop.setRetryCounter(1);
        } else if (pinName.equals(PWD_NAME_PUK)) {
            ppop.setRetryCounter(0);
        }
        return new PacePlusResult(ppop);
    }

    public static SecurityInfos.GeneralDomainParameterInfo selectPACEDomainParameterInfo(List<SecurityInfos.PACEDomainParameterInfo> dpiList, Integer id) throws IllegalArgumentException {
        if (id != null && id >= 8 && id <= 18) {
            return new SecurityInfos.StandardDomainParameterInfo(id);
        }
        AssertUtil.notNullOrEmpty(dpiList, "dpiList");
        for (SecurityInfos.PACEDomainParameterInfo info : dpiList) {
            ASN1 pID = null;
            try {
                pID = info.getParameterID();
            }
            catch (IOException e) {
                continue;
            }
            Integer foundID = null;
            if (pID != null) {
                foundID = new BigInteger(pID.getValue()).intValue();
            }
            if ((foundID == null || !foundID.equals(id)) && (foundID != null || id != null)) continue;
            return info;
        }
        return null;
    }

    public static SecurityInfos.PACEInfo selectPACE(List<SecurityInfos.PACEInfo> paceList) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(paceList, "paceList");
        if (paceList.size() == 1) {
            return paceList.get(0);
        }
        for (SecurityInfos.PACEInfo info : paceList) {
            int id;
            ASN1 pID = null;
            try {
                pID = info.getParameterID();
            }
            catch (IOException e) {
                continue;
            }
            if (pID == null || (id = new BigInteger(pID.getValue()).intValue()) < 8 || id > 18) continue;
            return info;
        }
        return paceList.get(0);
    }

    public static SecurityInfos.ChipAuthenticationDomainParameterInfo selectCADomainParameterInfo(List<SecurityInfos.ChipAuthenticationDomainParameterInfo> dpiList) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(dpiList, "list of domain parameter info");
        if (dpiList.size() == 1) {
            return dpiList.get(0);
        }
        for (SecurityInfos.ChipAuthenticationDomainParameterInfo info : dpiList) {
            try {
                SecurityInfos.AlgorithmIdentifier ai = info.getDomainParameter();
                if (!OIDConstants.OID_STANDARDIZED_DOMAIN_PARAMETERS.equals(ai.getAlgorithm())) continue;
                return info;
            }
            catch (IOException e) {
            }
        }
        return dpiList.get(0);
    }

    public static SecurityInfos.ChipAuthenticationInfo selectCAInfo(List<SecurityInfos.ChipAuthenticationInfo> caList, SecurityInfos.ChipAuthenticationDomainParameterInfo dpi) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(caList, "list of chip authentication info");
        AssertUtil.notNull(dpi, "domain parameter info");
        try {
            if (dpi.getKeyID() != null) {
                for (SecurityInfos.ChipAuthenticationInfo caInfo : caList) {
                    try {
                        if (caInfo.getKeyID() == null || !caInfo.getKeyID().equals(dpi.getKeyID())) continue;
                        return caInfo;
                    }
                    catch (IOException e) {
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        OID protocol = null;
        try {
            protocol = new OID(dpi.getProtocol().getEncoded());
        }
        catch (IOException e) {
            return null;
        }
        for (SecurityInfos.ChipAuthenticationInfo caInfo : caList) {
            try {
                OID caInfoProt = new OID(caInfo.getProtocol().getEncoded());
                if (!caInfoProt.toString().startsWith(protocol.toString())) continue;
                return caInfo;
            }
            catch (IOException e) {
            }
        }
        return null;
    }

    public static SecurityInfos.ChipAuthenticationPublicKeyInfo selectCAPubKeyInfo(List<SecurityInfos.ChipAuthenticationPublicKeyInfo> caPubKeyList, SecurityInfos.ChipAuthenticationInfo caInfo) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(caPubKeyList, "list of chip authentication public keys");
        AssertUtil.notNull(caInfo, "chip authentication info");
        try {
            if (caInfo.getKeyID() != null) {
                for (SecurityInfos.ChipAuthenticationPublicKeyInfo caPK : caPubKeyList) {
                    try {
                        if (!caInfo.getKeyID().equals(caPK.getKeyID())) continue;
                        return caPK;
                    }
                    catch (IOException e) {
                    }
                }
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (caPubKeyList.size() == 1) {
            return caPubKeyList.get(0);
        }
        return null;
    }

    public static SecurityInfos.TerminalAuthenticationInfo selectTAInfo(List<SecurityInfos.TerminalAuthenticationInfo> taList, SecurityInfos.ChipAuthenticationInfo caInfo) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(taList, "list of terminal authentication info");
        return taList.get(0);
    }

    @Override
    public synchronized SecureCard.SecurityProtocolResult<? extends Object> allocateSecureContext(SecureCard.SecurityProtocol securityProtocol, SecureCard.SecurityProtocolParameter securityParameters) throws IllegalArgumentException, CardServiceException, CardTerminalException {
        if (!this.isTransactionLocked) {
            this.isTransactionLocked = CardTerminalManager.beginTransaction(this.ctReference);
        }
        if (securityProtocol == SecureCard.SecurityProtocol.EAC2_PACEPLUS || securityProtocol == SecureCard.SecurityProtocol.EAC2_PACE) {
            int retryCount;
            PacePlusOutputParameters outputParams;
            boolean success;
            PACE pace;
            PaceInputParameters pip;
            block52: {
                if (!securityProtocol.getParameterClass().isInstance(securityParameters)) {
                    throw new IllegalArgumentException("given security parameters are no PaceInputParameters");
                }
                pip = (PaceInputParameters)securityParameters;
                PacePlusResult terminalResult = this.establishPaceChannelWithTerminal(pip, securityProtocol == SecureCard.SecurityProtocol.EAC2_PACEPLUS);
                if (terminalResult != null) {
                    if (terminalResult.equals(SPECIAL_RESULT)) {
                        this.secondPacePossible = false;
                        return terminalResult;
                    }
                    this.secondPacePossible = (PacePlusOutputParameters)terminalResult.getData() != null && ((PacePlusOutputParameters)terminalResult.getData()).getRetryCounter() == 1 && pip.getTemplate() == null && PACE.USE_CAN_KEY.equals(pip.getSecretChoice());
                    if (terminalResult.getThrowable() == null) {
                        this.securityProtocol = securityProtocol;
                        this.usedPwdPACE = pip.getSecretChoice() != null ? pip.getSecretChoice() : PACE.USE_PIN_KEY;
                        this.usedChatPACE = pip.getTemplate();
                    }
                    return terminalResult;
                }
                this.readEFCardAccess();
                if (this.cardAccess.getPrivilegedTerminalInfo() == null) {
                    log.debug((Object)"nPA as defined in spec 2.03");
                } else {
                    log.debug((Object)"nPA as defined in spec 2.04 and following");
                }
                List<SecurityInfos.PACEInfo> infoList = this.cardAccess.getPACEInfo();
                List<SecurityInfos.PACEDomainParameterInfo> domainParameterInfoList = this.cardAccess.getPACEDomainParameterInfo();
                if (infoList == null || infoList.size() == 0) {
                    throw new IllegalStateException("Required data for PACE not available in EF.CardAccess");
                }
                log.debug((Object)"select PACE domain parameters to be used (step 0.3)");
                pace = null;
                success = false;
                outputParams = new PacePlusOutputParameters();
                retryCount = -1;
                try {
                    SecurityInfos.GeneralDomainParameterInfo domParamInfo;
                    SecurityInfos.PACEInfo info = EPA.selectPACE(infoList);
                    if (info == null) {
                        throw new IllegalStateException("Required data for PACE not available in EF.CardAccess");
                    }
                    ASN1 pID = info.getParameterID();
                    Integer id = null;
                    if (pID != null) {
                        id = new BigInteger(pID.getValue()).intValue();
                    }
                    if ((domParamInfo = EPA.selectPACEDomainParameterInfo(domainParameterInfoList, id)) == null) {
                        throw new IllegalStateException("Required data for PACE not available in EF.CardAccess");
                    }
                    OID protocolOID = new OID(info.getProtocol().getEncoded());
                    int paceVersion = new BigInteger(info.getVersion().getValue()).intValue();
                    pace = new PACE(this, domParamInfo, protocolOID, paceVersion, id);
                    boolean initCard = false;
                    try {
                        retryCount = this.getRetryCount();
                    }
                    catch (NotYetInitializedException e) {
                        initCard = true;
                        retryCount = e.getRetries();
                    }
                    catch (CardTerminalException e) {
                        // empty catch block
                    }
                    if (pip.getSecretChoice() == null) {
                        if (retryCount == 0) {
                            PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                            ppop.setRetryCounter(retryCount);
                            return new PacePlusResult(ppop, (Throwable)new RetryCounterExpiredException(PWD_NAME_PIN, 27011, APDUCommands.getVerifyErrorMsg(27011)));
                        }
                        if (retryCount == 1) {
                            char[] canChar = CanPukRequestDialog.requestUserAuthenticationCode(OCFCertificateInfo.Usage.EID, BDialogMode.EID_CAN, this.getCardTerminal().getName(), 6);
                            if (canChar == null) {
                                PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                                ppop.setRetryCounter(retryCount);
                                return new PacePlusResult(ppop, (Throwable)new PinInputCancelledException(PWD_NAME_CAN, 25601, APDUCommands.getVerifyErrorMsg(0)));
                            }
                            String can = new String(canChar);
                            success = pace.executePACE(PACE.USE_CAN_KEY, can, null);
                            if (success) {
                                AESEncSSCIvParameterSpecImpl ssc = new AESEncSSCIvParameterSpecImpl(new byte[16], false, pace.getEncKey());
                                AESKeyMaterialImpl smKeyMaterial = new AESKeyMaterialImpl(pace.getEncKey(), pace.getMacKey(), ssc);
                                AESSecureMessagingImpl sm = new AESSecureMessagingImpl(smKeyMaterial);
                                super.setSM(sm);
                            } else {
                                PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                                ppop.setRetryCounter(retryCount);
                                return new PacePlusResult(ppop, (Throwable)new Exception("PACE execution not successful"));
                            }
                        }
                        String pin = null;
                        GovCHVDialog chvDialog = null;
                        OCFCertificateInfo ocfCertInfo = new OCFCertificateInfo(this.getCardObject(), OCFCertificateInfo.Usage.EID, OCFCertificateInfo.ChainEntry.UNKNOWN);
                        try {
                            chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
                            chvDialog.setParentWindow(this.parentWindow);
                        }
                        catch (InstantiationException ex) {
                            throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                        }
                        catch (IllegalAccessException ex) {
                            throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                        }
                        GovCHVConfiguration config = new GovCHVConfiguration(retryCount, BDialogMode.CARD_VERIFY, initCard ? this.getMinPINLengthInit(null).intValue() : this.getMinPINLength(null), initCard ? this.getMaxPINLengthInit(null).intValue() : this.getMaxPINLength(null), ocfCertInfo, this.createTerminalString(null), this.getInitPIN(), null, null, this.getClass());
                        config.setShowPseudoDisplay(false);
                        chvDialog.setConfiguration(config);
                        chvDialog.show();
                        int result = chvDialog.getResult();
                        if (result == 2) {
                            throw new PinInputCancelledException(PWD_NAME_PIN, CardErrorUtil.getErrorCodeForRetries(retryCount), APDUCommands.getVerifyErrorMsg(0));
                        }
                        pin = new String(chvDialog.getPIN());
                        pip.setSecretChoice(PACE.USE_PIN_KEY);
                        success = pace.executePACE(PACE.USE_PIN_KEY, pin, pip.getTemplate() != null ? HexUtil.hexify(pip.getTemplate().getEncoded()) : null);
                        break block52;
                    }
                    success = pace.executePACE(pip.getSecretChoice(), new String(pip.getSecretValue()), pip.getTemplate() != null ? HexUtil.hexify(pip.getTemplate().getEncoded()) : null);
                }
                catch (Exception e) {
                    try {
                        int paceRetryCount = pace.getRetryCount();
                        outputParams.setRetryCounter(paceRetryCount != -1 ? paceRetryCount : this.getRetryCount());
                    }
                    catch (NotYetInitializedException e1) {
                        outputParams.setRetryCounter(e1.getRetries());
                    }
                    catch (Exception e1) {
                        return new PacePlusResult(e);
                    }
                    return new PacePlusResult(outputParams, (Throwable)e);
                }
            }
            if (success) {
                AESEncSSCIvParameterSpecImpl ssc = new AESEncSSCIvParameterSpecImpl(new byte[16], false, pace.getEncKey());
                AESKeyMaterialImpl smKeyMaterial = new AESKeyMaterialImpl(pace.getEncKey(), pace.getMacKey(), ssc);
                AESSecureMessagingImpl sm = new AESSecureMessagingImpl(smKeyMaterial);
                super.setSM(sm);
                byte[] challenge = null;
                if (securityProtocol == SecureCard.SecurityProtocol.EAC2_PACEPLUS) {
                    challenge = TerminalAuthentication.requestChallenge(this);
                }
                this.securityProtocol = securityProtocol;
                this.usedPwdPACE = pip.getSecretChoice() != null ? pip.getSecretChoice() : PACE.USE_PIN_KEY;
                this.usedChatPACE = pip.getTemplate();
                this.carList = pace.getCertificationAuthorityReference();
                outputParams.setCardEphemeralPublicKey(pace.getCardEphemeralPublicKey());
                outputParams.setCertificationAuthorityReference(pace.getCertificationAuthorityReference());
                outputParams.setChallenge(challenge);
            }
            if (retryCount == 1 && pip.getTemplate() == null && PACE.USE_CAN_KEY.equals(pip.getSecretChoice())) {
                this.secondPacePossible = true;
            } else {
                this.secondPacePossible = false;
                if (PACE.USE_PIN_KEY.equals(pip.getSecretChoice())) {
                    outputParams.setRetryCounter(pace.getRetryCount());
                }
            }
            return new PacePlusResult(outputParams);
        }
        if (securityProtocol == SecureCard.SecurityProtocol.EAC2_TACA) {
            this.secondPacePossible = false;
            if (!securityProtocol.getParameterClass().isInstance(securityParameters)) {
                throw new IllegalArgumentException("given security parameters are no TACAInputParameters");
            }
            TACAInputParameters tacaParam = (TACAInputParameters)securityParameters;
            List<SecurityInfos.ChipAuthenticationDomainParameterInfo> caDomainParameterInfoList = this.cardAccess.getChipAuthenticationDomainParameterInfo();
            List<SecurityInfos.TerminalAuthenticationInfo> taInfoList = this.cardAccess.getTerminalAuthenticationInfo();
            if (taInfoList == null || taInfoList.size() == 0 || caDomainParameterInfoList == null || caDomainParameterInfoList.size() == 0) {
                throw new CardServiceException("Required data for TA/CA not available in EF.CardAccess");
            }
            SecurityInfos.ChipAuthenticationDomainParameterInfo caDomParamInfo = EPA.selectCADomainParameterInfo(caDomainParameterInfoList);
            SecurityInfos.TerminalAuthenticationInfo taInfo = EPA.selectTAInfo(taInfoList, null);
            Integer taVersion = null;
            try {
                taVersion = new Integer(taInfo.getVersion().getValue()[0]);
            }
            catch (Exception e) {
                return new TACAResult(e);
            }
            if (taVersion == 2) {
                TerminalAuthentication ta = new TerminalAuthentication(this, taInfo, caDomParamInfo);
                boolean success = false;
                try {
                    success = ta.executeTARemote(tacaParam.getCertificateList(), this.carList, tacaParam.getEphemeralKey(), tacaParam.getAuxiliaryData(), tacaParam.getSignature());
                }
                catch (Exception e) {
                    return new TACAResult(e);
                }
                if (!success) {
                    return new TACAResult(new InternalError("TA failed"));
                }
                try {
                    this.rawCardSecurity = this.readEFCardSecurityRaw();
                    this.cardSecurity = EPAUtil.extractFromCardSecurity(this.rawCardSecurity);
                }
                catch (Exception e) {
                    return new TACAResult(new InternalError("unable to read EF.CardSecurity"));
                }
                List<SecurityInfos.ChipAuthenticationPublicKeyInfo> caPubKeyInfoList = this.cardSecurity.getChipAuthenticationPublicKeyInfo();
                List<SecurityInfos.ChipAuthenticationInfo> caInfoList = this.cardSecurity.getChipAuthenticationInfo();
                List<SecurityInfos.PACEInfo> paceInfoList = this.cardAccess.getPACEInfo();
                if (caPubKeyInfoList == null || caPubKeyInfoList.size() == 0 || caInfoList == null || caInfoList.size() == 0 || paceInfoList == null || paceInfoList.size() == 0) {
                    throw new CardServiceException("Required data for CA not available in EF.CardSecurity / EF.CardAccess");
                }
                SecurityInfos.PACEInfo paceInfo = EPA.selectPACE(paceInfoList);
                SecurityInfos.ChipAuthenticationInfo caInfo = EPA.selectCAInfo(caInfoList, caDomParamInfo);
                SecurityInfos.ChipAuthenticationPublicKeyInfo caPubKeyInfo = EPA.selectCAPubKeyInfo(caPubKeyInfoList, caInfo);
                ChipAuthentication ca = null;
                try {
                    ca = new ChipAuthentication(this, caInfo, caDomParamInfo, caPubKeyInfo, paceInfo);
                }
                catch (Exception e) {
                    return new TACAResult(e);
                }
                if (success &= ca.executeCARemote(tacaParam.getEphemeralKey())) {
                    TACAOutputParameters outputParams = new TACAOutputParameters();
                    this.securityProtocol = SecureCard.SecurityProtocol.EAC2_TACA;
                    outputParams.setAuthenticationToken(ca.getAuthenticationToken());
                    outputParams.setNonce(ca.getNonce());
                    super.setSM(null);
                    return new TACAResult(outputParams);
                }
            } else {
                if (taVersion == 1) {
                    return new TACAResult(new InternalError("TA version 1 not supported"));
                }
                return new TACAResult(new InternalError("unknown TA version"));
            }
        }
        return new SecureCard.SimpleSecurityProtocolResult(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRetryCount() throws CardTerminalException, NotYetInitializedException, ResponseCodeException, PinDeactivatedException {
        boolean transactionStarted = false;
        int retryCount = -1;
        try {
            OID protocolOID;
            String dataFieldString;
            CommandAPDU mseATPace;
            ResponseAPDU response;
            List<SecurityInfos.PACEInfo> infoList;
            transactionStarted = CardTerminalManager.beginTransaction(this.ctReference);
            if (this.cardAccess == null) {
                this.sendCommandAPDU(super.createSelectMasterFile());
                this.readEFCardAccess();
            }
            if ((infoList = this.cardAccess.getPACEInfo()) == null || infoList.size() == 0) {
                throw new IllegalStateException("Required data not available in EF.CardAccess");
            }
            SecurityInfos.PACEInfo info = infoList.get(0);
            ASN1 pID = info.getParameterID();
            Integer id = null;
            if (pID != null) {
                id = new BigInteger(pID.getValue()).intValue();
            }
            if ((response = this.sendCommandAPDU(mseATPace = EPAUtil.commandFromString("0022C1 A4", dataFieldString = EPAUtil.makeTag("80", HexUtil.hexify((protocolOID = new OID(info.getProtocol().getEncoded())).getValue())) + EPAUtil.makeTag("83", HexUtil.hexify((byte)3)) + (id != null ? EPAUtil.makeTag(ID_ESIGN_KEY, HexUtil.hexify(id)) : ""), EPAUtil.LENGTH_EXPECTED_NONE))).sw() == 36864) {
                retryCount = 3;
            } else if (response.sw1() == 99 && (response.sw2() & 0xFFFFFFF0) == -64) {
                retryCount = response.sw2() & 0xF;
            } else if (response.sw1() == 98 && response.sw2() == -125) {
                throw new PinDeactivatedException(PWD_NAME_PIN, 25219, "eID PIN deactivated");
            }
            CommandAPDU cmd = EPAUtil.commandFromString("00200003", null, null);
            ResponseAPDU response2 = this.sendCommandAPDU(cmd);
            if (response2.sw() == 27013) {
                throw new NotYetInitializedException(PWD_NAME_PIN, response.sw(), "PIN not initialized, retry count " + retryCount);
            }
            int n = retryCount;
            return n;
        }
        catch (IOException e) {
            int n = retryCount;
            return n;
        }
        finally {
            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
        }
    }

    @Override
    public SecureCard.SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    @Override
    public boolean isSecure() {
        return this.securityProtocol == SecureCard.SecurityProtocol.EAC2_PACEPLUS || this.securityProtocol == SecureCard.SecurityProtocol.EAC2_PACE || this.securityProtocol == SecureCard.SecurityProtocol.EAC2_TACA;
    }

    @Override
    public boolean releaseSecureContext() throws CardServiceException, CardTerminalException {
        if (this.isTransactionLocked) {
            CardTerminalManager.endTransaction(this.ctReference, true);
            this.isTransactionLocked = false;
        }
        this.secondPacePossible = false;
        return true;
    }

    @Override
    public List<SecureCard.SecurityProtocol> getSupportedSecurityProtocols() {
        return this.supportedProtocols;
    }

    private void readEFCardAccess() throws InternalError {
        if (this.cardAccess == null) {
            try {
                SecurityInfos result = this.readEFCardAccessInt("011c", false);
                if (result == null) {
                    result = this.readEFCardAccessInt(FID_CARDACCESS_OLD, true);
                }
                this.cardAccess = result;
            }
            catch (Exception e) {
                throw new InternalError("Unable to read EF.CardAccess");
            }
        }
    }

    private SecurityInfos readEFCardAccessInt(String fid, boolean exception) throws IOException, IllegalArgumentException {
        AssertUtil.notNullOrEmpty(fid, "file ID of EF.CardAccess");
        try {
            byte[] fileBytes = super.readFileRaw(fid, "EF.CardAccess");
            SecurityInfos result = new SecurityInfos(fileBytes);
            result = (SecurityInfos)result.decode(result);
            return result;
        }
        catch (IOException t) {
            if (exception) {
                throw t;
            }
            return null;
        }
    }

    private byte[] readEFCardSecurityRaw() throws IOException {
        return super.readFileRaw(FID_CARDSECURITY, "EF.CardSecurity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isKeyInitialized(OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException {
        String pinName = EPA.getPinNameForInfo(_info);
        boolean transactionStarted = false;
        try {
            transactionStarted = CardTerminalManager.beginTransaction(this.ctReference);
            CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand((byte)3);
            log.debug((Object)("INIT CMD : " + HexUtil.hexify(cmd.getBuffer())));
            ResponseAPDU res = this.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            log.debug((Object)("INIT RES : " + HexUtil.hexify(res.getBuffer())));
            int err = res.sw();
            if (err == 27011) {
                log.debug((Object)"", (Throwable)new RetryCounterExpiredException(pinName, err, APDUCommands.getVerifyErrorMsg(err)));
                boolean bl = false;
                return bl;
            }
            boolean bl = err != 27013;
            return bl;
        }
        finally {
            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
        }
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        return 6;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        String pwdName;
        String string = pwdName = _info == null || _info.getKey() == null || _info.getKey().getPinList().isEmpty() ? null : _info.getKey().getPinList().get(0).getName();
        if (PWD_NAME_PUK.equals(pwdName)) {
            return 10;
        }
        return 6;
    }

    @Override
    public Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        String pwdName;
        String string = pwdName = _info == null || _info.getKey() == null || _info.getKey().getPinList().isEmpty() ? null : _info.getKey().getPinList().get(0).getName();
        if (PWD_NAME_PIN.equals(pwdName)) {
            return 5;
        }
        return 6;
    }

    @Override
    public Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        String pwdName;
        String string = pwdName = _info == null || _info.getKey() == null || _info.getKey().getPinList().isEmpty() ? null : _info.getKey().getPinList().get(0).getName();
        if (PWD_NAME_PIN.equals(pwdName)) {
            return 5;
        }
        return 6;
    }

    public SecurityInfos getCardAccess() {
        return this.cardAccess;
    }

    public byte[] getRawCardSecurity() {
        return this.rawCardSecurity;
    }

    @Override
    public synchronized int getRetryCount(OCFCertificateInfo _info) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        try {
            if (_info == null || _info.getPin() == null) {
                return this.getRetryCount();
            }
            return this.getRetryCount(null, _info.getPin());
        }
        catch (CardTerminalException e) {
            return -1;
        }
        catch (ResponseCodeException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int changePassword(OCFCertificateInfo _info, char[] _pin, char[] _newpin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, OperationCancelledException, PinDeactivatedException {
        if (_info != null) {
            if (this.securityProtocol != SecureCard.SecurityProtocol.EAC2_TACA) throw new IllegalStateException("not having right for changing eSig-PIN");
            if (this.usedChatPACE.getAccessRoleAndRights().existsRight(SignatureTerminals.AccessRightEnum.ESIGN_GENERATE_QUALIFIED_ELECTRONIC_SIGNATURE)) return super.changePassword(_info, _pin, _newpin);
            throw new IllegalStateException("not having right for changing eSig-PIN");
        }
        if (this.securityProtocol == SecureCard.SecurityProtocol.EAC2_TACA) {
            if (!this.usedChatPACE.getAccessRoleAndRights().existsRight(AuthenticationTerminals.AccessRightEnum.PIN_MANAGEMENT)) throw new IllegalStateException("not having right for changing PIN");
        }
        if (!(this.securityProtocol != SecureCard.SecurityProtocol.EAC2_PACEPLUS && this.securityProtocol != SecureCard.SecurityProtocol.EAC2_PACE || this.usedPwdPACE.equals(PACE.USE_PIN_KEY) || this.usedChatPACE == null)) {
            throw new IllegalStateException("not having right for changing PIN");
        }
        boolean transactionStarted = false;
        try {
            block54: {
                byte[] resultBytes;
                block55: {
                    GovCHVDialog chvDialog;
                    Object monitor;
                    block53: {
                        transactionStarted = CardTerminalManager.beginTransaction(this.ctReference);
                        int retryCount = -1;
                        boolean initCard = false;
                        try {
                            retryCount = this.getRetryCount();
                        }
                        catch (NotYetInitializedException e) {
                            initCard = true;
                            retryCount = e.getRetries();
                        }
                        catch (CardTerminalException e) {
                            // empty catch block
                        }
                        if (retryCount == -1 && !initCard) {
                            int e = 0;
                            return e;
                        }
                        _info = new OCFCertificateInfo(this.getCardObject(), OCFCertificateInfo.Usage.EID, OCFCertificateInfo.ChainEntry.UNKNOWN);
                        if (retryCount == 1) {
                            int e = this.resumeChangePassword(_info, null, _pin, _newpin);
                            return e;
                        }
                        if (retryCount == 0) {
                            int e = this.unblockPassword(_info, null, _newpin);
                            return e;
                        }
                        PCSCCardTerminal paceReader = this.getPACEReader();
                        if (paceReader == null && (_pin == null || _newpin == null)) {
                            GovCHVDialog chvDialog2 = null;
                            try {
                                chvDialog2 = (GovCHVDialog)this.chvDialogClass.newInstance();
                                chvDialog2.setParentWindow(this.parentWindow);
                            }
                            catch (InstantiationException ex) {
                                throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                            }
                            GovCHVConfiguration config = new GovCHVConfiguration(retryCount, initCard ? BDialogMode.CARD_INIT_3 : BDialogMode.CARD_CHANGE, this.getMinPINLength(null), this.getMaxPINLength(null), _info, this.createTerminalString(null), this.getInitPIN(), this.getMinPINLengthInit(_info), this.getMaxPINLengthInit(_info), this.getClass());
                            config.setShowPseudoDisplay(false);
                            chvDialog2.setConfiguration(config);
                            chvDialog2.show();
                            int result = chvDialog2.getResult();
                            if (result == 2) {
                                throw new PinInputCancelledException(PWD_NAME_PIN, 25601, APDUCommands.getVerifyErrorMsg(0));
                            }
                            _pin = chvDialog2.getPIN();
                            _newpin = chvDialog2.getNewPIN();
                        }
                        if (this.securityProtocol == null || this.securityProtocol == SecureCard.SecurityProtocol.NONE || (this.securityProtocol == SecureCard.SecurityProtocol.EAC2_PACEPLUS || this.securityProtocol == SecureCard.SecurityProtocol.EAC2_PACE) && !this.usedPwdPACE.equals(PACE.USE_PIN_KEY)) {
                            PaceInputParameters pip = new PaceInputParameters(PACE.USE_PIN_KEY, _pin, null, null);
                            SecureCard.SecurityProtocolResult<? extends Object> spr = null;
                            try {
                                spr = this.allocateSecureContext(SecureCard.SecurityProtocol.EAC2_PACE, pip);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (!PacePlusResult.class.isInstance(spr)) {
                                int e = 0;
                                return e;
                            }
                            PacePlusResult ppr = (PacePlusResult)spr;
                            if (!(ppr.getThrowable() == null || initCard && NotYetInitializedException.class.isInstance(ppr.getThrowable()))) {
                                this.evaluateThrowable(ppr.getThrowable(), paceReader, PWD_NAME_PIN);
                            }
                        }
                        if (paceReader == null) break block54;
                        Pcsc20Features features = paceReader.getPcsc20Features();
                        if (!features.isFeatureSupported(7)) {
                            int spr = 0;
                            return spr;
                        }
                        resultBytes = null;
                        monitor = null;
                        chvDialog = null;
                        try {
                            try {
                                chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
                                chvDialog.setParentWindow(this.parentWindow);
                            }
                            catch (InstantiationException ex) {
                                throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                            }
                            GovCHVConfiguration config = new GovCHVConfiguration(-1, BDialogMode.CARD_INIT_2, this.getMinPINLength(null), this.getMaxPINLength(null), _info, this.createTerminalString(null), this.getInitPIN(), null, null, this.getClass());
                            config.setShowPseudoDisplay(false);
                            chvDialog.setConfiguration(config);
                            monitor = chvDialog.showReaderMessage();
                            if (this.ctReference instanceof JPCSCCardTerminal) {
                                PinModifyParameters pmp = new PinModifyParameters(HexUtil.parse("002C0203"), PinEncoder.ENCODER_T50, null, null, false, 6, 6, 30, 5, LanguageEnum.GERMAN, false, new byte[0]);
                                try {
                                    resultBytes = ((JPCSCCardTerminal)this.ctReference).pinOperation(chvDialog, pmp);
                                }
                                catch (BTerminalException e) {
                                    int n = 0;
                                    if (monitor != null) {
                                        chvDialog.hideReaderMessage(monitor);
                                    }
                                    monitor = null;
                                    CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
                                    return n;
                                }
                            } else {
                                Pcsc20PinStructureHandler structureHandler = Pcsc20PinStructureHandlerFactory.getHandler(this.ctReference.getName());
                                PinModifyStructure pms = structureHandler.buildPinModifyStructureNPA(30, 5, LanguageEnum.GERMAN);
                                resultBytes = paceReader.sendTerminalCommand(features.getModifyPINDirect().valueAsNumber(), pms.getEncoded());
                            }
                            if (monitor != null) {
                            }
                            break block53;
                        }
                        catch (CardTerminalException e) {
                            int structureHandler = 0;
                            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
                            return structureHandler;
                        }
                        chvDialog.hideReaderMessage(monitor);
                    }
                    monitor = null;
                    if (resultBytes == null) {
                        int n = 0;
                        return n;
                    }
                    break block55;
                    finally {
                        if (monitor != null) {
                            chvDialog.hideReaderMessage(monitor);
                        }
                        monitor = null;
                    }
                }
                ResponseAPDU res = new ResponseAPDU(resultBytes);
                log.debug((Object)("VP RES : " + HexUtil.hexify(res.getBuffer())));
                log.debug((Object)("VP RES : " + APDUCommands.getChangePasswordErrorMsg(res.sw())));
                if (res.sw() == 25616 || res.sw() == 28160) {
                    int structureHandler = res.sw();
                    return structureHandler;
                }
                int structureHandler = this.evaluateChangePasswordResultCode(PWD_NAME_PIN, null, res.sw());
                return structureHandler;
            }
            int n = this.setPinBasicReader(_newpin);
            return n;
        }
        finally {
            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
        }
    }

    private int setPinBasicReader(char[] _newpin) throws WrongPinException, RetryCounterExpiredException, WrongConfirmedNewPinException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException {
        CommandAPDU cmd = EPAUtil.commandFromString("002c0203", HexUtil.hexify(new String(_newpin).getBytes()), null);
        ResponseAPDU decResponse = null;
        try {
            decResponse = this.sendCommandAPDU(cmd);
        }
        catch (Exception e) {
            return 0;
        }
        if (decResponse != null) {
            try {
                return this.evaluateChangePasswordResultCode(PWD_NAME_PIN, null, decResponse.sw());
            }
            catch (NotYetInitializedException e) {
                return 27013;
            }
            catch (OperationCancelledException e) {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public synchronized int verifyPassword(OCFCertificateInfo _info, char[] _pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (_info != null) {
            return super.verifyPassword(_info, _pin);
        }
        throw new UnsupportedOperationException("direct verify not supported for eID-PIN of nPA");
    }

    @Override
    public boolean isResumePinRequired(OCFCertificateInfo _info) throws RetryCounterExpiredException, PinDeactivatedException {
        block4: {
            try {
                return this.getRetryCount() == 1;
            }
            catch (CardTerminalException cardTerminalException) {
            }
            catch (ResponseCodeException responseCodeException) {
            }
            catch (NotYetInitializedException e) {
                if (e.getRetries() != 1) break block4;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isUnblockPinRequired(OCFCertificateInfo _info) throws RetryCounterExpiredException, PinDeactivatedException {
        block4: {
            try {
                return this.getRetryCount() == 0;
            }
            catch (CardTerminalException cardTerminalException) {
            }
            catch (ResponseCodeException responseCodeException) {
            }
            catch (NotYetInitializedException e) {
                if (e.getRetries() != 0) break block4;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int resumeChangePassword(OCFCertificateInfo _info, char[] _can, char[] _pin, char[] _newPin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, OperationCancelledException, PinDeactivatedException {
        if (PACE.USE_PIN_KEY.equals(this.usedPwdPACE)) {
            throw new IllegalStateException("PIN was used for PACE, no need to resume");
        }
        if (PACE.USE_MRZ_KEY.equals(this.usedPwdPACE)) throw new IllegalStateException("MRZ or PUK was used for PACE, resume not possible");
        if (PACE.USE_PUK_KEY.equals(this.usedPwdPACE)) {
            throw new IllegalStateException("MRZ or PUK was used for PACE, resume not possible");
        }
        if (this.usedChatPACE != null) {
            throw new IllegalStateException("A CHAT was used for PACE, resume not possible");
        }
        if (this.securityProtocol == SecureCard.SecurityProtocol.EAC2_TACA) {
            throw new IllegalStateException("resuming PIN not possible after TA/CA");
        }
        boolean transactionStarted = false;
        try {
            int result;
            block49: {
                byte[] resultBytes;
                block50: {
                    GovCHVDialog chvDialog;
                    Object monitor;
                    block48: {
                        int result2;
                        transactionStarted = CardTerminalManager.beginTransaction(this.ctReference);
                        int retryCount = -1;
                        boolean initCard = false;
                        try {
                            retryCount = this.getRetryCount();
                        }
                        catch (NotYetInitializedException e) {
                            initCard = true;
                            retryCount = e.getRetries();
                        }
                        catch (CardTerminalException e) {
                            // empty catch block
                        }
                        if (retryCount != 1) {
                            throw new IllegalStateException("retry counter not 1, resuming PIN not possible");
                        }
                        _info = new OCFCertificateInfo(this.getCardObject(), OCFCertificateInfo.Usage.EID, OCFCertificateInfo.ChainEntry.UNKNOWN);
                        PCSCCardTerminal paceReader = this.getPACEReader();
                        if (paceReader == null) {
                            if ((_can == null || _can.length != 6) && (_can = CanPukRequestDialog.requestUserAuthenticationCode(OCFCertificateInfo.Usage.EID, BDialogMode.EID_CAN, this.getCardTerminal().getName(), 6)) == null) {
                                int n = 0;
                                return n;
                            }
                            if (_pin == null || _pin.length == 0 || _newPin == null || _newPin.length == 0) {
                                GovCHVDialog chvDialog2 = null;
                                try {
                                    chvDialog2 = (GovCHVDialog)this.chvDialogClass.newInstance();
                                    chvDialog2.setParentWindow(this.parentWindow);
                                }
                                catch (InstantiationException ex) {
                                    throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                                }
                                catch (IllegalAccessException ex) {
                                    throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                                }
                                GovCHVConfiguration config = new GovCHVConfiguration(1, initCard ? BDialogMode.CARD_INIT_3 : BDialogMode.CARD_CHANGE, this.getMinPINLength(null), this.getMaxPINLength(null), _info, this.createTerminalString(null), this.getInitPIN(), this.getMinPINLengthInit(_info), this.getMaxPINLengthInit(_info), this.getClass());
                                config.setShowPseudoDisplay(false);
                                chvDialog2.setConfiguration(config);
                                chvDialog2.show();
                                result2 = chvDialog2.getResult();
                                if (result2 == 2) {
                                    throw new PinInputCancelledException(PWD_NAME_PIN, 1, APDUCommands.getVerifyErrorMsg(0));
                                }
                                _pin = chvDialog2.getPIN();
                                _newPin = chvDialog2.getNewPIN();
                            }
                        }
                        if ((result = this.resumePassword(_info, _can, _pin)) != 36864) break block49;
                        if (paceReader == null) {
                            int n = this.setPinBasicReader(_newPin);
                            return n;
                        }
                        Pcsc20Features features = paceReader.getPcsc20Features();
                        if (!features.isFeatureSupported(7)) {
                            result2 = 0;
                            return result2;
                        }
                        resultBytes = null;
                        monitor = null;
                        chvDialog = null;
                        try {
                            try {
                                chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
                                chvDialog.setParentWindow(this.parentWindow);
                            }
                            catch (InstantiationException ex) {
                                throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                            }
                            catch (IllegalAccessException ex) {
                                throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                            }
                            GovCHVConfiguration config = new GovCHVConfiguration(-1, BDialogMode.CARD_INIT_2, this.getMinPINLength(null), this.getMaxPINLength(null), _info, this.createTerminalString(null), this.getInitPIN(), null, null, this.getClass());
                            config.setShowPseudoDisplay(false);
                            chvDialog.setConfiguration(config);
                            monitor = chvDialog.showReaderMessage();
                            if (this.ctReference instanceof JPCSCCardTerminal) {
                                PinModifyParameters pmp = new PinModifyParameters(HexUtil.parse("002c0203"), PinEncoder.ENCODER_T50, null, null, false, 6, 6, 30, 5, LanguageEnum.GERMAN, false, new byte[0]);
                                try {
                                    resultBytes = ((JPCSCCardTerminal)this.ctReference).pinOperation(chvDialog, pmp);
                                }
                                catch (BTerminalException e) {
                                    int n = 0;
                                    if (monitor != null) {
                                        chvDialog.hideReaderMessage(monitor);
                                    }
                                    monitor = null;
                                    CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
                                    return n;
                                }
                            } else {
                                Pcsc20PinStructureHandler structureHandler = Pcsc20PinStructureHandlerFactory.getHandler(this.ctReference.getName());
                                PinModifyStructure pms = structureHandler.buildPinModifyStructureNPA(30, 5, LanguageEnum.GERMAN);
                                resultBytes = paceReader.sendTerminalCommand(features.getModifyPINDirect().valueAsNumber(), pms.getEncoded());
                            }
                            if (monitor != null) {
                            }
                            break block48;
                        }
                        catch (CardTerminalException e) {
                            int structureHandler = 0;
                            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
                            return structureHandler;
                        }
                        chvDialog.hideReaderMessage(monitor);
                    }
                    monitor = null;
                    if (resultBytes == null) {
                        int n = 0;
                        return n;
                    }
                    break block50;
                    finally {
                        if (monitor != null) {
                            chvDialog.hideReaderMessage(monitor);
                        }
                        monitor = null;
                    }
                }
                ResponseAPDU res = new ResponseAPDU(resultBytes);
                log.debug((Object)("VP RES : " + HexUtil.hexify(res.getBuffer())));
                log.debug((Object)("VP RES : " + APDUCommands.getChangePasswordErrorMsg(res.sw())));
                if (res.sw() == 25616 || res.sw() == 28160) {
                    int structureHandler = res.sw();
                    return structureHandler;
                }
                int structureHandler = this.evaluateChangePasswordResultCode(PWD_NAME_PIN, null, res.sw());
                return structureHandler;
            }
            int n = result;
            return n;
        }
        finally {
            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resumePassword(OCFCertificateInfo _info, char[] _can, char[] _pin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, IllegalStateException, OperationCancelledException, PinDeactivatedException {
        if (PACE.USE_PIN_KEY.equals(this.usedPwdPACE)) {
            throw new IllegalStateException("PIN was used for PACE, no need to resume");
        }
        if (PACE.USE_MRZ_KEY.equals(this.usedPwdPACE) || PACE.USE_PUK_KEY.equals(this.usedPwdPACE)) {
            throw new IllegalStateException("MRZ or PUK was used for PACE, resume not possible");
        }
        if (this.usedChatPACE != null) {
            throw new IllegalStateException("A CHAT was used for PACE, resume not possible");
        }
        if (this.securityProtocol == SecureCard.SecurityProtocol.EAC2_TACA) {
            throw new IllegalStateException("resuming PIN not possible after TA/CA");
        }
        boolean transactionStarted = false;
        try {
            SecureCard.SecurityProtocolResult<? extends Object> spr;
            PaceInputParameters pip;
            transactionStarted = CardTerminalManager.beginTransaction(this.ctReference);
            int retryCount = -1;
            boolean initCard = false;
            try {
                retryCount = this.getRetryCount();
            }
            catch (NotYetInitializedException e) {
                initCard = true;
                retryCount = e.getRetries();
            }
            catch (CardTerminalException e) {
                // empty catch block
            }
            if (retryCount != 1) {
                throw new IllegalStateException("retry counter not 1, resuming PIN not possible");
            }
            PCSCCardTerminal paceReader = this.getPACEReader();
            if (this.securityProtocol == null || this.securityProtocol == SecureCard.SecurityProtocol.NONE) {
                pip = null;
                if (paceReader != null) {
                    pip = new PaceInputParameters();
                } else {
                    if ((_can == null || _can.length != 6) && (_can = CanPukRequestDialog.requestUserAuthenticationCode(OCFCertificateInfo.Usage.EID, BDialogMode.EID_CAN, this.getCardTerminal().getName(), 6)) == null) {
                        int n = 0;
                        return n;
                    }
                    pip = new PaceInputParameters(PACE.USE_CAN_KEY, _can, null, null);
                }
                spr = null;
                try {
                    spr = this.allocateSecureContext(SecureCard.SecurityProtocol.EAC2_PACE, pip);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!PacePlusResult.class.isInstance(spr)) {
                    int e = 0;
                    return e;
                }
                PacePlusResult ppr = (PacePlusResult)spr;
                if (ppr.getThrowable() != null) {
                    int n = this.evaluateThrowable(ppr.getThrowable(), paceReader, PWD_NAME_CAN);
                    return n;
                }
                if (paceReader != null) {
                    int n = 36864;
                    return n;
                }
            }
            if (_pin == null || _pin.length == 0) {
                GovCHVDialog chvDialog = null;
                try {
                    chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
                    chvDialog.setParentWindow(this.parentWindow);
                }
                catch (InstantiationException ex) {
                    throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                }
                catch (IllegalAccessException ex) {
                    throw new OperationCancelledException("", 25601, ex.getMessage(), ex);
                }
                _info = new OCFCertificateInfo(this.getCardObject(), OCFCertificateInfo.Usage.EID, OCFCertificateInfo.ChainEntry.UNKNOWN);
                GovCHVConfiguration config = new GovCHVConfiguration(1, BDialogMode.CARD_VERIFY, initCard ? this.getMinPINLengthInit(null).intValue() : this.getMinPINLength(null), initCard ? this.getMaxPINLengthInit(null).intValue() : this.getMaxPINLength(null), _info, this.createTerminalString(null), this.getInitPIN(), null, null, this.getClass());
                config.setShowPseudoDisplay(false);
                chvDialog.setConfiguration(config);
                chvDialog.show();
                int result = chvDialog.getResult();
                if (result == 2) {
                    throw new PinInputCancelledException(PWD_NAME_PIN, 1, APDUCommands.getVerifyErrorMsg(0));
                }
                _pin = chvDialog.getPIN();
            }
            pip = new PaceInputParameters(PACE.USE_PIN_KEY, _pin, null, null);
            spr = null;
            try {
                spr = this.allocateSecureContext(SecureCard.SecurityProtocol.EAC2_PACE, pip);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!PacePlusResult.class.isInstance(spr)) {
                int e = 0;
                return e;
            }
            PacePlusResult ppr = (PacePlusResult)spr;
            if (ppr.getThrowable() != null) {
                int n = this.evaluateThrowable(ppr.getThrowable(), paceReader, PWD_NAME_PIN);
                return n;
            }
            int n = 36864;
            return n;
        }
        finally {
            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unblockPassword(OCFCertificateInfo _info, char[] _puk, char[] _newPin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, IllegalStateException, OperationCancelledException, PinDeactivatedException {
        if (PACE.USE_PIN_KEY.equals(this.usedPwdPACE)) {
            throw new IllegalStateException("PIN was used for PACE, no need to unblock");
        }
        if (PACE.USE_MRZ_KEY.equals(this.usedPwdPACE)) {
            throw new IllegalStateException("MRZ was used for PACE, unblock not possible");
        }
        if (this.securityProtocol == SecureCard.SecurityProtocol.EAC2_TACA && !this.usedChatPACE.getAccessRoleAndRights().existsRight(AuthenticationTerminals.AccessRightEnum.PIN_MANAGEMENT) || (this.securityProtocol == SecureCard.SecurityProtocol.EAC2_PACEPLUS || this.securityProtocol == SecureCard.SecurityProtocol.EAC2_PACE) && (this.usedChatPACE != null || !PACE.USE_PUK_KEY.equals(this.usedPwdPACE))) {
            throw new IllegalStateException("not having right for unblock PIN");
        }
        boolean transactionStarted = false;
        try {
            transactionStarted = CardTerminalManager.beginTransaction(this.ctReference);
            if (!this.isUnblockPinRequired(null)) {
                throw new IllegalStateException("unblocking PIN not required");
            }
            PCSCCardTerminal paceReader = this.getPACEReader();
            if (this.securityProtocol == null || this.securityProtocol == SecureCard.SecurityProtocol.NONE) {
                if (paceReader == null && (_puk == null || _puk.length != 10) && (_puk = CanPukRequestDialog.requestUserAuthenticationCode(OCFCertificateInfo.Usage.EID, BDialogMode.EID_PUK, this.getCardTerminal().getName(), 10)) == null) {
                    int n = 0;
                    return n;
                }
                PaceInputParameters pip = new PaceInputParameters(PACE.USE_PUK_KEY, _puk, null, null);
                SecureCard.SecurityProtocolResult<? extends Object> spr = null;
                try {
                    spr = this.allocateSecureContext(SecureCard.SecurityProtocol.EAC2_PACE, pip);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!PacePlusResult.class.isInstance(spr)) {
                    int e = 0;
                    return e;
                }
                PacePlusResult ppr = (PacePlusResult)spr;
                if (ppr.getThrowable() != null) {
                    int n = this.evaluateThrowable(ppr.getThrowable(), paceReader, PWD_NAME_PUK);
                    return n;
                }
            }
            CommandAPDU cmd = _newPin != null && _newPin.length > 0 ? EPAUtil.commandFromString("002c0203", HexUtil.hexify(new String(_newPin).getBytes()), null) : EPAUtil.commandFromString("002c0303");
            try {
                ResponseAPDU decResponse = this.sendCommandAPDU(cmd);
                int n = this.evaluateChangePasswordResultCode(PWD_NAME_PIN, null, decResponse.sw());
                return n;
            }
            catch (Throwable t) {
                int n = 0;
                CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
                return n;
            }
        }
        finally {
            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
        }
    }

    @Override
    public int deactivatePassword() throws IllegalStateException {
        if (this.securityProtocol != SecureCard.SecurityProtocol.EAC2_TACA || this.usedChatPACE == null || !this.usedChatPACE.getAccessRoleAndRights().existsRight(AuthenticationTerminals.AccessRightEnum.PIN_MANAGEMENT)) {
            throw new IllegalStateException("PIN Management not allowed");
        }
        CommandAPDU cmd = EPAUtil.commandFromString("00041003");
        try {
            ResponseAPDU res = this.sendCommandAPDU(cmd);
            return res.sw();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int activatePassword() throws IllegalStateException {
        if (this.securityProtocol != SecureCard.SecurityProtocol.EAC2_TACA || this.usedChatPACE == null || !this.usedChatPACE.getAccessRoleAndRights().existsRight(AuthenticationTerminals.AccessRightEnum.PIN_MANAGEMENT)) {
            throw new IllegalStateException("PIN Management not allowed");
        }
        CommandAPDU cmd = EPAUtil.commandFromString("00441003");
        try {
            ResponseAPDU res = this.sendCommandAPDU(cmd);
            return res.sw();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private PCSCCardTerminal getPACEReader() {
        return super.getReader(PaceConstants.PaceCapabilityEnum.PACE);
    }

    private PCSCCardTerminal getESignReader() {
        return super.getReader(PaceConstants.PaceCapabilityEnum.ESIGN);
    }

    @Override
    protected final GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] value, String algorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        PCSCCardTerminal comfortReader = this.getESignReader();
        if (comfortReader == null) {
            throw new IllegalStateException("QES currently only possible with comfort reader!");
        }
        AssertUtil.notNull(value, "data to be signed must be present");
        if (this.securityProtocol != SecureCard.SecurityProtocol.EAC2_TACA) {
            throw new IllegalStateException("TACA must be established in order to sign");
        }
        if (!this.usedChatPACE.getAccessRoleAndRights().isRole(SignatureTerminals.AccessRoleEnum.SIGNATURE_TERMINAL)) {
            throw new IllegalStateException("Role must be signature terminal");
        }
        if (!this.usedChatPACE.getAccessRoleAndRights().existsRight(SignatureTerminals.AccessRightEnum.ESIGN_GENERATE_QUALIFIED_ELECTRONIC_SIGNATURE)) {
            throw new IllegalStateException("Right for qualified signature must exist");
        }
        ResponseAPDU response = null;
        try {
            byte[] le = HexUtil.parse("00");
            if (le == null || le.length == 0) {
                log.debug((Object)"Java implementation problem occured on simple parsing hex string working on all other Java");
                EPA.dumpSystemInfos();
                le = new byte[]{0};
            }
            CommandAPDU signCmd = new CommandAPDU(ByteUtil.combine(new byte[][]{HexUtil.parse("002a9e9a"), {(byte)value.length}, value, le}));
            log.debug((Object)("c1:\n" + HexUtil.dump(signCmd.getBytes())));
            this.getCurrentProtocol(super.getCardTerminal(), false);
            response = this.sendCommandAPDU(signCmd);
            log.debug((Object)("r1:\n" + HexUtil.dump(response.getBytes())));
            this.getCurrentProtocol(super.getCardTerminal(), false);
            if (response.sw() == 26368) {
                log.debug((Object)"Java, OS or driver specific problem occured on simple default command, retry with a little change at le");
                EPA.dumpSystemInfos();
                le = new byte[]{-64};
                signCmd = new CommandAPDU(ByteUtil.combine(new byte[][]{HexUtil.parse("002a9e9a"), {(byte)value.length}, value, le}));
                log.debug((Object)("c2:\n" + HexUtil.dump(signCmd.getBytes())));
                this.getCurrentProtocol(super.getCardTerminal(), false);
                response = this.sendCommandAPDU(signCmd);
                log.debug((Object)("r2:\n" + HexUtil.dump(response.getBytes())));
                this.getCurrentProtocol(super.getCardTerminal(), false);
            }
        }
        catch (CardTerminalException e) {
            log.error((Object)"communication with terminal failed", (Throwable)e);
        }
        if (response == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(response.sw());
        ro.setResultData(response.data());
        return ro;
    }

    public static void dumpSystemInfos() {
        try {
            log.debug((Object)("Current system: " + SystemEnum.getCurrentSystem()));
            log.debug((Object)("OS version: " + OSInfo.getVersion()));
            log.debug((Object)("OS details: " + OSInfo.getDetails()));
            log.debug((Object)("Java version: " + SystemPropertyUtil.getJavaVersion()));
            log.debug((Object)("Java architecture: " + SystemPropertyUtil.getJavaArchitecture()));
            log.debug((Object)("Java OS name: " + SystemPropertyUtil.getOSName()));
        }
        catch (Throwable t) {
            log.debug((Object)"failed to log some debug informations about OS and Java", t);
        }
    }

    @Override
    public boolean prepareSignatureTerminal(boolean initMode) throws IllegalStateException, OperationCancelledException, WrongPinException {
        if (this.getESignReader() == null) {
            throw new IllegalStateException("signature terminal only possible with comfort reader");
        }
        try {
            Throwable t;
            PaceInputParameters pip = new PaceInputParameters();
            CertificateHolderAuthorizationTemplate chat = new CertificateHolderAuthorizationTemplate();
            chat.decode(HexUtil.parse(CHAT_SIG_TERM));
            pip.setTemplate(chat);
            pip.setSecretChoice(initMode ? PACE.USE_PIN_KEY : PACE.USE_CAN_KEY);
            log.debug((Object)"before PACE");
            this.getCurrentProtocol(super.getCardTerminal(), false);
            PacePlusResult ppr = (PacePlusResult)this.allocateSecureContext(SecureCard.SecurityProtocol.EAC2_PACE, pip);
            log.debug((Object)"after PACE");
            this.getCurrentProtocol(super.getCardTerminal(), false);
            if (SPECIAL_RESULT.equals(ppr)) {
                CardTerminalManager ctm = CardTerminalManager.getInstance(null, null, null);
                ctm.fireGovCSRemoved(this);
                log.debug((Object)"after removing");
                ctm.fireGovCSAdded(this);
                log.debug((Object)"after adding");
                this.checkWorkaroundYosemiteT0(super.getCardTerminal());
                return true;
            }
            if (ppr != null && (t = ppr.getThrowable()) != null) {
                if (t instanceof OperationCancelledException) {
                    throw (OperationCancelledException)t;
                }
                if (t instanceof WrongPinException) {
                    throw (WrongPinException)t;
                }
            }
        }
        catch (CardTerminalException cardTerminalException) {
        }
        catch (CardServiceException cardServiceException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private int evaluateThrowable(Throwable throwable, PCSCCardTerminal paceReader, String pinName) throws OperationCancelledException, WrongPinException, RetryCounterExpiredException, WrongConfirmedNewPinException {
        AssertUtil.notNull(throwable, "throwable");
        if (paceReader != null && throwable instanceof OCFException) {
            int errorCode = ((OCFException)throwable).getErrorCode();
            try {
                return super.evaluateChangePasswordResultCode(pinName, null, errorCode);
            }
            catch (NotYetInitializedException e) {
                return 27013;
            }
        }
        return 0;
    }

    @Override
    public void setSM(SecureMessaging<?, ?, ?> sm) {
        super.setSM(sm);
    }

    @Override
    public GovCS.CardContactMode getCardContactMode() {
        return GovCS.CardContactMode.RFID_CONTACTLESS;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            JavaSystemBridge.loadLibrary();
            EPA.dumpSystemInfos();
        }
        catch (Throwable t) {
            log.debug((Object)"failed to log OS informations", t);
        }
        byte[] value = new byte[32];
        Arrays.fill(value, (byte)-1);
        CommandAPDU signCmd = new CommandAPDU(ByteUtil.combine(new byte[][]{HexUtil.parse("002a9e9a"), {(byte)value.length}, value, HexUtil.parse("00")}));
        log.debug((Object)("cmd:\n" + HexUtil.dump(signCmd.getBytes())));
        log.debug((Object)("HexUtil.parse(\"00\"): " + HexUtil.parse("00")));
        log.debug((Object)("HexUtil.parse(\"00\").length: " + HexUtil.parse("00").length));
    }
}

