/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECFieldElement;

public class ConversionUtil {
    public static final byte[] I2OS(BigInteger x, int l) throws IllegalArgumentException {
        BigInteger lengthCheck = BigInteger.valueOf(256L);
        lengthCheck = lengthCheck.pow(l);
        if (l < 1 || x.compareTo(lengthCheck) >= 0) {
            throw new IllegalArgumentException("length " + l + " too short for representing " + x);
        }
        byte[] retval = new byte[l];
        for (int i = 0; i < retval.length; ++i) {
            BigInteger bi = BigInteger.valueOf(256L);
            bi = bi.pow(retval.length - 1 - i);
            retval[i] = x.divide(bi).byteValue();
            x = x.mod(bi);
        }
        return retval;
    }

    public static final byte[] FE2OS(ECFieldElement fe) {
        return ConversionUtil.I2OS(fe.toBigInteger(), fe.getFieldSize());
    }

    public static final BigInteger OS2I(byte[] os) throws IllegalArgumentException {
        if (os == null) {
            throw new IllegalArgumentException("null array not permitted");
        }
        if (os.length == 0) {
            return BigInteger.valueOf(0L);
        }
        return new BigInteger(os);
    }
}

