/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui;

import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.common.StringUtil;
import de.bos_bremen.common.swing.MultiLineToolTipUI;
import de.bos_bremen.common.swing.SwingUtil;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVConfiguration;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialogProvider;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.CapsLockIcon;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.FindBugsRequiredInterface;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.Closeable;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.PinGUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.StringContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class GovCHV_JDialog
extends JDialog
implements Closeable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GovCHV_JDialog.class);
    private JButton button_ok = null;
    private JPasswordField curPINField = null;
    private JPasswordField newPINField = null;
    private JPasswordField newPINRepeatField = null;
    private transient FocusAdapter defaultButtonEnabler = new OKButtonEnabler();
    private transient FocusAdapter selectAllOnFocus = new SelectAllOnFocuser();
    private Window parent = null;
    private transient FindBugsRequiredInterface findBugs = null;
    private OKEnabler okenabler;
    private Component firstFocus = null;

    @Override
    public void setVisible(boolean b) {
        if (b) {
            MultiLineToolTipUI.install();
        } else {
            MultiLineToolTipUI.uninstall();
        }
        boolean m = super.isModal();
        if (!this.isVisible() && b && m) {
            super.setModal(false);
            super.setVisible(true);
            SwingUtil.update(this);
            super.setVisible(false);
            super.setModal(true);
        }
        super.setVisible(b);
        if (!m && b) {
            SwingUtil.update(this);
        }
    }

    public GovCHV_JDialog(Frame _parent, FindBugsRequiredInterface _findBugs) {
        super(_parent, true);
        this.findBugs = _findBugs;
        this.init(_parent);
    }

    public GovCHV_JDialog(Dialog _parent, FindBugsRequiredInterface _findBugs) {
        super(_parent, true);
        this.findBugs = _findBugs;
        this.init(_parent);
    }

    private void init(Window _parent) {
        this.parent = _parent;
        super.setAlwaysOnTop(true);
        this.initComponents();
        this.installFocusListenersRecursive(this.getContentPane(), this.getRootPane());
        this.pack();
        this.okenabler.check(null);
        this.setResizable(true);
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth();
        int height = gd.getDisplayMode().getHeight();
        float factorNormal = 2.0f;
        Dimension dimensionNormal = new Dimension((int)((float)width / factorNormal), (int)((float)height / factorNormal));
        float factorMin = 3.0f;
        Dimension dimensionMin = new Dimension((int)((float)width / factorMin), (int)((float)height / factorMin));
        this.setMinimumSize(dimensionMin);
        this.setPreferredSize(dimensionNormal);
        this.setSize(dimensionNormal);
        this.setLocationRelativeTo(this.parent);
    }

    public void installFocusListenersRecursive(Component _comp, JRootPane _root) {
        if (!(_comp instanceof JComponent)) {
            return;
        }
        JComponent comp = (JComponent)_comp;
        if (comp instanceof JButton && comp.isFocusable()) {
            comp.addFocusListener(this.defaultButtonEnabler);
        }
        if (comp instanceof JTextComponent && comp.isFocusable()) {
            comp.addFocusListener(this.selectAllOnFocus);
        }
        Component[] comps = comp.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            this.installFocusListenersRecursive(comps[i], _root);
        }
    }

    private JComponent buildCenterPanel() {
        int maxLength;
        int minLength;
        JPanel centerPanel = new JPanel(new GridBagLayout());
        GovCHVConfiguration configuration = this.findBugs.getConfiguration();
        OCFCertificateInfo.Usage usage = configuration.getOCFCertificateInfo().getUsage();
        int gridy = 0;
        Insets insets5 = new Insets(5, 5, 5, 5);
        JComponent certificatePanel = null;
        try {
            certificatePanel = this.findBugs.buildInfoPanel(usage);
        }
        catch (Throwable ex) {
            log.debug((Object)"", ex);
        }
        if (certificatePanel != null) {
            centerPanel.add((Component)certificatePanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 11, 1, insets5, 0, 0));
        }
        if ((minLength = configuration.getMinLength()) == 0) {
            minLength = 4;
        }
        if ((maxLength = configuration.getMaxLength()) == 0) {
            maxLength = 20;
        }
        maxLength = Math.max(maxLength, minLength);
        this.okenabler = new OKEnabler();
        BDialogMode chvMode = configuration.getMode();
        JComponent[] components = new JComponent[3];
        PinGUIUtil.Mode mode = chvMode == BDialogMode.CARD_CHANGE || chvMode == BDialogMode.FILE_CHANGE || chvMode == BDialogMode.CARD_INIT_2 || chvMode == BDialogMode.CARD_INIT_3 ? PinGUIUtil.Mode.MODE_MODIFY : PinGUIUtil.Mode.MODE_VERIFY;
        gridy = (chvMode == BDialogMode.CARD_INIT_2 || chvMode == BDialogMode.CARD_INIT_3) && configuration.getMinLengthInit() != null && configuration.getMaxLengthInit() != null ? this.addDefaultComponents(centerPanel, configuration, usage, gridy, insets5, certificatePanel, configuration.getMinLengthInit(), configuration.getMaxLengthInit(), chvMode, components, mode) : this.addDefaultComponents(centerPanel, configuration, usage, gridy, insets5, certificatePanel, minLength, maxLength, chvMode, components, mode);
        this.addChangeComponents(centerPanel, configuration, usage, gridy, insets5, minLength, maxLength, chvMode, components, mode);
        this.addInitComponents(centerPanel, configuration, usage, gridy, insets5, minLength, maxLength, chvMode, components, mode);
        return centerPanel;
    }

    private int addDefaultComponents(JPanel centerPanel, final GovCHVConfiguration configuration, OCFCertificateInfo.Usage usage, int gridy, Insets insets5, JComponent certificatePanel, int minLength, int maxLength, BDialogMode chvMode, final JComponent[] components, final PinGUIUtil.Mode mode) {
        JPanel pinPanel = new JPanel(new GridBagLayout());
        int gridy2 = 0;
        String propertyKeyPartMode = chvMode == BDialogMode.CARD_CHANGE || chvMode == BDialogMode.FILE_CHANGE ? "old_" : "";
        propertyKeyPartMode = chvMode == BDialogMode.CARD_INIT_2 || chvMode == BDialogMode.FILE_INIT ? "init2_" : propertyKeyPartMode;
        propertyKeyPartMode = chvMode == BDialogMode.CARD_INIT_3 ? "init3_" : propertyKeyPartMode;
        propertyKeyPartMode = chvMode == BDialogMode.EID_CAN ? "eid_can." : propertyKeyPartMode;
        propertyKeyPartMode = chvMode == BDialogMode.EID_PUK ? "eid_puk." : propertyKeyPartMode;
        propertyKeyPartMode = chvMode == BDialogMode.RFID_CAN ? "rfid_can." : propertyKeyPartMode;
        pinPanel.setBorder(new TitledBorder(null, this.findBugs.getResource("chv_dialog.border." + propertyKeyPartMode + "pin.title"), 1, 2));
        String prompt3 = this.findBugs.getResource("chv_dialog." + usage.name + "." + propertyKeyPartMode + "pin.label");
        final JLabel pinLabel = new JLabel(prompt3);
        PlainDocument docCurPINField = new PlainDocument(new StringContent(maxLength));
        JPasswordField pf1 = new JPasswordField(docCurPINField, null, maxLength);
        pinLabel.setLabelFor(pf1);
        this.curPINField = pf1;
        this.curPINField.putClientProperty("minLength", minLength);
        this.curPINField.putClientProperty("maxLength", maxLength);
        components[0] = this.curPINField;
        final boolean useInitPinLengths = chvMode == BDialogMode.EID_INIT || chvMode == BDialogMode.CARD_INIT_3;
        JButton eb1 = new JButton(this.findBugs.getResource("button.1.dialog.pin.entry.txt"));
        eb1.setToolTipText(this.findBugs.getResource("button.1.dialog.pin.entry.txt.tooltip") + (String)(pinLabel.getToolTipText() != null ? " " + pinLabel.getToolTipText() : ""));
        eb1.setMnemonic(eb1.getText().charAt(0));
        if (!GovCHVDialogProvider.getInstance().isPinGuiEnabled()) {
            eb1.setEnabled(false);
            eb1.setVisible(false);
        } else {
            eb1.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    GovCHV_JDialog.this.setEnabled(false);
                    JComponent focusComponent = null;
                    try {
                        GovCHV_JDialog.this.okenabler.setEnabled(false);
                        int r = PinGUIUtil.requestPIN(mode, GovCHV_JDialog.this, GovCHV_JDialog.this.findBugs.getResource("dialog.pin.entry.title"), pinLabel, configuration, GovCHV_JDialog.this.curPINField, (Closeable)GovCHV_JDialog.this, useInitPinLengths);
                        focusComponent = GovCHV_JDialog.this.getFocusComponent(r, components[0], components[1], components[0]);
                    }
                    finally {
                        GovCHV_JDialog.this.okenabler.setEnabled(true);
                        GovCHV_JDialog.this.setEnabled(true);
                        if (focusComponent != null) {
                            focusComponent.grabFocus();
                        }
                    }
                }
            });
        }
        JLabel capsLockInfo = new JLabel();
        capsLockInfo.setIcon(new CapsLockIcon(capsLockInfo, this.curPINField));
        capsLockInfo.getAccessibleContext().setAccessibleName("Icon-capslock-Feststelltaste");
        capsLockInfo.setToolTipText(this.findBugs.getResource("chv_dialog.capslock.tooltip"));
        pinPanel.add((Component)pinLabel, new GridBagConstraints(0, gridy2++, 2, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
        pinPanel.add((Component)this.curPINField, new GridBagConstraints(0, gridy2, 1, 1, 1.0, 1.0, 18, 2, insets5, 0, 0));
        pinPanel.add((Component)eb1, new GridBagConstraints(2, gridy2, 1, 1, 0.0, 0.0, 12, 0, insets5, 0, 0));
        pinPanel.add((Component)capsLockInfo, new GridBagConstraints(1, gridy2++, 1, 1, 0.0, 0.0, 17, 0, insets5, 0, 0));
        centerPanel.add((Component)pinPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 11, 1, insets5, 0, 0));
        this.firstFocus = this.curPINField;
        if (configuration.getMode() == BDialogMode.CARD_INIT_2) {
            this.curPINField.setEnabled(false);
            eb1.setEnabled(false);
            this.curPINField.setText(new String(configuration.getTransportPIN()));
        }
        pf1.getDocument().addDocumentListener(this.okenabler);
        if (chvMode != BDialogMode.EID_CAN && chvMode != BDialogMode.EID_PUK && chvMode != BDialogMode.RFID_CAN) {
            int maxPinLength;
            Object k = configuration.getMode() == BDialogMode.CARD_INIT_2 || configuration.getMode() == BDialogMode.CARD_INIT_3 ? "chv_dialog.enter.init_pin" : "chv_dialog.enter.old_pin";
            int minPinLength = (configuration.getMode() == BDialogMode.CARD_INIT_2 || configuration.getMode() == BDialogMode.CARD_INIT_3) && configuration.getMinLengthInit() != null ? configuration.getMinLengthInit().intValue() : configuration.getMinLength();
            int n = maxPinLength = (configuration.getMode() == BDialogMode.CARD_INIT_2 || configuration.getMode() == BDialogMode.CARD_INIT_3) && configuration.getMaxLengthInit() != null ? configuration.getMaxLengthInit().intValue() : configuration.getMaxLength();
            if (minPinLength == maxPinLength) {
                k = StringUtil.format(this.findBugs.getResource((String)k) + "\n", minPinLength, StringUtil.format(this.findBugs.getResource("inputTooShort"), this.curPINField.getDocument().getLength()));
            } else {
                k = (String)k + ".d";
                k = StringUtil.format(this.findBugs.getResource((String)k) + "\n", minPinLength, maxPinLength, StringUtil.format(this.findBugs.getResource("inputTooShort"), this.curPINField.getDocument().getLength()));
            }
            this.curPINField.setToolTipText((String)(certificatePanel.getToolTipText() == null || certificatePanel.getToolTipText().isEmpty() ? k : certificatePanel.getToolTipText() + " - \n" + (String)k));
        } else {
            Object k = "chv_dialog." + usage.name + "." + propertyKeyPartMode + "pin.field";
            if (configuration.getMinLength() == configuration.getMaxLength()) {
                k = StringUtil.format(this.findBugs.getResource((String)k) + "\n", configuration.getMinLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.curPINField.getDocument().getLength()));
            } else {
                k = (String)k + ".d";
                k = StringUtil.format(this.findBugs.getResource((String)k) + "\n", configuration.getMinLength(), configuration.getMaxLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.curPINField.getDocument().getLength()));
            }
            this.curPINField.setToolTipText((String)k);
        }
        return gridy;
    }

    private void addChangeComponents(JPanel centerPanel, final GovCHVConfiguration configuration, OCFCertificateInfo.Usage usage, int gridy, Insets insets5, int minLength, int maxLength, BDialogMode chvMode, final JComponent[] components, final PinGUIUtil.Mode mode) {
        if (chvMode == BDialogMode.CARD_CHANGE || chvMode == BDialogMode.FILE_CHANGE) {
            JPanel pinPanel = new JPanel(new GridBagLayout());
            int gridy2 = 0;
            pinPanel.setBorder(new TitledBorder(null, this.findBugs.getResource("chv_dialog.border.new_pin.title"), 1, 2));
            String prompt4 = this.findBugs.getResource("chv_dialog." + usage.name + ".new_pin.label");
            final JLabel pinLabel2 = new JLabel(prompt4);
            pinLabel2.setFocusable(false);
            JPasswordField pf1 = new JPasswordField(maxLength);
            pf1.setDocument(new PlainDocument(new StringContent(maxLength)));
            this.newPINField = pf1;
            this.newPINField.putClientProperty("minLength", minLength);
            this.newPINField.putClientProperty("maxLength", maxLength);
            pf1.getDocument().addDocumentListener(this.okenabler);
            Object k = "chv_dialog.enter.new_pin";
            if (configuration.getMinLength() == configuration.getMaxLength()) {
                k = StringUtil.format(this.findBugs.getResource((String)k), configuration.getMinLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.newPINField.getDocument().getLength()));
            } else {
                k = (String)k + ".d";
                k = StringUtil.format(this.findBugs.getResource((String)k), configuration.getMinLength(), configuration.getMaxLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.newPINField.getDocument().getLength()));
            }
            this.newPINField.setToolTipText((String)k);
            components[1] = this.newPINField;
            JButton eb2 = new JButton(this.findBugs.getResource("button.2.dialog.pin.entry.txt"));
            eb2.setToolTipText(this.findBugs.getResource("button.2.dialog.pin.entry.txt.tooltip") + " " + (String)(pinLabel2.getToolTipText() != null ? " " + pinLabel2.getToolTipText() : ""));
            if (!GovCHVDialogProvider.getInstance().isPinGuiEnabled()) {
                eb2.setEnabled(false);
                eb2.setVisible(false);
            } else {
                eb2.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GovCHV_JDialog.this.setEnabled(false);
                        JComponent focusComponent = null;
                        try {
                            GovCHV_JDialog.this.okenabler.setEnabled(false);
                            int r = PinGUIUtil.requestPIN(mode, GovCHV_JDialog.this, GovCHV_JDialog.this.findBugs.getResource("dialog.pin.entry.title"), pinLabel2, configuration, GovCHV_JDialog.this.newPINField, (Closeable)GovCHV_JDialog.this, false);
                            focusComponent = GovCHV_JDialog.this.getFocusComponent(r, components[1], components[2], components[1]);
                        }
                        finally {
                            GovCHV_JDialog.this.okenabler.setEnabled(true);
                            GovCHV_JDialog.this.setEnabled(true);
                            if (focusComponent != null) {
                                focusComponent.grabFocus();
                            }
                        }
                    }
                });
            }
            JLabel capsLockInfo = new JLabel();
            capsLockInfo.setIcon(new CapsLockIcon(capsLockInfo, this.newPINField));
            capsLockInfo.setToolTipText(this.findBugs.getResource("chv_dialog.capslock.tooltip"));
            pinPanel.add((Component)pinLabel2, new GridBagConstraints(0, gridy2++, 2, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
            pinPanel.add((Component)this.newPINField, new GridBagConstraints(0, gridy2, 1, 1, 1.0, 1.0, 18, 2, insets5, 0, 0));
            pinPanel.add((Component)eb2, new GridBagConstraints(2, gridy2, 1, 1, 0.0, 0.0, 12, 0, insets5, 0, 0));
            pinPanel.add((Component)capsLockInfo, new GridBagConstraints(1, gridy2++, 1, 1, 0.0, 0.0, 17, 0, insets5, 0, 0));
            prompt4 = this.findBugs.getResource("chv_dialog." + usage.name + ".repeat_new_pin.label");
            final JLabel pinLabel3 = new JLabel(prompt4);
            pinLabel3.setFocusable(false);
            JPasswordField pf2 = new JPasswordField(maxLength);
            pf2.setDocument(new PlainDocument(new StringContent(maxLength)));
            this.newPINRepeatField = pf2;
            this.newPINRepeatField.putClientProperty("minLength", minLength);
            this.newPINRepeatField.putClientProperty("maxLength", maxLength);
            pf2.getDocument().addDocumentListener(this.okenabler);
            k = "chv_dialog.enter.new_pin_confirm";
            if (configuration.getMinLength() == configuration.getMaxLength()) {
                k = StringUtil.format(this.findBugs.getResource((String)k), configuration.getMinLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.newPINRepeatField.getDocument().getLength()));
            } else {
                k = (String)k + ".d";
                k = StringUtil.format(this.findBugs.getResource((String)k), configuration.getMinLength(), configuration.getMaxLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.newPINRepeatField.getDocument().getLength()));
            }
            this.newPINRepeatField.setToolTipText((String)k);
            this.newPINRepeatField.putClientProperty("KEY_CLIENT_PROPERTY_COMPARE_PASSWORDFIELD", this.newPINField);
            components[2] = this.newPINRepeatField;
            JButton eb3 = new JButton(this.findBugs.getResource("button.3.dialog.pin.entry.txt"));
            eb3.setToolTipText(this.findBugs.getResource("button.3.dialog.pin.entry.txt.tooltip") + " " + (String)(pinLabel3.getToolTipText() != null ? " " + pinLabel3.getToolTipText() : ""));
            if (!GovCHVDialogProvider.getInstance().isPinGuiEnabled()) {
                eb3.setEnabled(false);
                eb3.setVisible(false);
            } else {
                eb3.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GovCHV_JDialog.this.setEnabled(false);
                        JComponent focusComponent = null;
                        try {
                            GovCHV_JDialog.this.okenabler.setEnabled(false);
                            int r = PinGUIUtil.requestPIN(PinGUIUtil.Mode.MODE_VERIFY, GovCHV_JDialog.this, GovCHV_JDialog.this.findBugs.getResource("dialog.pin.entry.title"), pinLabel3, configuration, GovCHV_JDialog.this.newPINRepeatField, (Closeable)GovCHV_JDialog.this, false);
                            focusComponent = GovCHV_JDialog.this.getFocusComponent(r, components[2], null, null);
                        }
                        finally {
                            GovCHV_JDialog.this.okenabler.setEnabled(true);
                            GovCHV_JDialog.this.setEnabled(true);
                            if (focusComponent != null) {
                                focusComponent.grabFocus();
                            }
                        }
                    }
                });
            }
            capsLockInfo = new JLabel();
            capsLockInfo.setIcon(new CapsLockIcon(capsLockInfo, this.newPINRepeatField));
            capsLockInfo.setToolTipText(this.findBugs.getResource("chv_dialog.capslock.tooltip"));
            pinPanel.add((Component)pinLabel3, new GridBagConstraints(0, gridy2++, 2, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
            pinPanel.add((Component)this.newPINRepeatField, new GridBagConstraints(0, gridy2, 1, 1, 1.0, 1.0, 18, 2, insets5, 0, 0));
            pinPanel.add((Component)eb3, new GridBagConstraints(2, gridy2, 1, 1, 0.0, 0.0, 12, 0, insets5, 0, 0));
            pinPanel.add((Component)capsLockInfo, new GridBagConstraints(1, gridy2++, 1, 1, 0.0, 0.0, 17, 0, insets5, 0, 0));
            centerPanel.add((Component)pinPanel, new GridBagConstraints(0, gridy, 1, 1, 1.0, 1.0, 11, 1, insets5, 0, 0));
        }
    }

    private void addInitComponents(JPanel centerPanel, final GovCHVConfiguration configuration, OCFCertificateInfo.Usage usage, int gridy, Insets insets5, int minLength, int maxLength, BDialogMode chvMode, final JComponent[] components, final PinGUIUtil.Mode mode) {
        if (chvMode == BDialogMode.CARD_INIT_2 || chvMode == BDialogMode.CARD_INIT_3) {
            JPanel pinPanel = new JPanel(new GridBagLayout());
            int gridy2 = 0;
            pinPanel.setBorder(new TitledBorder(null, this.findBugs.getResource("chv_dialog.border.new_pin.title"), 1, 2));
            String prompt4 = this.findBugs.getResource("chv_dialog." + usage.name + ".new_pin.label");
            final JLabel pinLabel2 = new JLabel(prompt4);
            pinLabel2.setFocusable(false);
            JPasswordField pf1 = new JPasswordField(maxLength);
            pf1.setDocument(new PlainDocument(new StringContent(maxLength)));
            this.newPINField = pf1;
            this.newPINField.putClientProperty("minLength", minLength);
            this.newPINField.putClientProperty("maxLength", maxLength);
            pf1.getDocument().addDocumentListener(this.okenabler);
            if (chvMode == BDialogMode.CARD_INIT_2) {
                this.firstFocus = this.newPINField;
            }
            Object k = "chv_dialog.enter.new_pin";
            if (configuration.getMinLength() == configuration.getMaxLength()) {
                k = StringUtil.format(this.findBugs.getResource((String)k), configuration.getMinLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.newPINField.getDocument().getLength()));
            } else {
                k = (String)k + ".d";
                k = StringUtil.format(this.findBugs.getResource((String)k), configuration.getMinLength(), configuration.getMaxLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.newPINField.getDocument().getLength()));
            }
            this.newPINField.setToolTipText((String)k);
            components[1] = this.newPINField;
            JButton eb2 = new JButton(this.findBugs.getResource("button.2.dialog.pin.entry.txt"));
            eb2.setToolTipText(this.findBugs.getResource("button.2.dialog.pin.entry.txt.tooltip") + " " + (String)(pinLabel2.getToolTipText() != null ? " " + pinLabel2.getToolTipText() : ""));
            if (!GovCHVDialogProvider.getInstance().isPinGuiEnabled()) {
                eb2.setEnabled(false);
                eb2.setVisible(false);
            } else {
                eb2.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GovCHV_JDialog.this.setEnabled(false);
                        JComponent focusComponent = null;
                        try {
                            GovCHV_JDialog.this.okenabler.setEnabled(false);
                            int r = PinGUIUtil.requestPIN(mode, GovCHV_JDialog.this, GovCHV_JDialog.this.findBugs.getResource("dialog.pin.entry.title"), pinLabel2, configuration, GovCHV_JDialog.this.newPINField, (Closeable)GovCHV_JDialog.this, false);
                            focusComponent = GovCHV_JDialog.this.getFocusComponent(r, components[1], components[2], components[1]);
                        }
                        finally {
                            GovCHV_JDialog.this.okenabler.setEnabled(true);
                            GovCHV_JDialog.this.setEnabled(true);
                            if (focusComponent != null) {
                                focusComponent.grabFocus();
                            }
                        }
                    }
                });
            }
            JLabel capsLockInfo = new JLabel();
            capsLockInfo.setIcon(new CapsLockIcon(capsLockInfo, this.curPINField));
            capsLockInfo.setToolTipText(this.findBugs.getResource("chv_dialog.capslock.tooltip"));
            pinPanel.add((Component)pinLabel2, new GridBagConstraints(0, gridy2++, 2, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
            pinPanel.add((Component)this.newPINField, new GridBagConstraints(0, gridy2, 1, 1, 1.0, 1.0, 18, 2, insets5, 0, 0));
            pinPanel.add((Component)eb2, new GridBagConstraints(2, gridy2, 1, 1, 0.0, 0.0, 12, 0, insets5, 0, 0));
            pinPanel.add((Component)capsLockInfo, new GridBagConstraints(1, gridy2++, 1, 1, 0.0, 0.0, 17, 0, insets5, 0, 0));
            prompt4 = this.findBugs.getResource("chv_dialog." + usage.name + ".repeat_new_pin.label");
            final JLabel pinLabel3 = new JLabel(prompt4);
            pinLabel3.setFocusable(false);
            JPasswordField pf2 = new JPasswordField(maxLength);
            pf2.setDocument(new PlainDocument(new StringContent(maxLength)));
            this.newPINRepeatField = pf2;
            this.newPINRepeatField.putClientProperty("minLength", minLength);
            this.newPINRepeatField.putClientProperty("maxLength", maxLength);
            pf2.getDocument().addDocumentListener(this.okenabler);
            k = "chv_dialog.enter.new_pin_confirm";
            if (configuration.getMinLength() == configuration.getMaxLength()) {
                k = StringUtil.format(this.findBugs.getResource((String)k), configuration.getMinLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.newPINRepeatField.getDocument().getLength()));
            } else {
                k = (String)k + ".d";
                k = StringUtil.format(this.findBugs.getResource((String)k), configuration.getMinLength(), configuration.getMaxLength(), StringUtil.format(this.findBugs.getResource("inputTooShort"), this.newPINRepeatField.getDocument().getLength()));
            }
            this.newPINRepeatField.setToolTipText((String)k);
            this.newPINRepeatField.putClientProperty("KEY_CLIENT_PROPERTY_COMPARE_PASSWORDFIELD", this.newPINField);
            components[2] = this.newPINRepeatField;
            JButton eb3 = new JButton(this.findBugs.getResource("button.3.dialog.pin.entry.txt"));
            eb3.setToolTipText(this.findBugs.getResource("button.3.dialog.pin.entry.txt.tooltip") + " " + (String)(pinLabel3.getToolTipText() != null ? " " + pinLabel3.getToolTipText() : ""));
            if (!GovCHVDialogProvider.getInstance().isPinGuiEnabled()) {
                eb3.setEnabled(false);
                eb3.setVisible(false);
            } else {
                eb3.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GovCHV_JDialog.this.setEnabled(false);
                        JComponent focusComponent = null;
                        try {
                            GovCHV_JDialog.this.okenabler.setEnabled(false);
                            int r = PinGUIUtil.requestPIN(PinGUIUtil.Mode.MODE_VERIFY, GovCHV_JDialog.this, GovCHV_JDialog.this.findBugs.getResource("dialog.pin.entry.title"), pinLabel3, configuration, GovCHV_JDialog.this.newPINRepeatField, (Closeable)GovCHV_JDialog.this, false);
                            focusComponent = GovCHV_JDialog.this.getFocusComponent(r, components[2], null, null);
                        }
                        finally {
                            GovCHV_JDialog.this.okenabler.setEnabled(true);
                            GovCHV_JDialog.this.setEnabled(true);
                            if (focusComponent != null) {
                                focusComponent.grabFocus();
                            }
                        }
                    }
                });
            }
            capsLockInfo = new JLabel();
            capsLockInfo.setIcon(new CapsLockIcon(capsLockInfo, this.curPINField));
            capsLockInfo.setToolTipText(this.findBugs.getResource("chv_dialog.capslock.tooltip"));
            pinPanel.add((Component)pinLabel3, new GridBagConstraints(0, gridy2++, 2, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
            pinPanel.add((Component)this.newPINRepeatField, new GridBagConstraints(0, gridy2, 1, 1, 1.0, 1.0, 18, 2, insets5, 0, 0));
            pinPanel.add((Component)capsLockInfo, new GridBagConstraints(1, gridy2++, 1, 1, 0.0, 0.0, 17, 0, insets5, 0, 0));
            pinPanel.add((Component)eb3, new GridBagConstraints(2, gridy2, 1, 1, 0.0, 0.0, 12, 0, insets5, 0, 0));
            centerPanel.add((Component)pinPanel, new GridBagConstraints(0, gridy, 1, 1, 1.0, 1.0, 11, 1, insets5, 0, 0));
        }
    }

    void resetDefaultButton() {
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    protected JComponent getFocusComponent(int r, JComponent backComponent, JComponent okComponent, JComponent cancelComponent) {
        JComponent focusComponent;
        switch (r) {
            case 0: {
                focusComponent = backComponent;
                break;
            }
            case 2: {
                focusComponent = cancelComponent;
                break;
            }
            default: {
                focusComponent = okComponent;
            }
        }
        return focusComponent;
    }

    private JComponent buildControlPanel() {
        this.button_ok = new JButton(this.findBugs.getResource("chv_dialog.button.ok.text"));
        this.button_ok.setToolTipText(this.findBugs.getResource("chv_dialog.button.ok.tooltiptext"));
        this.button_ok.setMnemonic(this.button_ok.getText().charAt(0));
        JButton button_cancel = new JButton(this.findBugs.getResource("chv_dialog.button.cancel.text"));
        button_cancel.setToolTipText(this.findBugs.getResource("chv_dialog.button.cancel.tooltiptext"));
        this.resetDefaultButton();
        button_cancel.setMnemonic(button_cancel.getText().charAt(0));
        ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GovCHV_JDialog.this.closeDialog(2);
            }
        };
        button_cancel.addActionListener(cancelAction);
        this.getRootPane().registerKeyboardAction(cancelAction, "Cancel Command", KeyStroke.getKeyStroke(27, 0, false), 2);
        this.button_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GovCHV_JDialog.this.closeDialog(0);
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)this.button_ok, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        p.add((Component)button_cancel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        return p;
    }

    private void initComponents() {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout(10, 10));
        content.add((Component)this.buildCenterPanel(), "Center");
        content.add((Component)this.buildControlPanel(), "South");
        OCFCertificateInfo.Usage usage = this.findBugs.getConfiguration().getOCFCertificateInfo().getUsage();
        String title = this.findBugs.getResource("chv_dialog." + usage.name + "." + this.findBugs.getConfiguration().getMode() + ".title");
        this.setTitle(title);
    }

    private void closeDialog(int _result) {
        this.findBugs.setResult(_result);
        this.verifyInputs(this.findBugs.getResult() == 0);
        this.setVisible(false);
        this.dispose();
    }

    private boolean verifyInputs(boolean _okPressed) {
        Document d = this.curPINField.getDocument();
        Segment s = new Segment();
        if ((this.findBugs.getConfiguration().getMode() == BDialogMode.CARD_CHANGE || this.findBugs.getConfiguration().getMode() == BDialogMode.FILE_CHANGE) && d.getLength() == 0) {
            s.array = new char[6];
            s.count = 6;
        }
        if (s.count == 0) {
            try {
                d.getText(0, d.getLength(), s);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        char[] pin = new char[_okPressed ? s.count : 0];
        System.arraycopy(s.array, s.offset, pin, 0, pin.length);
        this.findBugs.setPINVariable(pin);
        Arrays.fill(pin, 0, pin.length, '\u0000');
        Arrays.fill(s.array, s.offset, s.count, this.curPINField.getEchoChar());
        if (this.findBugs.getConfiguration().getMode() == BDialogMode.CARD_CHANGE || this.findBugs.getConfiguration().getMode() == BDialogMode.CARD_INIT_2 || this.findBugs.getConfiguration().getMode() == BDialogMode.CARD_INIT_3 || this.findBugs.getConfiguration().getMode() == BDialogMode.FILE_CHANGE) {
            d = this.newPINField.getDocument();
            s = new Segment();
            try {
                d.getText(0, d.getLength(), s);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            pin = new char[_okPressed ? s.count : 0];
            System.arraycopy(s.array, s.offset, pin, 0, pin.length);
            this.findBugs.setNewPINVariable(pin);
            Arrays.fill(pin, 0, pin.length, '\u0000');
            Arrays.fill(s.array, s.offset, s.count, this.newPINField.getEchoChar());
            d = this.newPINRepeatField.getDocument();
            s = new Segment();
            try {
                d.getText(0, d.getLength(), s);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            Arrays.fill(s.array, s.offset, s.count, this.newPINRepeatField.getEchoChar());
        }
        return true;
    }

    public Component getFirstFocus() {
        return this.firstFocus;
    }

    @Override
    public void close(int option) {
        this.closeDialog(option);
    }

    private class OKEnabler
    implements DocumentListener {
        public static final String KEY_MIN_LENGTH = "minLength";
        public static final String KEY_MAX_LENGTH = "maxLength";
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.check(null);
        }

        private OKEnabler() {
        }

        @Override
        public void changedUpdate(DocumentEvent _e) {
        }

        @Override
        public void insertUpdate(DocumentEvent _e) {
            this.check(_e);
        }

        @Override
        public void removeUpdate(DocumentEvent _e) {
            this.check(_e);
        }

        private void check(DocumentEvent _e) {
            int curLength = GovCHV_JDialog.this.curPINField.getDocument().getLength();
            boolean okEnabled = curLength >= (Integer)GovCHV_JDialog.this.curPINField.getClientProperty(KEY_MIN_LENGTH) && curLength <= (Integer)GovCHV_JDialog.this.curPINField.getClientProperty(KEY_MAX_LENGTH);
            boolean wrongRepeat = false;
            if (okEnabled && GovCHV_JDialog.this.newPINField != null) {
                Document d1 = GovCHV_JDialog.this.newPINField.getDocument();
                Segment s1 = new Segment();
                try {
                    d1.getText(0, d1.getLength(), s1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                Document d2 = GovCHV_JDialog.this.newPINRepeatField.getDocument();
                Segment s2 = new Segment();
                try {
                    d2.getText(0, d2.getLength(), s2);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                okEnabled = s1.count == s2.count && s1.count >= (Integer)GovCHV_JDialog.this.newPINField.getClientProperty(KEY_MIN_LENGTH) && s1.count <= (Integer)GovCHV_JDialog.this.newPINField.getClientProperty(KEY_MAX_LENGTH);
                char c1 = s1.first();
                char c2 = s2.first();
                while (okEnabled && c1 != '\uffff') {
                    boolean bl = okEnabled = c1 == c2;
                    if (!okEnabled) {
                        wrongRepeat = true;
                    }
                    c1 = s1.next();
                    c2 = s2.next();
                }
            }
            if (okEnabled != GovCHV_JDialog.this.button_ok.isEnabled() && this.isEnabled()) {
                GovCHV_JDialog.this.button_ok.setEnabled(okEnabled);
            }
            if (_e != null) {
                JPasswordField p = null;
                Document d = _e.getDocument();
                if (GovCHV_JDialog.this.curPINField.getDocument() == d) {
                    p = GovCHV_JDialog.this.curPINField;
                } else if (GovCHV_JDialog.this.newPINField.getDocument() == d) {
                    p = GovCHV_JDialog.this.newPINField;
                } else if (GovCHV_JDialog.this.newPINRepeatField.getDocument() == d) {
                    p = GovCHV_JDialog.this.newPINRepeatField;
                }
                if (p != null) {
                    int min = (Integer)p.getClientProperty(KEY_MIN_LENGTH);
                    int max = (Integer)p.getClientProperty(KEY_MAX_LENGTH);
                    if (!wrongRepeat || p != GovCHV_JDialog.this.newPINRepeatField) {
                        PinGUIUtil.replaceTooltipText(p, min, max, false);
                    } else {
                        PinGUIUtil.replaceTooltipText(GovCHV_JDialog.this.newPINRepeatField, min, max, true);
                    }
                }
            }
        }
    }

    private class OKButtonEnabler
    extends FocusAdapter {
        private OKButtonEnabler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            GovCHV_JDialog.this.resetDefaultButton();
        }

        @Override
        public void focusLost(FocusEvent e) {
            GovCHV_JDialog.this.resetDefaultButton();
        }
    }

    private static class SelectAllOnFocuser
    extends FocusAdapter {
        private SelectAllOnFocuser() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JTextComponent) {
                JTextComponent tc = (JTextComponent)e.getSource();
                tc.selectAll();
            }
        }
    }
}

