/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui;

import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.common.dialog.BTerminalDialog;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.StringUtil;
import de.bos_bremen.common.swing.MultiLineToolTipUI;
import de.bos_bremen.common.swing.SwingUtil;
import de.bos_bremen.gov2.jca_provider.ocf.CardTerminalManager;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.EnhancedGovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVConfiguration;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.FindBugsRequiredInterface;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.GovCHV_JDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.RemoveCardListener;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.ScrollBarObserver;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.SwingCVProcessor;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.LocalFocusListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import opencard.core.event.CTListener;
import opencard.core.service.CHVDialog;
import opencard.core.service.SmartCard;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultGovCHVDialog
implements GovCHVDialog,
CHVDialog,
EnhancedGovCHVDialog {
    private CTListener listener = null;
    private static final String WARNING_PANEL_NAME = "warning panel";
    private static final Log log = LogFactory.getLog(DefaultGovCHVDialog.class);
    private ResourceBundle resources = null;
    private GovCHVConfiguration configuration = null;
    private char[] pin = null;
    private char[] newpin = null;
    private int result = 2;
    private Dialog parentDialog = null;
    private Frame parentFrame = null;
    private final SwingCVProcessor cvProcessor = null;
    private JPasswordField pseudoDisplay = null;

    public DefaultGovCHVDialog() {
        this.loadTextProperties();
    }

    @Override
    public void setParentWindow(Object _parentWindow) {
        this.parentDialog = null;
        this.parentFrame = null;
        if (_parentWindow == null) {
            return;
        }
        if (_parentWindow instanceof Dialog) {
            this.parentDialog = (Dialog)_parentWindow;
        } else if (_parentWindow instanceof Frame) {
            this.parentFrame = (Frame)_parentWindow;
        }
    }

    @Override
    public void setConfiguration(GovCHVConfiguration _configuration) {
        this.configuration = _configuration;
    }

    public GovCHVConfiguration getConfiguration() {
        return this.configuration;
    }

    void setPINVariable(char[] _pin) {
        if (_pin.length == 0) {
            if (this.pin != null) {
                for (int i = 0; i < this.pin.length; ++i) {
                    this.pin[i] = '\u0000';
                }
            }
            this.pin = null;
            return;
        }
        char[] newPIN = new char[_pin.length];
        System.arraycopy(_pin, 0, newPIN, 0, _pin.length);
        this.pin = newPIN;
    }

    char[] getPINVariable() {
        return this.pin;
    }

    void setNewPINVariable(char[] _newpin) {
        if (_newpin.length == 0) {
            if (this.newpin != null) {
                for (int i = 0; i < this.newpin.length; ++i) {
                    this.newpin[i] = '\u0000';
                }
            }
            this.newpin = null;
            return;
        }
        char[] newNewPIN = new char[_newpin.length];
        System.arraycopy(_newpin, 0, newNewPIN, 0, _newpin.length);
        this.newpin = newNewPIN;
    }

    char[] getNewPINVariable() {
        return this.newpin;
    }

    private JComponent createTitlePanel() {
        OCFCertificateInfo.Usage usage = this.getConfiguration().getOCFCertificateInfo().getUsage();
        String title = this.getResource("chv_dialog." + usage.name + "." + this.getConfiguration().getMode() + ".title.class3");
        JLabel l = new JLabel(title);
        l.setHorizontalTextPosition(0);
        l.setVerticalTextPosition(0);
        l.setHorizontalAlignment(0);
        l.setVerticalAlignment(0);
        return l;
    }

    private JComponent buildInfoPanel(OCFCertificateInfo.Usage _usage) {
        JPanel certificatePanel = null;
        JComponent certificateInfo = null;
        try {
            SwingCVProcessor processor = new SwingCVProcessor((FlatCertificate)Certificate.forX509((X509Certificate)this.getConfiguration().getCertificate()), false, false, null, null);
            certificateInfo = processor.getView();
            processor.run();
        }
        catch (Exception processor) {
            // empty catch block
        }
        Insets insets5 = new Insets(5, 5, 5, 5);
        String toolTip = "";
        if (certificateInfo != null || this.getConfiguration().getTerminalName() != null || this.getConfiguration().getRetryCount() != -1) {
            int minLength;
            certificatePanel = new JPanel(new GridBagLayout());
            String title = this.getResource((String)(certificateInfo != null ? "chv_dialog.border.certificate.title" : "chv_dialog.border." + _usage.name + ".title"));
            boolean showRetries = true;
            if (this.configuration.getMode() == BDialogMode.EID_CAN) {
                title = "eID-CAN";
                showRetries = false;
            } else if (this.configuration.getMode() == BDialogMode.EID_PUK) {
                title = "eID-PUK";
                showRetries = false;
            } else if (this.configuration.getMode() == BDialogMode.RFID_CAN) {
                showRetries = false;
            }
            certificatePanel.setBorder(new TitledBorder(null, title, 1, 2));
            int gridy2 = 0;
            if (certificateInfo != null) {
                JScrollPane scroller = new JScrollPane(22, 30);
                scroller.getViewport().setBackground(Color.WHITE);
                certificateInfo.addComponentListener(new ScrollBarObserver(scroller));
                scroller.setViewportView(certificateInfo);
                certificatePanel.add((Component)scroller, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 1.0, 11, 1, insets5, 0, 0));
            }
            if (certificateInfo != null && this.getConfiguration().getTerminalName() != null) {
                Object resourceKey = "chv_dialog.";
                resourceKey = this.getConfiguration().getMode() == BDialogMode.FILE_VERIFY || this.getConfiguration().getMode() == BDialogMode.FILE_CHANGE ? (String)resourceKey + "filepath_info" : (String)resourceKey + "terminal_info";
                resourceKey = (String)resourceKey + ".label";
                String terminalName = this.getResource((String)resourceKey);
                terminalName = terminalName.replaceFirst("SOURCE", this.getConfiguration().getTerminalName());
                JLabel l = new JLabel(terminalName);
                l.getAccessibleContext().setAccessibleName(terminalName);
                l.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(l));
                certificatePanel.add((Component)l, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
            }
            if (this.getConfiguration().getRetryCount() != -1 && showRetries) {
                String prompt2 = this.getResource("chv_dialog." + _usage.name + ".retrycount.label");
                prompt2 = prompt2.replaceFirst("RETRYCOUNT", String.valueOf(this.getConfiguration().getRetryCount()));
                JLabel l = new JLabel(prompt2);
                l.getAccessibleContext().setAccessibleName(prompt2);
                l.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(l));
                certificatePanel.add((Component)l, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
            }
            if ((minLength = this.configuration.getMinLength()) == 0) {
                minLength = 4;
            }
            Integer minInitLength = this.configuration.getMinLengthInit();
            int maxLength = this.configuration.getMaxLength();
            if (maxLength == 0) {
                maxLength = 20;
            }
            Integer maxInitLength = this.configuration.getMaxLengthInit();
            maxLength = Math.max(maxLength, minLength);
            Object key = "";
            if (minLength > 0 || maxLength > 0) {
                JLabel l;
                String password = "PIN";
                String s = null;
                if (this.configuration.getMode() == BDialogMode.EID_CAN || this.configuration.getMode() == BDialogMode.RFID_CAN) {
                    password = this.getResource("password.can");
                } else if (this.configuration.getMode() == BDialogMode.EID_PUK) {
                    password = this.getResource("password.puk");
                } else if (this.configuration.getMode() == BDialogMode.EID_INIT) {
                    password = this.getResource("password.transport");
                }
                String prompt3 = "";
                Object[] pinLengthInfos = new Object[]{};
                if ((this.configuration.getMode() == BDialogMode.CARD_INIT_2 || this.configuration.getMode() == BDialogMode.CARD_INIT_3) && minInitLength != null) {
                    s = prompt3 = this.getResource("passwordLengthInfoMore");
                    key = "passwordLengthDifferent";
                    OCFCertificateInfo certInfo = this.configuration.getOCFCertificateInfo();
                    if (minInitLength > 0 && maxInitLength > 0 && minInitLength == maxInitLength) {
                        key = (String)key + "Exact";
                        pinLengthInfos = new Object[]{minInitLength};
                    } else if (minInitLength > 0 && maxInitLength <= 0) {
                        key = (String)key + "From";
                        pinLengthInfos = new Object[]{minInitLength};
                    } else if (minInitLength <= 0 && maxInitLength > 0) {
                        key = (String)key + "To";
                        pinLengthInfos = new Object[]{maxInitLength};
                    } else if (minInitLength > 0 && maxInitLength > 0) {
                        key = (String)key + "FromTo";
                        pinLengthInfos = new Object[]{minInitLength, maxInitLength};
                    }
                    if (certInfo.getCard().getCardService().usesNullPin(certInfo)) {
                        pinLengthInfos = new Object[]{};
                    }
                    if (minLength > 0 && maxLength > 0 && minLength == maxLength) {
                        key = (String)key + "Exact";
                        pinLengthInfos = ArrayUtil.combine(pinLengthInfos, {minLength});
                    } else if (minLength > 0 && maxLength <= 0) {
                        key = (String)key + "From";
                        pinLengthInfos = ArrayUtil.combine(pinLengthInfos, {minLength});
                    } else if (minLength <= 0 && maxLength > 0) {
                        key = (String)key + "To";
                        pinLengthInfos = ArrayUtil.combine(pinLengthInfos, {maxLength});
                    } else if (minLength > 0 && maxLength > 0) {
                        key = (String)key + "FromTo";
                        pinLengthInfos = ArrayUtil.combine(pinLengthInfos, {minLength, maxLength});
                    }
                    if (certInfo.getCard().getCardService().usesNullPin(certInfo)) {
                        key = (String)key + ".fixed";
                    }
                } else {
                    if (this.configuration.getMode() == BDialogMode.CARD_VERIFY || this.configuration.getMode() == BDialogMode.EID_CAN || this.configuration.getMode() == BDialogMode.EID_PUK || this.configuration.getMode() == BDialogMode.EID_INIT || this.configuration.getMode() == BDialogMode.RFID_CAN) {
                        key = "One";
                        s = StringUtil.format(this.getResource("passwordLengthInfo" + (String)key), password);
                    } else {
                        key = "More";
                        password = null;
                        s = this.getResource("passwordLengthInfo" + (String)key);
                    }
                    prompt3 = s;
                    if (this.configuration.getMode() == BDialogMode.EID_INIT) {
                        if (this.configuration.getMinLengthInit() != null) {
                            minLength = this.configuration.getMinLengthInit();
                        }
                        if (this.configuration.getMaxLengthInit() != null) {
                            maxLength = this.configuration.getMaxLengthInit();
                        }
                    }
                    if (minLength > 1 && maxLength <= 0) {
                        pinLengthInfos = password != null ? new Object[]{password, minLength} : new Object[]{minLength};
                        key = "passwordLengthFrom" + (String)key;
                    } else if (minLength <= 0 && maxLength > 1) {
                        pinLengthInfos = password != null ? new Object[]{password, maxLength} : new Object[]{maxLength};
                        key = "passwordLengthTo" + (String)key;
                    } else if (minLength > 1 && maxLength > 1 && minLength != maxLength) {
                        pinLengthInfos = password != null ? new Object[]{password, minLength, maxLength} : new Object[]{minLength, maxLength};
                        key = "passwordLengthFromTo" + (String)key;
                    } else if (minLength > 1 && maxLength > 1 && minLength == maxLength) {
                        pinLengthInfos = password != null ? new Object[]{password, minLength} : new Object[]{minLength};
                        key = "passwordLengthExact" + (String)key;
                    }
                }
                if (this.getConfiguration().getMode() == BDialogMode.EID_CAN) {
                    l = new JLabel(this.getResource("chv_dialog.eid." + this.configuration.getOCFCertificateInfo().getUsage().name + ".pin.info"));
                    l.getAccessibleContext().setAccessibleName(l.getText());
                    l.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(l));
                    certificatePanel.add((Component)l, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
                } else if (this.getConfiguration().getMode() == BDialogMode.EID_PUK) {
                    l = new JLabel(this.getResource("chv_dialog.eid.eid_puk.pin.info"));
                    l.getAccessibleContext().setAccessibleName(l.getText());
                    l.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(l));
                    certificatePanel.add((Component)l, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
                } else if (this.getConfiguration().getMode() == BDialogMode.EID_INIT) {
                    l = new JLabel(this.getResource("chv_dialog.eid.eid_pin.pin.info"));
                    l.getAccessibleContext().setAccessibleName(l.getText());
                    l.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(l));
                    certificatePanel.add((Component)l, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
                } else if (this.getConfiguration().getMode() == BDialogMode.RFID_CAN) {
                    l = new JLabel(this.getResource("chv_dialog.rfid.rfid_can.info"));
                    l.getAccessibleContext().setAccessibleName(l.getText());
                    l.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(l));
                    certificatePanel.add((Component)l, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
                }
                l = new JLabel(prompt3);
                l.getAccessibleContext().setAccessibleName(l.getText());
                l.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(l));
                certificatePanel.add((Component)l, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
                String info = StringUtil.format(this.getResource((String)key), pinLengthInfos);
                l = new JLabel(info);
                l.getAccessibleContext().setAccessibleDescription(l.getText());
                l.getAccessibleContext().setAccessibleName(l.getText());
                l.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(l));
                certificatePanel.add((Component)l, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
            }
        }
        certificatePanel.setFocusable(true);
        certificatePanel.addFocusListener(new LocalFocusListener(certificatePanel));
        return certificatePanel;
    }

    private JComponent createWarningPanel(int msgID) {
        boolean initMode;
        if (msgID < 0 || msgID > 2) {
            throw new IllegalArgumentException("msgID must be in range [0..2]");
        }
        Insets insets5 = new Insets(5, 5, 5, 5);
        JPanel pinPanel = new JPanel(new GridBagLayout());
        pinPanel.setName(WARNING_PANEL_NAME);
        int gridy2 = 0;
        boolean changeMode = this.getConfiguration().getMode() == BDialogMode.CARD_CHANGE || this.getConfiguration().getMode() == BDialogMode.FILE_CHANGE;
        boolean bl = initMode = this.getConfiguration().getMode() == BDialogMode.CARD_INIT_2 || this.getConfiguration().getMode() == BDialogMode.CARD_INIT_3 || this.getConfiguration().getMode() == BDialogMode.FILE_INIT;
        String initKey = !initMode ? "" : (this.getConfiguration().getMode() == BDialogMode.CARD_INIT_2 ? "init2" : "init3");
        OCFCertificateInfo.Usage usage = this.getConfiguration().getOCFCertificateInfo().getUsage();
        if (this.getConfiguration().doesShowPseudoDisplay()) {
            int maxLength;
            String propertyKeyPartMode = initMode || changeMode ? (changeMode && msgID == 0 ? "old_" : "new_") : "";
            pinPanel.setBorder(new TitledBorder(null, this.getResource("chv_dialog.border." + propertyKeyPartMode + "pin.title"), 1, 2));
            propertyKeyPartMode = initMode || changeMode ? (msgID == 0 ? (initMode ? initKey + "_" : "old_") : (msgID == 1 ? "new_" : "repeat_new_")) : "";
            String prompt3 = this.getResource("chv_dialog." + usage.name + "." + propertyKeyPartMode + "pin.label");
            JLabel pinLabel = new JLabel(prompt3);
            pinPanel.add((Component)pinLabel, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
            this.pseudoDisplay = new JPasswordField();
            this.pseudoDisplay.setName("pseudodisplay");
            this.pseudoDisplay.setEditable(false);
            this.pseudoDisplay.setFocusable(false);
            int minLength = this.getConfiguration().getMinLength();
            if (minLength == 0) {
                minLength = 4;
            }
            if ((maxLength = this.getConfiguration().getMaxLength()) == 0) {
                maxLength = 20;
            }
            maxLength = Math.max(maxLength, minLength);
            this.pseudoDisplay.setColumns(maxLength);
            pinPanel.add((Component)this.pseudoDisplay, new GridBagConstraints(0, gridy2, 1, 1, 1.0, 0.0, 18, 0, insets5, 0, 0));
            this.addAdditionalMessage(insets5, pinPanel, ++gridy2);
        } else {
            pinPanel.setBorder(new TitledBorder(null, this.getResource((String)(usage.name == "eid" || usage.name == "eid_can" || usage.name == "eid_puk" || usage.name == "eid_can_not_forced" || usage.name == "esign" || usage.name == "rfid" ? "chv_dialog.border." + usage.name + ".title" : "chv_dialog.border.pin.title")), 1, 2));
            String resource = changeMode ? "chv_dialog.class2_3_info.change" : (initMode ? "chv_dialog.class2_3_info." + initKey : (usage.name == "eid_can" || usage.name == "eid_puk" || usage.name == "eid_can_not_forced" || usage.name == "esign" || usage.name == "rfid" ? "chv_dialog.class2_3_info." + usage.name : "chv_dialog.class2_3_info.verify"));
            String labelString = this.getResource(resource + ".label");
            String readableString = this.getResource(resource + ".readable");
            JLabel l = new JLabel(labelString);
            l.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(l));
            l.getAccessibleContext().setAccessibleName(l.getText());
            l.setBorder(new EmptyBorder(5, 5, 5, 5));
            l.setHorizontalAlignment(0);
            l.setVerticalAlignment(0);
            pinPanel.add((Component)l, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 11, 2, insets5, 0, 0));
            pinPanel.setFocusable(true);
            pinPanel.setToolTipText(readableString);
            pinPanel.addFocusListener(new LocalFocusListener(pinPanel));
            this.addAdditionalMessage(insets5, pinPanel, gridy2);
        }
        return pinPanel;
    }

    private void addAdditionalMessage(Insets insets5, JPanel pinPanel, int gridy2) {
        OCFCertificateInfo info = this.configuration.getOCFCertificateInfo();
        String additionalMessage = info.getAdditionalMessage();
        if (additionalMessage != null && !additionalMessage.isEmpty()) {
            info.setAdditionalMessage(null);
            if ("maximum count of signatures reached: for further signatures PIN must be entered again!".equals(additionalMessage)) {
                additionalMessage = "Die maximale Anzahl von Signaturen wurde erreicht.<br/>Bitte PIN f\u00fcr weitere Signaturen erneut eingeben!";
            }
            JLabel am = new JLabel("<html><font color='#a00000'><b>" + additionalMessage + "</b></font></html>");
            am.addFocusListener(DefaultGovCHVDialog.createFocusListenerFor(am));
            am.getAccessibleContext().setAccessibleName(additionalMessage);
            am.setBorder(new EmptyBorder(5, 5, 5, 5));
            am.setHorizontalAlignment(0);
            am.setVerticalAlignment(0);
            pinPanel.add((Component)am, new GridBagConstraints(0, gridy2++, 1, 1, 1.0, 0.0, 18, 2, insets5, 0, 0));
        }
    }

    private static FocusListener createFocusListenerFor(final JLabel label) {
        label.setFocusable(true);
        final EmptyBorder emptyBorder = new EmptyBorder(1, 1, 1, 1);
        final MatteBorder focusedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.DARK_GRAY);
        label.setBorder(emptyBorder);
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                label.setBorder(focusedBorder);
            }

            @Override
            public void focusLost(FocusEvent e) {
                label.setBorder(emptyBorder);
            }
        };
    }

    @Override
    public Object showReaderMessage() {
        MultiLineToolTipUI.install();
        JDialog d = this.parentDialog != null ? new JDialog(this.parentDialog) : new JDialog(this.parentFrame);
        Container contentPane = d.getContentPane();
        contentPane.setLayout(new BorderLayout());
        if (contentPane instanceof JComponent) {
            JComponent c = (JComponent)contentPane;
            c.setBorder(new BevelBorder(0));
        }
        contentPane.add((Component)this.createTitlePanel(), "North");
        OCFCertificateInfo.Usage usage = this.getConfiguration().getOCFCertificateInfo().getUsage();
        JComponent certificatePanel = this.buildInfoPanel(usage);
        if (certificatePanel != null) {
            certificatePanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            contentPane.add((Component)certificatePanel, "Center");
        }
        int msgID = this.getConfiguration().getMode() == BDialogMode.CARD_INIT_2 || this.getConfiguration().getMode() == BDialogMode.FILE_INIT ? 1 : 0;
        contentPane.add((Component)this.createWarningPanel(msgID), "South");
        d.pack();
        d.setLocationRelativeTo(d.getParent());
        d.setAlwaysOnTop(true);
        d.setVisible(true);
        SwingUtil.update(d);
        WindowCloser wc = new WindowCloser(d);
        this.listener = new RemoveCardListener(this, d, this.configuration.getTerminalName());
        return wc;
    }

    @Override
    public void displayMessage(final Object wcTemp, final int msgID) throws IllegalArgumentException {
        if (wcTemp == null || !(wcTemp instanceof WindowCloser)) {
            throw new IllegalArgumentException("wcTemp must be instance of WindowCloser");
        }
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowCloser wc = (WindowCloser)wcTemp;
                Container contentPane = null;
                if (JWindow.class.isInstance(wc.target)) {
                    JWindow w = (JWindow)wc.target;
                    contentPane = w.getContentPane();
                }
                if (JDialog.class.isInstance(wc.target)) {
                    JDialog d = (JDialog)wc.target;
                    contentPane = d.getContentPane();
                }
                for (Component c : contentPane.getComponents()) {
                    if (c.getName() == null || !c.getName().equals(DefaultGovCHVDialog.WARNING_PANEL_NAME)) continue;
                    contentPane.remove(c);
                    break;
                }
                contentPane.add((Component)DefaultGovCHVDialog.this.createWarningPanel(msgID), "South");
                contentPane.validate();
            }
        });
    }

    @Override
    public void pseudoDisplay(final int length) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DefaultGovCHVDialog.this.pseudoDisplay == null) {
                    return;
                }
                char[] display = new char[length];
                Arrays.fill(display, '#');
                DefaultGovCHVDialog.this.pseudoDisplay.setText(new String(display));
            }
        });
    }

    @Override
    public void hideReaderMessage(Object monitor) {
        MultiLineToolTipUI.uninstall();
        if (!(monitor instanceof WindowCloser)) {
            return;
        }
        ((WindowCloser)monitor).shutdown();
    }

    private final void loadTextProperties() {
        if (this.resources != null) {
            return;
        }
        this.resources = ResourceBundle.getBundle(this.getClass().getName());
    }

    String getResource(String _key) {
        try {
            return this.resources.getString(_key);
        }
        catch (MissingResourceException mre) {
            return "";
        }
    }

    @Override
    public void show() {
        GovCHV_JDialog view = null;
        FindBugsRequiredImpl fbi = new FindBugsRequiredImpl();
        fbi.target = this;
        view = this.parentDialog != null ? new GovCHV_JDialog(this.parentDialog, (FindBugsRequiredInterface)fbi) : new GovCHV_JDialog(this.parentFrame, (FindBugsRequiredInterface)fbi);
        final GovCHV_JDialog fview = view;
        view.setAlwaysOnTop(true);
        if (view.getFirstFocus() != null) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object o;
                        Object object = o = new Object();
                        synchronized (object) {
                            while (!fview.isVisible()) {
                                o.wait(500L);
                            }
                        }
                    }
                    catch (InterruptedException o) {
                        // empty catch block
                    }
                    Component c = fview.getFirstFocus();
                    if (JComponent.class.isInstance(c)) {
                        ((JComponent)c).grabFocus();
                    } else {
                        c.requestFocus();
                    }
                }
            }).start();
        }
        this.listener = new RemoveCardListener(this, view, this.configuration.getTerminalName());
        view.setVisible(true);
        if (SmartCard.isStarted()) {
            CardTerminalManager.getInstance(null, null, null).removeListener(this.listener);
        }
    }

    void setResult(int _result) {
        this.result = _result;
    }

    @Override
    public int getResult() {
        return this.result;
    }

    @Override
    public String getPrompt(OCFCertificateInfo.Usage usage, BTerminalDialog.Type type) {
        return this.getResource("chv_dialog." + usage.name + "." + type.getName() + "pin.prompt");
    }

    @Override
    @Deprecated
    public String getPinPrompt(int type) {
        return this.getPinPrompt(OCFCertificateInfo.convert(type));
    }

    @Override
    @Deprecated
    public String getPinPrompt(boolean[] keyUsage) {
        return this.getPrompt(OCFCertificateInfo.Usage.forKU(keyUsage), BTerminalDialog.Type.CUR_PIN);
    }

    @Override
    @Deprecated
    public String getOldPinPrompt(int type) {
        return this.getOldPinPrompt(OCFCertificateInfo.convert(type));
    }

    @Override
    @Deprecated
    public String getOldPinPrompt(boolean[] _keyUsage) {
        return this.getPrompt(OCFCertificateInfo.Usage.forKU(_keyUsage), BTerminalDialog.Type.OLD_PIN);
    }

    @Override
    @Deprecated
    public String getNewPinPrompt(int _type) {
        return this.getNewPinPrompt(OCFCertificateInfo.convert(_type));
    }

    @Override
    @Deprecated
    public String getNewPinPrompt(boolean[] keyUsage) {
        return this.getPrompt(OCFCertificateInfo.Usage.forKU(keyUsage), BTerminalDialog.Type.NEW_PIN);
    }

    @Override
    public char[] getPIN() {
        if (this.pin == null) {
            return "#cancelled#".toCharArray();
        }
        char[] result = new char[this.pin.length];
        System.arraycopy(this.pin, 0, result, 0, this.pin.length);
        return result;
    }

    @Override
    public char[] getNewPIN() {
        if (this.getConfiguration().getMode() == BDialogMode.CARD_CHANGE || this.getConfiguration().getMode() == BDialogMode.CARD_INIT_2 || this.getConfiguration().getMode() == BDialogMode.CARD_INIT_3 || this.getConfiguration().getMode() == BDialogMode.FILE_CHANGE) {
            if (this.newpin == null) {
                return "#cancelled#".toCharArray();
            }
            char[] result = new char[this.newpin.length];
            System.arraycopy(this.newpin, 0, result, 0, this.newpin.length);
            return result;
        }
        return null;
    }

    @Override
    public char[] getCHV(int pinNo) {
        this.show();
        return this.getPIN();
    }

    @Deprecated
    public static String getUsage(boolean[] ku) {
        return OCFCertificateInfo.Usage.forKU((boolean[])ku).name;
    }

    @Override
    public BDialogMode getMode() {
        return this.configuration.getMode();
    }

    static class WindowCloser
    extends Thread {
        private static final Log log = LogFactory.getLog(WindowCloser.class);
        private Window target = null;
        private Object monitor = null;
        private boolean running = false;

        public WindowCloser(Window target) {
            this.target = target;
            this.running = true;
            this.monitor = new Object();
        }

        public void shutdown() {
            this.hideWindow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this.monitor;
                synchronized (object) {
                    while (this.running) {
                        try {
                            this.monitor.wait(new SecureRandom().nextBoolean() ? 100L : Long.MAX_VALUE);
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            log.debug((Object)ex);
                            this.running = false;
                        }
                    }
                }
            }
            catch (Throwable ex) {
                log.debug((Object)ex);
            }
            finally {
                this.hideWindow();
            }
        }

        public void hideWindow() {
            SwingUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    target.setVisible(false);
                    target.dispose();
                }
            });
        }
    }

    private static class FindBugsRequiredImpl
    implements FindBugsRequiredInterface {
        private DefaultGovCHVDialog target = null;

        private FindBugsRequiredImpl() {
        }

        @Override
        public String getResource(String _key) {
            return this.target.getResource(_key);
        }

        @Override
        public JComponent buildInfoPanel(OCFCertificateInfo.Usage _usage) {
            return this.target.buildInfoPanel(_usage);
        }

        @Override
        public GovCHVConfiguration getConfiguration() {
            return this.target.getConfiguration();
        }

        @Override
        public void setPINVariable(char[] _pin) {
            this.target.setPINVariable(_pin);
        }

        @Override
        public void setNewPINVariable(char[] _pin) {
            this.target.setNewPINVariable(_pin);
        }

        @Override
        public char[] getNewPINVariable() {
            return this.target.getNewPINVariable();
        }

        @Override
        public void setResult(int _result) {
            this.target.setResult(_result);
        }

        @Override
        public int getResult() {
            return this.target.getResult();
        }
    }
}

