/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class CapsLockIcon
implements Icon {
    private static final Shape CAPSLOCK;
    private static final int SIZE = 13;
    protected static final Color RED;
    protected static final Color HRED;
    private final JLabel capsLockInfo;
    private boolean capsLocked = false;

    public CapsLockIcon(JLabel _capsLockInfo, JTextComponent _text) {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (KeyEvent.class.isInstance(event)) {
                    KeyEvent _e = (KeyEvent)event;
                    if (_e.getKeyCode() != 20) {
                        return;
                    }
                    CapsLockIcon.this.capsChanged();
                }
            }
        }, 8L);
        this.capsLockInfo = _capsLockInfo;
        this.capsLockInfo.setForeground(RED);
        this.capsChanged();
        this.capsLockInfo.setVisible(true);
    }

    private void capsChanged() {
        this.capsLocked = false;
        try {
            this.capsLocked = Toolkit.getDefaultToolkit().getLockingKeyState(20);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.capsLockInfo.paintImmediately(0, 0, 13, 13);
    }

    @Override
    public int getIconHeight() {
        return 13;
    }

    @Override
    public int getIconWidth() {
        return 13;
    }

    @Override
    public void paintIcon(Component _c, Graphics _g, int _x, int _y) {
        Graphics2D g = (Graphics2D)_g;
        if (this.capsLocked) {
            g.setColor(RED);
        } else {
            g.setColor(HRED);
        }
        Object old = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (old != RenderingHints.VALUE_ANTIALIAS_ON) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.draw(CAPSLOCK);
        if (old != g.getRenderingHint(RenderingHints.KEY_ANTIALIASING)) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
        }
    }

    static {
        GeneralPath p = new GeneralPath();
        p.moveTo(0.25f, 0.0f);
        p.lineTo(0.75f, 0.0f);
        p.lineTo(0.75f, 0.5f);
        p.lineTo(1.0f, 0.5f);
        p.lineTo(0.5f, 1.0f);
        p.lineTo(0.0f, 0.5f);
        p.lineTo(0.25f, 0.5f);
        p.closePath();
        CAPSLOCK = p.createTransformedShape(AffineTransform.getScaleInstance(12.0, 12.0));
        RED = new Color(192, 0, 0, 255);
        HRED = new Color(192, 0, 0, 0);
    }
}

