/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.debug;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.common.pin.coding.impl.PinEncoderFactory;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.CharUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.ListUtil;
import de.bos_bremen.common.StringUtil;
import de.bos_bremen.common.ThreadUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.common.io.FileUtil;
import de.bos_bremen.common.system.SystemPropertyUtil;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.SecureCard;
import de.bos_bremen.gov2.jca_provider.ocf.WrongConfirmedNewPinException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.CardChannelMock;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.CardMock;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.MockableCardChannel;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.PropertyConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.PropertyDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.SEX509Certificate;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PaceInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.swing.JDialog;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class ZCxxZeitControlBasicCardDebug
extends GovCS
implements PropertyConstants,
SecureCard {
    private static final Log LOG = LogFactory.getLog(ZCxxZeitControlBasicCardDebug.class);
    private MockableCardChannel mockableCardChannel = null;
    private static Map<String, Object> resultMap = new LinkedHashMap<String, Object>();
    private static Map<String, Throwable> throwableMap = new LinkedHashMap<String, Throwable>();
    private static CommandAPDU cmdChange = null;
    private static CardMock cardMock = null;
    private static List<String> useGovCSMethods = null;
    private static CommandAPDU cmdInit = null;
    private static CommandAPDU cmdVerify = null;
    private static boolean DEBUG = false;
    private static final String DEFAULT_CURRENT_PIN = "111111";
    private static final String DEFAULT_NEW_PIN = "222222";
    private static JDialog dialog = null;
    private static final String FALLBACK_CERTIFICATE_HEXSTRING = "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";
    private static int instanceCounter = 0;
    private static final String ISSUER = "BOS_DEBUG";
    private static final Properties settings = new Properties();
    static boolean update = true;
    private static KeyStore keyStore = null;
    private static List<String> keyStoreAliasList = null;
    private SecureCard.SecurityProtocol currentSecurityProtocol = SecureCard.SecurityProtocol.NONE;
    private String displayName = null;
    private final List<SecureCard.SecurityProtocol> supportedProtocols = Arrays.asList(SecureCard.SecurityProtocol.EAC2_PACEPLUS, SecureCard.SecurityProtocol.EAC2_TERMINAL_AUTHENTICATION, SecureCard.SecurityProtocol.EAC2_CHIP_AUTHENTICATION);
    private static CertificateReadListener listener = null;

    protected static boolean isPinpadUsableInitCaseForT50PinOfVariableLength(Properties settings) {
        return Boolean.TRUE.toString().equals(settings.getProperty("KEY_PINPAD_USABLE_FOR_INIT_OF_STRING_PIN_WITH_VARIABLE_LENGTH", "false"));
    }

    protected static boolean isPinpadUsableChangeCaseForT50PinOfVariableLength(Properties settings) {
        return Boolean.TRUE.toString().equals(settings.getProperty("KEY_PINPAD_USABLE_FOR_CHANGE_OF_STRING_PIN_WITH_VARIABLE_LENGTH", "false"));
    }

    @Override
    public boolean isPinpadUsableInitCaseForT50PinOfVariableLength() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.isPinpadUsableInitCaseForT50PinOfVariableLength();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Boolean result = ZCxxZeitControlBasicCardDebug.getMockResult(Boolean.class);
        if (result != null) {
            return result;
        }
        return ZCxxZeitControlBasicCardDebug.isPinpadUsableInitCaseForT50PinOfVariableLength(settings);
    }

    public void setCardChannelMock(CardChannelMock mockCardChannel) {
        this.mockableCardChannel.setCardChannelMock(mockCardChannel);
    }

    @Override
    public boolean isPinpadUsableChangeCaseForT50PinOfVariableLength() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.isPinpadUsableChangeCaseForT50PinOfVariableLength();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Boolean result = ZCxxZeitControlBasicCardDebug.getMockResult(Boolean.class);
        if (result != null) {
            return result;
        }
        return ZCxxZeitControlBasicCardDebug.isPinpadUsableChangeCaseForT50PinOfVariableLength(settings);
    }

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        boolean release = false;
        CardChannel cc = super.getCardChannel();
        if (cc == null) {
            super.allocateCardChannel();
            cc = super.getCardChannel();
        }
        this.mockableCardChannel = new MockableCardChannel(scheduler, cc);
        super.setCardChannel(this.mockableCardChannel);
        if (release) {
            super.releaseCardChannel();
        }
    }

    public static String[] createExpectedCommands(OCFCertificateInfo info, Properties settings) {
        String[] result = new String[3];
        cmdVerify = ZCxxZeitControlBasicCardDebug.createVerifyPasswordCommand(info, settings);
        if (Boolean.FALSE.toString().equals(settings.getProperty("KEY_INITIALIZED"))) {
            cmdVerify = null;
        }
        result[0] = cmdVerify != null ? HexUtil.hexify(cmdVerify.getBytes()) : "";
        LOG.debug((Object)("\n\n\n==============================\nverify: " + result[0]));
        cmdChange = ZCxxZeitControlBasicCardDebug.createChangePasswordCommand(settings, true);
        result[1] = cmdChange != null ? HexUtil.hexify(cmdChange.getBytes()) : "";
        LOG.debug((Object)("change: " + result[1]));
        cmdInit = ZCxxZeitControlBasicCardDebug.createChangePasswordCommand(settings, false);
        result[2] = cmdInit != null ? HexUtil.hexify(cmdInit.getBytes()) : "";
        LOG.debug((Object)("init: " + result[2]));
        return result;
    }

    public static <T> T getMockResult(Class<T> resultClass) {
        String methodName = ThreadUtil.getCallerMethodName(0);
        Object result = resultMap.get(methodName);
        if (result == null && !resultMap.containsKey(methodName)) {
            return null;
        }
        if (!resultClass.isInstance(result)) {
            LOG.debug((Object)("incompatible result for " + methodName + ": " + result + ", possible only: " + resultClass));
            return null;
        }
        return resultClass.cast(result);
    }

    public static void getMockThrowable() throws Throwable {
        String methodName = ThreadUtil.getCallerMethodName(0);
        Throwable t = throwableMap.get(methodName);
        if (t != null) {
            throw t;
        }
    }

    public static File getSettingsFile() {
        return new File(SystemPropertyUtil.getUserHome() + "/zeitControlSettings.xml");
    }

    public static void main(String[] args) throws Exception {
    }

    public static final void setDEBUG(boolean debug) {
        DEBUG = debug;
    }

    private static CommandAPDU createVerifyPasswordCommand(OCFCertificateInfo info, Properties settings) {
        try {
            char[] _pin = settings.getProperty("KEY_PIN_CURRENT", DEFAULT_CURRENT_PIN).toCharArray();
            byte[] pin = ZCxxZeitControlBasicCardDebug.getPaddedPIN(settings, _pin);
            byte[] commandBytes = new byte[4 + (pin == null ? 0 : 1 + pin.length)];
            int index = 0;
            commandBytes[index++] = 0;
            commandBytes[index++] = 32;
            commandBytes[index++] = 0;
            int n = commandBytes[index++] = info != null ? (int)info.getPinID() : -127;
            if (pin != null) {
                commandBytes[index++] = (byte)pin.length;
                System.arraycopy(pin, 0, commandBytes, index, pin.length);
            }
            return new CommandAPDU(commandBytes);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static byte[] getPaddedPIN(Properties settings, char[] _pin) {
        String name = settings.getProperty("KEY_PIN_FORMAT", "T.50 Encoding");
        PinEncoderFactory pef = PinEncoderFactory.getInstance();
        int padLength = ZCxxZeitControlBasicCardDebug.getPasswordBlockLength(settings);
        if (padLength == 0 || padLength == -1) {
            return CharUtil.convert(_pin);
        }
        byte pad = ZCxxZeitControlBasicCardDebug.getPasswordBlockFiller(settings);
        return pef.encode(name, _pin != null ? CharUtil.convert(_pin) : null, padLength, padLength > 0 ? Byte.valueOf(pad) : null);
    }

    private static byte getPasswordBlockFiller(Properties settings) {
        Object tmp = settings.getProperty("KEY_PIN_BLOCK_FILLER", "00");
        if (((String)tmp).length() % 2 == 1) {
            tmp = "0" + (String)tmp;
        }
        return HexUtil.parse((String)tmp)[0];
    }

    private static int getPasswordBlockLength(Properties settings) {
        return Integer.valueOf(settings.getProperty("KEY_PIN_BLOCK_LENGTH", "0"));
    }

    private static synchronized void resetProperties() {
        if (settings.size() == 0) {
            try {
                settings.loadFromXML(new FileInputStream(ZCxxZeitControlBasicCardDebug.getSettingsFile()));
            }
            catch (Exception e) {
                LOG.debug((Object)"reading ZC39Debug settings - loading properties failed...");
            }
        } else {
            Properties tmp = new Properties();
            try {
                tmp.loadFromXML(new FileInputStream(ZCxxZeitControlBasicCardDebug.getSettingsFile()));
            }
            catch (Exception e) {
                System.err.println("reading ZCxxDebug settings for update check - loading properties failed...");
            }
            if (tmp.getProperty("KEY_DIALOG", "false") != null && !tmp.getProperty("KEY_DIALOG", "false").equals(settings.getProperty("KEY_DIALOG", "false"))) {
                try {
                    settings.loadFromXML(new FileInputStream(ZCxxZeitControlBasicCardDebug.getSettingsFile()));
                }
                catch (Exception e) {
                    LOG.debug((Object)"updating ZCxxDebug settings - loading properties failed...");
                }
            }
        }
        ZCxxZeitControlBasicCardDebug.resetKeyStore();
        if (instanceCounter <= 1) {
            if (dialog != null && dialog.isVisible()) {
                dialog.setVisible(false);
            }
            return;
        }
        if (dialog != null && Boolean.valueOf(settings.getProperty("KEY_DIALOG", "false")).booleanValue()) {
            dialog.setVisible(true);
        } else if (dialog == null && Boolean.valueOf(settings.getProperty("KEY_DIALOG", "false")).booleanValue()) {
            dialog = new PropertyDialog((Frame)null, "ZC X.X ZeitControl BasicCard (Debug) - Settings", settings, ZCxxZeitControlBasicCardDebug.getSettingsFile());
            dialog.setVisible(true);
        } else if (dialog != null && !Boolean.valueOf(settings.getProperty("KEY_DIALOG", "false")).booleanValue()) {
            dialog.setVisible(false);
            dialog.dispose();
            dialog = null;
        }
    }

    private static void resetKeyStore() {
        File f;
        String keyStoreFile = settings.getProperty("KEY_STORE_FILE");
        String keyStoreType = settings.getProperty("KEY_STORE_TYPE");
        String keyStorePassword = settings.getProperty("KEY_STORE_PASSWORD");
        if (keyStoreAliasList != null) {
            keyStoreAliasList.clear();
        }
        keyStore = null;
        keyStoreAliasList = null;
        if (!StringUtil.isNullOrEmpty(keyStoreFile) && !StringUtil.isNullOrEmpty(keyStoreType) && !StringUtil.isNullOrEmpty(keyStorePassword) && (f = new File(keyStoreFile)).exists() && f.isFile()) {
            try {
                KeyStore ks = KeyStore.getInstance(keyStoreType, "BC");
                try (FileInputStream is = new FileInputStream(f);){
                    ks.load(is, keyStorePassword.toCharArray());
                }
                LOG.debug((Object)("loaded keystore from: " + f.getAbsolutePath()));
                keyStore = ks;
                keyStoreAliasList = Collections.list(keyStore.aliases());
            }
            catch (Throwable e) {
                LOG.debug((Object)("loading keystore failed: " + f.getAbsolutePath()));
            }
        }
    }

    protected static CommandAPDU createChangePasswordCommand(Properties settings, boolean change) {
        byte[] oldPIN;
        char[] _pin = settings.getProperty("KEY_PIN_CURRENT", DEFAULT_CURRENT_PIN).toCharArray();
        if (!change && Boolean.TRUE.toString().equals(settings.getProperty("KEY_INITIALIZED")) || change && Boolean.FALSE.toString().equals(settings.getProperty("KEY_INITIALIZED"))) {
            return null;
        }
        if (!change) {
            char[] init_pin = null;
            LOG.debug((Object)("nullPin: " + ZCxxZeitControlBasicCardDebug.usesNullPIN(settings)));
            if (ZCxxZeitControlBasicCardDebug.usesNullPIN(settings)) {
                init_pin = new char[6];
                Arrays.fill(init_pin, '\u0000');
            } else {
                try {
                    LOG.debug((Object)ZCxxZeitControlBasicCardDebug.getInitPIN(settings));
                    LOG.debug((Object)("initPin: " + HexUtil.hexify(new String(ZCxxZeitControlBasicCardDebug.getInitPIN(settings)).getBytes())));
                    init_pin = ZCxxZeitControlBasicCardDebug.getInitPIN(settings);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (!ArrayUtil.isNullOrEmpty(init_pin)) {
                _pin = init_pin;
            }
        }
        if ((oldPIN = ZCxxZeitControlBasicCardDebug.getPaddedPIN(settings, _pin)) == null) {
            oldPIN = new byte[6];
        }
        byte[] newPIN = ZCxxZeitControlBasicCardDebug.getPaddedPIN(settings, settings.getProperty("KEY_PIN_NEW", DEFAULT_NEW_PIN).toCharArray());
        byte[] commandBytes = new byte[4 + (oldPIN != null && newPIN != null ? 1 + oldPIN.length + newPIN.length : 0)];
        int index = 0;
        commandBytes[index++] = 0;
        commandBytes[index++] = 36;
        commandBytes[index++] = 0;
        commandBytes[index++] = -127;
        if (oldPIN != null && newPIN != null) {
            commandBytes[index++] = (byte)(oldPIN.length + newPIN.length);
            System.arraycopy(oldPIN, 0, commandBytes, index, oldPIN.length);
            System.arraycopy(newPIN, 0, commandBytes, index += oldPIN.length, newPIN.length);
        }
        return new CommandAPDU(commandBytes);
    }

    protected static char[] getInitPIN(Properties settings) {
        String initPIN = settings.getProperty("KEY_PIN_INIT", "null");
        if ("null".equals(initPIN)) {
            return new char[0];
        }
        try {
            byte[] initPinBytes = HexUtil.parse(initPIN);
            return ArrayUtil.isNullOrEmpty(initPinBytes) ? null : CharUtil.convert(initPinBytes);
        }
        catch (Throwable t) {
            return new char[0];
        }
    }

    protected static boolean usesNullPIN(Properties settings) {
        return Boolean.TRUE.toString().equals(settings.getProperty("KEY_USES_NULL_PIN", "false"));
    }

    public ZCxxZeitControlBasicCardDebug() {
        ++instanceCounter;
        ZCxxZeitControlBasicCardDebug.resetProperties();
    }

    public synchronized SecureCard.SecurityProtocolResult<?> allocateSecureContext(SecureCard.SecurityProtocol securityProtocol, SecureCard.SecurityProtocolParameter securityParameters) throws IllegalArgumentException, CardServiceException, CardTerminalException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.allocateSecureContext(securityProtocol, securityParameters);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (CardServiceException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        SecureCard.SecurityProtocolResult mockResult = ZCxxZeitControlBasicCardDebug.getMockResult(SecureCard.SecurityProtocolResult.class);
        if (mockResult != null) {
            return mockResult;
        }
        if (!this.supportedProtocols.contains(securityProtocol)) {
            throw new IllegalArgumentException("not supported protocol, supported protocols: " + this.supportedProtocols);
        }
        String context = "";
        switch (securityProtocol.getProtocol()) {
            case 4: {
                if (!PaceInputParameters.class.isInstance(securityParameters)) {
                    throw new IllegalArgumentException("invalid PACE parameters, expected instance of " + PaceInputParameters.class.getName());
                }
                context = "Pace";
                break;
            }
            case 1: {
                context = "TerminalAuthentication";
                break;
            }
            case 2: {
                context = "ChipAuthentication";
                break;
            }
            case 3: {
                context = "RestrictedIdentification";
                break;
            }
        }
        LOG.debug((Object)("secure context allocated (just switching security status): " + context));
        this.currentSecurityProtocol = securityProtocol;
        SecureCard.SimpleSecurityProtocolResult result = new SecureCard.SimpleSecurityProtocolResult(true);
        return result;
    }

    @Override
    public synchronized int getRetryCount(CardPin _pin) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.getRetryCount(_pin);
        }
        if (cardMock != null) {
            return cardMock.getRetryCount(_pin);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.debug((Object)"incompatible throwable with getRetryCount", e);
            throw new IllegalArgumentException();
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return -1;
    }

    @Override
    public synchronized int getRetryCount(OCFCertificateInfo _info) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.getRetryCount(_info);
        }
        if (cardMock != null) {
            return cardMock.getRetryCount(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.debug((Object)"incompatible throwable with getRetryCount", e);
            throw new IllegalArgumentException();
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public OCFCertificateInfo[] getAllCertificates() {
        block18: {
            Vector vector = this.certificates;
            // MONITORENTER : vector
            if (!ZCxxZeitControlBasicCardDebug.useMock()) break block18;
            OCFCertificateInfo[] oCFCertificateInfoArray = cardMock.getAllCertificates();
            // MONITOREXIT : vector
            if (listener == null) return oCFCertificateInfoArray;
            listener.readCertificatesFinished();
            return oCFCertificateInfoArray;
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        OCFCertificateInfo[] result = ZCxxZeitControlBasicCardDebug.getMockResult(OCFCertificateInfo[].class);
        if (result != null) {
            OCFCertificateInfo[] oCFCertificateInfoArray = result;
            // MONITOREXIT : vector
            if (listener == null) return oCFCertificateInfoArray;
            listener.readCertificatesFinished();
            return oCFCertificateInfoArray;
        }
        if (this.certificates.isEmpty()) {
            OCFCertificateInfo[] infos = this.getOCFCertificateInfos();
            byte[] baseCertBytes = this.getBaseCertificateBytes();
            try {
                X509Certificate baseCert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(baseCertBytes));
                for (int i = 0; i < infos.length; ++i) {
                    if (i == 0) {
                        SEX509Certificate sigCert = new SEX509Certificate(baseCert, new boolean[]{false, true, false, false, false, false, false, false, false});
                        infos[i].setX509Certificate(sigCert);
                        infos[i].setAlias("siggy");
                    } else if (i == 1) {
                        SEX509Certificate encAutCert = new SEX509Certificate(baseCert, new boolean[]{true, false, true, true, false, false, false, false, false});
                        infos[i].setX509Certificate(encAutCert);
                        infos[i].setAlias("ency_auty");
                    }
                    this.certificates.add(infos[i]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        result = new OCFCertificateInfo[this.certificates.size()];
        this.certificates.toArray(result);
        OCFCertificateInfo[] oCFCertificateInfoArray = result;
        // MONITOREXIT : vector
        if (listener == null) return oCFCertificateInfoArray;
        listener.readCertificatesFinished();
        return oCFCertificateInfoArray;
        catch (Throwable throwable) {
            if (listener == null) throw throwable;
            listener.readCertificatesFinished();
            throw throwable;
        }
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getAvailableHashAlgorithmNames(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        List result = ZCxxZeitControlBasicCardDebug.getMockResult(List.class);
        if (result != null) {
            return result;
        }
        return Arrays.asList("RIPEMD160", "SHA1", "SHA224", "SHA384", "SHA256", "SHA512", "WHIRLPOOL");
    }

    private static boolean useMock() {
        return cardMock != null && cardMock.supportsMethod(ThreadUtil.getCallerMethodName(1));
    }

    private static boolean useGovCSMethod() {
        return useGovCSMethods != null && useGovCSMethods.contains(ThreadUtil.getCallerMethodName(1));
    }

    public static void setUseGovCSMethods(List<String> methodList) {
        useGovCSMethods = ListUtil.createUnmodifableCopy(methodList);
    }

    @Override
    public String getDisplayName() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getDisplayName();
        }
        String version = "";
        String detail = null;
        if (this.displayName == null && super.getCard() != null && super.getCard().getCardID() != null) {
            byte[] _historicals = super.getCard().getCardID().getHistoricals();
            if (Arrays.equals(HexUtil.parse("5a 43 37 2e 35 20 52 45 56 20 41"), _historicals)) {
                version = "7.5";
                detail = "CombiCard incl. RFID";
                this.displayName = "ZC " + version + " ZeitControl BasicCard (Debug, " + detail + ")";
            } else if (Arrays.equals(HexUtil.parse("42 61 73 69 63 43 61 72 64 20 5A 43 33 2E 39"), _historicals)) {
                version = "3.9";
                this.displayName = "ZC " + version + " ZeitControl BasicCard (Debug)";
            }
        }
        return this.displayName == null ? "ZC " + version + " ZeitControl BasicCard (Debug" + (String)(detail != null ? ", " + detail : "") + ")" : this.displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandAPDU getLastCommandAPDUfromDebugCard(CardChannel channel) throws CardTerminalException {
        CommandAPDU command = new CommandAPDU(HexString.parseHexString("00 05 00 00 00"));
        if (command == null) {
            throw new CardServiceInvalidParameterException("command = null");
        }
        ResponseAPDU response = null;
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel lchannel = cardChannelManager.init(this);
            response = lchannel.sendCommandAPDU(command);
        }
        finally {
            cardChannelManager.destroy();
        }
        return (response.sw() == 36864 || response.sw1() == 97) && response.data() != null && response.data().length > 0 ? new CommandAPDU(response.data()) : null;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getMaxPINLength(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return Integer.valueOf(settings.getProperty("KEY_PIN_MAX_LENGTH", "12"));
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getMinPINLength(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return Integer.valueOf(settings.getProperty("KEY_PIN_MIN_LENGTH", "6"));
    }

    @Override
    public byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getPasswordBlockFiller(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Byte result = ZCxxZeitControlBasicCardDebug.getMockResult(Byte.class);
        if (result != null) {
            return result;
        }
        return ZCxxZeitControlBasicCardDebug.getPasswordBlockFiller(settings);
    }

    @Override
    public boolean useKeyboard() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.useKeyboard();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        return super.useKeyboard();
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getPasswordBlockLength(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return ZCxxZeitControlBasicCardDebug.getPasswordBlockLength(settings);
    }

    @Override
    public PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getPINEncoding(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        PinEncoder result = ZCxxZeitControlBasicCardDebug.getMockResult(PinEncoder.class);
        if (result != null) {
            return result;
        }
        String name = settings.getProperty("KEY_PIN_FORMAT", "T.50 Encoding");
        if ("BCD Encoding".equals(name)) {
            return PinEncoder.ENCODER_BCD;
        }
        if ("Format 1 Pin Block Encoding".equals(name)) {
            return PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK;
        }
        if ("Format 2 Pin Block Encoding".equals(name)) {
            return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
        }
        if ("T.50 Encoding".equals(name)) {
            return PinEncoder.ENCODER_T50;
        }
        return null;
    }

    @Override
    public synchronized SecureCard.SecurityProtocol getSecurityProtocol() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getSecurityProtocol();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        SecureCard.SecurityProtocol result = ZCxxZeitControlBasicCardDebug.getMockResult(SecureCard.SecurityProtocol.class);
        if (result != null) {
            return result;
        }
        return this.currentSecurityProtocol;
    }

    @Override
    public List<SecureCard.SecurityProtocol> getSupportedSecurityProtocols() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getSupportedSecurityProtocols();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        List result = ZCxxZeitControlBasicCardDebug.getMockResult(List.class);
        if (result != null) {
            return result;
        }
        return this.supportedProtocols;
    }

    @Override
    public synchronized boolean isSecure() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.isSecure();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Boolean result = ZCxxZeitControlBasicCardDebug.getMockResult(Boolean.class);
        if (result != null) {
            return result;
        }
        return SecureCard.SecurityProtocol.NONE != this.currentSecurityProtocol;
    }

    @Override
    public byte[] padPin(OCFCertificateInfo _info, char[] _pin) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.padPin(_info, _pin);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        byte[] r = ZCxxZeitControlBasicCardDebug.getMockResult(byte[].class);
        if (r != null) {
            return r;
        }
        byte[] result = super.padPin(_info, _pin);
        return ArrayUtil.isEmpty(result) ? null : result;
    }

    @Override
    public boolean prepareSignatureTerminal(boolean initMode) {
        return false;
    }

    @Override
    public synchronized boolean releaseSecureContext() throws CardServiceException, CardTerminalException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.releaseSecureContext();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (CardServiceException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Boolean result = ZCxxZeitControlBasicCardDebug.getMockResult(Boolean.class);
        if (result != null) {
            return result;
        }
        this.currentSecurityProtocol = SecureCard.SecurityProtocol.NONE;
        return true;
    }

    @Override
    public void reset() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            cardMock.reset();
            return;
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        --instanceCounter;
        ZCxxZeitControlBasicCardDebug.resetProperties();
        if (!super.isCardPresent()) {
            return;
        }
        super.reset();
    }

    @Override
    public synchronized GovCS.ResultObject authentify(CardKey _key, byte[] value, char[] _pin, String algorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, CardTerminalException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.authentify(_key, value, _pin, algorithm, algorithmParameters);
        }
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.authentify(_key, value, _pin, algorithm, algorithmParameters);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        GovCS.ResultObject ro = ZCxxZeitControlBasicCardDebug.getMockResult(GovCS.ResultObject.class);
        if (ro != null) {
            return ro;
        }
        return ZCxxZeitControlBasicCardDebug.signWithKeyStore(_key.getInfo(), value, algorithm);
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] value, String algorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.authentify(_channel, _info, value, algorithm, algorithmParameters);
        }
        return ZCxxZeitControlBasicCardDebug.signWithKeyStore(_info, value, algorithm);
    }

    @Override
    public synchronized GovCS.ResultObject authentify(OCFCertificateInfo _info, byte[] value, char[] _pin, String algorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, CardTerminalException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.authentify(_info, value, _pin, algorithm, algorithmParameters);
        }
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.authentify(_info, value, _pin, algorithm, algorithmParameters);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        GovCS.ResultObject ro = ZCxxZeitControlBasicCardDebug.getMockResult(GovCS.ResultObject.class);
        if (ro != null) {
            return ro;
        }
        return ZCxxZeitControlBasicCardDebug.signWithKeyStore(_info, value, algorithm);
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.decrypt(_channel, _info, _encryptedBytes, algorithmParameters);
        }
        return ZCxxZeitControlBasicCardDebug.decryptWithKeyStore(_info, _encryptedBytes);
    }

    @Override
    public synchronized GovCS.ResultObject decrypt(OCFCertificateInfo _info, byte[] bytes, char[] _pin, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.decrypt(_info, bytes, _pin, algorithmParameters);
        }
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.decrypt(_info, bytes, _pin, algorithmParameters);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        GovCS.ResultObject ro = ZCxxZeitControlBasicCardDebug.getMockResult(GovCS.ResultObject.class);
        if (ro != null) {
            return ro;
        }
        return ZCxxZeitControlBasicCardDebug.decryptWithKeyStore(_info, bytes);
    }

    @Override
    public synchronized boolean isKeyInitialized(OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.isKeyInitialized(_info);
        }
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.isKeyInitialized(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Boolean result = ZCxxZeitControlBasicCardDebug.getMockResult(Boolean.class);
        if (result != null) {
            return result;
        }
        try {
            return this.isKeyInitialized(null, _info);
        }
        catch (InvalidCardChannelException invalidCardChannelException) {
        }
        catch (RetryCounterExpiredException retryCounterExpiredException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public synchronized GovCS.ResultObject decrypt(CardKey _key, byte[] bytes, char[] _pin, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.decrypt(_key, bytes, _pin, algorithmParameters);
        }
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.decrypt(_key, bytes, _pin, algorithmParameters);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        GovCS.ResultObject ro = ZCxxZeitControlBasicCardDebug.getMockResult(GovCS.ResultObject.class);
        if (ro != null) {
            return ro;
        }
        return ZCxxZeitControlBasicCardDebug.decryptWithKeyStore(_key.getInfo(), bytes);
    }

    public static GovCS.ResultObject decryptWithKeyStore(OCFCertificateInfo _info, byte[] value) {
        GovCS.ResultObject result = new GovCS.ResultObject();
        result.setResultCode(26368);
        result.setResultData(null);
        if (keyStore != null) {
            try {
                Key key = keyStore.getKey(_info.getAlias(), null);
                if (PrivateKey.class.isInstance(key)) {
                    PrivateKey pk = (PrivateKey)key;
                    String keyAlgorithmName = pk.getAlgorithm();
                    if (keyAlgorithmName.equals("RSA")) {
                        result.setResultData(value);
                        Cipher c = Cipher.getInstance("RSA/ECB/NoPadding", "BC");
                        c.init(2, pk);
                        result.setResultData(c.doFinal((byte[])result.getResultData()));
                        result.setResultCode(36864);
                    } else {
                        if (keyAlgorithmName.equals("EC")) {
                            throw new IllegalArgumentException("decryption with keystore for EC not supported");
                        }
                        if (keyAlgorithmName.equals("DSA")) {
                            throw new IllegalArgumentException("decryption with keystore for EC not supported");
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.debug((Object)"decrypting with keystore failed", t);
            }
        }
        return result;
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(CardKey _key, byte[] value, char[] _pin, String algorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.signHash(_key, value, _pin, algorithm, algorithmParameters);
        }
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.signHash(_key, value, _pin, algorithm, algorithmParameters);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        GovCS.ResultObject ro = ZCxxZeitControlBasicCardDebug.getMockResult(GovCS.ResultObject.class);
        if (ro != null) {
            return ro;
        }
        return ZCxxZeitControlBasicCardDebug.signWithKeyStore(_key.getInfo(), value, algorithm);
    }

    private void notPossibleMockThrowable(Throwable e) {
        LOG.debug((Object)("incompatible throwable with " + ThreadUtil.getCallerMethodName(0)), e);
        throw new IllegalArgumentException();
    }

    @Override
    protected final GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.signHash(_channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
        }
        return ZCxxZeitControlBasicCardDebug.signWithKeyStore(_info, _hashValue, _hashAlgorithm);
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(OCFCertificateInfo _info, byte[] value, char[] _pin, String algorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.signHash(_info, value, _pin, algorithm, algorithmParameters);
        }
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.signHash(_info, value, _pin, algorithm, algorithmParameters);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        GovCS.ResultObject ro = ZCxxZeitControlBasicCardDebug.getMockResult(GovCS.ResultObject.class);
        if (ro != null) {
            return ro;
        }
        return ZCxxZeitControlBasicCardDebug.signWithKeyStore(_info, value, algorithm);
    }

    public static GovCS.ResultObject signWithKeyStorePSS(OCFCertificateInfo _info, byte[] value, String algorithm) {
        GovCS.ResultObject result = new GovCS.ResultObject();
        result.setResultCode(26368);
        result.setResultData(null);
        if (keyStore != null) {
            try {
                Key key = keyStore.getKey(_info.getAlias(), null);
                if (PrivateKey.class.isInstance(key)) {
                    PrivateKey pk = (PrivateKey)key;
                    Signature signature = Signature.getInstance(algorithm + "withRAWRSASSA-PSS", "MCardTestProvider");
                    signature.initSign(pk);
                    signature.update(value);
                    result.setResultData(signature.sign());
                    result.setResultCode(36864);
                }
            }
            catch (Throwable t) {
                LOG.debug((Object)"signing with keystore failed", t);
            }
        }
        return result;
    }

    public static GovCS.ResultObject signWithKeyStore(OCFCertificateInfo _info, byte[] value, String algorithm) {
        GovCS.ResultObject result = new GovCS.ResultObject();
        result.setResultCode(26368);
        result.setResultData(null);
        if (keyStore != null) {
            try {
                Key key = keyStore.getKey(_info.getAlias(), null);
                if (PrivateKey.class.isInstance(key)) {
                    PrivateKey pk = (PrivateKey)key;
                    String keyAlgorithmName = pk.getAlgorithm();
                    if (keyAlgorithmName.equals("RSA")) {
                        HashAlgorithm.Algorithm alg = HashAlgorithm.Algorithm.getAlgorithmByName(algorithm);
                        DigestInfo di = new DigestInfo(alg, value);
                        byte[] divalue = di.getEncoded();
                        RSAPrivateKey rk = (RSAPrivateKey)pk;
                        int byteLength = rk.getModulus().bitLength() / 8;
                        result.setResultData(new byte[byteLength]);
                        ByteUtil.fill((byte[])result.getResultData(), (byte)0);
                        System.arraycopy(divalue, 0, result.getResultData(), byteLength - divalue.length, divalue.length);
                        ((byte[])result.getResultData())[1] = 1;
                        ByteUtil.fill((byte[])result.getResultData(), (byte)-1, 2, byteLength - divalue.length - 1);
                        Cipher c = Cipher.getInstance("RSA", "BC");
                        c.init(1, pk);
                        result.setResultData(c.doFinal((byte[])result.getResultData()));
                        result.setResultCode(36864);
                    } else if (keyAlgorithmName.equals("EC")) {
                        result.setResultData(ZCxxZeitControlBasicCardDebug.signHashECwithResultAsByteArray(value, key));
                        result.setResultCode(36864);
                    } else if (keyAlgorithmName.equals("DSA")) {
                        LOG.debug((Object)"what now DSA................................");
                    }
                }
            }
            catch (Throwable t) {
                LOG.debug((Object)"signing with keystore failed", t);
            }
        }
        return result;
    }

    public static byte[] signHashECwithResultAsByteArray(byte[] value, Key key) throws Exception {
        LOG.debug((Object)HexUtil.dump(value));
        ECDSASigner e = new ECDSASigner();
        JCEECPrivateKey ek = (JCEECPrivateKey)key;
        ECParameterSpec ecp = ek.getParameters();
        ECDomainParameters ecddp = new ECDomainParameters(ecp.getCurve(), ecp.getG(), ecp.getN(), ecp.getH());
        ECPrivateKeyParameters ecpkp = new ECPrivateKeyParameters(ek.getD(), ecddp);
        e.init(true, (CipherParameters)ecpkp);
        BigInteger[] sigInt = e.generateSignature(value);
        int byteLength = ecp.getN().bitLength() / 8;
        if (byteLength % 2 == 1) {
            --byteLength;
        }
        byte[] result = new byte[byteLength * 2];
        byte[] b1 = sigInt[0].toByteArray();
        byte[] b2 = sigInt[1].toByteArray();
        if (b1.length != byteLength) {
            System.arraycopy(b1, 1, result, 0, byteLength);
        } else {
            System.arraycopy(b1, 0, result, 0, byteLength);
        }
        if (b2.length != byteLength) {
            System.arraycopy(b2, 1, result, byteLength, byteLength);
        } else {
            System.arraycopy(b2, 0, result, byteLength, byteLength);
        }
        return result;
    }

    public static byte[] signHashECwithResultAsASN1(byte[] value, Key key) throws Exception {
        LOG.debug((Object)HexUtil.dump(value));
        ECDSASigner e = new ECDSASigner();
        JCEECPrivateKey ek = (JCEECPrivateKey)key;
        ECParameterSpec ecp = ek.getParameters();
        ECDomainParameters ecddp = new ECDomainParameters(ecp.getCurve(), ecp.getG(), ecp.getN(), ecp.getH());
        ECPrivateKeyParameters ecpkp = new ECPrivateKeyParameters(ek.getD(), ecddp);
        e.init(true, (CipherParameters)ecpkp);
        BigInteger[] sigInt = e.generateSignature(value);
        ASN1 r = new ASN1(48, new byte[0]);
        r.addChildElement(new ASN1(2, sigInt[0].toByteArray()), r);
        r.addChildElement(new ASN1(2, sigInt[1].toByteArray()), r);
        return r.getEncoded();
    }

    private CardApplication createApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000001L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("81");
        byte pinID01 = -127;
        FileReference dirRef = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRef, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "PIN.SIG.ENC", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.EUROPEAN_QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ACCREDITED_SIGNATURE_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("d27600006601", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putPin(pin01);
        application.putFile(file01);
        application.putKey(key01);
        return application;
    }

    private CardApplication createEncDecAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfFile = 3000002L;
        long idOfKey = 4000003L;
        KeyID k = new KeyID("01");
        FileReference dirRefApp = new FileReference(8, "501550724B01");
        FileReference cerRef = new FileReference(8, "501543044301");
        FileEntry fileEntry = new FileEntry(dirRefApp, cerRef);
        OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile, idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDecAut", idOfFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey/AuthenticationKey", idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_DECRYPTION.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info, idOfFile, idOfPinCH, k);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724B01", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private CardApplication createKeyStoreApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        try {
            if (keyStore == null) {
                ZCxxZeitControlBasicCardDebug.resetKeyStore();
            }
            if (keyStore != null && keyStore.size() != 0) {
                long idOfApplication = 1000003L;
                long idOfFile = 3000002L;
                long idOfKey = 4000003L;
                long idOfPin01 = 2000003L;
                KeyID k = new KeyID("81");
                FileReference dirRefApp = new FileReference(8, "ffffffff");
                FileReference cerRef = new FileReference(8, "ffffffff");
                FileEntry fileEntry = new FileEntry(dirRefApp, cerRef);
                CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
                CardApplicationImpl keyStoreApp = new CardApplicationImpl("ffffffff", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
                byte pinID01 = -127;
                LOG.debug((Object)("key store entries: " + keyStoreAliasList.size()));
                LOG.debug((Object)("key store aliases: " + keyStoreAliasList));
                ArrayList<Long> listKeyIDs = new ArrayList<Long>();
                for (String alias : keyStoreAliasList) {
                    Certificate[] chain = keyStore.getCertificateChain(alias);
                    if (chain != null && chain.length == 3) {
                        LOG.debug((Object)("alias: " + alias));
                        LOG.debug((Object)("user-certificate-usage: " + ((X509Certificate)chain[0]).getKeyUsage()));
                        OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, idOfPin01, ++idOfFile, ++idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
                        info.setX509Certificate((X509Certificate)chain[0]);
                        info.setAlias(alias);
                        info.lockAlias();
                        CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, "file" + alias, idOfFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
                        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "key" + alias, idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info, idOfFile, idOfPin01, k);
                        keyStoreApp.putFile(file);
                        keyStoreApp.putKey(key);
                        listKeyIDs.add(idOfKey);
                        continue;
                    }
                    X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                    ++idOfKey;
                    LOG.debug((Object)("alias: " + alias));
                    LOG.debug((Object)("ca/intermediate-certificate-usage: " + certificate.getKeyUsage()));
                    OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, -1L, ++idOfFile, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
                    CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, "file" + alias, idOfFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info);
                    info.setX509Certificate(certificate);
                    info.setAlias(alias);
                    info.lockAlias();
                    keyStoreApp.putFile(file);
                }
                if (CollectionUtil.notNullOrEmpty(listKeyIDs)) {
                    CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "PIN.KS", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, ArrayUtil.to(listKeyIDs.toArray(new Long[listKeyIDs.size()])));
                    keyStoreApp.putPin(pin01);
                }
                return keyStoreApp;
            }
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("02");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(8, "1fff");
        FileReference cerRef01 = new FileReference(8, "5015430443f1");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "PIN.SIG", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("1fff", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private void debugPinOperation(String msg, CardChannel _channel, CommandAPDU expectedCommand, Throwable t) {
        try {
            CommandAPDU lastCommand = this.getLastCommandAPDUfromDebugCard(_channel);
            if (expectedCommand != null && lastCommand != null) {
                LOG.debug((Object)("\n====================\nPin Operation successful: " + Arrays.equals(lastCommand.getBytes(), expectedCommand.getBytes()) + "\n===================="));
                if (!Arrays.equals(lastCommand.getBytes(), expectedCommand.getBytes())) {
                    throw new RuntimeException("Pin Operation not successful - wrong command: - " + msg + ": " + HexUtil.hexify(lastCommand.getBytes()) + " <> " + HexUtil.hexify(expectedCommand.getBytes()) + " <> ");
                }
            } else {
                LOG.debug((Object)"\n====================\nPin Operation successful: false\n====================");
                if (DEBUG) {
                    throw new RuntimeException("Pin Operation not successful: - " + msg + ": " + (t != null ? t.getMessage() : " --- no throwable---\n") + (lastCommand != null ? lastCommand.toString() : " --- no command --- "));
                }
            }
            LOG.debug((Object)("debugPinOperation - " + msg + ": " + (lastCommand != null ? lastCommand.toString() : " --- no command --- ")));
        }
        catch (CardTerminalException e) {
            LOG.debug((Object)("debugPinOperation - " + msg + ": failed" + e.getMessage()));
        }
    }

    private byte[] getBaseCertificateBytes() {
        byte[] result = null;
        try {
            String filename = settings.getProperty("KEY_CERTIFICATE_FILE", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer");
            result = FileUtil.readBytesOfFile(filename);
        }
        catch (IOException e) {
            e.printStackTrace();
            result = HexUtil.parse(FALLBACK_CERTIFICATE_HEXSTRING);
        }
        return result;
    }

    private String readIssuer(CardChannel _channel) {
        String result = null;
        try {
            ResponseAPDU response = _channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("00f0000000")));
            if ((response.sw() == 36864 || response.sw1() == 97) && response.data() != null && response.data().length == 2 && "42".equals(new String(response.data()))) {
                result = ISSUER;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected int changePassword(CardChannel _channel, OCFCertificateInfo _info, char[] _pin, char[] pin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, CardTerminalException, WrongConfirmedNewPinException, NotYetInitializedException, OperationCancelledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.createCardInt(terminal, slotID);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Card result = ZCxxZeitControlBasicCardDebug.getMockResult(Card.class);
        if (result != null) {
            return result;
        }
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfPinCH = -1L;
        long idOfMFApplication = 1000000L;
        long idOfPin = 2000001L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        byte pinID = 1;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "PIN.CH", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L});
        CardApplication applicationSIGN = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationEncDecAut = this.createEncDecAutApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationKeyStore = this.createKeyStoreApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        mfManager.putApplication(applicationEncDecAut);
        if (applicationKeyStore != null) {
            mfManager.putApplication(applicationKeyStore);
        }
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.createCertificateInfos();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        OCFCertificateInfo[] result = ZCxxZeitControlBasicCardDebug.getMockResult(OCFCertificateInfo[].class);
        if (result != null) {
            return result;
        }
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c000"), new KeyID("81"), -127, OCFCertificateInfo.ChainEntry.USER)};
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String algorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return null;
    }

    protected byte[] get2BlockPin(OCFCertificateInfo _info, char[] _pin) {
        byte[] result = new byte[this.getPasswordBlockLength(_info)];
        Arrays.fill(result, this.getPasswordBlockFiller(_info));
        result[0] = (byte)(0x20 | (_pin == null ? 15 : _pin.length));
        if (_pin != null) {
            char[] pin = new char[_pin.length];
            System.arraycopy(_pin, 0, pin, 0, pin.length);
            int j = 0;
            for (int i = 1; i < result.length && j < pin.length; ++i) {
                result[i] = (byte)((pin[j++] & 0xF) << 4);
                if (j < pin.length) {
                    int n = i;
                    result[n] = (byte)(result[n] | (byte)(pin[j++] & 0xF));
                    continue;
                }
                int n = i;
                result[n] = (byte)(result[n] | 0xF);
            }
            Arrays.fill(pin, '\u0000');
        }
        return result;
    }

    protected Card.CardTypeEnum getCardTypeEnum() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getCardTypeEnum();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Card.CardTypeEnum result = ZCxxZeitControlBasicCardDebug.getMockResult(Card.CardTypeEnum.class);
        if (result != null) {
            return result;
        }
        return Card.CardTypeEnum.UNKNOWN;
    }

    @Override
    protected byte[] getHistoricals() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getHistoricals();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        byte[] result = ZCxxZeitControlBasicCardDebug.getMockResult(byte[].class);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    protected char[] getInitPIN() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getInitPIN();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        char[] result = ZCxxZeitControlBasicCardDebug.getMockResult(char[].class);
        if (result != null) {
            return result;
        }
        return ZCxxZeitControlBasicCardDebug.getInitPIN(settings);
    }

    @Override
    protected String getIssuerConstant() {
        return ISSUER;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return ZCxxZeitControlBasicCardDebug.getPaddedPIN(settings, _pin != null ? _pin : settings.getProperty("KEY_PIN_CURRENT", DEFAULT_CURRENT_PIN).toCharArray());
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, PinDeactivatedException, ResponseCodeException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getRetryCount(_channel, _info);
        }
        if (!this.isKeyInitialized(_channel, _info)) {
            throw new NotYetInitializedException(ZCxxZeitControlBasicCardDebug.getPinNameForInfo(_info), 27013, "pin not initialized");
        }
        return -1;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.historicalsEquals(_historicals);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Boolean result = ZCxxZeitControlBasicCardDebug.getMockResult(Boolean.class);
        if (result != null) {
            return result;
        }
        return Arrays.equals(HexUtil.parse("5a 43 37 2e 35 20 52 45 56 20 41"), _historicals) || Arrays.equals(HexUtil.parse("42 61 73 69 63 43 61 72 64 20 5A 43 33 2E 39"), _historicals) || Arrays.equals(HexUtil.parse("5a 43 37 2e 35"), _historicals) || Arrays.equals(HexUtil.parse("41 20 00 11 11 e0 5a 43 37 2e 35"), _historicals);
    }

    @Override
    public String getIndentifier() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getIndentifier();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        String result = ZCxxZeitControlBasicCardDebug.getMockResult(String.class);
        if (result != null) {
            return result;
        }
        return super.getIndentifier();
    }

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        if (ZCxxZeitControlBasicCardDebug.useGovCSMethod()) {
            return super.isKeyInitialized(_channel, _info);
        }
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.isKeyInitialized(_channel, _info);
        }
        return Boolean.valueOf(settings.getProperty("KEY_INITIALIZED", "true"));
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.readIssuerFromATR(_channel);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        String result = ZCxxZeitControlBasicCardDebug.getMockResult(String.class);
        if (result != null) {
            return result;
        }
        return this.readIssuer(_channel);
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel, int bytes) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.readIssuerFromATR(_channel, bytes);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        String result = ZCxxZeitControlBasicCardDebug.getMockResult(String.class);
        if (result != null) {
            return result;
        }
        return this.readIssuer(_channel);
    }

    @Override
    protected void selectFile(CardChannel _channel, FileEntry entry, boolean file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        super.selectFile(_channel, entry, file);
    }

    @Override
    protected void selectMasterFile(CardChannel _channel) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            cardMock.selectMasterFile(_channel);
            return;
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (InvalidCardChannelException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        super.selectMasterFile(_channel);
    }

    @Override
    protected void selectSubDirectory(CardChannel _channel, FileReference _directory) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            cardMock.selectSubDirectory(_channel, _directory);
            return;
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (InvalidCardChannelException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        super.selectSubDirectory(_channel, _directory);
    }

    @Override
    protected void selectFile(CardChannel _channel, FileReference _file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            cardMock.selectFile(_channel, _file);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (InvalidCardChannelException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        super.selectFile(_channel, _file);
    }

    @Override
    protected GovCS.ResultObject readSelectedFile(CardChannel _channel, int _offset, int _length) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.readSelectedFile(_channel, _offset, _length);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (InvalidCardChannelException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        GovCS.ResultObject r = ZCxxZeitControlBasicCardDebug.getMockResult(GovCS.ResultObject.class);
        if (r != null) {
            return r;
        }
        byte[] result = this.getBaseCertificateBytes();
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(36864);
        ro.setResultData(result);
        return ro;
    }

    @Override
    protected void selectFile(CardChannel _channel, OCFCertificateInfo _info, boolean file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            cardMock.selectFile(_channel, _info, file);
            return;
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        super.selectFile(_channel, _info, file);
    }

    @Override
    public boolean usesNullPIN() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.usesNullPIN();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Boolean result = ZCxxZeitControlBasicCardDebug.getMockResult(Boolean.class);
        if (result != null) {
            return result;
        }
        return ZCxxZeitControlBasicCardDebug.usesNullPIN(settings);
    }

    @Override
    public synchronized int initPassword(CardPin _pin, char[] pin, char[] _newpin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.initPassword(_pin, pin, _newpin);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongConfirmedNewPinException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return super.initPassword(_pin, pin, _newpin);
    }

    @Override
    public synchronized int changePassword(CardPin pin, char[] _pin, char[] _newpin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.changePassword(pin, _pin, _newpin);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongConfirmedNewPinException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return super.changePassword(pin, _pin, _newpin);
    }

    @Override
    public boolean isKeybordAllowed() {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.isKeybordAllowed();
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        return super.isKeybordAllowed();
    }

    @Override
    public synchronized int changePassword(OCFCertificateInfo _info, char[] _pin, char[] _newpin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.changePassword(_info, _pin, _newpin);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongConfirmedNewPinException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return super.changePassword(_info, _pin, _newpin);
    }

    @Override
    public Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getMinPINLengthInit(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return this.getMinPINLengthInit(settings);
    }

    @Override
    public Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.getMaxPINLengthInit(_info);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return this.getMaxPINLengthInit(settings);
    }

    private Integer getMinPINLengthInit(Properties settings) {
        String s = settings.getProperty("KEY_PIN_MIN_LENGTH_INIT");
        return s != null && s.length() > 0 ? Integer.valueOf(s) : null;
    }

    private Integer getMaxPINLengthInit(Properties settings) {
        String s = settings.getProperty("KEY_PIN_MAX_LENGTH_INIT");
        return s != null && s.length() > 0 ? Integer.valueOf(s) : null;
    }

    @Override
    public synchronized int initPassword(OCFCertificateInfo _info, char[] pin, char[] _newpin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.initPassword(_info, pin, _newpin);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongConfirmedNewPinException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return super.initPassword(_info, pin, _newpin);
    }

    @Override
    public synchronized int verifyPassword(CardPin pin, char[] _pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, CardTerminalException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.verifyPassword(pin, _pin);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return super.verifyPassword(pin, _pin);
    }

    @Override
    public synchronized int verifyPassword(OCFCertificateInfo _info, char[] _pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, CardTerminalException, OperationCancelledException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.verifyPassword(_info, _pin);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return super.verifyPassword(_info, _pin);
    }

    @Override
    protected int verifyPassword(CardChannel _channel, OCFCertificateInfo _info, char[] _pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.verifyPassword(_channel, _info, _pin);
        }
        try {
            ZCxxZeitControlBasicCardDebug.getMockThrowable();
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            this.notPossibleMockThrowable(e);
        }
        Integer result = ZCxxZeitControlBasicCardDebug.getMockResult(Integer.class);
        if (result != null) {
            return result;
        }
        return super.verifyPassword(_channel, _info, _pin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int verifyPassword(CardChannel _channel, OCFCertificateInfo _info, char[] _pin, Integer retryCount) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        ZCxxZeitControlBasicCardDebug.resetProperties();
        ZCxxZeitControlBasicCardDebug.createExpectedCommands(_info, settings);
        boolean executed = false;
        try {
            int result = super.verifyPassword(_channel, _info, _pin, retryCount);
            executed = true;
            int n = result;
            return n;
        }
        catch (InvalidCardChannelException e) {
            throw e;
        }
        catch (WrongPinException e) {
            this.debugPinOperation("verify_WrongPinException", _channel, null, e);
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            this.debugPinOperation("verify_RetryCounterExpiredException", _channel, null, e);
            throw e;
        }
        catch (NotYetInitializedException e) {
            this.debugPinOperation("verify_NotYetInitializedException", _channel, null, e);
            throw e;
        }
        catch (PinInputTooShortException e) {
            this.debugPinOperation("verify_PinInputTooShortException", _channel, null, e);
            throw e;
        }
        catch (PinInputTooLongException e) {
            this.debugPinOperation("verify_PinInputTooLongException", _channel, null, e);
            throw e;
        }
        catch (PinInputTimeoutException e) {
            this.debugPinOperation("verify_PinInputTimeoutException", _channel, null, e);
            throw e;
        }
        catch (PinInputCancelledException e) {
            this.debugPinOperation("verify_PinInputCancelledException", _channel, null, e);
            throw e;
        }
        catch (OperationCancelledException e) {
            this.debugPinOperation("verify_OperationCancelledException", _channel, null, e);
            throw e;
        }
        catch (ResponseCodeException e) {
            this.debugPinOperation("verify_ResponseCodeException", _channel, null, e);
            throw e;
        }
        catch (CardTerminalException e) {
            LOG.debug((Object)"", (Throwable)e);
            this.debugPinOperation("verify_CardTerminalException", _channel, null, e);
            throw e;
        }
        catch (Throwable e) {
            LOG.debug((Object)"", e);
            this.debugPinOperation("verify_Throwable", _channel, null, e);
            int n = 0;
            return n;
        }
        finally {
            if (executed) {
                this.debugPinOperation("verify", _channel, cmdVerify, null);
            } else {
                LOG.debug((Object)"verify failed");
            }
        }
    }

    @Override
    protected final GovCS.ResultObject setSecurityEnvironment(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException {
        if (ZCxxZeitControlBasicCardDebug.useMock()) {
            return cardMock.setSecurityEnvironment(_channel, _info, _type, _hashAlgorithm, algorithmParameters);
        }
        return super.setSecurityEnvironment(_channel, _info, _type, _hashAlgorithm, algorithmParameters);
    }

    public static CardMock getCardMock() {
        return cardMock;
    }

    public static void setCardMock(CardMock cardMock) {
        ZCxxZeitControlBasicCardDebug.cardMock = cardMock;
    }

    public static KeyStore getKeyStore() {
        return keyStore;
    }

    public static CertificateReadListener getListener() {
        return listener;
    }

    public static void setListener(CertificateReadListener listener) {
        ZCxxZeitControlBasicCardDebug.listener = listener;
    }

    public static interface CertificateReadListener {
        public void readCertificatesFinished();
    }
}

