/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.debug;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.HexUtil;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class SEX509Certificate
extends X509Certificate {
    public static final String FALLBACK_CERTIFICATE_HEXSTRING = "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";
    private X509Certificate certificate = null;
    private boolean[] keyUsage = null;

    public SEX509Certificate() throws IllegalStateException {
        this(null, null);
    }

    public SEX509Certificate(boolean[] keyUsage) throws IllegalArgumentException, IllegalStateException {
        this(null, keyUsage);
    }

    public SEX509Certificate(X509Certificate certificate) throws IllegalStateException {
        this(certificate, certificate != null ? certificate.getKeyUsage() : null);
    }

    public SEX509Certificate(X509Certificate certificate, boolean[] keyUsage) throws IllegalStateException {
        if (certificate != null) {
            this.certificate = certificate;
        } else {
            try {
                this.certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(HexUtil.parse(FALLBACK_CERTIFICATE_HEXSTRING)));
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to generate certificate from fallback, instance not usable");
            }
        }
        this.keyUsage = ArrayUtil.isNullOrEmpty(keyUsage) ? this.certificate.getKeyUsage() : keyUsage;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.certificate.checkValidity();
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.certificate.checkValidity(date);
    }

    @Override
    public boolean equals(Object other) {
        return this.certificate.equals(other);
    }

    @Override
    public int getBasicConstraints() {
        return this.certificate.getBasicConstraints();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.certificate.getCriticalExtensionOIDs();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.certificate.getEncoded();
    }

    @Override
    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        return this.certificate.getExtendedKeyUsage();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return this.certificate.getExtensionValue(oid);
    }

    @Override
    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        return this.certificate.getIssuerAlternativeNames();
    }

    @Override
    public Principal getIssuerDN() {
        return this.certificate.getIssuerDN();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.certificate.getIssuerUniqueID();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.certificate.getIssuerX500Principal();
    }

    @Override
    public boolean[] getKeyUsage() {
        return this.keyUsage;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.certificate.getNonCriticalExtensionOIDs();
    }

    @Override
    public Date getNotAfter() {
        return this.certificate.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.certificate.getNotBefore();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber();
    }

    @Override
    public String getSigAlgName() {
        return this.certificate.getSigAlgName();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate.getSigAlgOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.certificate.getSigAlgParams();
    }

    @Override
    public byte[] getSignature() {
        return this.certificate.getSignature();
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        return this.certificate.getSubjectAlternativeNames();
    }

    @Override
    public Principal getSubjectDN() {
        return this.certificate.getSubjectDN();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return this.certificate.getSubjectUniqueID();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.certificate.getSubjectX500Principal();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.certificate.getTBSCertificate();
    }

    @Override
    public int getVersion() {
        return this.certificate.getVersion();
    }

    @Override
    public int hashCode() {
        return this.certificate.hashCode();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.certificate.hasUnsupportedCriticalExtension();
    }

    @Override
    public String toString() {
        return this.certificate.toString();
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.certificate.verify(key, sigProvider);
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.certificate.verify(key);
    }
}

