/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.debug;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.Property;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.PropertyConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.ZCxxZeitControlBasicCardDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class PropertyDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 0L;
    private JButton buttonDefaultsSettings = null;
    private JButton buttonStoreSettings = null;
    private final JComboBox comboboxPropertySet = new JComboBox<PropertySet>(PropertySet.values());
    private List<JLabel> commandsLabelFields = null;
    private File file = null;
    private List<JComboBox> listComboBoxFields = null;
    private List<JTextField> listTextFields = null;
    private Properties properties = null;

    public PropertyDialog(Dialog owner, boolean modal, Properties properties, File file) {
        super(owner, modal);
        this.init(properties, file);
    }

    public PropertyDialog(Dialog owner, Properties properties, File file) {
        super(owner);
        this.init(properties, file);
    }

    public PropertyDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc, Properties properties, File file) {
        super(owner, title, modal, gc);
        this.init(properties, file);
    }

    public PropertyDialog(Dialog owner, String title, boolean modal, Properties properties, File file) {
        super(owner, title, modal);
        this.init(properties, file);
    }

    public PropertyDialog(Dialog owner, String title, Properties properties, File file) {
        super(owner, title);
        this.init(properties, file);
    }

    public PropertyDialog(Frame owner, boolean modal, Properties properties, File file) {
        super(owner, modal);
        this.init(properties, file);
    }

    public PropertyDialog(Frame owner, Properties properties, File file) {
        super(owner);
        this.init(properties, file);
    }

    public PropertyDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc, Properties properties, File file) {
        super(owner, title, modal, gc);
        this.init(properties, file);
    }

    public PropertyDialog(Frame owner, String title, boolean modal, Properties properties, File file) {
        super(owner, title, modal);
        this.init(properties, file);
    }

    public PropertyDialog(Frame owner, String title, Properties properties, File file) {
        super(owner, title);
        this.init(properties, file);
    }

    public PropertyDialog(Properties properties, File file) {
        this.init(properties, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block16: {
            try {
                if (JComponent.class.isInstance(e.getSource()) && ((JComponent)e.getSource()).getClientProperty("PROPERTY") != null) {
                    Property p = (Property)((JComponent)e.getSource()).getClientProperty("PROPERTY");
                    p.getComponent(p.getDefaultValue());
                    this.properties.setProperty(p.getKey(), p.getDefaultValue());
                    break block16;
                }
                if (JComponent.class.isInstance(e.getSource()) && ((JComponent)e.getSource()).getClientProperty("EDIT_PROPERTY") != null) {
                    Property p = (Property)((JComponent)e.getSource()).getClientProperty("EDIT_PROPERTY");
                    this.properties.setProperty(p.getKey(), ((JComboBox)e.getSource()).getSelectedItem().toString());
                    break block16;
                }
                if (e.getSource() == this.comboboxPropertySet) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ZCxxZeitControlBasicCardDebug.update = false;
                                PropertySet ps = (PropertySet)PropertyDialog.this.comboboxPropertySet.getSelectedItem();
                                Property[] props = ps.getProps();
                                String[] values = ps.getPropertyValues();
                                for (int i = 0; i < values.length; ++i) {
                                    String tmp;
                                    boolean processed = false;
                                    for (JTextField tf : PropertyDialog.this.listTextFields) {
                                        if (tf.getClientProperty("EDIT_PROPERTY") != props[i]) continue;
                                        tmp = values[i];
                                        if (tmp == null) {
                                            tmp = "null";
                                        }
                                        props[i].getComponent(tmp);
                                        PropertyDialog.this.properties.setProperty(props[i].getKey(), tmp);
                                        processed = true;
                                    }
                                    if (processed) continue;
                                    for (JComboBox cb : PropertyDialog.this.listComboBoxFields) {
                                        if (cb.getClientProperty("EDIT_PROPERTY") != props[i]) continue;
                                        tmp = values[i];
                                        props[i].getComponent(tmp);
                                        PropertyDialog.this.properties.setProperty(props[i].getKey(), tmp);
                                        processed = true;
                                    }
                                }
                            }
                            finally {
                                ZCxxZeitControlBasicCardDebug.update = true;
                            }
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List<JComboBox> cl = PropertyDialog.this.listComboBoxFields;
                            for (JComboBox cb : cl) {
                                if (!"KEY_USES_NULL_PIN".equals(((Property)cb.getClientProperty("EDIT_PROPERTY")).getKey())) continue;
                                int oldIndex = cb.getSelectedIndex();
                                int newIndex = (oldIndex + 1) % 2;
                                cb.setSelectedIndex(newIndex);
                                cb.setSelectedIndex(oldIndex);
                            }
                        }
                    });
                    break block16;
                }
                if (e.getSource() == this.buttonDefaultsSettings) {
                    Object[] props = Property.values();
                    if (!ArrayUtil.isNullOrEmpty(props)) {
                        for (Object p : props) {
                            ((Property)p).getComponent(((Property)p).getDefaultValue());
                        }
                    }
                    break block16;
                }
                if (e.getSource() != this.buttonStoreSettings) break block16;
                try (FileOutputStream os = new FileOutputStream(this.file);){
                    this.properties.storeToXML(os, "ZC x.x ZeitControl BasicCard (Debug) - settings: pinEncoding: 'T.50', 'Format 1 Pin Block', 'Format 2 Pin Block', 'Packed BCD'");
                }
                catch (IOException ioe) {
                    System.err.println("storing properties failed...");
                }
            }
            finally {
                this.updateCommands();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(e);
    }

    private void init(Properties properties, File file) {
        this.comboboxPropertySet.addActionListener(this);
        this.listTextFields = new ArrayList<JTextField>();
        this.commandsLabelFields = new ArrayList<JLabel>();
        this.listComboBoxFields = new ArrayList<JComboBox>();
        Container contentPane = this.getContentPane();
        this.file = file == null ? ZCxxZeitControlBasicCardDebug.getSettingsFile() : file;
        if (properties == null) {
            this.properties = new Properties();
            Object[] props = Property.values();
            if (!ArrayUtil.isNullOrEmpty(props)) {
                for (int i = 0; i < props.length; ++i) {
                    this.properties.setProperty(((Property)props[i]).getKey(), ((Property)props[i]).getDefaultValue());
                }
            }
        } else {
            this.properties = properties;
        }
        contentPane.setLayout(new BorderLayout());
        JPanel panelTop = new JPanel();
        panelTop.setLayout(new GridLayout(2, 1));
        panelTop.add(this.comboboxPropertySet);
        this.comboboxPropertySet.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (JLabel.class.isInstance(c) && PropertySet.class.isInstance(value)) {
                    ((JLabel)c).setText(((PropertySet)value).getName());
                }
                return c;
            }
        });
        panelTop.add(new JLabel("Settings stored at file: " + this.file.getAbsolutePath()));
        contentPane.add((Component)panelTop, "North");
        Object[] props = Property.values();
        if (!ArrayUtil.isNullOrEmpty(props)) {
            JPanel panelLabels = new JPanel();
            JPanel panelEditor = new JPanel();
            JPanel panelDefaults = new JPanel();
            panelLabels.setLayout(new GridLayout(props.length, 1));
            panelEditor.setLayout(new GridLayout(props.length, 1));
            panelDefaults.setLayout(new GridLayout(props.length, 1));
            for (int i = 0; i < props.length; ++i) {
                panelLabels.add(((Property)props[i]).getComponentLabel());
                JComponent c = ((Property)props[i]).getComponent(this.properties.getProperty(((Property)props[i]).getKey(), ((Property)props[i]).getDefaultValue()));
                panelEditor.add(c);
                if (JComboBox.class.isInstance(c)) {
                    ((JComboBox)c).addActionListener(this);
                    this.listComboBoxFields.add((JComboBox)c);
                } else if (JTextField.class.isInstance(c)) {
                    ((JTextField)c).getDocument().addDocumentListener(this);
                    this.listTextFields.add((JTextField)c);
                } else if (JLabel.class.isInstance(c) && Arrays.asList("KEY_PIN_VERIFY_CMD", "KEY_PIN_CHANGE_CMD", "KEY_PIN_INIT_CMD").contains(((Property)props[i]).getKey())) {
                    this.commandsLabelFields.add((JLabel)c);
                }
                c.putClientProperty("EDIT_PROPERTY", props[i]);
                if (((Property)props[i]).isEditable()) {
                    JButton button = new JButton("default");
                    button.putClientProperty("PROPERTY", props[i]);
                    button.addActionListener(this);
                    panelDefaults.add(button);
                    continue;
                }
                panelDefaults.add(new JLabel());
            }
            contentPane.add((Component)panelLabels, "West");
            contentPane.add((Component)panelEditor, "Center");
            contentPane.add((Component)panelDefaults, "East");
        }
        this.updateCommands();
        JPanel panelButtons = new JPanel();
        this.buttonDefaultsSettings = new JButton("Reset");
        this.buttonStoreSettings = new JButton("Store");
        this.buttonDefaultsSettings.addActionListener(this);
        this.buttonStoreSettings.addActionListener(this);
        panelButtons.add(this.buttonDefaultsSettings);
        panelButtons.add(this.buttonStoreSettings);
        contentPane.add((Component)panelButtons, "South");
        this.setDefaultCloseOperation(0);
        this.pack();
    }

    private synchronized void update(DocumentEvent e) {
        if (!ZCxxZeitControlBasicCardDebug.update) {
            return;
        }
        for (JTextField tf : this.listTextFields) {
            if (tf.getDocument() != e.getDocument()) continue;
            final JTextField selTF = tf;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ZCxxZeitControlBasicCardDebug.update = false;
                        Property p = (Property)selTF.getClientProperty("EDIT_PROPERTY");
                        p.getComponent(selTF.getText());
                        PropertyDialog.this.properties.setProperty(p.getKey(), selTF.getText());
                    }
                    finally {
                        PropertyDialog.this.updateCommands();
                        ZCxxZeitControlBasicCardDebug.update = true;
                    }
                }
            });
        }
    }

    private void updateCommands() {
        try {
            final String[] commands = ZCxxZeitControlBasicCardDebug.createExpectedCommands(null, this.properties);
            if (commands != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ZCxxZeitControlBasicCardDebug.update = false;
                            for (int i = 0; i < commands.length; ++i) {
                                PropertyDialog.this.commandsLabelFields.get(i).setText(commands[i] != null ? commands[i] : "");
                            }
                        }
                        finally {
                            ZCxxZeitControlBasicCardDebug.update = true;
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static enum PropertySet implements PropertyConstants
    {
        DEFAULTS("Defaults", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "true", "false", "T.50 Encoding", "12", "6", "0", "00", "null", "", "", "false", "false"}),
        FORMAT_2_PIN_BLOCK_INITIALIZED("Format 2 Pin Block (initialized - HBA, DSV, SignTrust)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "true", "false", "Format 2 Pin Block Encoding", "12", "4", "8", "ff", "null", "", "", "false", "false"}),
        FORMAT_2_PIN_BLOCK_NOT_INITIALIZED("Format 2 Pin Block (not initialized - HBA, DSV, SignTrust)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "false", "false", "Format 2 Pin Block Encoding", "12", "4", "8", "ff", "null", "false", "", "", "false"}),
        STRING_INITIALIZED_INIT_PIN_123456("String (initialized, Init PIN '123456' - TeleSec PKS)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "true", "false", "T.50 Encoding", "12", "6", "0", "00", HexUtil.hexify("123456".getBytes()), "", "", "false", "false"}),
        STRING_INITIALIZED_INIT_PIN_123456_PADDED("String (padded 0x20, initialized, Init PIN '123456' - old DSV or DTrust)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "true", "false", "T.50 Encoding", "8", "6", "8", "20", HexUtil.hexify("123456".getBytes()), "", "", "false", "false"}),
        STRING_INITIALIZED_NO_INIT_PIN("String (initialized, Transport PIN, no Init PIN, no NullPin) - DTrust (alt)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "true", "false", "T.50 Encoding", "12", "6", "0", "00", null, "", "", "false", "false"}),
        STRING_INITIALIZED_NO_INIT_PIN_PADDED("String (padded 0x20, initialized, Transport Pin, no init PIN or NullPin - old DSV)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "true", "false", "T.50 Encoding", "8", "6", "8", "20", null, "", "", "false", "false"}),
        STRING_INITIALIZED_NULLPIN("String (initialized, nullPIN - TeleSec PKS)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "true", "true", "T.50 Encoding", "12", "6", "0", "00", "000000000000", "", "", "false", "false"}),
        STRING_INITIALIZED_NULLPIN_PADDED("String (padded 0x20, initialized, nullPIN - old DSV or DTrust)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "true", "true", "T.50 Encoding", "8", "6", "8", "20", "000000000000", "", "", "false", "false"}),
        STRING_NOT_INITIALIZED_INIT_PIN_123456("String (not initialized, Init PIN '123456' - TeleSec PKS)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "false", "false", "T.50 Encoding", "12", "6", "0", "00", HexUtil.hexify("123456".getBytes()), "", "", "false", "false"}),
        STRING_NOT_INITIALIZED_INIT_PIN_123456_PADDED("String (padded 0x20, not initialized, Init PIN '123456' - old DSV or DTrust)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "false", "false", "T.50 Encoding", "8", "6", "8", "20", HexUtil.hexify("123456".getBytes()), "", "", "false", "false"}),
        STRING_NOT_INITIALIZED_NO_INIT_PADDED("String (padded 0x20, not initialized, Transport Pin, no init PIN or NullPin - old DSV)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "false", "false", "T.50 Encoding", "8", "6", "8", "20", null, "", "", "false", "false"}),
        STRING_NOT_INITIALIZED_NO_INIT_PIN("String (not initialized, Transport PIN, no Init PIN, no NullPin  - DTrust (alt)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "false", "false", "T.50 Encoding", "12", "6", "0", "00", null, "", "", "false", "false"}),
        STRING_NOT_INITIALIZED_NULLPIN("String (not initialized, nullPIN - TeleSec PKS)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "false", "true", "T.50 Encoding", "6", "6", "0", "00", "000000000000", "", "", "false", "false"}),
        STRING_NOT_INITIALIZED_NULLPIN_PADDED("String (padded 0x20, not initialized, nullPIN - old DSV or DTrust)", new String[]{"true", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "false", "true", "T.50 Encoding", "8", "6", "8", "20", "000000000000", "", "", "false", "false"});

        private String name = null;
        private String[] propertyValues = null;
        private Property[] props = null;

        private PropertySet(String name, String[] propertyValues) {
            this.name = name;
            this.propertyValues = propertyValues;
            this.props = Property.values();
        }

        public String getName() {
            return this.name;
        }

        public String[] getPropertyValues() {
            return this.propertyValues;
        }

        public Property[] getProps() {
            return this.props;
        }
    }
}

