/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.debug;

import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.PropertyConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.debug.PropertyType;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

enum Property implements PropertyConstants
{
    DIALOG("KEY_DIALOG", "false", "Dialog", "show this dialog (only changeable with Editor)", Arrays.asList("true", "false"), false, PropertyType.BOOLEAN, 0),
    CERTIFICATE_FILE("KEY_CERTIFICATE_FILE", "/home/jwothe/workspace/mcard/resources/cer_p12/certificate.cer", "Certificate file", "file for certificate", null, true, PropertyType.STRING, 1),
    INITIALIZED("KEY_INITIALIZED", "true", "Initialized", "edit initialization state", Arrays.asList("true", "false"), true, PropertyType.BOOLEAN, 2),
    USES_NULL_PIN("KEY_USES_NULL_PIN", "false", "NullPin", "edit use of null PIN", Arrays.asList("true", "false"), true, PropertyType.BOOLEAN, 3),
    PIN_FORMAT("KEY_PIN_FORMAT", "T.50 Encoding", "PinFormat", "edit format of PIN", Arrays.asList("T.50 Encoding", "Format 2 Pin Block Encoding", "Format 1 Pin Block Encoding", "BCD Encoding"), true, PropertyType.STRING, 4),
    PIN_MAX_LENGTH("KEY_PIN_MAX_LENGTH", "12", "Max length", "edit max length of PIN", Arrays.asList("4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"), true, PropertyType.INT, 5),
    PIN_MIN_LENGTH("KEY_PIN_MIN_LENGTH", "6", "Min length", "edit min length of PIN", Arrays.asList("4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"), true, PropertyType.INT, 6),
    PIN_BLOCK_LENGTH("KEY_PIN_BLOCK_LENGTH", "0", "length of PIN block", "edit length of PIN block", Arrays.asList("-1", "0", "8", "16"), true, PropertyType.INT, 7),
    PIN_BLOCK_FILLER("KEY_PIN_BLOCK_FILLER", "00", "filler of PIN block (hex String)", "edit filler of PIN block (one byte with two nibbles)", Arrays.asList(new String[0]), true, PropertyType.HEXSTRING, 8),
    PIN_INIT("KEY_PIN_INIT", "null", "initialization PIN (hex String)", "edit initialization PIN", null, true, PropertyType.HEXSTRING, 9),
    PIN_MAX_LENGTH_INIT("KEY_PIN_MAX_LENGTH_INIT", "", "Max length (init)", "edit max length of PIN for init", Arrays.asList("", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"), true, PropertyType.INT, 10),
    PIN_MIN_LENGTH_INIT("KEY_PIN_MIN_LENGTH_INIT", "", "Min length (int)", "edit min length of PIN for init", Arrays.asList("", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"), true, PropertyType.INT, 11),
    PINPAD_USABLE_FOR_CHANGE_OF_STRING_PIN_WITH_VARIABLE_LENGTH("KEY_PINPAD_USABLE_FOR_CHANGE_OF_STRING_PIN_WITH_VARIABLE_LENGTH", "false", "pinpad usable for change", "select pinpad usable in case of changing a T.50/String-PIN with variable pin length", Arrays.asList("true", "false"), true, PropertyType.BOOLEAN, 12),
    PINPAD_USABLE_FOR_INIT_OF_STRING_PIN_WITH_VARIABLE_LENGTH("KEY_PINPAD_USABLE_FOR_INIT_OF_STRING_PIN_WITH_VARIABLE_LENGTH", "false", "pinpad usable for init", "select pinpad usable in case of initializing a T.50/String-PIN with variable pin length", Arrays.asList("true", "false"), true, PropertyType.BOOLEAN, 13),
    USED_CURRENT_PIN("KEY_PIN_CURRENT", "111111", "used current PIN", "edit current PIN for verify, as old or as initialization/transport PIN (what you use at Pinpad)", null, true, PropertyType.INT, 14),
    USED_NEW_PIN("KEY_PIN_NEW", "222222", "used new PIN", "edit new PIN for modification (what you use at Pinpad)", null, true, PropertyType.INT, 15),
    PIN_VERIFY_CMD("KEY_PIN_VERIFY_CMD", "", "verify command", "verify command as expected for used settings and PINs", null, false, PropertyType.HEXSTRING, 16),
    PIN_CHANGE_CMD("KEY_PIN_CHANGE_CMD", "", "change command", "change command as expected for used settings and PINs", null, false, PropertyType.HEXSTRING, 17),
    PIN_INIT_CMD("KEY_PIN_INIT_CMD", "", "init command", "init command as expected for used settings and PINs", null, false, PropertyType.HEXSTRING, 18),
    KEYSTORE_USE("KEY_STORE_USE", "true", "use keystore", "use of keystore for signature, decryption and authentication", Arrays.asList("true", "false"), true, PropertyType.BOOLEAN, 19),
    KEYSTORE_FILE("KEY_STORE_FILE", "", "Keystore file", "file for keystore", null, true, PropertyType.STRING, 20),
    KEYSTORE_TYPE("KEY_STORE_TYPE", "JKS", "Keystore type", "type for keystore", Arrays.asList("JKS", "PKCS12"), true, PropertyType.STRING, 21),
    KEYSTORE_PASSWORD("KEY_STORE_PASSWORD", "", "Keystore password", "password for keystore", null, true, PropertyType.STRING, 22);

    private JComponent component = null;
    private JLabel componentLabel = null;
    private String defaultValue = null;
    private boolean editable = true;
    private String key = null;
    private String label = null;
    private String tooltip = null;
    private PropertyType type = null;
    private List<String> valueList = null;
    private final int position = 0;

    private Property(String key, String defaultValue, String label, String tooltip, List<String> valueList, boolean editable, PropertyType type, int position) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.label = label;
        this.tooltip = tooltip;
        this.valueList = valueList;
        this.editable = editable;
        this.type = type;
    }

    public int getPosition() {
        return this.position;
    }

    public JComponent getComponent(String value) {
        if (this.component == null) {
            this.createComponents();
        }
        if (!this.editable) {
            ((JLabel)this.component).setText(value);
        } else if (!CollectionUtil.isNullOrEmpty(this.valueList)) {
            ((JComboBox)this.component).setSelectedItem(value);
        } else {
            ((JTextField)this.component).setText(value);
        }
        return this.component;
    }

    public JLabel getComponentLabel() {
        if (this.component == null) {
            this.createComponents();
        }
        return this.componentLabel;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public List<String> getValueList() {
        return this.valueList;
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void createComponents() {
        if (!this.editable) {
            this.component = new JLabel();
        } else if (!CollectionUtil.isNullOrEmpty(this.valueList)) {
            this.component = new JComboBox<String>(this.valueList.toArray(new String[this.valueList.size()]));
        } else {
            this.component = new JTextField();
            if (PropertyType.INT == this.type) {
                ((JTextField)this.component).addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if ("0123456789".indexOf(e.getKeyChar()) >= 0 || '\b' == e.getKeyChar() || 37 == e.getKeyCode() || 39 == e.getKeyCode() || 36 == e.getKeyCode() || 35 == e.getKeyCode() || 127 == e.getKeyCode()) {
                            super.keyPressed(e);
                        } else {
                            e.consume();
                        }
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                        if ("0123456789".indexOf(e.getKeyChar()) >= 0) {
                            super.keyTyped(e);
                        } else {
                            e.consume();
                        }
                    }
                });
            }
            if (PropertyType.HEXSTRING == this.type) {
                ((JTextField)this.component).addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if ("0123456789abcdef".indexOf(e.getKeyChar()) >= 0 || '\b' == e.getKeyChar() || 37 == e.getKeyCode() || 39 == e.getKeyCode() || 36 == e.getKeyCode() || 35 == e.getKeyCode() || 127 == e.getKeyCode()) {
                            super.keyPressed(e);
                        } else {
                            e.consume();
                        }
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                        if ("0123456789abcdef".indexOf(e.getKeyChar()) >= 0) {
                            super.keyTyped(e);
                        } else {
                            e.consume();
                        }
                    }
                });
            }
        }
        this.component.setToolTipText(this.tooltip);
        this.componentLabel = new JLabel(this.label + ": ");
    }
}

