/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.debug;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.WhirlpoolDigest;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;

public class MCardTestProvider
extends Provider {
    private static final long serialVersionUID = 1L;
    public static final String PROVIDER_NAME = "MCardTestProvider";

    public MCardTestProvider() {
        super(PROVIDER_NAME, 1.0, "Provider used in MCard tests");
        super.put("Signature.SHA224withRAWRSASSA-PSS", RAWPSS_SHA224.class.getName());
        super.put("Signature.SHA256withRAWRSASSA-PSS", RAWPSS_SHA256.class.getName());
        super.put("Signature.SHA384withRAWRSASSA-PSS", RAWPSS_SHA384.class.getName());
        super.put("Signature.SHA512withRAWRSASSA-PSS", RAWPSS_SHA512.class.getName());
        super.put("Signature.MD5withRAWRSASSA-PSS", RAWPSS_MD5.class.getName());
        super.put("Signature.RIPEMD160withRAWRSASSA-PSS", RAWPSS_RIPEMD160.class.getName());
        super.put("Signature.WHIRLPOOLwithRAWRSASSA-PSS", RAWPSS_WHIRLPOOL.class.getName());
        super.put("Signature.MD5withRSA/PSS", PSS_MD5.class.getName());
        super.put("Signature.RIPEMD160withRSA/PSS", PSS_RIPEMD160.class.getName());
        super.put("Signature.WHIRLPOOLwithRSA/PSS", PSS_WHIRLPOOL.class.getName());
    }

    private static class NullPssDigest
    implements Digest {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        private Digest baseDigest;
        private boolean oddTime = true;

        public NullPssDigest(Digest mgfDigest) {
            this.baseDigest = mgfDigest;
        }

        public String getAlgorithmName() {
            return "NULL";
        }

        public int getDigestSize() {
            return this.baseDigest.getDigestSize();
        }

        public void update(byte in) {
            this.bOut.write(in);
        }

        public void update(byte[] in, int inOff, int len) {
            this.bOut.write(in, inOff, len);
        }

        public int doFinal(byte[] out, int outOff) {
            byte[] res = this.bOut.toByteArray();
            if (this.oddTime) {
                System.arraycopy(res, 0, out, outOff, res.length);
            } else {
                this.baseDigest.update(res, 0, res.length);
                this.baseDigest.doFinal(out, outOff);
            }
            this.reset();
            this.oddTime = !this.oddTime;
            return res.length;
        }

        public void reset() {
            this.bOut.reset();
            this.baseDigest.reset();
        }
    }

    private static class PSSSignature
    extends SignatureSpi {
        private PSSSigner pss = null;

        private PSSSignature(String digestAlgo, boolean raw, int saltLength) {
            Digest d = this.getDigest(digestAlgo);
            this.pss = !raw ? new PSSSigner((AsymmetricBlockCipher)new RSABlindedEngine(), d, d, saltLength, -68) : new PSSSigner((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new NullPssDigest(d), d, saltLength, -68);
        }

        private Digest getDigest(String algo) {
            if (algo == "RIPEMD160") {
                return new RIPEMD160Digest();
            }
            if (algo == "WHIRLPOOL") {
                return new WhirlpoolDigest();
            }
            return null;
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            if (!(publicKey instanceof RSAPublicKey)) {
                throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
            }
            RSAPublicKey rsaKey = (RSAPublicKey)publicKey;
            this.pss.init(false, (CipherParameters)new RSAKeyParameters(false, rsaKey.getModulus(), rsaKey.getPublicExponent()));
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            if (!(privateKey instanceof RSAPrivateKey)) {
                throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
            }
            RSAPrivateKey rsaKey = (RSAPrivateKey)privateKey;
            this.pss.init(true, (CipherParameters)new RSAKeyParameters(true, rsaKey.getModulus(), rsaKey.getPrivateExponent()));
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            this.pss.update(b);
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            this.pss.update(b, off, len);
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            try {
                return this.pss.generateSignature();
            }
            catch (CryptoException e) {
                throw new SignatureException(e.getMessage());
            }
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            return this.pss.verifySignature(sigBytes);
        }

        @Override
        protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object engineGetParameter(String param) throws InvalidParameterException {
            throw new UnsupportedOperationException();
        }
    }

    public static class PSS_WHIRLPOOL
    extends PSSSignature {
        public PSS_WHIRLPOOL() {
            super("WHIRLPOOL", false, 64);
        }
    }

    public static class PSS_RIPEMD160
    extends PSSSignature {
        public PSS_RIPEMD160() {
            super("RIPEMD160", false, 20);
        }
    }

    public static class PSS_MD5
    extends PSSSigner {
        public PSS_MD5() {
            super((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new MD5Digest(), (Digest)new MD5Digest(), 16);
        }
    }

    public static class RAWPSS_WHIRLPOOL
    extends PSSSignature {
        public RAWPSS_WHIRLPOOL() {
            super("WHIRLPOOL", true, 64);
        }
    }

    public static class RAWPSS_RIPEMD160
    extends PSSSignature {
        public RAWPSS_RIPEMD160() {
            super("RIPEMD160", true, 20);
        }
    }

    public static class RAWPSS_MD5
    extends PSSSigner {
        public RAWPSS_MD5() {
            super((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new MD5Digest(), (Digest)new MD5Digest(), 16);
        }
    }

    public static class RAWPSS_SHA512
    extends PSSSigner {
        public RAWPSS_SHA512() {
            super((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new SHA512Digest(), (Digest)new SHA512Digest(), 64);
        }
    }

    public static class RAWPSS_SHA384
    extends PSSSigner {
        public RAWPSS_SHA384() {
            super((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new SHA384Digest(), (Digest)new SHA384Digest(), 48);
        }
    }

    public static class RAWPSS_SHA256
    extends PSSSigner {
        public RAWPSS_SHA256() {
            super((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new SHA256Digest(), (Digest)new SHA256Digest(), 32);
        }
    }

    public static class RAWPSS_SHA224
    extends PSSSigner {
        public RAWPSS_SHA224() {
            super((AsymmetricBlockCipher)new RSABlindedEngine(), (Digest)new SHA224Digest(), (Digest)new SHA224Digest(), 28);
        }
    }
}

