/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.cardos;

import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.RSAPadding;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Objects;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.APDU;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CardOS60Standard
extends GovCS {
    public static final byte CMDO_HASH_METHOD_SHA1 = 8;
    public static final byte CMDO_HASH_METHOD_SHA224 = 16;
    public static final byte CMDO_HASH_METHOD_SHA256 = 24;
    public static final byte CMDO_HASH_METHOD_SHA384 = 32;
    public static final byte CMDO_HASH_METHOD_SHA512 = 40;
    public static final byte CMDO_PADDING_PKCS1_V15 = 2;
    public static final String DO_CM_RSA_PKCS1_5 = HexUtil.hexify((byte)-128) + "01" + HexUtil.hexify((byte)2);
    public static final byte CMDO_PADDING_PKCS1_PSS = 7;
    public static final String ALGORITHM_ID_SHA1_RSA_PKCS1_5 = HexUtil.hexify(10);
    public static final String ALGORITHM_ID_SHA224_RSA_PKCS1_5 = HexUtil.hexify(18);
    public static final String ALGORITHM_ID_SHA256_RSA_PKCS1_5 = HexUtil.hexify(26);
    public static final String ALGORITHM_ID_SHA384_RSA_PKCS1_5 = HexUtil.hexify(34);
    public static final String ALGORITHM_ID_SHA512_RSA_PKCS1_5 = HexUtil.hexify(42);
    public static final String ALGORITHM_ID_SHA1_RSA_PSS = HexUtil.hexify(15);
    public static final String ALGORITHM_ID_SHA224_RSA_PSS = HexUtil.hexify(23);
    public static final String ALGORITHM_ID_SHA256_RSA_PSS = HexUtil.hexify(31);
    public static final String ALGORITHM_ID_SHA384_RSA_PSS = HexUtil.hexify(39);
    public static final String ALGORITHM_ID_SHA512_RSA_PSS = HexUtil.hexify(47);
    private static final Log LOG = LogFactory.getLog(CardOS60Standard.class);
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("cb 01")};
    private int historicalsIndex = 0;
    protected final Card.CardTypeEnum cardType;
    public static final String SEID_RSA_OAEP_SHA256 = "32";
    public static final String SEID_RSA_OAEP_SHA384 = "33";
    public static final String SEID_RSA_OAEP_SHA512 = "34";
    public static final String SEID_RSA_PKCS1_5 = "31";

    protected final void selectForPin(OCFCertificateInfo _info, CardChannel cardChannel) throws ResponseCodeException, CardTerminalException {
        if (_info.getPinID() == -127) {
            this.selectSubDirectory(cardChannel, _info.getPin().getParentApplication().getFileEntry().getDirectory());
        } else {
            this.selectSubDirectory(cardChannel, _info.getKey().getParentApplication().getFileEntry().getDirectory());
        }
    }

    public CardOS60Standard(Card.CardTypeEnum cardType) {
        this.cardType = cardType == null ? Card.CardTypeEnum.UNKNOWN_CARDOS50 : cardType;
    }

    @Override
    protected final byte[] getHistoricals() {
        return HISTORICALS[this.historicalsIndex];
    }

    @Override
    protected final boolean historicalsEquals(byte[] _historicals) {
        if (Objects.isNull(_historicals)) {
            return false;
        }
        this.historicalsIndex = -1;
        for (int i = 0; i < HISTORICALS.length; ++i) {
            byte[] historicals = HISTORICALS[i];
            if (historicals.length != _historicals.length) continue;
            boolean diff = false;
            for (int j = 0; j < _historicals.length && !diff; ++j) {
                diff = historicals[j] != _historicals[j];
            }
            if (diff) continue;
            this.historicalsIndex = i;
            break;
        }
        return this.historicalsIndex >= 0 && this.historicalsIndex < HISTORICALS.length;
    }

    protected final Card.CardTypeEnum getCardTypeEnum() {
        return this.cardType;
    }

    @Override
    protected final OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    @Override
    protected final String getOSName() {
        return "CardOS 5.0";
    }

    @Override
    protected final int getMaximumChunkSize() {
        return 240;
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    protected final void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException, InvalidCardChannelException, RetryCounterExpiredException {
        return super.isKeyInitialized(_channel, _info);
    }

    @Override
    protected final int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = CardOS60Standard.getPinNameForInfo(_info);
        if (!this.isKeyInitialized(_info)) {
            throw new NotYetInitializedException(pinName, 27013, "password not initialized");
        }
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        LOG.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                byte se = HexUtil.parse(SEID_RSA_PKCS1_5)[0];
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)-13, se, null);
            }
            case 0: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length);
                    data.write(_info.getKeyID().getID());
                    byte[] algorithm = HexUtil.parse(ALGORITHM_ID_SHA256_RSA_PKCS1_5);
                    try {
                        CardExecutionSignAuthenticateParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                        algorithm = parameterSpec.getAlgorithmID();
                    }
                    catch (InvalidParameterSpecException e) {
                        LOG.debug((Object)e);
                    }
                    data.write(-128);
                    data.write(algorithm.length);
                    data.write(algorithm);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, "MSE failed");
                }
            }
            case 2: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length);
                    data.write(_info.getKeyID().getID());
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, "MSE failed");
                }
            }
        }
        return null;
    }

    @Override
    protected final GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException {
        int i;
        APDU cmd = null;
        ResponseAPDU res = null;
        try (ByteArrayOutputStream os2 = new ByteArrayOutputStream();){
            os2.write(0);
            os2.write(42);
            os2.write(-128);
            os2.write(-122);
            os2.write(0);
            os2.write((byte)(_encryptedBytes.length + 1 >> 8));
            os2.write((byte)(_encryptedBytes.length + 1 & 0xFF));
            os2.write(this.getPaddingIndicator());
            os2.write(_encryptedBytes, 0, _encryptedBytes.length);
            os2.write(1);
            os2.write(0);
            cmd = new CommandAPDU(os2.toByteArray());
        }
        catch (IOException os2) {
            // empty catch block
        }
        LOG.debug((Object)("DECRYPT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU((CommandAPDU)cmd);
        if ((this.ctReference.getName().toLowerCase().contains("omnikey") || this.ctReference.getName().toLowerCase().contains("XX44")) && PCSCCardTerminal.class.isInstance(this.ctReference)) {
            try {
                ((PCSCCardTerminal)this.ctReference).resetSlot(0);
            }
            catch (CardTerminalException e) {
                LOG.debug((Object)("reset of slot failed: " + e.getMessage()));
            }
        }
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("DECRYPT RESULT : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        byte[] b = (byte[])ro.getResultData();
        if (b == null || b.length < 3) {
            return ro;
        }
        if (b.length % 8 != 0) {
            b = ByteUtil.combine(new byte[]{0}, b);
        }
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    @Override
    protected CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -122;
        store[3] = -128;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    public synchronized void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 22 f3 01")));
            channel.setState(null);
        }
        catch (Exception e) {
            LOG.debug((Object)("reset failed: " + e.getMessage()));
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized GovCS.ResultObject signHashServer(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (this.getAvailableHashAlgorithmNames(_info).indexOf(_hashAlgorithm) < 0) {
            throw new ResponseCodeException(65535, "hash algorithm not supported by card: " + _hashAlgorithm, new NoSuchAlgorithmException("OperationCancelledException"));
        }
        ProgressSession session = new ProgressSession(2);
        session.setStepCount(6);
        session.setProgressMessage("init sign hash operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        CardChannelManager cm = new CardChannelManager();
        try {
            cm.init(this, true, false);
            boolean localTransaction = cm.isTransactionLocallyStarted();
            try {
                this.checkSignCounter(null, localTransaction);
            }
            catch (MaxSignatureCountReachedException e) {
                cm.allocate();
                this.resetCard(cm.getCardChannel());
                throw e;
            }
            GovCS.ResultObject ro = this.signHashServerInt(_info, _hashValue, _pin, _hashAlgorithm, session, algorithmParameters);
            if (ro.getResultCode() == 36864) {
                try {
                    this.increaseAndCheckSignCounter(null, localTransaction);
                }
                catch (MaxSignatureCountReachedException e) {
                    cm.allocate();
                    this.resetCard(cm.getCardChannel());
                }
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cm.destroy();
        }
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        try {
            CardExecutionSignAuthenticateParameterSpec sps = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
            String algorithmName = sps.getAlgorithmName();
            if (algorithmName.contains("/PSS") || algorithmName.contains("andMGF1")) {
                return super.signHash(_channel, _info, RSAPadding.padPKCS1PSS(_info.getX509Certificate().getPublicKey(), _hashAlgorithm, _hashValue), _hashAlgorithm, algorithmParameters);
            }
            return super.signHash(_channel, _info, RSAPadding.padPKCS1V15(_info.getX509Certificate().getPublicKey(), _hashAlgorithm, _hashValue), _hashAlgorithm, algorithmParameters);
        }
        catch (InvalidParameterSpecException e) {
            throw new ResponseCodeException(e.getMessage());
        }
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && this.isStapleSign() || OCFProvider.Settings.getInstance().isServerEnvironmentActive() && this.isMultiSign()) {
            return this.signHashServer(_info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
        }
        return super.signHash(_info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final GovCS.ResultObject signHashServerInt(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, ProgressSession session, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        GovCS.ResultObject ro = new GovCS.ResultObject();
        CardChannelManager cardChannelManager = new CardChannelManager();
        CardChannel channel = null;
        try {
            this.fireProgressEvent(session, "get connection to the device");
            channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!this.checkChannelState(channel, _info)) {
                this.selectForPin(_info, channel);
            }
            boolean loop = true;
            this.fireProgressEvent(session, "install corresponding security environment");
            ro = this.setSecurityEnvironment(channel, _info, 0, _hashAlgorithm, algorithmParameters);
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                GovCS.ResultObject resultObject = ro;
                return resultObject;
            }
            while (loop) {
                this.fireProgressEvent(session, "sign the given hash value");
                ro = this.signHash(channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
                if (ro.getResultCode() == 27010) {
                    this.resetChannelState(channel);
                    try {
                        this.checkSignCounter(channel, false);
                    }
                    catch (MaxSignatureCountReachedException e) {
                        LOG.debug((Object)"maximum of signatures reached - never happens in server mode and method");
                    }
                    this.selectFile(channel, _info, false);
                    this.fireProgressEvent(session, "verify the corresponding password");
                    ro.setResultCode(this.verifyPassword(channel, _info, _pin));
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    this.fireProgressEvent(session, "install corresponding security environment");
                    ro = this.setSecurityEnvironment(channel, _info, 0, _hashAlgorithm, algorithmParameters);
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    loop = true;
                    continue;
                }
                this.fireProgressEvent(session, "operation finished!");
                loop = false;
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    @Override
    protected CommandAPDU createSignHashCommand(byte[] hashValue, AlgorithmParameters algorithmParameters, OCFCertificateInfo info) {
        return this.createSignHashCommand(hashValue, algorithmParameters);
    }

    @Override
    protected CommandAPDU createSignHashCommand(byte[] hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[]{0, 42, -98, -102};
        return new GISOCommandAPDU(true, store, hashValue, 0);
    }
}

