/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.cardos;

import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.ChannelState;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS60;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS60Util;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CardOS60DTrust54
extends CardOS60 {
    private static final Integer INIT_LENGTH = 6;
    private static final Log LOG = LogFactory.getLog(CardOS60DTrust54.class);
    private final String displayName;
    private final String tokenLabel;
    private final boolean stapleSign;
    private final boolean multiSign;
    private final boolean issuerReadRequired;

    public CardOS60DTrust54(String displayName, String issuerConstant, boolean stapleSign, boolean multiSign, Card.CardTypeEnum cardType, boolean issuerReadRequired) {
        this(displayName, issuerConstant, stapleSign, multiSign, cardType, issuerReadRequired, false);
    }

    public CardOS60DTrust54(String displayName, String issuerConstant, boolean stapleSign, boolean multiSign, Card.CardTypeEnum cardType, boolean issuerReadRequired, boolean isRsa) {
        super(cardType, isRsa);
        this.displayName = displayName;
        this.tokenLabel = issuerConstant;
        this.stapleSign = stapleSign;
        this.multiSign = multiSign;
        this.issuerReadRequired = issuerReadRequired;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return this.issuerReadRequired;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    @Override
    public final Integer getStapleSignCounter() {
        Integer result = this.stapleSign ? Integer.valueOf(100) : (this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null);
        return result;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 3;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000002L});
        CardApplication applicationCerts = this.createCertsApp(terminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationQSign = this.createQSignApp(terminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationESign = this.createESignApp(terminal, pSlotID, idOfCard, idOfMFApplication);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationCerts);
        mfManager.putApplication(applicationQSign);
        mfManager.putApplication(applicationESign);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        return new CardImpl(this.getDisplayName() + "-" + idOfCard, idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
    }

    private CardApplication createCertsApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        long idOfApplication = 1000001L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        FileReference refSigCerRCA = new FileReference(8, "01030203");
        FileReference refSigCerCA = new FileReference(8, "01030202");
        FileEntry fileEntrySigCerRCA = new FileEntry(refSigCerRCA, refSigCerRCA);
        FileEntry fileEntrySigCerCA = new FileEntry(refSigCerCA, refSigCerCA);
        OCFCertificateInfo infoSigCerRCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile01, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo infoSigCerCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl fileSigCerRCA = new CardFileImpl(Disposeable.NO_LOCK, "cerSigRCA", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntrySigCerRCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoSigCerRCA);
        CardFileImpl fileSigCerCA = new CardFileImpl(Disposeable.NO_LOCK, "cerSigCA", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntrySigCerCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoSigCerCA);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("0103", idOfApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntrySigCerRCA, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileSigCerRCA);
        applicationApp.putFile(fileSigCerCA);
        FileReference refAutCerRCA = new FileReference(8, "01030206");
        FileReference refAutCerCA = new FileReference(8, "01030205");
        FileEntry fileEntryAutCerRCA = new FileEntry(refAutCerRCA, refAutCerRCA);
        FileEntry fileEntryAutCerCA = new FileEntry(refAutCerCA, refAutCerCA);
        OCFCertificateInfo infoAutCerRCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo infoAutCerCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile04, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl fileAutCerRCA = new CardFileImpl(Disposeable.NO_LOCK, "cerAutRCA", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryAutCerRCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoAutCerRCA);
        CardFileImpl fileAutCerCA = new CardFileImpl(Disposeable.NO_LOCK, "cerAutCA", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryAutCerCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoAutCerCA);
        applicationApp.putFile(fileAutCerRCA);
        applicationApp.putFile(fileAutCerCA);
        return applicationApp;
    }

    protected CardApplication createQSignApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        long idOfApplication = 1000002L;
        long idOfFile01 = 3000005L;
        long idOfPin01 = 2000002L;
        long idOfKey01 = 4000001L;
        FileReference dirRefApp = new FileReference(4, "D2 76 00 00 66 01");
        FileReference refCer = new FileReference(8, "01030201");
        FileEntry fileEntryCer = new FileEntry(dirRefApp, refCer);
        OCFCertificateInfo infoCer = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl fileCer = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01, infoCer);
        byte pinID = -121;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "QES Signature PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        KeyID k01 = new KeyID("0c");
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "QES SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.EUROPEAN_QUALIFIED_SIGNATURE.getType()}), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), infoCer, idOfFile01, idOfPin01, k01);
        if (this.isRsa) {
            key01.setAlgorithmProvider(CardOS60Util.createDefaultRSAAlgorithmProviderSignature());
        } else {
            key01.setAlgorithmProvider(CardOS60Util.createDefaultECAlgorithmProviderSignature("SHA384", "22"));
        }
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("0101", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntryCer, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileCer);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    protected CardApplication createESignApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        long idOfApplication = 1000003L;
        long idOfFile01 = 3000006L;
        long idOfPin01 = 2000003L;
        long idOfKey01 = 4000002L;
        FileReference dirRefApp = new FileReference(4, "A0 00 00 01 67 45 53 49 47 4e");
        FileReference refCer = new FileReference(8, "01030204");
        FileEntry fileEntryCer = new FileEntry(dirRefApp, refCer);
        OCFCertificateInfo infoCer = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl fileCer = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01, infoCer);
        byte pinID = -111;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentication PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        KeyID k01 = new KeyID("0c");
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), infoCer, idOfFile01, idOfPin01, k01);
        if (this.isRsa) {
            key01.setAlgorithmProvider(CardOS60Util.createDefaultRSAAlgorithmProviderDecryptionEncryptionAuthentication());
        } else {
            key01.setAlgorithmProvider(CardOS60Util.createDefaultECAlgorithmProviderDecryptionEncryptionAuthentication("SHA384", "22"));
        }
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("0102", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntryCer, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileCer);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo info) {
        return INIT_LENGTH;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo info) {
        return INIT_LENGTH;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo info) {
        return -1;
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo info) {
        return PinEncoder.ENCODER_T50;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo info) {
        return -1;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo info) {
        return 12;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo info) {
        ArrayList<String> c = new ArrayList<String>();
        c.add("SHA384");
        if (this.isRsa) {
            c.add("SHA256");
            c.add("SHA512");
        }
        return c;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel channel, OCFCertificateInfo info, int type, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException {
        byte se = HexUtil.parse("01")[0];
        switch (type) {
            case 0: 
            case 2: {
                try {
                    CardExecutionSignAuthenticateParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                    byte[] algorithmID = parameterSpec.getAlgorithmID();
                    if (algorithmID != null && algorithmID.length == 1) {
                        se = algorithmID[0];
                        return APDUCommands.createManageSecurityEnvironmentCommand((byte)-13, se, null);
                    }
                }
                catch (InvalidParameterSpecException e) {
                    LOG.debug((Object)e);
                }
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)-13, se, null);
            }
            case 1: {
                try {
                    byte[] algorithmID = null;
                    if (this.isRsa) {
                        CardExecutionDecryptRSAParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionDecryptRSAParameterSpec.class);
                        if (parameterSpec != null) {
                            algorithmID = parameterSpec.getAlgorithmID();
                        }
                    } else {
                        algorithmID = HexUtil.parse("39");
                    }
                    if (algorithmID != null && algorithmID.length == 1) {
                        se = algorithmID[0];
                        return APDUCommands.createManageSecurityEnvironmentCommand((byte)-13, se, null);
                    }
                }
                catch (InvalidParameterSpecException e) {
                    LOG.debug((Object)e);
                }
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)-13, se, null);
            }
        }
        return super.createMSECommand(channel, info, type, hashAlgorithm, algorithmParameters);
    }

    @Override
    protected final CommandAPDU createSignHashCommand(byte[] hashValue, AlgorithmParameters algorithmParameters) {
        if (hashValue != null && hashValue.length >= 20) {
            return new GISOCommandAPDU(true, (byte)0, (byte)42, (byte)-98, (byte)-102, hashValue, 384);
        }
        throw new UnsupportedOperationException("something went wrong");
    }

    @Override
    protected final GovCS.ResultObject authentify(CardChannel channel, OCFCertificateInfo info, byte[] hashValue, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException, OperationCancelledException {
        return this.signHash(channel, info, hashValue, hashAlgorithm, algorithmParameters);
    }

    @Override
    protected void resetCard(CardChannel channel) {
        try {
            LOG.debug((Object)"reset of card");
            this.selectMasterFile(channel);
            CommandAPDU c = new CommandAPDU(HexUtil.parse("0022f300"));
            LOG.debug((Object)("RESET CMD: " + HexUtil.hexify(c.getBytes())));
            ResponseAPDU r = this.sendCommandAPDU(channel, c);
            LOG.debug((Object)("RESET RSP: " + HexUtil.hexify(r.getBytes())));
            LOG.debug((Object)"reset of card finished");
            ChannelState channelState = this.getChannelState(channel);
            if (channelState != null) {
                channelState.resetCurrentSignCount();
            }
        }
        catch (Exception t) {
            LOG.debug((Object)("reset of card failed: " + t.getMessage()), (Throwable)t);
        }
    }

    @Override
    public synchronized void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            this.sendCommandAPDU(channel, new CommandAPDU(HexString.parseHexString("00 22 f3 00")));
            channel.setState(null);
        }
        catch (Exception e) {
            LOG.debug((Object)("reset failed: " + e.getMessage()));
        }
        finally {
            cardChannelManager.destroy();
        }
    }
}

