/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.cardos;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.crypto.AlgorithmIdentifierHelper;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.DefaultBaseAlgorithmProviderBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFDefaultAlgorithmFinder;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS60Standard;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class CardOS60DRV3
extends CardOS60Standard {
    private static final String DEFAULT_HASH_ALGORITHM = "SHA512";
    private static final Integer INIT_LENGTH = 6;
    private static final Log LOG = LogFactory.getLog(CardOS60DRV3.class);
    private static final String SEID_SHA256_RSA_PKCS1_5 = "04";
    private static final String SEID_SHA256_RSA_PSS = "09";
    private static final String SEID_SHA384_RSA_PSS = "0a";
    private static final String SEID_SHA512_RSA_PSS = "0b";
    private final String displayName;
    private final String tokenLabel;
    private final boolean stapleSign;
    private final boolean multiSign;
    private final boolean issuerReadRequired;
    public static final String SEID_RSA_OAEP_SHA256 = "32";
    public static final String SEID_RSA_OAEP_SHA384 = "33";
    public static final String SEID_RSA_OAEP_SHA512 = "34";
    public static final String SEID_RSA_PKCS1_5 = "31";

    public CardOS60DRV3(String displayName, String issuerConstant, boolean stapleSign, boolean multiSign, Card.CardTypeEnum cardType, boolean issuerReadRequired) {
        super(cardType);
        this.displayName = displayName;
        this.tokenLabel = issuerConstant;
        this.stapleSign = stapleSign;
        this.multiSign = multiSign;
        this.issuerReadRequired = issuerReadRequired;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return this.issuerReadRequired;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    @Override
    protected final String readIssuerFromATR(CardChannel channel) {
        String readPKCS15TokenInfoString = super.readPKCS15TokenInfoFromCard(channel);
        LOG.debug((Object)("EF.TokenInfo: " + readPKCS15TokenInfoString));
        if (readPKCS15TokenInfoString != null && readPKCS15TokenInfoString.contains(this.tokenLabel)) {
            return this.tokenLabel;
        }
        return null;
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSign ? 100 : (this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null);
    }

    @Override
    protected Card createCardInt(Terminal terminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 1;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L});
        CardApplication applicationData = this.createDataApp(terminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationSign = this.createSignApp(terminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationEncDec = null;
        CardApplication applicationAut = null;
        if (!this.multiSign) {
            applicationEncDec = this.createEncDecApp(terminal, pSlotID, idOfCard, idOfMFApplication, idOfPin);
            applicationAut = this.createAutApp(terminal, pSlotID, idOfCard, idOfMFApplication, idOfPin);
        }
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationData);
        mfManager.putApplication(applicationSign);
        if (!this.multiSign) {
            mfManager.putApplication(applicationEncDec);
            mfManager.putApplication(applicationAut);
            mfManager.putPin(pin);
        }
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createDataApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        long idOfApplication = 1000001L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        FileReference refSigCerRCA = new FileReference(8, "501543057402");
        FileReference refEncDecAutCerRCA = new FileReference(8, "501543057401");
        FileReference refCerCA = new FileReference(8, "501543044304");
        FileEntry fileEntrySigCerRCA = new FileEntry(refSigCerRCA, refSigCerRCA);
        FileEntry fileEntryEncDecAutCerRCA = new FileEntry(refEncDecAutCerRCA, refEncDecAutCerRCA);
        FileEntry fileEntryEncDecAutCerCA = new FileEntry(refCerCA, refCerCA);
        OCFCertificateInfo infoSigRCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo infoEncDecAutRCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile01, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo infoEncDecAutCerCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl fileSigCerRCA = new CardFileImpl(Disposeable.NO_LOCK, this.multiSign ? "dummy" : "cerSigRCA", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntrySigCerRCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoSigRCA);
        CardFileImpl fileEncDecAutCerRCA = new CardFileImpl(Disposeable.NO_LOCK, this.multiSign ? "cerSigRCA" : "cerEncDecAutRCA", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryEncDecAutCerRCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoEncDecAutRCA);
        CardFileImpl fileEncDecAutCerCA = new CardFileImpl(Disposeable.NO_LOCK, this.multiSign ? "cerEncDecAutRCA" : "cerEncDecAutCA", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryEncDecAutCerCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoEncDecAutCerCA);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("50154305", idOfApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryEncDecAutCerRCA, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileSigCerRCA);
        applicationApp.putFile(fileEncDecAutCerRCA);
        applicationApp.putFile(fileEncDecAutCerCA);
        return applicationApp;
    }

    protected CardApplication createSignApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        long idOfApplication = 1000002L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000004L;
        long idOfFile02 = 3000005L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID(SEID_SHA256_RSA_PSS);
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(4, "D2 76 00 00 66 01");
        FileReference refCer = new FileReference(8, "501543044301");
        FileReference refCerCA = new FileReference(8, this.multiSign ? "501543044302" : "501543044305");
        FileEntry fileEntryCer = new FileEntry(dirRefApp, refCer);
        FileEntry fileEntryCerCA = new FileEntry(dirRefApp, refCerCA);
        OCFCertificateInfo infoCer = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo infoCerCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl fileCer = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01, infoCer);
        CardFileImpl fileCerCA = new CardFileImpl(Disposeable.NO_LOCK, "cerSigCA", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryCerCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoCerCA);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signature PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), infoCer, idOfFile01, idOfPin01, k01);
        key01.setAlgorithmProvider(this.createDefaultAlgorithmProviderSignature());
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("1fff", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntryCer, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileCer);
        applicationApp.putFile(fileCerCA);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private CardApplication createEncDecApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000003L;
        long idOfFile01 = 3000006L;
        long idOfKey01 = 4000002L;
        KeyID k = new KeyID("03");
        FileReference dirRefApp = new FileReference(8, "501550724B03");
        FileReference refCer = new FileReference(8, "501543044303");
        FileEntry fileEntryCer = new FileEntry(dirRefApp, refCer);
        OCFCertificateInfo infoCer = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl fileCer = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDec", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01, infoCer);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), infoCer, idOfFile01, idOfPinCH, k);
        key.setAlgorithmProvider(this.createDefaultAlgorithmProviderDecryption());
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724B03", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType()}), fileEntryCer, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileCer);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private CardApplication createAutApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000004L;
        long idOfFile01 = 3000007L;
        long idOfKey01 = 4000003L;
        KeyID k = new KeyID("02");
        FileReference dirRefApp = new FileReference(8, "501550724B02");
        FileReference refCer = new FileReference(8, "501543044302");
        FileEntry fileEntryCer = new FileEntry(dirRefApp, refCer);
        OCFCertificateInfo infoCer = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl fileCer = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_DECRYPTION.getType()}), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), infoCer, idOfFile01, idOfPinCH, k);
        key.setAlgorithmProvider(this.createDefaultAlgorithmProviderAuthentication());
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724B01", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntryCer, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileCer);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderDecryption() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.CIPHER);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        OCFDefaultAlgorithmFinder finder = OCFDefaultAlgorithmFinder.getInstance();
        try {
            String algorithmRSAOAEP = "RSA/NONE/OAEPWithSHA512AndMGF1Padding";
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList01, algorithmRSAOAEP, "RSA/ECB/OAEP-SHA512", new CardExecutionDecryptRSAParameterSpec(algorithmRSAOAEP, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (ASN1Encodable)AlgorithmIdentifierHelper.createRSAOAEPByHashAlgorithm(DEFAULT_HASH_ALGORITHM)), finder.findURI(algorithmRSAOAEP), null, null)));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    private AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderSignature() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.SIGNATURE);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPSSAlgorithms(Arrays.asList("SHA256", DEFAULT_HASH_ALGORITHM, "SHA384"), Arrays.asList(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE), Arrays.asList(SEID_SHA256_RSA_PSS, SEID_SHA512_RSA_PSS, SEID_SHA384_RSA_PSS), usageList01));
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPKCS1Algorithms(Arrays.asList("SHA256"), Arrays.asList(Boolean.TRUE), Arrays.asList(SEID_SHA256_RSA_PKCS1_5), usageList01));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    private AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderAuthentication() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.AUTHENTICATION, UsageRelated.Usage.SIGNATURE);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPKCS1Algorithms(Arrays.asList("SHA256", "SHA384", DEFAULT_HASH_ALGORITHM), Arrays.asList(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE), Arrays.asList(null, null, null), usageList01));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_T50;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo info) {
        return 12;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA384");
            c.add(DEFAULT_HASH_ALGORITHM);
            c.add("SHA256");
        }
        return c;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 0: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length);
                    data.write(HexUtil.parse(SEID_RSA_PKCS1_5));
                    byte se = 4;
                    try {
                        CardExecutionSignAuthenticateParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                        byte[] algorithmID = parameterSpec.getAlgorithmID();
                        if (algorithmID != null && algorithmID.length == 1) {
                            se = algorithmID[0];
                        }
                    }
                    catch (InvalidParameterSpecException e) {
                        LOG.debug((Object)e);
                    }
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)-13, se, null);
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, "MSE failed");
                }
            }
        }
        return super.createMSECommand(_channel, _info, _type, _hashAlgorithm, algorithmParameters);
    }
}

