/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.cardos;

import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.terminal.pcsc.PaceConstants;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.CharUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1Util;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFPinRelatedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.SecureCard;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CanPukRequestDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVConfiguration;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.SMCard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.SMGovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PACE;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PaceInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PacePlusOutputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PacePlusResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.SimplePACETrustedChannelWithCAN;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.CardErrorUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.RSAPadding;
import de.bos_bremen.gov2.jca_provider.ocf.channel.SecureMessaging;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AESKeyMaterialImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AESSecureMessagingImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.AESEncSSCIvParameterSpecImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.utils.AESCrypter;
import de.bos_bremen.gov2.jca_provider.utils.MCardProperties;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Strings;

public abstract class CardOS60
extends SMGovCS
implements SecureCard,
SMCard {
    public static final int LENGTH_CAN = 6;
    public static final byte PINID_CAN = 2;
    public static final String PWD_NAME_CAN = "CAN";
    private static final String ERROR_MESSAGE_MSE_FAILED = "MSE failed";
    private static final String ERROR_MESSAGE_NO_RESPONSE = "no_response";
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("CB 01")};
    private static final Log LOG = LogFactory.getLog(CardOS60.class);
    protected final Card.CardTypeEnum cardType;
    protected final boolean isRsa;
    private SecurityInfos cardAccess;
    private SecureCard.SecurityProtocol currentSecurityProtocol;
    private int historicalsIndex = 0;
    private AESCrypter aesCanCrypter;
    private boolean forcePinpad = false;

    public CardOS60(Card.CardTypeEnum cardType, boolean isRsa) {
        this.cardType = cardType == null ? Card.CardTypeEnum.UNKNOWN_CARDOS60 : cardType;
        this.isRsa = isRsa;
        try {
            this.aesCanCrypter = new AESCrypter(new HexBinaryAdapter().unmarshal("1CE46C9B55284FF673BCFE12B4575465D0D769E8698BD7022E42CBD9C84CFB85"));
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected static SecurityInfos readEFCardAccess(CardChannel cardChannel) throws InternalError {
        SecurityInfos result;
        try {
            result = CardOS60.readEFCardAccessInt(cardChannel, "011c", false);
        }
        catch (Exception e) {
            throw new InternalError("Unable to read EF.CardAccess");
        }
        return result;
    }

    protected static SecurityInfos readEFCardAccessInt(CardChannel cardChannel, String fid, boolean exception) throws IOException {
        AssertUtil.notNullOrEmpty(fid, "file ID of EF.CardAccess");
        try {
            byte[] fileBytes = CardOS60.readFileRaw(cardChannel, fid, "EF.CardAccess");
            SecurityInfos result = new SecurityInfos(fileBytes);
            result = (SecurityInfos)result.decode(result);
            return result;
        }
        catch (IOException t) {
            if (exception) {
                throw t;
            }
            return null;
        }
    }

    protected static byte[] readFileRaw(CardChannel cardChannel, String fid, String filenameText) throws IOException {
        int blockSize = 208;
        LOG.debug((Object)("Read " + filenameText));
        CommandAPDU selectEFCardAccess = EPAUtil.commandFromString("00a4020c", fid, null);
        CommandAPDU readLength = EPAUtil.commandFromString("00b00000", null, "08");
        ResponseAPDU response = cardChannel.sendCommandAPDU(selectEFCardAccess);
        EPAUtil.logCommand(LOG, "Select " + filenameText, selectEFCardAccess, response);
        response = cardChannel.sendCommandAPDU(readLength);
        EPAUtil.logCommand(LOG, "Read length of " + filenameText, readLength, response);
        long l = ASN1Util.getEncodedLength(response.data()).longValue();
        LOG.info((Object)("Length determined as " + l + " bytes."));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while ((long)i < l) {
            int bl = blockSize;
            if (l - (long)i < (long)blockSize) {
                bl = (int)(l - (long)i);
            }
            readLength = EPAUtil.commandFromString("00b0" + HexUtil.hexify((byte)(i / 256)) + HexUtil.hexify((byte)(i % 256)) + HexUtil.hexify((byte)bl));
            response = cardChannel.sendCommandAPDU(readLength);
            EPAUtil.logCommand(LOG, "Read " + filenameText, readLength, response);
            baos.write(response.data());
            i += blockSize;
        }
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SecureCard.SecurityProtocolResult<? extends Object> allocateSecureContext(SecureCard.SecurityProtocol securityProtocol, SecureCard.SecurityProtocolParameter securityParameters) throws CardServiceException, CardTerminalException {
        PacePlusResult result;
        LOG.debug((Object)"allocateSecureContext()");
        LOG.debug((Object)("hasPinPad: " + this.hasPinPad()));
        LOG.debug((Object)("isKeyBoardAllowed: " + this.isKeybordAllowed()));
        LOG.debug((Object)("useKeyboard: " + this.useKeyboard()));
        if (this.getPACEReader() != null) {
            return this.establishPaceChannelWithTerminal((PaceInputParameters)securityParameters, true);
        }
        LOG.debug((Object)"establishPaceChannelWithKeyboard()");
        if (securityProtocol != SecureCard.SecurityProtocol.EAC2_PACE) {
            throw new IllegalArgumentException("not supported protocol used: " + securityProtocol);
        }
        if (!securityProtocol.getParameterClass().isInstance(securityParameters)) {
            throw new IllegalArgumentException("given security parameters are no PaceInputParameters");
        }
        if (this.hasPinPad()) {
            LOG.info((Object)"no PACE reader with pinpad - deactivate pinpad, can not be used after PACE");
            this.pinpad = false;
        }
        LOG.debug((Object)("hasPinPad: " + this.hasPinPad()));
        LOG.debug((Object)("isKeyBoardAllowed: " + this.isKeybordAllowed()));
        LOG.debug((Object)("useKeyboard: " + this.useKeyboard()));
        CardChannelManager cm = new CardChannelManager();
        try {
            CardChannel cardChannel = cm.init(this, true, true);
            this.selectMasterFile(cardChannel);
            String key = this.buildMCardPropertiesKey(cardChannel, ".CAN");
            this.cardAccess = CardOS60.readEFCardAccess(cardChannel);
            MCardProperties mp = MCardProperties.getInstance();
            char[] canChar = this.retrieveCan(mp, key, securityParameters, true);
            SimplePACETrustedChannelWithCAN pace = new SimplePACETrustedChannelWithCAN();
            boolean success = pace.executePACE(cardChannel, this.cardAccess, canChar);
            if (success) {
                AESEncSSCIvParameterSpecImpl ssc = new AESEncSSCIvParameterSpecImpl(new byte[16], false, pace.getEncKey());
                AESKeyMaterialImpl smKeyMaterial = new AESKeyMaterialImpl(pace.getEncKey(), pace.getMacKey(), ssc);
                AESSecureMessagingImpl sm = new AESSecureMessagingImpl(smKeyMaterial);
                super.setSM(sm);
                LOG.info((Object)"ok, secure messaging/PACE setup");
                this.currentSecurityProtocol = SecureCard.SecurityProtocol.EAC2_PACE;
                result = new PacePlusResult(new PacePlusOutputParameters());
                mp.put(key, new HexBinaryAdapter().marshal(this.aesCanCrypter.encrypt(Strings.toUTF8ByteArray((String)new String(canChar)))));
            } else {
                mp.remove(key);
                result = new PacePlusResult(new OperationCancelledException(PWD_NAME_CAN, 25601, "PACE failed"));
            }
        }
        catch (Exception e) {
            result = new PacePlusResult(e);
        }
        finally {
            cm.destroy();
        }
        return result;
    }

    private char[] retrieveCan(MCardProperties mp, String key, SecureCard.SecurityProtocolParameter securityParameters, boolean requestCan) throws OperationCancelledException {
        char[] canChar = null;
        if (mp.containsKey(key)) {
            try {
                canChar = Strings.fromUTF8ByteArray((byte[])this.aesCanCrypter.decrypt(new HexBinaryAdapter().unmarshal((String)mp.get(key)))).toCharArray();
            }
            catch (Exception e) {
                canChar = null;
                mp.remove(key);
                LOG.debug((Object)("remove key: " + key + " - " + e.getMessage()));
            }
        } else {
            LOG.debug((Object)"CAN: not cached");
        }
        if (requestCan && canChar == null) {
            LOG.debug((Object)"requestCAN ...");
            canChar = this.requestCAN(securityParameters);
            LOG.debug((Object)"requestCAN ... finished");
        } else if (!requestCan) {
            LOG.debug((Object)"requestCAN ... deactivated");
        }
        if (canChar != null) {
            LOG.debug((Object)("CAN: " + new String(canChar)));
        }
        return canChar;
    }

    private char[] requestCAN(SecureCard.SecurityProtocolParameter securityParameters) throws OperationCancelledException {
        char[] canChar = ((PaceInputParameters)securityParameters).getSecretValue();
        if (canChar == null || canChar.length == 0) {
            canChar = CanPukRequestDialog.requestUserAuthenticationCode(OCFCertificateInfo.Usage.EID_CAN_NOT_FORCED, BDialogMode.EID_CAN, this.getCardTerminal().getName(), 6);
        }
        if (Objects.isNull(canChar)) {
            throw new OperationCancelledException(PWD_NAME_CAN, 25601, "PIN-Eingabe abgebrochen");
        }
        return canChar;
    }

    @Override
    public synchronized GovCS.ResultObject authentify(CardKey key, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        return this.authentify(key.getInfo(), hashValue, pin, hashAlgorithm, algorithmParameters);
    }

    @Override
    public synchronized GovCS.ResultObject authentify(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, OperationCancelledException, CardTerminalException {
        boolean transactionStarted = false;
        try {
            transactionStarted = this.beginTransaction();
            this.doPaceWhenRequired();
            GovCS.ResultObject resultObject = super.authentify(info, hashValue, pin, hashAlgorithm, algorithmParameters);
            return resultObject;
        }
        catch (CardTerminalException e) {
            this.doReset(27016);
            throw e;
        }
        catch (NotYetInitializedException | OperationCancelledException | ResponseCodeException | RetryCounterExpiredException | WrongPinException e) {
            this.doReset(e.getErrorCode());
            throw e;
        }
        finally {
            this.endTransaction(transactionStarted);
        }
    }

    @Override
    public synchronized GovCS.ResultObject decrypt(CardKey key, byte[] encryptedBytes, char[] pin, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, OperationCancelledException {
        return super.decrypt(key.getInfo(), encryptedBytes, pin, algorithmParameters);
    }

    @Override
    public synchronized GovCS.ResultObject decrypt(OCFCertificateInfo info, byte[] encryptedBytes, char[] pin, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, OperationCancelledException {
        boolean transactionStarted = false;
        try {
            transactionStarted = this.beginTransaction();
            this.doPaceWhenRequired();
            GovCS.ResultObject resultObject = super.decrypt(info, encryptedBytes, pin, algorithmParameters);
            return resultObject;
        }
        catch (NotYetInitializedException | OperationCancelledException | ResponseCodeException | RetryCounterExpiredException | WrongPinException e) {
            this.doReset(e.getErrorCode());
            throw e;
        }
        finally {
            this.endTransaction(transactionStarted);
        }
    }

    @Override
    public SecureCard.SecurityProtocol getSecurityProtocol() {
        return this.currentSecurityProtocol;
    }

    @Override
    public List<SecureCard.SecurityProtocol> getSupportedSecurityProtocols() {
        return Collections.singletonList(SecureCard.SecurityProtocol.EAC2_PACE);
    }

    @Override
    public boolean isSecure() {
        return this.currentSecurityProtocol != null;
    }

    @Override
    public boolean prepareSignatureTerminal(boolean initMode) throws OperationCancelledException, WrongPinException {
        return false;
    }

    @Override
    public boolean releaseSecureContext() throws CardServiceException, CardTerminalException {
        this.currentSecurityProtocol = null;
        return true;
    }

    @Override
    public synchronized void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            this.sendCommandAPDU(channel, new CommandAPDU(HexString.parseHexString("00 22 f3 01")));
            channel.setState(null);
        }
        catch (Exception e) {
            LOG.debug((Object)("reset failed: " + e.getMessage()));
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(CardKey key, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        return this.signHash(key.getInfo(), hashValue, pin, hashAlgorithm, algorithmParameters);
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        boolean transactionStarted = false;
        try {
            transactionStarted = this.beginTransaction();
            this.doPaceWhenRequired();
            GovCS.ResultObject resultObject = this.signHashInt(info, hashValue, pin, hashAlgorithm, algorithmParameters);
            return resultObject;
        }
        catch (CardTerminalException e) {
            this.doReset(27016);
            throw e;
        }
        catch (NotYetInitializedException | OperationCancelledException | ResponseCodeException | RetryCounterExpiredException | WrongPinException e) {
            this.doReset(e.getErrorCode());
            throw e;
        }
        finally {
            this.endTransaction(transactionStarted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isKeyInitialized(OCFCertificateInfo info) throws ResponseCodeException, CardTerminalException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            this.selectFile(channel, info, false);
            boolean bl = this.isKeyInitialized(channel, info);
            return bl;
        }
        catch (ResponseCodeException ex) {
            throw ex;
        }
        catch (CardTerminalException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    @Override
    public synchronized int verifyPassword(CardPin cardPin, char[] pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        return this.verifyPassword(cardPin.getInfos()[0], pin);
    }

    @Override
    public synchronized int verifyPassword(OCFCertificateInfo info, char[] pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        boolean transactionStarted = false;
        try {
            transactionStarted = this.beginTransaction();
            this.doPaceWhenRequired();
            int n = super.verifyPassword(info, pin);
            return n;
        }
        catch (CardTerminalException e) {
            this.doReset(27016);
            throw e;
        }
        catch (NotYetInitializedException | OperationCancelledException | ResponseCodeException | RetryCounterExpiredException | WrongPinException e) {
            this.doReset(e.getErrorCode());
            throw e;
        }
        finally {
            this.endTransaction(transactionStarted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int verifyPasswordReaderClass1(CardChannel channel, OCFCertificateInfo info, char[] externalPin, Integer retryCount, String pinName, GovCHVDialog chvDialog) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, OperationCancelledException, PinDeactivatedException {
        ResponseAPDU res;
        block9: {
            char[] pin = null;
            CommandAPDU cmd = null;
            try {
                if (externalPin == null) {
                    chvDialog.show();
                    int result = chvDialog.getResult();
                    if (result == 2) {
                        throw new PinInputCancelledException(pinName, CardErrorUtil.getErrorCodeForRetries(retryCount), APDUCommands.getVerifyErrorMsg(0));
                    }
                    pin = chvDialog.getPIN();
                } else {
                    pin = new char[externalPin.length];
                    System.arraycopy(externalPin, 0, pin, 0, pin.length);
                }
                cmd = this.createVerifyPasswordCommand(info, pin);
                LOG.debug((Object)("VP CMD : " + HexString.hexify(cmd.getBuffer(), 0, Math.min(5, cmd.getBuffer().length), false)));
                res = super.sendCommandAPDU(channel, cmd);
                LOG.debug((Object)("VP RES : " + (res == null ? null : HexString.hexify(res.getBuffer(), false))));
                if (pin == null) break block9;
            }
            catch (Throwable throwable) {
                if (pin != null) {
                    for (int i = 0; i < pin.length; ++i) {
                        pin[i] = '\u0000';
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < pin.length; ++i) {
                pin[i] = '\u0000';
            }
        }
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString(ERROR_MESSAGE_NO_RESPONSE));
        }
        return this.evaluateVerifyPasswordResultCode(pinName, retryCount, res.sw());
    }

    @Override
    protected final void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel channel, OCFCertificateInfo info, byte[] hashValue, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException, OperationCancelledException {
        try {
            CardExecutionSignAuthenticateParameterSpec sps = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
            String algorithmName = sps.getAlgorithmName();
            if (algorithmName.contains("/PSS") || algorithmName.contains("andMGF1")) {
                return super.signHash(channel, info, RSAPadding.padPKCS1PSS(info.getX509Certificate().getPublicKey(), hashAlgorithm, hashValue), hashAlgorithm, algorithmParameters);
            }
            return super.signHash(channel, info, RSAPadding.padPKCS1V15(info.getX509Certificate().getPublicKey(), hashAlgorithm, hashValue), hashAlgorithm, algorithmParameters);
        }
        catch (InvalidParameterSpecException e) {
            throw new ResponseCodeException(e.getMessage());
        }
    }

    @Override
    protected CommandAPDU createAuthentifyCommand(byte[] hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -122;
        store[3] = -128;
        store[4] = (byte)hashValue.length;
        System.arraycopy(hashValue, 0, store, 5, hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    protected final OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] encryptedBytes, byte paddingIndicator, AlgorithmParameters algorithmParameters) {
        int blockSize = 257;
        byte[] store = new byte[7 + blockSize + 2];
        Arrays.fill(store, (byte)-1);
        int i = 0;
        store[i++] = 0;
        store[i++] = 42;
        store[i++] = -128;
        store[i++] = -122;
        store[i++] = 0;
        store[i++] = (byte)(blockSize >> 8 & 0xFF);
        store[i++] = (byte)(blockSize >> 0 & 0xFF);
        store[i++] = this.getPaddingIndicator();
        System.arraycopy(encryptedBytes, 0, store, i, encryptedBytes.length);
        i += encryptedBytes.length;
        int resultLength = 256;
        store[i++] = (byte)(resultLength >> 8 & 0xFF);
        store[i] = (byte)(resultLength & 0xFF);
        return new CommandAPDU(store);
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel channel, OCFCertificateInfo info, int type, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException {
        switch (type) {
            case 1: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(info.getKeyID().getID().length);
                    data.write(info.getKeyID().getID());
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, ERROR_MESSAGE_MSE_FAILED);
                }
            }
            case 0: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(info.getKeyID().getID().length);
                    data.write(info.getKeyID().getID());
                    byte[] algorithm = this.isRsa ? HexUtil.parse("22") : HexUtil.parse("19");
                    try {
                        CardExecutionSignAuthenticateParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                        algorithm = parameterSpec.getAlgorithmID();
                    }
                    catch (InvalidParameterSpecException e) {
                        LOG.debug((Object)e);
                    }
                    data.write(-128);
                    data.write(algorithm.length);
                    data.write(algorithm);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, ERROR_MESSAGE_MSE_FAILED);
                }
            }
            case 2: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(info.getKeyID().getID().length);
                    data.write(info.getKeyID().getID());
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, ERROR_MESSAGE_MSE_FAILED);
                }
            }
        }
        return null;
    }

    @Override
    protected final GovCS.ResultObject decrypt(CardChannel channel, OCFCertificateInfo info, byte[] encryptedBytes, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException {
        int i;
        byte[] lEncryptedBytes = encryptedBytes;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte paddingIndicator = 0;
        int p2 = 0;
        if (this.isRsa) {
            try {
                CardExecutionDecryptRSAParameterSpec rsaSpec = algorithmParameters.getParameterSpec(CardExecutionDecryptRSAParameterSpec.class);
                if (rsaSpec != null) {
                    paddingIndicator = rsaSpec.getPaddingIndicator()[0];
                    p2 = -122;
                }
            }
            catch (Exception rsaSpec) {}
        } else {
            p2 = -90;
            try {
                X509Certificate bcCertificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(new X509CertificateHolder(info.getCertificateBag().getCertificate().getEncoded()));
                ECPoint decodePoint = ((ECPublicKey)bcCertificate.getPublicKey()).getParameters().getCurve().decodePoint(encryptedBytes);
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    byte[] encodedX = decodePoint.getAffineXCoord().getEncoded();
                    byte[] encodedY = decodePoint.getAffineYCoord().getEncoded();
                    boolean xWithZero = false;
                    boolean yWithZero = false;
                    int l = 0;
                    if ((encodedX[0] & 0xFFFFFF80) == -128) {
                        ++l;
                        xWithZero = true;
                    }
                    if ((encodedY[0] & 0xFFFFFF80) == -128) {
                        ++l;
                        yWithZero = true;
                    }
                    baos.write(-100);
                    if (xWithZero != yWithZero) {
                        ++l;
                        xWithZero = true;
                        yWithZero = true;
                    }
                    baos.write(l + encodedX.length + encodedY.length);
                    if (xWithZero) {
                        baos.write(0);
                    }
                    baos.write(encodedX);
                    if (yWithZero) {
                        baos.write(0);
                    }
                    baos.write(encodedY);
                    lEncryptedBytes = baos.toByteArray();
                }
            }
            catch (Exception bcCertificate) {
                // empty catch block
            }
        }
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        os = new ByteArrayOutputStream();
        os.write(0);
        os.write(42);
        os.write(-128);
        os.write(p2);
        if (this.isRsa) {
            os.write(0);
            os.write((byte)(lEncryptedBytes.length + 1 >> 8));
            os.write((byte)(lEncryptedBytes.length + 1 & 0xFF));
            os.write(paddingIndicator);
        } else {
            os.write((byte)lEncryptedBytes.length);
        }
        os.write(lEncryptedBytes, 0, lEncryptedBytes.length);
        if (this.isRsa) {
            os.write(0);
        }
        os.write(0);
        cmd = new CommandAPDU(os.toByteArray());
        LOG.debug((Object)("DECRYPT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = this.sendCommandAPDU(channel, cmd);
        if ((this.ctReference.getName().toLowerCase().contains("omnikey") || this.ctReference.getName().toLowerCase().contains("XX44")) && PCSCCardTerminal.class.isInstance(this.ctReference)) {
            try {
                ((PCSCCardTerminal)this.ctReference).resetSlot(0);
            }
            catch (CardTerminalException e) {
                LOG.debug((Object)("reset of slot failed: " + e.getMessage()));
            }
        }
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString(ERROR_MESSAGE_NO_RESPONSE));
        }
        LOG.debug((Object)("DECRYPT RESULT : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        byte[] b = (byte[])ro.getResultData();
        if (b == null || b.length < 3) {
            return ro;
        }
        if (b.length % 8 != 0) {
            b = ByteUtil.combine(new byte[]{0}, b);
        }
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    protected final Card.CardTypeEnum getCardTypeEnum() {
        return this.cardType;
    }

    @Override
    protected final byte[] getHistoricals() {
        return HISTORICALS[this.historicalsIndex];
    }

    @Override
    protected final int getMaximumChunkSize() {
        return 240;
    }

    @Override
    protected final String getOSName() {
        return "CardOS 6.0";
    }

    @Override
    protected final int getRetryCount(CardChannel channel, OCFCertificateInfo info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = CardOS60.getPinNameForInfo(info);
        try {
            this.doPaceWhenRequired();
        }
        catch (OperationCancelledException | WrongPinException e) {
            ResponseCodeException rce = new ResponseCodeException(e.getErrorCode(), e.getMessage());
            rce.initCause(e);
            throw rce;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        if (!this.isKeyInitialized(info)) {
            throw new NotYetInitializedException(pinName, 27013, "password not initialized");
        }
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(info.getPinID());
        LOG.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = super.sendCommandAPDU(channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString(ERROR_MESSAGE_NO_RESPONSE));
        }
        LOG.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected final boolean historicalsEquals(byte[] historicals) {
        if (Objects.isNull(historicals)) {
            return true;
        }
        this.historicalsIndex = -1;
        for (int i = 0; i < HISTORICALS.length; ++i) {
            if (!Arrays.equals(HISTORICALS[i], historicals)) continue;
            this.historicalsIndex = i;
            break;
        }
        return this.historicalsIndex >= 0 && this.historicalsIndex < HISTORICALS.length;
    }

    @Override
    protected final synchronized boolean isKeyInitialized(CardChannel channel, OCFCertificateInfo info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException {
        try {
            this.doPaceWhenRequired();
        }
        catch (OperationCancelledException | WrongPinException e) {
            ResponseCodeException rce = new ResponseCodeException(e.getErrorCode(), e.getMessage());
            rce.initCause(e);
            throw rce;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        if (this.isTransportStateActive(channel)) {
            return false;
        }
        String pinName = CardOS60.getPinNameForInfo(info);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(info.getPinID());
        LOG.debug((Object)("INIT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = super.sendCommandAPDU(channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString(ERROR_MESSAGE_NO_RESPONSE));
        }
        LOG.debug((Object)("INIT RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err == 27011) {
            throw new RetryCounterExpiredException(pinName, err, APDUCommands.getVerifyErrorMsg(err));
        }
        return err != 27012;
    }

    protected boolean isTransportStateActive(CardChannel channel) throws CardTerminalException {
        CommandAPDU cmd = new CommandAPDU(HexUtil.parse("80ca000b00"));
        LOG.debug((Object)("TRANSPORT STATE CHECK CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU transportCheck = super.sendCommandAPDU(channel, cmd);
        LOG.debug((Object)("TRANSPORT STATE CHECK RESP : " + HexString.hexify(transportCheck.getBuffer(), false)));
        return 36864 == transportCheck.sw() && transportCheck.data() != null && Arrays.equals(HexUtil.parse("E3 04 90 02 00 01"), transportCheck.data());
    }

    @Override
    protected String readIssuerFromATR(CardChannel channel) {
        try {
            if (this.isTransportStateActive(channel)) {
                LOG.error((Object)"card at transport state, card not initialized");
            }
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
        String readPKCS15TokenInfoString = super.readApplicationFileFromCard(channel, "E8 28 BD 08 0F A0 00 00 01 67 45 53 49 47 4E", "50 32");
        String matchingIssuerConstant = this.getIssuerConstant();
        if (readPKCS15TokenInfoString != null && readPKCS15TokenInfoString.contains(matchingIssuerConstant)) {
            LOG.debug((Object)("EF.TokenInfo: " + matchingIssuerConstant));
            return matchingIssuerConstant;
        }
        return null;
    }

    protected final void selectForPin(OCFCertificateInfo info, CardChannel cardChannel) throws ResponseCodeException, CardTerminalException {
        if (info.getPinID() == -127) {
            this.selectSubDirectory(cardChannel, info.getPin().getParentApplication().getFileEntry().getDirectory());
        } else {
            this.selectSubDirectory(cardChannel, info.getKey().getParentApplication().getFileEntry().getDirectory());
        }
    }

    @Override
    protected synchronized void setSM(SecureMessaging<?, ?, ?> sm) {
        if (sm == null) {
            this.currentSecurityProtocol = null;
        }
        super.setSM(sm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final GovCS.ResultObject signHashServerInt(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, ProgressSession session, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, OperationCancelledException {
        GovCS.ResultObject ro = new GovCS.ResultObject();
        CardChannelManager cardChannelManager = new CardChannelManager();
        CardChannel channel = null;
        try {
            this.fireProgressEvent(session, "get connection to the device");
            channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!this.checkChannelState(channel, info)) {
                this.selectForPin(info, channel);
            }
            boolean loop = true;
            this.fireProgressEvent(session, "install corresponding security environment");
            ro = this.setSecurityEnvironment(channel, info, 0, hashAlgorithm, algorithmParameters);
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                GovCS.ResultObject resultObject = ro;
                return resultObject;
            }
            while (loop) {
                this.fireProgressEvent(session, "sign the given hash value");
                ro = this.signHash(channel, info, hashValue, hashAlgorithm, algorithmParameters);
                if (ro.getResultCode() == 27010) {
                    this.resetChannelState(channel);
                    try {
                        this.checkSignCounter(channel, false);
                    }
                    catch (MaxSignatureCountReachedException e) {
                        LOG.debug((Object)"maximum of signatures reached - never happens in server mode and method");
                    }
                    this.selectFile(channel, info, false);
                    this.fireProgressEvent(session, "verify the corresponding password");
                    ro.setResultCode(this.verifyPassword(channel, info, pin));
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    this.fireProgressEvent(session, "install corresponding security environment");
                    ro = this.setSecurityEnvironment(channel, info, 0, hashAlgorithm, algorithmParameters);
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    loop = true;
                    continue;
                }
                this.fireProgressEvent(session, "operation finished!");
                loop = false;
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (NotYetInitializedException | OperationCancelledException | ResponseCodeException | RetryCounterExpiredException | WrongPinException e) {
            throw e;
        }
        catch (Exception ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return false;
    }

    @Override
    protected final boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    private void doPaceWhenRequired() throws ResponseCodeException, WrongPinException, OperationCancelledException {
        if (!this.isSecure()) {
            try {
                SecureCard.SecurityProtocolResult<? extends Object> allocateSecureContextResult = this.allocateSecureContext(SecureCard.SecurityProtocol.EAC2_PACE, new PaceInputParameters(PACE.USE_CAN_KEY, null, null, null));
                if (allocateSecureContextResult.getThrowable() instanceof WrongPinException) {
                    throw (WrongPinException)allocateSecureContextResult.getThrowable();
                }
                if (allocateSecureContextResult.getThrowable() instanceof OperationCancelledException) {
                    throw (OperationCancelledException)allocateSecureContextResult.getThrowable();
                }
                if (allocateSecureContextResult.getThrowable() instanceof ResponseCodeException) {
                    throw (ResponseCodeException)allocateSecureContextResult.getThrowable();
                }
            }
            catch (OperationCancelledException | ResponseCodeException | WrongPinException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResponseCodeException("PACE failed: " + e.getMessage());
            }
        }
    }

    private void doReset(int code) {
        if (27016 == code) {
            super.setSM(null);
        }
        this.reset();
    }

    private synchronized GovCS.ResultObject signHashInt(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && this.isStapleSign() || OCFProvider.Settings.getInstance().isServerEnvironmentActive() && this.isMultiSign()) {
            return this.signHashServer(info, hashValue, pin, hashAlgorithm, algorithmParameters);
        }
        return super.signHash(info, hashValue, pin, hashAlgorithm, algorithmParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized GovCS.ResultObject signHashServer(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, OperationCancelledException {
        if (this.getAvailableHashAlgorithmNames(info).indexOf(hashAlgorithm) < 0) {
            throw new ResponseCodeException(65535, "hash algorithm not supported by card: " + hashAlgorithm, new NoSuchAlgorithmException("OperationCancelledException"));
        }
        ProgressSession session = new ProgressSession(2);
        session.setStepCount(6);
        session.setProgressMessage("init sign hash operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        CardChannelManager cm = new CardChannelManager();
        try {
            cm.init(this, true, false);
            boolean localTransaction = cm.isTransactionLocallyStarted();
            try {
                this.checkSignCounter(null, localTransaction);
            }
            catch (MaxSignatureCountReachedException e) {
                cm.allocate();
                this.resetCard(cm.getCardChannel());
                throw e;
            }
            GovCS.ResultObject ro = this.signHashServerInt(info, hashValue, pin, hashAlgorithm, session, algorithmParameters);
            if (ro.getResultCode() == 36864) {
                try {
                    this.increaseAndCheckSignCounter(null, localTransaction);
                }
                catch (MaxSignatureCountReachedException e) {
                    cm.allocate();
                    this.resetCard(cm.getCardChannel());
                }
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cm.destroy();
        }
    }

    private PCSCCardTerminal getPACEReader() throws CardServiceException {
        PCSCCardTerminal result;
        block6: {
            result = super.getReader(PaceConstants.PaceCapabilityEnum.PACE);
            if (result != null) {
                try {
                    byte[] resp = result.sendTerminalCommand(3211272, HexUtil.parse("00 01 01 00"));
                    String vendor = new String(resp);
                    LOG.info((Object)("Vendor: " + vendor));
                    resp = result.sendTerminalCommand(3211272, HexUtil.parse("01 01 01 00"));
                    String ifdType = new String(resp);
                    LOG.info((Object)("IFD-Type: " + ifdType));
                    resp = result.sendTerminalCommand(3211272, HexUtil.parse("02 01 01 00"));
                    LOG.info((Object)("IFD-Version (raw): " + HexUtil.hexify(resp)));
                    resp = ByteUtil.flip(resp);
                    LOG.info((Object)("IFD-Version (reordered): " + HexUtil.hexify(resp)));
                    StringBuilder sb = new StringBuilder();
                    for (byte r : resp) {
                        sb.append(r);
                        sb.append(".");
                    }
                    String ifdVersion = sb.toString().substring(0, sb.length() - 1);
                    LOG.info((Object)("IDF-Version: " + ifdVersion));
                    Optional<SupportedPaceReader> foundSupportedPaceReader = SupportedPaceReader.findSupportedPaceReader(vendor, ifdType, ifdVersion);
                    if (foundSupportedPaceReader.isEmpty()) {
                        String msg = "not supported PACE reader for D-Trust / CardOS 6.0 cards, vendor: " + vendor + ", type: " + ifdType + " and version: " + ifdVersion + ", supported PACE readers: " + SupportedPaceReader.SUPPORTED_PACE_READERS;
                        LOG.error((Object)msg);
                        break block6;
                    }
                    LOG.info((Object)("unsupported/unknown PACE reader detected: " + result));
                }
                catch (CardTerminalException e) {
                    String msg = "requesting terminal " + result.getName() + " informations failed: " + e.getMessage();
                    LOG.error((Object)msg);
                }
            } else {
                LOG.info((Object)"no PC/SC reader or PACE not supported");
            }
        }
        return result;
    }

    @Override
    public void setKeyboardAllowed(boolean flag) {
        if (this.forcePinpad) {
            return;
        }
        super.setKeyboardAllowed(flag);
    }

    @Override
    public boolean hasPinPad() {
        if (this.forcePinpad) {
            return true;
        }
        return super.hasPinPad();
    }

    @Override
    public boolean isKeybordAllowed() {
        if (this.forcePinpad) {
            return false;
        }
        return super.isKeybordAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private PacePlusResult establishPaceChannelWithTerminal(PaceInputParameters paceParameters, boolean pacePlus) {
        PacePlusResult pacePlusResult;
        block29: {
            PCSCCardTerminal reader;
            LOG.info((Object)"establishPaceChannelWithTerminal()");
            try {
                reader = this.getPACEReader();
            }
            catch (CardServiceException e1) {
                reader = null;
            }
            if (reader == null) {
                return null;
            }
            int rc = -1;
            String secretChoice = paceParameters.getSecretChoice();
            int pinID = 3;
            if (!PACE.USE_CAN_KEY.equals(secretChoice)) {
                throw new UnsupportedOperationException("only CAN supported for PACE");
            }
            pinID = 2;
            GovCHVDialog chvDialog = null;
            try {
                chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
                chvDialog.setParentWindow(this.parentWindow);
            }
            catch (InstantiationException ex) {
                PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                ppop.setRetryCounter(rc);
                return new PacePlusResult(ppop, (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                ppop.setRetryCounter(rc);
                return new PacePlusResult(ppop, (Throwable)ex);
            }
            Object monitor = null;
            CardChannelManager cm = new CardChannelManager();
            try {
                byte[] verifyCAN = null;
                OCFCertificateInfo ocfCertInfo = new OCFCertificateInfo(this.getCardObject(), OCFCertificateInfo.Usage.EID_CAN, OCFCertificateInfo.ChainEntry.UNKNOWN, 2);
                char[] canChar = null;
                CardChannel cardChannel = cm.init(this, true, true);
                this.selectMasterFile(cardChannel);
                LOG.info((Object)"prepare CAN cache");
                String key = this.buildMCardPropertiesKey(cardChannel, ".CAN");
                MCardProperties mp = MCardProperties.getInstance();
                LOG.info((Object)("retrieve CAN ..." + this.useKeyboard()));
                canChar = this.retrieveCan(mp, key, paceParameters, true);
                LOG.info((Object)"retrieve CAN ... finished");
                if (canChar == null && !this.useKeyboard()) {
                    GovCHVConfiguration config = new GovCHVConfiguration(rc, BDialogMode.EID_CAN, 6, 6, ocfCertInfo, this.createTerminalString(null), null, null, null, this.getClass());
                    config.setShowPseudoDisplay(false);
                    chvDialog.setConfiguration(config);
                    monitor = chvDialog.showReaderMessage();
                    LOG.info((Object)"prepare CAN entering at terminal");
                    verifyCAN = HexUtil.parse("02 05 00 " + HexUtil.hexify((byte)2) + " 00 00 00 00");
                } else {
                    LOG.info((Object)"prepare PACE with cached CAN");
                    try (ByteArrayOutputStream baos2222222222 = new ByteArrayOutputStream();){
                        baos2222222222.write(2);
                        baos2222222222.write(11);
                        baos2222222222.write(0);
                        baos2222222222.write(2);
                        baos2222222222.write(0);
                        baos2222222222.write(6);
                        baos2222222222.write(CharUtil.convert(canChar));
                        baos2222222222.write(0);
                        baos2222222222.write(0);
                        verifyCAN = baos2222222222.toByteArray();
                    }
                    catch (IOException baos2222222222) {
                        // empty catch block
                    }
                }
                byte[] result = reader.sendTerminalCommand(reader.getPcsc20Features().getExecutePACE().valueAsNumber(), verifyCAN);
                PacePlusResult pacePlusResult2 = this.analyzeTerminalPaceResult(PWD_NAME_CAN, rc, result, pacePlus);
                if (pacePlusResult2.isSecurityProtocolSuccessfulAllocated()) {
                    this.forcePinpad = true;
                    this.currentSecurityProtocol = SecureCard.SecurityProtocol.EAC2_PACE;
                    if (canChar != null && canChar.length > 0) {
                        mp.put(key, new HexBinaryAdapter().marshal(this.aesCanCrypter.encrypt(Strings.toUTF8ByteArray((String)new String(canChar)))));
                    }
                } else if (mp.containsKey(key)) {
                    mp.remove(key);
                }
                pacePlusResult = pacePlusResult2;
                cm.destroy();
                if (monitor == null) break block29;
            }
            catch (OperationCancelledException | ResponseCodeException | CardTerminalException e) {
                PacePlusResult pacePlusResult3 = new PacePlusResult(e);
                return pacePlusResult3;
            }
            catch (IOException | BadPaddingException | IllegalBlockSizeException e2) {
                PacePlusResult pacePlusResult4 = new PacePlusResult(new CardTerminalException(e2.getMessage()));
                return pacePlusResult4;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                cm.destroy();
                if (monitor != null) {
                    chvDialog.hideReaderMessage(monitor);
                }
            }
            chvDialog.hideReaderMessage(monitor);
        }
        return pacePlusResult;
    }

    private String buildMCardPropertiesKey(CardChannel cardChannel, String keySuffix) {
        byte[] iccsn = this.readFileBytesFromCard(cardChannel, "2f02");
        String key = new HexBinaryAdapter().marshal(iccsn) + keySuffix;
        LOG.info((Object)("key: " + key));
        return key;
    }

    private PacePlusResult analyzeTerminalPaceResult(String pinName, Integer retryCount, byte[] result, boolean pacePlus) throws CardTerminalException {
        if (ArrayUtil.isNullOrEmpty(result) || result.length < 4) {
            throw new CardTerminalException("protocol failed at terminal - no response received (at least 4 bytes required containing execution result code");
        }
        byte[] code = ByteUtil.flip(ByteUtil.subbytes(result, 0, 4));
        if (!ByteUtil.equals(code, HexUtil.parse("00000000"))) {
            if (code[0] == -16 && code[1] >= 0 && code[1] < 7) {
                int sw = (code[2] + 256) % 256 * 256 + (code[3] + 256) % 256;
                if (code[2] == 99 && (code[3] & 0xFFFFFFF0) == -64) {
                    PacePlusOutputParameters ppop = new PacePlusOutputParameters();
                    ppop.setRetryCounter(code[3] & 0xF);
                    return new PacePlusResult(ppop, (Throwable)new WrongPinException(pinName, sw, "protocol failed - wrong password entered: " + HexUtil.hexify(code)));
                }
                try {
                    super.evaluateVerifyPasswordResultCode(pinName, retryCount, sw);
                }
                catch (OCFPinRelatedException e) {
                    return new PacePlusResult(e);
                }
                return new PacePlusResult(new OCFException(sw, "protocol failed at terminal: " + HexUtil.hexify(code)));
            }
            if (code[0] == -16 && code[1] == 16 && code[2] == 0 && code[3] >= 1 && code[3] <= 2) {
                return new PacePlusResult(new OCFException(new BigInteger(code).intValue(), "protocol failed at terminal, card communication error: " + HexUtil.hexify(code)));
            }
            if (code[0] == -16 && code[1] == 32 && code[2] == 0) {
                if (code[3] == 1) {
                    return new PacePlusResult(new PinInputCancelledException(pinName, 25601, "user cancelled request"));
                }
                if (code[3] == 2) {
                    return new PacePlusResult(new PinInputTimeoutException(pinName, 25600, "user request not in time"));
                }
            }
            if (code[0] == -48 && code[1] == 0 && code[2] == 2 && code[3] >= 1 && code[3] <= 3) {
                return new PacePlusResult(new OCFException(new BigInteger(code).intValue(), "protocol failed at terminal, data input error: " + HexUtil.hexify(code)));
            }
            if (code[0] == -32 && code[1] == 0 && code[2] == 2 && code[3] >= 1 && code[3] <= 3) {
                return new PacePlusResult(new OCFException(new BigInteger(code).intValue(), "protocol failed at terminal, operation not supported: " + HexUtil.hexify(code)));
            }
            return new PacePlusResult(new OCFException(new BigInteger(code).intValue(), "protocol failed at terminal: " + HexUtil.hexify(code)));
        }
        byte[] lOutputBufferLength = ByteUtil.flip(ByteUtil.subbytes(result, 4, 6));
        int l = new BigInteger(1, lOutputBufferLength).intValue();
        byte[] responseData = ByteUtil.subbytes(result, 6);
        int offset = 0;
        byte[] responseSWmseAT = ByteUtil.subbytes(responseData, offset, offset + 2);
        byte[] lEFCardAccessLength = ByteUtil.flip(ByteUtil.subbytes(responseData, offset += 2, offset + 2));
        int lEFCardAccess = new BigInteger(1, lEFCardAccessLength).intValue();
        byte[] efCardAccess = ByteUtil.subbytes(responseData, offset += 2, offset + lEFCardAccess);
        byte lCAR = responseData[offset += lEFCardAccess];
        byte[] car = ByteUtil.subbytes(responseData, ++offset, offset + Math.abs(lCAR));
        byte lPreviousCAR = responseData[offset += Math.abs(lCAR)];
        byte[] previousCar = ByteUtil.subbytes(responseData, ++offset, offset + Math.abs(lPreviousCAR));
        byte[] lIDiccLength = ByteUtil.flip(ByteUtil.subbytes(responseData, offset += Math.abs(lPreviousCAR), offset + 2));
        int lIDicc = new BigInteger(1, lIDiccLength).intValue();
        byte[] idICC = ByteUtil.subbytes(responseData, offset += 2, offset + Math.abs(lIDicc));
        try {
            this.cardAccess = new SecurityInfos(efCardAccess);
            this.cardAccess = (SecurityInfos)this.cardAccess.decode(this.cardAccess);
        }
        catch (IOException e) {
            return new PacePlusResult(e);
        }
        PacePlusOutputParameters ppop = new PacePlusOutputParameters();
        ppop.setCardEphemeralPublicKey(idICC);
        ppop.setRetryCounter(1);
        return new PacePlusResult(ppop);
    }

    public static class SupportedPaceReader {
        private String vendor;
        private String ifdType;
        private String ifdVersionMinimum;
        public static final List<SupportedPaceReader> SUPPORTED_PACE_READERS = List.of(new SupportedPaceReader("REINER SCT", "cyberJack RFID komfort", "2.0.47.0"), new SupportedPaceReader("REINER SCT", "cyberJack RFID standard", "1.2.71.0"));

        public SupportedPaceReader(String vendor, String ifdType, String ifdVersionMinimum) {
            this.vendor = vendor;
            this.ifdType = ifdType;
            this.ifdVersionMinimum = ifdVersionMinimum;
        }

        public static Optional<SupportedPaceReader> findSupportedPaceReader(String vendor, String ifdType, String ifdVersion) {
            return SUPPORTED_PACE_READERS.stream().filter(r -> vendor.equalsIgnoreCase(r.vendor) && ifdType.equalsIgnoreCase(r.ifdType) && ifdVersion.compareTo(r.ifdVersionMinimum) >= 0).findAny();
        }

        public String toString() {
            return "SupportedPaceReader [vendor=" + this.vendor + ", ifdType=" + this.ifdType + ", ifdVersionMinimum=" + this.ifdVersionMinimum + "]";
        }
    }
}

