/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.cardos;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptECParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.crypto.AlgorithmIdentifierHelper;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.DefaultBaseAlgorithmProviderBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.OCFDefaultAlgorithmFinder;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class CardOS54Util {
    private static final Log LOG = LogFactory.getLog(CardOS54Util.class);
    public static final String SEID_DEFAULT = "01";
    public static final String SEID_ECDSA_SHA256 = "21";
    public static final String SEID_ECDH = "39";
    public static final String SEID_RSA_PKCS1_5_SHA256 = "25";
    public static final String SEID_RSA_PKCS1_5_SHA384 = "26";
    public static final String SEID_RSA_PKCS1_5_SHA512 = "27";
    public static final String SEID_RSA_PSS_SHA256 = "19";
    public static final String SEID_RSA_PSS_SHA384 = "1a";
    public static final String SEID_RSA_PSS_SHA512 = "1b";
    public static final String SEID_RSA_PKCS1_5 = "31";
    public static final String SEID_RSA_OAEP_SHA256 = "32";
    public static final String SEID_RSA_OAEP_SHA384 = "33";
    public static final String SEID_RSA_OAEP_SHA512 = "34";

    private CardOS54Util() {
    }

    public static AlgorithmProvider<OCFPrivateKey> createDefaultRSAAlgorithmProviderDecryptionEncryptionAuthentication() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.AUTHENTICATION, UsageRelated.Usage.SIGNATURE);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        CardOS54Util.addRSASignatureAuthenticationAlgorithms(usageList01, listKeyAlgorithms01);
        List<UsageRelated.Usage> usageList02 = Arrays.asList(UsageRelated.Usage.CIPHER);
        OCFDefaultAlgorithmFinder finder = OCFDefaultAlgorithmFinder.getInstance();
        CardOS54Util.addOAEPAlgorithm(listKeyAlgorithms01, usageList02, SEID_RSA_OAEP_SHA256, "SHA256", finder);
        CardOS54Util.addOAEPAlgorithm(listKeyAlgorithms01, usageList02, SEID_RSA_OAEP_SHA384, "SHA384", finder);
        CardOS54Util.addOAEPAlgorithm(listKeyAlgorithms01, usageList02, SEID_RSA_OAEP_SHA512, "SHA512", finder);
        try {
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList02, "RSA/ECB/PKCS1Padding", "RSA/PKCS1", new CardExecutionDecryptRSAParameterSpec("RSA/ECB/PKCS1Padding", new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), finder.findURI("RSA/ECB/PKCS1Padding"), new byte[]{-127}, HexUtil.parse(SEID_RSA_PKCS1_5))));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return CardOS54Util.createAlgorithmProvider(listKeyAlgorithms01);
    }

    private static void addOAEPAlgorithm(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms, List<UsageRelated.Usage> usageList, String seid, String digestAlgorithm, OCFDefaultAlgorithmFinder finder) {
        try {
            String jcaAlgorithm = "RSA/NONE/OAEPWith" + digestAlgorithm + "AndMGF1Padding";
            listKeyAlgorithms.add(new Algorithm("OCF", usageList, jcaAlgorithm, "RSA/OAEP/" + digestAlgorithm, new CardExecutionDecryptRSAParameterSpec(jcaAlgorithm, AlgorithmIdentifierHelper.createRSAOAEPByHashAlgorithm(digestAlgorithm), finder.findURI(jcaAlgorithm), new byte[]{0}, HexUtil.parse(seid))));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
    }

    public static AlgorithmProvider<OCFPrivateKey> createDefaultRSAAlgorithmProviderSignature() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.SIGNATURE);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        CardOS54Util.addRSASignatureAuthenticationAlgorithms(usageList01, listKeyAlgorithms01);
        return CardOS54Util.createAlgorithmProvider(listKeyAlgorithms01);
    }

    private static void addRSASignatureAuthenticationAlgorithms(List<UsageRelated.Usage> usageList01, List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms01) {
        try {
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPSSAlgorithms(Arrays.asList("SHA256", "SHA384", "SHA512"), Arrays.asList(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE), Arrays.asList(SEID_RSA_PSS_SHA256, SEID_RSA_PSS_SHA384, SEID_RSA_PSS_SHA512), usageList01));
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPKCS1Algorithms(Arrays.asList("SHA256", "SHA384", "SHA512"), Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE), Arrays.asList(SEID_RSA_PKCS1_5_SHA256, SEID_RSA_PKCS1_5_SHA384, SEID_RSA_PKCS1_5_SHA512), usageList01));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
    }

    public static AlgorithmProvider<OCFPrivateKey> createDefaultECAlgorithmProviderDecryptionEncryptionAuthentication() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.AUTHENTICATION, UsageRelated.Usage.SIGNATURE);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        CardOS54Util.addECSignatureAuthenticationAlgorithms(usageList01, listKeyAlgorithms01);
        List<UsageRelated.Usage> usageList02 = Arrays.asList(UsageRelated.Usage.CIPHER, UsageRelated.Usage.KEYAGREEMENT);
        OCFDefaultAlgorithmFinder finder = OCFDefaultAlgorithmFinder.getInstance();
        try {
            for (String ecAlg : new String[]{"ECDH", "ECIES"}) {
                listKeyAlgorithms01.add(new Algorithm("OCF", usageList02, ecAlg, ecAlg, new CardExecutionDecryptECParameterSpec(ecAlg, new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, (ASN1Encodable)DERNull.INSTANCE.toASN1Primitive()), finder.findURI(ecAlg), "ConcatKDF", HexUtil.parse(SEID_ECDH))));
            }
        }
        catch (Throwable e) {
            LOG.debug((Object)e);
        }
        return CardOS54Util.createAlgorithmProvider(listKeyAlgorithms01);
    }

    public static AlgorithmProvider<OCFPrivateKey> createDefaultECAlgorithmProviderSignature() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.SIGNATURE);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        CardOS54Util.addECSignatureAuthenticationAlgorithms(usageList01, listKeyAlgorithms01);
        return CardOS54Util.createAlgorithmProvider(listKeyAlgorithms01);
    }

    private static void addECSignatureAuthenticationAlgorithms(List<UsageRelated.Usage> usageAlgorithms, List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) {
        try {
            String hashAlgorithm = "SHA256";
            String seid = SEID_ECDSA_SHA256;
            String providerName = "OCF";
            String[] separators = new String[]{"with", "hashedWith"};
            String[] formats = new String[]{"ECDSA", "CVC-ECDSA"};
            for (String separator : separators) {
                for (String format : formats) {
                    String sigAutAlgorithmName;
                    String sigAutAlternativeAlgorithmName = sigAutAlgorithmName = hashAlgorithm + separator + format;
                    listAlgorithms.add(new Algorithm("OCF", usageAlgorithms, sigAutAlgorithmName, sigAutAlternativeAlgorithmName, new CardExecutionSignAuthenticateParameterSpec(sigAutAlgorithmName, OCFDefaultAlgorithmFinder.getInstance().find(sigAutAlgorithmName), OCFDefaultAlgorithmFinder.getInstance().findURI(sigAutAlgorithmName), false, HexUtil.parse(seid))));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static AlgorithmProvider<OCFPrivateKey> createAlgorithmProvider(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms) {
        try {
            return DefaultBaseAlgorithmProviderBuilder.createAlgorithmProvider(listKeyAlgorithms);
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Provider provider = Security.getProvider("BC");
        for (Provider.Service service : provider.getServices()) {
            if (!"Cipher".equals(service.getType()) || !service.getAlgorithm().contains("RSA")) continue;
            LOG.debug((Object)service);
        }
        LOG.debug((Object)Cipher.getInstance("RSA/NONE/OAEPWithSHA224AndMGF1Padding", "BC"));
        LOG.debug((Object)Cipher.getInstance("RSA/NONE/OAEPWithSHA256AndMGF1Padding", "BC"));
        LOG.debug((Object)Cipher.getInstance("RSA/NONE/OAEPWithSHA384AndMGF1Padding", "BC"));
        LOG.debug((Object)Cipher.getInstance("RSA/NONE/OAEPWithSHA512AndMGF1Padding", "BC"));
    }
}

