/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.cardos;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.DefaultBaseAlgorithmProviderBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFDefaultAlgorithmFinder;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.ChannelState;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class CardOS50DTrust31
extends CardOS50 {
    private static final Integer INIT_LENGTH = 6;
    private static final Log LOG = LogFactory.getLog(CardOS50DTrust31.class);
    private static final String SEID_SHA256_RSA_PKCS1_5 = "04";
    private static final String SEID_SHA256_RSA_PSS = "09";
    private static final String SEID_RSA_PKCS1_5 = "14";
    private final String displayName;
    private final String tokenLabel;
    private final boolean stapleSign;
    private final boolean multiSign;
    private final boolean issuerReadRequired;

    public CardOS50DTrust31(String displayName, String issuerConstant, boolean stapleSign, boolean multiSign, Card.CardTypeEnum cardType, boolean issuerReadRequired) {
        super(cardType);
        this.displayName = displayName;
        this.tokenLabel = issuerConstant;
        this.stapleSign = stapleSign;
        this.multiSign = multiSign;
        this.issuerReadRequired = issuerReadRequired;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return this.issuerReadRequired;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    @Override
    protected final String readIssuerFromATR(CardChannel _channel) {
        String readPKCS15TokenInfoString = super.readPKCS15TokenInfoFromCard(_channel);
        LOG.debug((Object)("EF.TokenInfo: " + readPKCS15TokenInfoString));
        if (readPKCS15TokenInfoString != null && readPKCS15TokenInfoString.contains(this.tokenLabel)) {
            return this.tokenLabel;
        }
        return null;
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSign ? Integer.valueOf(100) : (this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null);
    }

    @Override
    protected Card createCardInt(Terminal terminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 17;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000002L});
        CardApplication applicationCerts = this.createCertsApp(terminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationQSign = this.createQSignApp(terminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationESign = this.createESignApp(terminal, pSlotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationCerts);
        mfManager.putApplication(applicationQSign);
        mfManager.putApplication(applicationESign);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createCertsApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        long idOfApplication = 1000001L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        FileReference refSigCerRCA = new FileReference(8, "1ffec00e");
        FileReference refSigCerCA = new FileReference(8, "1ffec00d");
        FileReference refDecEncAutCerRCA = new FileReference(8, "1ffec10e");
        FileReference refDecEncAutCerCA = new FileReference(8, "1ffec10d");
        FileEntry fileEntrySigCerRCA = new FileEntry(refSigCerRCA, refSigCerRCA);
        FileEntry fileEntrySigCerCA = new FileEntry(refSigCerCA, refSigCerCA);
        FileEntry fileEntryDecEncAutCerRCA = new FileEntry(refDecEncAutCerRCA, refDecEncAutCerRCA);
        FileEntry fileEntryDecEncAutCerCA = new FileEntry(refDecEncAutCerCA, refDecEncAutCerCA);
        OCFCertificateInfo infoSigCerRCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile01, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo infoSigCerCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo infoDecEncAutCerRCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo infoDecEncAutCerCA = new OCFCertificateInfo(idOfCard, -1L, idOfFile04, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl fileSigCerRCA = new CardFileImpl(Disposeable.NO_LOCK, "cerSigRCA", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntrySigCerRCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoSigCerRCA);
        CardFileImpl fileSigCerCA = new CardFileImpl(Disposeable.NO_LOCK, "cerSigCA", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntrySigCerCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoSigCerCA);
        CardFileImpl fileDecEncAutCerRCA = new CardFileImpl(Disposeable.NO_LOCK, "cerDecEncAutRCA", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDecEncAutCerRCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoDecEncAutCerRCA);
        CardFileImpl fileDecEncAutCerCA = new CardFileImpl(Disposeable.NO_LOCK, "cerDecEncAutCA", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryDecEncAutCerCA, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, infoDecEncAutCerCA);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("1ffe", idOfApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntrySigCerRCA, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileSigCerRCA);
        applicationApp.putFile(fileSigCerCA);
        applicationApp.putFile(fileDecEncAutCerRCA);
        applicationApp.putFile(fileDecEncAutCerCA);
        return applicationApp;
    }

    protected CardApplication createQSignApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        long idOfApplication = 1000002L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000005L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("02");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(4, "D2 76 00 00 66 01");
        FileReference refCer = new FileReference(8, "1ffec001");
        FileEntry fileEntryCer = new FileEntry(dirRefApp, refCer);
        OCFCertificateInfo infoCer = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl fileCer = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01, infoCer);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signature PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), infoCer, idOfFile01, idOfPin01, k01);
        key01.setAlgorithmProvider(this.createDefaultAlgorithmProviderSignature());
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("1fff", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntryCer, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileCer);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private CardApplication createESignApp(Terminal terminal, int pSlotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000003L;
        long idOfFile01 = 3000006L;
        long idOfKey01 = 4000002L;
        KeyID k = new KeyID("12");
        FileReference dirRefApp = new FileReference(4, "A0 00 00 01 67 45 53 49 47 4e");
        FileReference refCer = new FileReference(8, "1ffec101");
        FileEntry fileEntryCer = new FileEntry(dirRefApp, refCer);
        OCFCertificateInfo infoCer = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl fileCer = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDecAut", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01, infoCer);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "DecEncAutKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntryCer, idOfCard, idOfApplication, terminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), infoCer, idOfFile01, idOfPinCH, k);
        key.setAlgorithmProvider(this.createDefaultAlgorithmProviderDecryptionEncryptionAuthentication());
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("1ffd", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntryCer, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(fileCer);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderSignature() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.SIGNATURE);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPSSAlgorithms(Arrays.asList("SHA256"), Arrays.asList(Boolean.FALSE), Arrays.asList(SEID_SHA256_RSA_PSS), usageList01));
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPKCS1Algorithms(Arrays.asList("SHA256", "SHA512", "SHA384"), Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE), Arrays.asList(SEID_SHA256_RSA_PKCS1_5, SEID_SHA256_RSA_PKCS1_5, SEID_SHA256_RSA_PKCS1_5), usageList01));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    private AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderDecryptionEncryptionAuthentication() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.AUTHENTICATION, UsageRelated.Usage.SIGNATURE);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPSSAlgorithms(Arrays.asList("SHA256"), Arrays.asList(Boolean.FALSE), Arrays.asList(SEID_SHA256_RSA_PSS), usageList01));
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPKCS1Algorithms(Arrays.asList("SHA256", "SHA512", "SHA384"), Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE), Arrays.asList(SEID_SHA256_RSA_PKCS1_5, SEID_SHA256_RSA_PKCS1_5, SEID_SHA256_RSA_PKCS1_5), usageList01));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        List<UsageRelated.Usage> usageList02 = Arrays.asList(UsageRelated.Usage.CIPHER);
        OCFDefaultAlgorithmFinder finder = OCFDefaultAlgorithmFinder.getInstance();
        try {
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList02, "RSA/ECB/PKCS1Padding", "RSA/PKCS1", new CardExecutionDecryptRSAParameterSpec("RSA/ECB/PKCS1Padding", new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), finder.findURI("RSA/ECB/PKCS1Padding"), null, HexUtil.parse(SEID_RSA_PKCS1_5))));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_T50;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo info) {
        return 12;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        c.add("SHA256");
        c.add("SHA512");
        c.add("SHA384");
        return c;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 0: 
            case 2: {
                byte se = HexUtil.parse(SEID_SHA256_RSA_PKCS1_5)[0];
                try {
                    CardExecutionSignAuthenticateParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                    byte[] algorithmID = parameterSpec.getAlgorithmID();
                    if (algorithmID != null && algorithmID.length == 1) {
                        se = algorithmID[0];
                    }
                }
                catch (InvalidParameterSpecException e) {
                    LOG.debug((Object)e);
                }
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)-13, se, null);
            }
            case 1: {
                byte se2 = HexUtil.parse(SEID_RSA_PKCS1_5)[0];
                try {
                    CardExecutionDecryptRSAParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionDecryptRSAParameterSpec.class);
                    byte[] algorithmID = parameterSpec.getAlgorithmID();
                    if (algorithmID != null && algorithmID.length == 1) {
                        se2 = algorithmID[0];
                    }
                }
                catch (InvalidParameterSpecException e) {
                    LOG.debug((Object)e);
                }
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)-13, se2, null);
            }
        }
        return super.createMSECommand(_channel, _info, _type, _hashAlgorithm, algorithmParameters);
    }

    @Override
    protected final CommandAPDU createSignHashCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        if (_hashValue == null || _hashValue.length < 256) {
            return new GISOCommandAPDU(true, (byte)0, (byte)42, (byte)-98, (byte)-102, _hashValue, 384);
        }
        throw new UnsupportedOperationException("something went wrong");
    }

    @Override
    protected final GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        return this.signHash(_channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        String pinName = CardOS50DTrust31.getPinNameForInfo(_info);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        LOG.debug((Object)("INIT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("INIT RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err == 27011) {
            throw new RetryCounterExpiredException(pinName, err, APDUCommands.getVerifyErrorMsg(err));
        }
        return err != 27012;
    }

    @Override
    protected void resetCard(CardChannel channel) {
        try {
            LOG.debug((Object)"reset of card");
            this.selectMasterFile(channel);
            CommandAPDU c = new CommandAPDU(HexUtil.parse("0022f300"));
            LOG.debug((Object)("RESET CMD: " + HexUtil.hexify(c.getBytes())));
            ResponseAPDU r = channel.sendCommandAPDU(c);
            LOG.debug((Object)("RESET RSP: " + HexUtil.hexify(r.getBytes())));
            LOG.debug((Object)"reset of card finished");
            ChannelState channelState = this.getChannelState(channel);
            if (channelState != null) {
                channelState.resetCurrentSignCount();
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)("reset of card failed: " + t.getMessage()), t);
        }
    }

    @Override
    public synchronized void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 22 f3 00")));
            channel.setState(null);
        }
        catch (Exception e) {
            LOG.debug((Object)("reset failed: " + e.getMessage()));
        }
        finally {
            cardChannelManager.destroy();
        }
    }
}

