/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.base;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultHBA
extends GovCS {
    private static final Log log = LogFactory.getLog(DefaultHBA.class);
    public static final String ISSUER_HBA = "HBA";

    @Override
    protected String getIssuerConstant() {
        return ISSUER_HBA;
    }

    @Override
    protected byte[] getHistoricals() {
        return null;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return true;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfPinCH = 2000001L;
        long idOfMFApplication = 1000000L;
        CardApplication applicationQSIGN = this.createQSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardApplication applicationESIGN = this.createESignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        byte pinID01 = 1;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pinCH = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPinCH, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{4000001L, 4000002L});
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationQSIGN);
        mfManager.putApplication(applicationESIGN);
        mfManager.putPin(pinCH);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.HPC_HBA;
    }

    private CardApplication createQSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplicationQSIGN = 1000003L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("84");
        byte pinID01 = -127;
        FileReference dirRefQSIGN = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefQSIGN, cerRef01);
        FileReference attrCerRef02 = new FileReference(2, "c001");
        FileEntry fileEntry02 = new FileEntry(dirRefQSIGN, attrCerRef02);
        FileReference attrCerRef03 = new FileReference(2, "c002");
        FileEntry fileEntry03 = new FileEntry(dirRefQSIGN, attrCerRef03);
        FileReference attrCerRef04 = new FileReference(2, "c003");
        FileEntry fileEntry04 = new FileEntry(dirRefQSIGN, attrCerRef04);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, new long[]{idOfFile02, idOfFile03, idOfFile04});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer1", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer2", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer3", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplicationQSIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, new long[]{idOfFile02, idOfFile03, idOfFile04}, new long[]{idOfPin01}, k01);
        CardObjectManagerImpl managerQSIGN = new CardObjectManagerImpl(idOfApplicationQSIGN);
        CardApplicationImpl applicationQSIGN = new CardApplicationImpl("d27600006601", idOfApplicationQSIGN, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerQSIGN, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationQSIGN.putPin(pin01);
        applicationQSIGN.putFile(file01);
        applicationQSIGN.putFile(file02);
        applicationQSIGN.putFile(file03);
        applicationQSIGN.putFile(file04);
        applicationQSIGN.putKey(key01);
        return applicationQSIGN;
    }

    private CardApplication createESignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplicationESIGN = 1000001L;
        long idOfFile01 = 3000005L;
        long idOfFile02 = 3000006L;
        long idOfKey01 = 4000002L;
        long idOfKey02 = 4000003L;
        KeyID k01 = new KeyID("82");
        KeyID k02 = new KeyID("83");
        FileReference dirRefESIGN = new FileReference(4, "a000000167455349474e");
        FileReference cerRef01 = new FileReference(2, "c500");
        FileEntry fileEntry01 = new FileEntry(dirRefESIGN, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c200");
        FileEntry fileEntry02 = new FileEntry(dirRefESIGN, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_DEFAULT.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry01, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry02, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPinCH, k02);
        CardObjectManagerImpl managerESIGN = new CardObjectManagerImpl(idOfApplicationESIGN);
        CardApplicationImpl applicationESIGN = new CardApplicationImpl("a000000167455349474e", idOfApplicationESIGN, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry01, (CardObjectManager)managerESIGN, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationESIGN.putFile(file01);
        applicationESIGN.putFile(file02);
        applicationESIGN.putKey(key01);
        applicationESIGN.putKey(key02);
        return applicationESIGN;
    }

    @Override
    protected final OCFCertificateInfo[] createCertificateInfos() {
        ArrayList<OCFCertificateInfo> l = new ArrayList<OCFCertificateInfo>();
        l.add(new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c000"), new KeyID("84"), -127, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, new FileEntry[]{new FileEntry(new FileReference(4, "d27600006601"), new FileReference(2, "c001")), new FileEntry(new FileReference(4, "d27600006601"), new FileReference(2, "c002")), new FileEntry(new FileReference(4, "d27600006601"), new FileReference(2, "c003"))}));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c500"), new KeyID("82"), 1, OCFCertificateInfo.ChainEntry.USER));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c200"), new KeyID("83"), 1, OCFCertificateInfo.ChainEntry.USER));
        return l.toArray(new OCFCertificateInfo[l.size()]);
    }

    @Override
    protected String getOSName() {
        return "unknown COS";
    }

    @Override
    public String getDisplayName() {
        return "Heilberufsausweis ";
    }

    @Override
    protected final int getMaximumChunkSize() {
        return 240;
    }

    protected final byte[] get2BlockPin(OCFCertificateInfo _info, char[] _pin) {
        byte[] result = new byte[this.getPasswordBlockLength(_info)];
        Arrays.fill(result, this.getPasswordBlockFiller(_info));
        result[0] = (byte)(0x20 | (_pin == null ? 15 : _pin.length));
        if (_pin != null) {
            char[] pin = new char[_pin.length];
            System.arraycopy(_pin, 0, pin, 0, pin.length);
            int j = 0;
            for (int i = 1; i < result.length && j < pin.length; ++i) {
                result[i] = (byte)((pin[j++] & 0xF) << 4);
                if (j < pin.length) {
                    int n = i;
                    result[n] = (byte)(result[n] | (byte)(pin[j++] & 0xF));
                    continue;
                }
                int n = i;
                result[n] = (byte)(result[n] | 0xF);
            }
            Arrays.fill(pin, '\u0000');
        }
        return result;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected final byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return this.get2BlockPin(_info, _pin);
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    protected final void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return -1;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (!"83".equals(HexString.hexify(_info.getKeyID().id))) {
            c.add("SHA1");
            if ("84".equals(HexString.hexify(_info.getKeyID().id))) {
                c.add("RIPEMD160");
                c.add("SHA224");
                c.add("SHA384");
                c.add("SHA512");
                c.add("SHA256");
            }
        }
        return c;
    }

    @Override
    protected final boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                data.write(-124);
                data.write(_info.getKeyID().getID().length);
                data.write(_info.getKeyID().getID(), 0, _info.getKeyID().getID().length);
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data.toByteArray());
            }
            case 0: {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                data.write(-124);
                data.write(_info.getKeyID().getID().length);
                data.write(_info.getKeyID().getID(), 0, _info.getKeyID().getID().length);
                data.write(-128);
                data.write(1);
                data.write(this.getHashAndCryptoID(_hashAlgorithm, _info));
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
            }
            case 2: {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                data.write(-124);
                data.write(_info.getKeyID().getID().length);
                data.write(_info.getKeyID().getID(), 0, _info.getKeyID().getID().length);
                data.write(-128);
                data.write(1);
                data.write(this.getHashAndCryptoID(_hashAlgorithm, _info));
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-92, data.toByteArray());
            }
        }
        return null;
    }

    private int getHashAndCryptoID(String _hashAlgorithm, OCFCertificateInfo _info) {
        if (!"84".equals(HexString.hexify(_info.getKeyID().id))) {
            return 5;
        }
        if ("SHA1".equals(_hashAlgorithm)) {
            return 18;
        }
        if ("RIPEMD160".equals(_hashAlgorithm)) {
            return 34;
        }
        if ("SHA224".equals(_hashAlgorithm)) {
            return 50;
        }
        if ("SHA256".equals(_hashAlgorithm)) {
            return 66;
        }
        if ("SHA384".equals(_hashAlgorithm)) {
            return 82;
        }
        if ("SHA512".equals(_hashAlgorithm)) {
            return 98;
        }
        return 0;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = -120;
        store[2] = 0;
        store[3] = 0;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters) {
        int index = 0;
        byte[] store = new byte[10 + _encryptedBytes.length];
        store[index++] = 0;
        store[index++] = 42;
        store[index++] = -128;
        store[index++] = -122;
        store[index++] = 0;
        int len = _encryptedBytes.length + 1;
        store[index++] = (byte)(len >> 8 & 0xFF);
        store[index++] = (byte)(len >> 0 & 0xFF);
        store[index++] = _paddingIndicator;
        System.arraycopy(_encryptedBytes, 0, store, index, _encryptedBytes.length);
        index += _encryptedBytes.length;
        store[index++] = 1;
        store[index++] = 0;
        return new CommandAPDU(store);
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        try {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            int err = 36864;
            boolean tryGetData = false;
            cmd = this.createSelectMasterFile();
            if (cmd != null) {
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    tryGetData = true;
                }
                if ((err = res.sw()) != 36864) {
                    tryGetData = true;
                }
            }
            if ((res = _channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 a4 04 0c 06 d2 76 00 00 40 02")))) == null) {
                return "";
            }
            err = res.sw();
            if (err == 36864) {
                return ISSUER_HBA;
            }
            return "";
        }
        catch (Throwable ex) {
            log.error((Object)"", ex);
            return null;
        }
    }
}

