/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCSClientFactory;
import de.bos_bremen.gov2.jca_provider.ocf.cards.base.DefaultHBA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epo.EPO;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epo.OLDEPO;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.QuoVadisToken;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseIDQuoVadis;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseIDTestPost1;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseIDTestSwisscom;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.at.ATrustV2Card;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.bg.InfoNotary;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.fi.FinEID21;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.fr.certinomis.Certinomis;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.it.infocert.InfoCert;
import de.bos_bremen.gov2.jca_provider.ocf.cards.micardo.MICARDOv21r1_DTrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.seccos.SECCOS_HVB;
import de.bos_bremen.gov2.jca_provider.ocf.cards.seccos.STrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.DTrust2k;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.DTrust2kMS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43_2;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43_ms;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43b;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.TCTrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.TCTrustUnlimited;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.HBA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30BNotkCARD;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30DGNService;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30SignTrustMCARD;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30SignTrustMCARD100;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30SignTrustStandard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32BNotkCARD;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32DatevStandard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32SignTrustMCARD;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32SignTrustMCARD100;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32SignTrustStandard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS_ATrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS_TCTrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.NetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.NetKey30M;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_Datev_PKS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_SignTrust_PKS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_TeleSec_NetKey;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_TeleSec_NetKeyE4;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_TeleSec_NetKeyOld;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_TeleSec_PKS;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestGovCSFactory
extends CardServiceFactory {
    private static final Log log = LogFactory.getLog(GovCSClientFactory.class);
    private static final Map<CardType, GovCS> availableGovernikusCSs = new LinkedHashMap<CardType, GovCS>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestGovCSFactory() {
        Map<CardType, GovCS> map = availableGovernikusCSs;
        synchronized (map) {
            if (availableGovernikusCSs.isEmpty()) {
                int n = CardType.UNSUPPORTED.getType() + 1;
                CardType ct = null;
                GovCS gcs = null;
                ct = new CardType(n++);
                gcs = new EPA();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new TCOSv2r3_TeleSec_PKS();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new TCOSv2r3_Datev_PKS();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new TCOSv2r3_SignTrust_PKS();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new TCOSv2r3_TeleSec_NetKey();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new TCOSv2r3_TeleSec_NetKeyE4();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new TCOSv2r3_TeleSec_NetKeyOld();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new MICARDOv21r1_DTrust();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new SECCOS_HVB();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new Siemensv43();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new Siemensv43_2();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS_TCTrust();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS_ATrust();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new STrust();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new Siemensv43_ms();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new DTrust2kMS();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new DTrust2k();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS30SignTrustStandard();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS30SignTrustMCARD();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS30BNotkCARD();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS30SignTrustMCARD100();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS30DGNService();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS30();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS32SignTrustStandard();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS32DatevStandard();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS32SignTrustMCARD100();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS32SignTrustMCARD();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new StarCOS32BNotkCARD();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new NetKey30();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new NetKey30M();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new Siemensv43b();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new FinEID21();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new TCTrustUnlimited();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new TCTrust();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new InfoNotary();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                try {
                    gcs = (GovCS)Class.forName("de.bos_bremen.gov2.jca_provider.ocf.cards.debug.ZCxxZeitControlBasicCardDebug").newInstance();
                    ct = new CardType(n++);
                    ct.setInfo(gcs.toString());
                    availableGovernikusCSs.put(ct, gcs);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ct = new CardType(n++);
                gcs = new HBA();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new DefaultHBA();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new EPO();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new OLDEPO();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new ATrustV2Card();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new SuisseIDTestSwisscom();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new SuisseIDQuoVadis();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new QuoVadisToken();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new SuisseIDTestPost1();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new Certinomis();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
                ct = new CardType(n++);
                gcs = new InfoCert();
                ct.setInfo(gcs.toString());
                availableGovernikusCSs.put(ct, gcs);
            }
        }
    }

    @Override
    protected CardType getCardType(CardID _cardId, CardServiceScheduler _scheduler) throws CardTerminalException {
        log.debug((Object)"==================================");
        log.debug((Object)"-------- TestGovCSFactory --------");
        log.debug((Object)"==================================");
        byte[] historicals = _cardId.getHistoricals();
        char[] atr = new char[Math.max(_cardId.getATR().length, 30) * 3];
        Arrays.fill(atr, ' ');
        String s = HexString.hexify(_cardId.getATR());
        System.arraycopy(s.toCharArray(), 0, atr, 0, s.length());
        log.debug((Object)("ATR: " + HexString.hexify(_cardId.getATR()) + " / Historicals: " + HexString.hexify(historicals)));
        log.debug((Object)(new String(atr) + "/Historicals: " + HexString.hexify(historicals)));
        CardType result = CardType.UNSUPPORTED;
        String issuer = null;
        for (Map.Entry<CardType, GovCS> entry : availableGovernikusCSs.entrySet()) {
            GovCS cardService = entry.getValue();
            CardType cardType = entry.getKey();
            if (!cardService.historicalsEquals(historicals)) continue;
            if (issuer == null || cardService.isIssuerReadRequired()) {
                CardChannel channel = null;
                try {
                    channel = _scheduler.allocateCardChannel(null, true);
                }
                catch (CardTerminalException ex) {
                    log.debug((Object)"", (Throwable)ex);
                }
                if (channel != null) {
                    issuer = cardService.readIssuerFromATR(channel);
                    log.debug((Object)("ISSUER : " + issuer));
                    try {
                        _scheduler.releaseCardChannel(channel);
                    }
                    catch (InvalidCardChannelException ex) {
                        log.debug((Object)"", (Throwable)ex);
                    }
                }
            }
            if (cardService.getIssuerConstant() != null && !cardService.getIssuerConstant().equals(issuer)) continue;
            log.debug((Object)"SUPPORTED CARD FOUND");
            result = cardType;
            break;
        }
        if (result == CardType.UNSUPPORTED) {
            log.debug((Object)"UNSUPPORTED CARD!!!");
        }
        return result;
    }

    @Override
    protected Enumeration getClasses(CardType _cardType) {
        GovCS o = availableGovernikusCSs.get(_cardType);
        return new SingleEnumeration(o == null ? null : o.getClass());
    }

    private static class SingleEnumeration
    implements Enumeration {
        private Object o = null;

        private SingleEnumeration(Object _o) {
            this.o = _o;
        }

        @Override
        public boolean hasMoreElements() {
            return this.o != null;
        }

        public Object nextElement() {
            Object oo = this.o;
            this.o = null;
            return oo;
        }
    }
}

