/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Constants;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.constants.Constants;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.EnhancedGovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.PinInformationProvider;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public interface TerminalOperationHandler {
    public static final boolean VERIFY_MODE = true;
    public static final boolean MODIFY_MODE = false;

    public ResponseAPDU verifyPassword(OCFCertificateInfo var1, GovCHVDialog var2, PinInformationProvider var3) throws CardTerminalException, OperationCancelledException, InvalidCardChannelException, RetryCounterExpiredException, ResponseCodeException;

    public ResponseAPDU modifyPassword(OCFCertificateInfo var1, GovCHVDialog var2, PinInformationProvider var3, byte[] var4, boolean var5) throws CardTerminalException, OperationCancelledException, InvalidCardChannelException, RetryCounterExpiredException, ResponseCodeException;

    public byte[] sendTerminalCommand(int var1, byte[] var2) throws IllegalArgumentException, CardTerminalException;

    public boolean isStructureForFeatureValid(int var1, byte[] var2) throws IllegalArgumentException;

    public void update(CardTerminal var1, Pcsc20Features var2, String var3);

    public static class Util
    implements Pcsc20Constants {
        private static final int TIMEOUT_KEY_COUNT_FACTOR = 12;
        private static final int MILLISECONDS_FACTOR = 1000;
        public static final int GET_KEY_PRESSED_DELAY = 50;
        private static final Log log = LogFactory.getLog(GovCS.class);

        static byte[] sendTerminalCMD(CardTerminal cardTerminal, int controlCode, byte[] controlStructure) throws CardTerminalException {
            if (PCSCCardTerminal.class.isInstance(cardTerminal)) {
                PCSCCardTerminal terminal = (PCSCCardTerminal)cardTerminal;
                return terminal.sendTerminalCommand(controlCode, controlStructure);
            }
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }

        public static ResponseAPDU sendTerminalCMD(CardTerminal cardTerminal, CommandAPDU cmd, GovCHVDialog chvDialog, boolean verify, PinInformationProvider pip, Pcsc20Features pcsc20Features) throws CardTerminalException {
            return Util.sendTerminalCMD(cardTerminal, cmd, chvDialog, verify, false, pip, pcsc20Features);
        }

        private static boolean cardIsPresent(CardTerminal pct) {
            boolean result = false;
            try {
                result = pct.isCardPresent(0);
            }
            catch (Exception e) {
                result = false;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        static ResponseAPDU sendTerminalCMD(CardTerminal cardTerminal, CommandAPDU cmd, GovCHVDialog chvDialog, boolean verify, boolean mctReaderDirect, PinInformationProvider pip, Pcsc20Features pcsc20Features) throws CardTerminalException {
            block63: {
                block62: {
                    Util.log.debug((Object)("PV/PM CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                    monitor = null;
                    useDirect = Util.usePCSCVerifyModifyDirect(cardTerminal, verify);
                    if (verify || !mctReaderDirect || pcsc20Features.getMctReaderDirect().valueAsNumber() == 0 || !(cardTerminal instanceof PCSCCardTerminal)) {
                        monitor = chvDialog.showReaderMessage();
                    }
                    if (mctReaderDirect && pcsc20Features.isFeatureSupported(8) && cardTerminal instanceof PCSCCardTerminal) {
                        pct = (PCSCCardTerminal)cardTerminal;
                        rc = null;
                        if (pcsc20Features.isFeatureSupported(10)) {
                            Util.log.debug((Object)"CMD: [get ifd pin properties]");
                            rc = pct.sendTerminalCommand(pcsc20Features.getIFDPINProperties().valueAsNumber(), new byte[0]);
                            Util.log.debug((Object)("RES [get ifd pin properties]: " + HexString.hexify(rc)));
                        }
                        Util.log.debug((Object)("CMD [perform verification/perform modification - mct reader direct]: " + HexString.hexify(cmd.getBuffer(), false)));
                        rc = pct.sendTerminalCommand(pcsc20Features.getMctReaderDirect().valueAsNumber(), cmd.getBuffer());
                        Util.log.debug((Object)("RES [perform verification/perform modification - mct reader direct]: " + HexString.hexify(rc)));
                        var11_19 = new ResponseAPDU(rc);
                        return var11_19;
                    }
                    if (!useDirect && !verify && pcsc20Features.isFeatureSupported(3) && cardTerminal instanceof PCSCCardTerminal) {
                        pct = (PCSCCardTerminal)cardTerminal;
                        okCount = 0;
                        if (EnhancedGovCHVDialog.class.isInstance(chvDialog) && ((EnhancedGovCHVDialog)chvDialog).getMode() == BDialogMode.CARD_INIT_2) {
                            ++okCount;
                        }
                        tmpDialog = null;
                        if (EnhancedGovCHVDialog.class.isInstance(chvDialog)) {
                            tmpDialog = (EnhancedGovCHVDialog)chvDialog;
                        }
                        m = new Object();
                        loop = true;
                        cancel = false;
                        error = false;
                        timeout = false;
                        time = Util.calculateTimeout(cmd) * (long)(3 - okCount);
                        start = System.currentTimeMillis();
                        now = System.currentTimeMillis();
                        result = 0;
                        display = 0;
                        rc = null;
                        if (pcsc20Features.isFeatureSupported(10)) {
                            Util.log.debug((Object)"CMD: [get ifd pin properties]");
                            rc = pct.sendTerminalCommand(pcsc20Features.getIFDPINProperties().valueAsNumber(), new byte[0]);
                            Util.log.debug((Object)("RES [get ifd pin properties]: " + HexString.hexify(rc)));
                        }
                        Util.log.debug((Object)("PM CMD [perform modification - modify pin start]: " + HexString.hexify(cmd.getBuffer(), false)));
                        rc = pct.sendTerminalCommand(pcsc20Features.getModifyPINStart().valueAsNumber(), cmd.getBuffer());
                        Util.log.debug((Object)("PM RES [perform modification - modify pin start]: " + HexString.hexify(rc)));
                        var26_48 = m;
                        synchronized (var26_48) {
                            while (loop) {
                                try {
                                    now = System.currentTimeMillis();
                                    if (now - start > time) {
                                        loop = false;
                                        timeout = true;
                                        break;
                                    }
                                    if (!Util.cardIsPresent(pct)) {
                                        loop = false;
                                        error = true;
                                        cancel = true;
                                        break;
                                    }
                                    try {
                                        m.wait(50L);
                                    }
                                    catch (InterruptedException ex) {
                                        loop = false;
                                        error = true;
                                        break;
                                    }
                                    rc = pct.sendTerminalCommand(pcsc20Features.getGetKeyPressed().valueAsNumber(), new byte[0]);
                                    if (ArrayUtil.isNullOrEmpty(rc)) {
                                        loop = false;
                                        break;
                                    }
                                    try {
                                        m.wait(50L);
                                    }
                                    catch (InterruptedException ex) {
                                        loop = false;
                                        error = true;
                                        break;
                                    }
                                    result = rc[0];
                                    if (result == 0) continue;
                                    if (result == 43) {
                                        ++display;
                                    } else if (result == 13) {
                                        if (++okCount == 3) break;
                                        if (tmpDialog != null) {
                                            tmpDialog.displayMessage(monitor, okCount);
                                        }
                                        display = 0;
                                    } else {
                                        if (result == 27) {
                                            loop = false;
                                            cancel = true;
                                            break;
                                        }
                                        if (result == 8) {
                                            if (display == 0) continue;
                                            --display;
                                        } else if (result == 10) {
                                            display = 0;
                                        } else {
                                            if (result == 64) {
                                                loop = false;
                                                error = true;
                                                break;
                                            }
                                            Util.log.debug((Object)("unknown return of reader: " + HexUtil.hexify(rc)));
                                            loop = false;
                                            error = true;
                                            break;
                                        }
                                    }
                                    chvDialog.pseudoDisplay(display);
                                }
                                catch (CardTerminalException e) {
                                    loop = false;
                                    error = true;
                                    break;
                                }
                            }
                        }
                        Util.log.debug((Object)"PM CMD: [perform modification - modify pin finish]");
                        rc = pct.sendTerminalCommand(pcsc20Features.getModifyPINFinish().valueAsNumber(), new byte[0]);
                        Util.log.debug((Object)("PM RES [perform modification - modify pin finish]: " + HexString.hexify(rc)));
                        var26_48 = new ResponseAPDU(rc);
                        return var26_48;
                    }
                    if (useDirect || !verify || !pcsc20Features.isFeatureSupported(1) || !(cardTerminal instanceof PCSCCardTerminal)) break block62;
                    pct = (PCSCCardTerminal)cardTerminal;
                    m = new Object();
                    loop = true;
                    cancel = false;
                    error = false;
                    timeout = false;
                    time = Util.calculateTimeout(cmd);
                    start = System.currentTimeMillis();
                    now = System.currentTimeMillis();
                    result = 0;
                    display = 0;
                    rc = null;
                    if (pcsc20Features.isFeatureSupported(10)) {
                        Util.log.debug((Object)"CMD: [get ifd pin properties]");
                        rc = pct.sendTerminalCommand(pcsc20Features.getIFDPINProperties().valueAsNumber(), new byte[0]);
                        Util.log.debug((Object)("RES [get ifd pin properties]: " + HexString.hexify(rc)));
                    }
                    Util.log.debug((Object)("PV CMD [perform verification - verify pin start]: " + HexString.hexify(cmd.getBuffer(), false)));
                    rc = pct.sendTerminalCommand(pcsc20Features.getVerifyPINStart().valueAsNumber(), cmd.getBuffer());
                    Util.log.debug((Object)("PV RES [perform verification - verify pin start]: " + HexString.hexify(rc)));
                    var24_42 = m;
                    synchronized (var24_42) {
                        while (loop) {
                            try {
                                now = System.currentTimeMillis();
                                if (now - start > time) {
                                    loop = false;
                                    timeout = true;
                                    break;
                                }
                                if (!Util.cardIsPresent(pct)) {
                                    loop = false;
                                    error = true;
                                    cancel = true;
                                    break;
                                }
                                try {
                                    m.wait(50L);
                                }
                                catch (InterruptedException ex) {
                                    loop = false;
                                    error = true;
                                    break;
                                }
                                rc = pct.sendTerminalCommand(pcsc20Features.getGetKeyPressed().valueAsNumber(), new byte[0]);
                                if (ArrayUtil.isNullOrEmpty(rc)) {
                                    loop = false;
                                    break;
                                }
                                try {
                                    m.wait(50L);
                                }
                                catch (InterruptedException ex) {
                                    loop = false;
                                    error = true;
                                    break;
                                }
                                result = rc[0];
                                if (result == 0) continue;
                                if (result == 43) {
                                    ++display;
                                } else {
                                    if (result == 13) {
                                        loop = false;
                                        break;
                                    }
                                    if (result == 27) {
                                        loop = false;
                                        cancel = true;
                                        break;
                                    }
                                    if (result == 8) {
                                        if (display == 0) continue;
                                        --display;
                                    } else if (result == 10) {
                                        display = 0;
                                    } else {
                                        if (result == 64) {
                                            loop = false;
                                            error = true;
                                            break;
                                        }
                                        Util.log.debug((Object)("unknown return of reader: " + HexUtil.hexify(rc)));
                                        loop = false;
                                        error = true;
                                        break;
                                    }
                                }
                                chvDialog.pseudoDisplay(display);
                            }
                            catch (CardTerminalException e) {
                                loop = false;
                                error = true;
                                break;
                            }
                        }
                        Util.log.debug((Object)"PM CMD: [perform verification - verify pin finish]");
                        rc = pct.sendTerminalCommand(pcsc20Features.getVerifyPINFinish().valueAsNumber(), new byte[0]);
                        Util.log.debug((Object)("PV RES [perform verification - verify pin finish]: " + HexString.hexify(rc)));
                        var25_47 = new ResponseAPDU(rc);
                        return var25_47;
                    }
                }
                if (verify || !pcsc20Features.isFeatureSupported(7) || !(cardTerminal instanceof PCSCCardTerminal)) ** GOTO lbl-1000
                pct = (PCSCCardTerminal)cardTerminal;
                Util.log.debug((Object)("PM CMD [perform modification - modify pin direct]: " + HexString.hexify(cmd.getBuffer(), false)));
                rc = pct.sendTerminalCommand(pcsc20Features.getModifyPINDirect().valueAsNumber(), cmd.getBuffer());
                Util.log.debug((Object)("PM RES [perform modification - modify pin direct]: " + HexString.hexify(rc)));
                Util.log.debug((Object)("RES: " + HexString.hexify(rc)));
                var11_22 = new ResponseAPDU(rc);
                return var11_22;
lbl-1000:
                // 1 sources

                {
                    if (!verify || !pcsc20Features.isFeatureSupported(6) || !(cardTerminal instanceof PCSCCardTerminal)) break block63;
                    pct = (PCSCCardTerminal)cardTerminal;
                    Util.log.debug((Object)("PV CMD [perform verification - verify pin direct]: " + HexString.hexify(cmd.getBuffer(), false)));
                    rc = pct.sendTerminalCommand(pcsc20Features.getVerifyPINDirect().valueAsNumber(), cmd.getBuffer());
                    Util.log.debug((Object)("PV RES [perform verification - verify pin direct]: " + HexString.hexify(rc)));
                    var11_23 = new ResponseAPDU(rc);
                }
                return var11_23;
                finally {
                    if (monitor != null) {
                        chvDialog.hideReaderMessage(monitor);
                    }
                }
            }
            throw new IllegalArgumentException("illegal execution");
        }

        public static boolean usePCSCVerifyModifyDirect(CardTerminal cardTerminal, boolean verify) {
            boolean useDirect = false;
            if (cardTerminal instanceof PCSCCardTerminal) {
                Pcsc20Features feat = ((PCSCCardTerminal)cardTerminal).getPcsc20Features();
                useDirect = feat.usePCSCVerifyModifyDirect(cardTerminal.getName(), verify);
            }
            return useDirect;
        }

        public static long calculateTimeout(CommandAPDU cmd) {
            int delayKey;
            int delayInput = cmd.getBuffer()[0];
            if (delayInput < 0) {
                delayInput += 256;
            }
            if ((delayKey = cmd.getBuffer()[1]) < 0) {
                delayKey += 256;
            }
            return delayInput * 1000 + 12 * delayKey * 1000;
        }
    }
}

