/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.terminal.pcsc.PaceCapabilities;
import de.bos_bremen.basecard.terminal.pcsc.PaceConstants;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1Util;
import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.gov2.jca_provider.ocf.CardTerminalManager;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitCommand;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitParameter;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitResult;
import de.bos_bremen.gov2.jca_provider.ocf.WrongConfirmedNewPinException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.ChannelState;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVConfiguration;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.SMCard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.TerminalOperationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.CardErrorUtil;
import de.bos_bremen.gov2.jca_provider.ocf.channel.SecureMessaging;
import de.bos_bremen.gov2.jca_provider.ocf.channel.impl.CardCommunicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SMGovCS
extends GovCS
implements SMCard {
    private static final Log LOG = LogFactory.getLog(SMGovCS.class);
    private SecureMessaging<?, ?, ?> sm = null;

    protected SMGovCS() {
    }

    @Override
    public final synchronized ResponseAPDU sendCommandAPDU(CardChannel channel, CommandAPDU command) throws CardTerminalException, IllegalArgumentException {
        AssertUtil.notNull(channel, "channel");
        AssertUtil.notNull(command, "command");
        CommandAPDU smCommand = command;
        CardCommunicationImpl cc = null;
        if (this.sm != null) {
            cc = new CardCommunicationImpl(command);
            this.sm.toCard(cc);
            smCommand = cc.getCommands()[0];
            LOG.debug((Object)("CMD SM: " + new HexBinaryAdapter().marshal(smCommand.getBytes())));
        }
        ResponseAPDU response = null;
        response = channel.sendCommandAPDU(smCommand);
        if (this.sm != null && response.data() == null) {
            this.sm = null;
        }
        if (this.sm != null) {
            LOG.debug((Object)("RSP SM: " + new HexBinaryAdapter().marshal(response.getBytes())));
            cc.setResponse(response);
            cc.setFinished(false);
            this.sm.fromCard(cc);
            return cc.getResponse();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ResponseAPDU sendCommandAPDU(CommandAPDU command) throws CardTerminalException, IllegalArgumentException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            ResponseAPDU responseAPDU = this.sendCommandAPDU(channel, command);
            return responseAPDU;
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    protected synchronized void setSM(SecureMessaging<?, ?, ?> sm) {
        this.sm = sm;
    }

    protected final boolean isSMEstablished() {
        return this.sm != null;
    }

    @Override
    protected void resetCard(CardChannel channel) {
        try {
            LOG.debug((Object)"reset of card");
            this.selectMasterFile(channel);
            CommandAPDU c = new CommandAPDU(HexUtil.parse("0022f301"));
            LOG.debug((Object)("RESET CMD: " + HexUtil.hexify(c.getBytes())));
            ResponseAPDU r = this.sendCommandAPDU(channel, c);
            LOG.debug((Object)("RESET RSP: " + HexUtil.hexify(r.getBytes())));
            LOG.debug((Object)"reset of card finished");
            ChannelState channelState = this.getChannelState(channel);
            if (channelState != null) {
                channelState.resetCurrentSignCount();
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)("reset of card failed: " + t.getMessage()), t);
        }
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        if (_hashValue != null && this.usesASN1HeaderWithAuthentify()) {
            LOG.debug((Object)("usesASN1HeaderWithAuthentify=" + this.usesASN1HeaderWithAuthentify()));
            try {
                _hashValue = new DigestInfo(HashAlgorithm.Algorithm.getAlgorithmByName(_hashAlgorithm), _hashValue).getEncoded();
                LOG.debug((Object)("pkcs#1=" + HexString.hexify(_hashValue)));
            }
            catch (Exception ex) {
                LOG.error((Object)"", (Throwable)ex);
            }
        }
        CommandAPDU cmd = this.createAuthentifyCommand(_hashValue, algorithmParameters);
        LOG.debug((Object)("AUTH COMMAND : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("AUTH RESULT  : " + (res.getBuffer().length - 2) + " bytes, " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        this.authentifyAdjust(ro, algorithmParameters);
        return ro;
    }

    @Override
    protected int changePassword(CardChannel _channel, OCFCertificateInfo _info, char[] _pin, char[] _newPin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, CardTerminalException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        boolean pinpadUsable;
        String pinName = SMGovCS.getPinNameForInfo(_info);
        int retryCount = -1;
        boolean initCard = false;
        try {
            retryCount = this.getRetryCount(_channel, _info);
        }
        catch (NotYetInitializedException e) {
            initCard = true;
        }
        ResponseAPDU res = null;
        GovCHVDialog chvDialog = null;
        try {
            chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
            chvDialog.setParentWindow(this.parentWindow);
        }
        catch (InstantiationException ex) {
            throw new OperationCancelledException("", CardErrorUtil.getErrorCodeForRetries(retryCount), ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new OperationCancelledException("", CardErrorUtil.getErrorCodeForRetries(retryCount), ex.getMessage(), ex);
        }
        if (_pin == null) {
            GovCHVConfiguration config = new GovCHVConfiguration(retryCount, initCard && (this.getInitPIN() != null || this.usesNullPIN()) ? BDialogMode.CARD_INIT_2 : (initCard ? BDialogMode.CARD_INIT_3 : BDialogMode.CARD_CHANGE), this.getMinPINLength(_info), this.getMaxPINLength(_info), _info, this.createTerminalString(_channel), !this.usesNullPIN() ? this.getInitPIN() : new char[6], this.getMinPINLengthInit(_info), this.getMaxPINLengthInit(_info), this.getClass());
            config.setShowPseudoDisplay(this.pcsc20Features.getModifyPINStart().valueAsNumber() != 0);
            if (this.pcsc20Features.getModifyPINStart().valueAsNumber() != 0) {
                config.setShowPseudoDisplay(!TerminalOperationHandler.Util.usePCSCVerifyModifyDirect(this.ctReference, false));
            }
            chvDialog.setConfiguration(config);
        }
        boolean bl = pinpadUsable = this.getMaxPINLength(_info) == this.getMinPINLength(_info) && this.getPinEncoder(_info) == PinEncoder.ENCODER_T50 && this.getPasswordBlockLength(_info) <= 0;
        if (!pinpadUsable) {
            boolean bl2 = pinpadUsable = initCard ? this.isPinpadUsableInitCaseForT50PinOfVariableLength() : this.isPinpadUsableChangeCaseForT50PinOfVariableLength();
        }
        if (!this.useKeyboard() && _newPin == null && pinpadUsable) {
            byte[] firstPin;
            byte[] byArray = firstPin = _pin != null ? ByteUtil.convert(_pin) : null;
            if (initCard && !this.usesNullPIN()) {
                firstPin = ByteUtil.convert(this.getInitPIN());
            }
            if (initCard && this.usesNullPIN()) {
                firstPin = new byte[6];
                Arrays.fill(firstPin, (byte)0);
            }
            if ((res = this.terminalHandler.modifyPassword(_info, chvDialog, this, firstPin, initCard)) != null) {
                LOG.debug((Object)("VP RES : " + HexString.hexify(res.getBuffer(), false)));
                LOG.debug((Object)("VP RES : " + APDUCommands.getChangePasswordErrorMsg(res.sw())));
                if (res.sw() == 25616 || res.sw() == 28160) {
                    res = null;
                } else {
                    int result = this.evaluateChangePasswordResultCode(pinName, retryCount, res.sw());
                    return result;
                }
            }
        }
        char[] oldPIN = null;
        char[] newPIN = null;
        if (_pin == null || _newPin == null) {
            chvDialog.show();
            int result = chvDialog.getResult();
            if (result == 2) {
                throw new PinInputCancelledException(pinName, CardErrorUtil.getErrorCodeForRetries(retryCount), APDUCommands.getVerifyErrorMsg(0));
            }
            oldPIN = initCard && !ArrayUtil.isNullOrEmpty(this.getInitPIN()) ? this.getInitPIN() : (initCard && this.usesNullPIN() ? new char[6] : chvDialog.getPIN());
            newPIN = chvDialog.getNewPIN();
        } else {
            oldPIN = new char[_pin.length];
            System.arraycopy(_pin, 0, oldPIN, 0, _pin.length);
            newPIN = new char[_newPin.length];
            System.arraycopy(_newPin, 0, newPIN, 0, _newPin.length);
        }
        CommandAPDU cmd = this.createChangePasswordCommand(_info, oldPIN, newPIN);
        LOG.debug((Object)((!initCard ? "CHANGE" : "INIT") + " 1 CMD : " + HexString.hexify(cmd.getBuffer(), 0, Math.min(5, cmd.getBuffer().length), false)));
        res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)((!initCard ? "CHANGE" : "INIT") + " 1 RES : " + HexString.hexify(res.getBuffer(), false)));
        int resultCode = this.evaluateChangePasswordResultCode(pinName, retryCount, res.sw());
        return resultCode;
    }

    @Override
    protected int changePassword(CardChannel _channel, CardPin _cardPin, char[] _pin, char[] _newPin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, CardTerminalException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        boolean pinpadUsable;
        String pinName = SMGovCS.getPinName(_cardPin);
        int retryCount = -1;
        boolean initCard = false;
        try {
            retryCount = _cardPin.getRetries(_channel);
        }
        catch (NotYetInitializedException e) {
            initCard = true;
        }
        ResponseAPDU res = null;
        GovCHVDialog chvDialog = null;
        try {
            chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
            chvDialog.setParentWindow(this.parentWindow);
        }
        catch (InstantiationException ex) {
            throw new OperationCancelledException("", -1, ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new OperationCancelledException("", -1, ex.getMessage(), ex);
        }
        GovCS.CardPinOCFCertificateInfo cpInfo = new GovCS.CardPinOCFCertificateInfo(_cardPin);
        if (_pin == null) {
            GovCHVConfiguration config = new GovCHVConfiguration(retryCount, initCard && (this.getInitPIN() != null || this.usesNullPIN()) ? BDialogMode.CARD_INIT_2 : (initCard ? BDialogMode.CARD_INIT_3 : BDialogMode.CARD_CHANGE), this.getMinPINLength(cpInfo), this.getMaxPINLength(cpInfo), cpInfo, this.createTerminalString(_channel), !this.usesNullPIN() ? this.getInitPIN() : new char[6], this.getMinPINLengthInit(cpInfo), this.getMaxPINLengthInit(cpInfo), this.getClass());
            config.setShowPseudoDisplay(this.pcsc20Features.getModifyPINStart().valueAsNumber() != 0);
            if (this.pcsc20Features.getModifyPINStart().valueAsNumber() != 0) {
                config.setShowPseudoDisplay(!TerminalOperationHandler.Util.usePCSCVerifyModifyDirect(this.ctReference, false));
            }
            chvDialog.setConfiguration(config);
        }
        boolean bl = pinpadUsable = this.getMaxPINLength(cpInfo) == this.getMinPINLength(cpInfo) && this.getPinEncoder(cpInfo) == PinEncoder.ENCODER_T50 && this.getPasswordBlockLength(cpInfo) <= 0;
        if (!pinpadUsable) {
            boolean bl2 = pinpadUsable = initCard ? this.isPinpadUsableInitCaseForT50PinOfVariableLength() : this.isPinpadUsableChangeCaseForT50PinOfVariableLength();
        }
        if (!this.useKeyboard() && _newPin == null && pinpadUsable) {
            byte[] firstPin;
            byte[] byArray = firstPin = _pin != null ? ByteUtil.convert(_pin) : null;
            if (initCard && !this.usesNullPIN()) {
                firstPin = ByteUtil.convert(this.getInitPIN());
            }
            if (initCard && this.usesNullPIN()) {
                firstPin = new byte[6];
                Arrays.fill(firstPin, (byte)0);
            }
            if ((res = this.terminalHandler.modifyPassword(cpInfo, chvDialog, this, firstPin, initCard)) != null) {
                LOG.debug((Object)("VP RES : " + HexString.hexify(res.getBuffer(), false)));
                LOG.debug((Object)("VP RES : " + APDUCommands.getChangePasswordErrorMsg(res.sw())));
                if (res.sw() == 25616 || res.sw() == 28160) {
                    res = null;
                } else {
                    int result = this.evaluateChangePasswordResultCode(pinName, retryCount, res.sw());
                    return result;
                }
            }
        }
        char[] oldPIN = null;
        char[] newPIN = null;
        if (_pin == null || _newPin == null) {
            chvDialog.show();
            int result = chvDialog.getResult();
            if (result == 2) {
                throw new PinInputCancelledException(SMGovCS.getPinName(_cardPin), -1, APDUCommands.getVerifyErrorMsg(0));
            }
            oldPIN = initCard && !ArrayUtil.isNullOrEmpty(this.getInitPIN()) ? this.getInitPIN() : (initCard && this.usesNullPIN() ? new char[6] : chvDialog.getPIN());
            newPIN = chvDialog.getNewPIN();
        } else {
            oldPIN = new char[_pin.length];
            System.arraycopy(_pin, 0, oldPIN, 0, _pin.length);
            newPIN = new char[_newPin.length];
            System.arraycopy(_newPin, 0, newPIN, 0, _newPin.length);
        }
        CommandAPDU cmd = this.createChangePasswordCommand(cpInfo, oldPIN, newPIN);
        LOG.debug((Object)((!initCard ? "CHANGE" : "INIT") + " 1 CMD : " + HexString.hexify(cmd.getBuffer(), 0, Math.min(5, cmd.getBuffer().length), false)));
        res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)((!initCard ? "CHANGE" : "INIT") + " 1 RES : " + HexString.hexify(res.getBuffer(), false)));
        int resultCode = this.evaluateChangePasswordResultCode(pinName, retryCount, res.sw());
        return resultCode;
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        CommandAPDU cmd = this.createDecryptCommand(_encryptedBytes, this.getPaddingIndicator(), algorithmParameters);
        LOG.debug((Object)("DECRYPT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("DECRYPT RESULT : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        return ro;
    }

    @Override
    protected synchronized boolean isInitialized(CardChannel _channel, CardPin _pin) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        String pinName = SMGovCS.getPinName(_pin);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_pin.getPinID());
        LOG.debug((Object)("INIT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("INIT RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err == 27011) {
            throw new RetryCounterExpiredException(pinName, err, APDUCommands.getVerifyErrorMsg(err));
        }
        return err != 27013;
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        String pinName = SMGovCS.getPinNameForInfo(_info);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        LOG.debug((Object)("INIT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("INIT RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err == 27011) {
            throw new RetryCounterExpiredException(pinName, err, APDUCommands.getVerifyErrorMsg(err));
        }
        return err != 27013;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel, int bytes) {
        try {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            int err = 36864;
            boolean tryGetData = false;
            cmd = this.createSelectMasterFile();
            if (cmd != null) {
                res = this.sendCommandAPDU(_channel, cmd);
                if (res == null) {
                    tryGetData = true;
                }
                if ((err = res.sw()) != 36864) {
                    tryGetData = true;
                }
            }
            if ((res = this.sendCommandAPDU(_channel, new CommandAPDU(HexString.parseHexString("00 a4 02 0c 02 2f 02")))) == null) {
                tryGetData = true;
            }
            if ((err = res.sw()) != 36864) {
                tryGetData = true;
            }
            if (tryGetData) {
                cmd = new CommandAPDU(HexString.parseHexString("00 ca 01 80 00"));
                res = this.sendCommandAPDU(_channel, cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                err = res.sw();
                if (err != 36864) {
                    throw new ResponseCodeException(err, APDUCommands.getReadBinaryErrorMsg(err));
                }
                return HexString.hexify(res.data());
            }
            cmd = this.createReadBinaryCommand(0, bytes);
            res = this.sendCommandAPDU(_channel, cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            err = res.sw();
            if (err != 36864) {
                throw new ResponseCodeException(err, APDUCommands.getReadBinaryErrorMsg(err));
            }
            String result = res.data() == null ? null : HexString.hexify(res.data(), false);
            return result;
        }
        catch (Throwable ex) {
            LOG.error((Object)"", ex);
            return null;
        }
    }

    protected String readPKCS15FileFromCard(CardChannel _channel, String fid) {
        try {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            int err = 36864;
            cmd = this.createSelectMasterFile();
            if (cmd != null) {
                res = this.sendCommandAPDU(_channel, cmd);
                if (res == null) {
                    return "";
                }
                err = res.sw();
                if (err != 36864) {
                    return "";
                }
            }
            if ((res = this.sendCommandAPDU(_channel, new CommandAPDU(HexString.parseHexString("00 a4 04 0c 0c a0 00 00 00 63 50 4b 43 53 2d 31 35")))) == null) {
                return "";
            }
            err = res.sw();
            if (err != 36864) {
                return "";
            }
            res = this.sendCommandAPDU(_channel, new CommandAPDU(HexString.parseHexString("00 a4 02 0c 02 " + fid)));
            if (res == null) {
                return "";
            }
            err = res.sw();
            if (err != 36864) {
                return "";
            }
            cmd = this.createReadBinaryCommand(0, 240);
            res = this.sendCommandAPDU(_channel, cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            err = res.sw();
            if (err != 36864 && (err & 0x6200) != 25088) {
                throw new ResponseCodeException(err, APDUCommands.getReadBinaryErrorMsg(err));
            }
            String result = res.data() == null ? null : new String(res.data());
            return result;
        }
        catch (Throwable ex) {
            LOG.error((Object)"", ex);
            return null;
        }
    }

    @Override
    protected GovCS.ResultObject readSelectedFile(CardChannel _channel, int _offset, int _length) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        boolean ignoreErrorCode;
        byte[] readBytes;
        int fileSize;
        ResponseAPDU res;
        block12: {
            CommandAPDU cmd = this.createReadBinaryCommand(0, 10);
            res = this.sendCommandAPDU(_channel, cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            int err = res.sw();
            if (err != 36864) {
                throw new ResponseCodeException(err, APDUCommands.getReadBinaryErrorMsg(err));
            }
            byte[] responseData = res.data();
            if (responseData == null || responseData.length < 5) {
                throw new IllegalArgumentException(RESOURCES.getString("insufficient_data") + HexString.hexify(responseData, false));
            }
            fileSize = 0;
            if (responseData[0] != -1 && (responseData[1] & 0xFFFFFF80) == -128) {
                int length = responseData[1] & 0x7F;
                length = Math.min(length, 2);
                LOG.debug((Object)("fst 10 bytes: " + HexString.hexify(responseData)));
                for (int j = 0; j < length; ++j) {
                    fileSize <<= 8;
                    fileSize += responseData[2 + j] & 0xFF;
                }
                fileSize += 2 + length;
            }
            if (fileSize == 0) {
                return null;
            }
            LOG.debug((Object)("cert size: " + fileSize));
            boolean readFully = _length == 2048;
            readBytes = new byte[readFully ? fileSize : _length];
            int chunkSize = Math.min(readBytes.length, this.getMaximumChunkSize());
            int offset = _offset;
            ignoreErrorCode = false;
            do {
                byte[] buffer;
                if ((res = this.sendCommandAPDU(_channel, cmd = this.createReadBinaryCommand(offset, chunkSize))) == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                err = res.sw();
                if (err != 36864) {
                    if (err == 27270) {
                        ignoreErrorCode = true;
                        break block12;
                    }
                    if (err != 27392 && err != 25218) break block12;
                }
                if ((buffer = res.data()) == null) break block12;
                System.arraycopy(buffer, 0, readBytes, offset, buffer.length);
                if ((offset += buffer.length) == readBytes.length) break block12;
                chunkSize = Math.min(readBytes.length - offset, this.getMaximumChunkSize());
            } while (err != 25218 && err != 27392);
            LOG.debug((Object)"pricicely when it means to ...");
            ignoreErrorCode = true;
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(ignoreErrorCode ? 36864 : res.sw());
        ro.setResultData(readBytes);
        String hashString = "- no hash generated -";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1", "BC");
            hashString = HexUtil.hexify(md.digest(readBytes));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOG.debug((Object)("cert size: " + fileSize));
        LOG.debug((Object)("read bytes length: " + readBytes.length));
        LOG.debug((Object)("sha1 of read bytes: " + hashString));
        return ro;
    }

    @Override
    protected void selectSubDirectory(CardChannel _channel, FileReference _directory) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (_directory == null) {
            return;
        }
        CommandAPDU cmd = APDUCommands.createSelectCommand(_directory.referenceType, 12, _directory.reference, 1024);
        LOG.debug((Object)("SELECT SUB DIR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT SUB DIR RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
    }

    @Override
    protected GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        boolean usesASN1HeaderWithSignHash = this.evaluateUseDigestInfo(_hashValue, algorithmParameters);
        LOG.debug((Object)("usesASN1HeaderWithSignHash=" + usesASN1HeaderWithSignHash));
        if (usesASN1HeaderWithSignHash) {
            try {
                _hashValue = new DigestInfo(HashAlgorithm.Algorithm.getAlgorithmByName(_hashAlgorithm), _hashValue).getEncoded();
                LOG.debug((Object)("pkcs#1=" + HexString.hexify(_hashValue)));
            }
            catch (Exception ex) {
                LOG.error((Object)"", (Throwable)ex);
            }
        }
        CommandAPDU cmd = this.createSignHashCommand(_hashValue, algorithmParameters);
        LOG.debug((Object)("SIGN CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SIGN RES  : " + HexString.hexify(res.getBuffer(), false)));
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        return ro;
    }

    private boolean evaluateUseDigestInfo(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        boolean usesASN1HeaderWithSignHash = false;
        try {
            CardExecutionSignAuthenticateParameterSpec sps = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
            if (Objects.nonNull(sps) && Objects.nonNull(sps.isDigestInfoUsed()) && sps.isDigestInfoUsed().booleanValue()) {
                usesASN1HeaderWithSignHash = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_hashValue != null && this.usesASN1HeaderWithSignHash()) {
            usesASN1HeaderWithSignHash = true;
        }
        return usesASN1HeaderWithSignHash;
    }

    @Override
    protected void selectFile(CardChannel _channel, FileReference _file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (_file == null) {
            return;
        }
        CommandAPDU cmd = APDUCommands.createSelectCommand(_file.referenceType, 12, _file.reference, 1024);
        LOG.debug((Object)("SELECT FILE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT FILE RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
    }

    @Override
    protected void selectMasterFile(CardChannel _channel) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (this.ctReference != null && !this.ctReference.isCardPresent(this.slotID)) {
            return;
        }
        CommandAPDU cmd = this.createSelectMasterFile();
        if (cmd == null) {
            return;
        }
        LOG.debug((Object)("SELECT MF CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT MF RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864 && err != 25220) {
            cmd = this.createSelectMasterFile1();
            if (cmd == null) {
                return;
            }
            LOG.debug((Object)("SELECT MF CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            res = this.sendCommandAPDU(_channel, cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            LOG.debug((Object)("SELECT MF RES : " + HexString.hexify(res.getBuffer(), false)));
            err = res.sw();
            if (err != 36864 && err != 25220) {
                cmd = this.createSelectMasterFile2();
                if (cmd == null) {
                    return;
                }
                LOG.debug((Object)("SELECT MF CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = this.sendCommandAPDU(_channel, cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                LOG.debug((Object)("SELECT MF RES : " + HexString.hexify(res.getBuffer(), false)));
                err = res.sw();
                if (err != 36864 && err != 25220) {
                    throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
                }
            }
        }
    }

    @Override
    protected final GovCS.ResultObject setSecurityEnvironment(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException {
        LOG.debug((Object)"entered");
        GovCS.ResultObject ro = new GovCS.ResultObject();
        CommandAPDU cmdMSO = this.createMSECommand(_channel, _info, _type, _hashAlgorithm, algorithmParameters);
        if (cmdMSO == null) {
            ro.setResultCode(36864);
            return ro;
        }
        LOG.debug((Object)("MSE " + _type + " CMD : " + HexString.hexify(cmdMSO.getBuffer(), false)));
        ResponseAPDU res = this.sendCommandAPDU(_channel, cmdMSO);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("MSE " + _type + " RES : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getManageSecurityEnvironmentErrorMsg(res.sw()));
        }
        return ro;
    }

    @Override
    protected int verifyPassword(CardChannel _channel, OCFCertificateInfo _info, char[] _pin, Integer retryCount) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        String pinName = SMGovCS.getPinNameForInfo(_info);
        if (retryCount == null) {
            if (!this.isKeyInitialized(_channel, _info)) {
                throw new NotYetInitializedException(pinName, 27013, APDUCommands.getVerifyErrorMsg(27013));
            }
            retryCount = this.getRetryCount(_channel, _info);
            if (retryCount == 0) {
                throw new RetryCounterExpiredException(pinName, 27011, APDUCommands.getVerifyErrorMsg(27011));
            }
        }
        GovCHVDialog chvDialog = null;
        try {
            chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
            chvDialog.setParentWindow(this.parentWindow);
        }
        catch (InstantiationException ex) {
            throw new OperationCancelledException("", CardErrorUtil.getErrorCodeForRetries(retryCount), ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new OperationCancelledException("", CardErrorUtil.getErrorCodeForRetries(retryCount), ex.getMessage(), ex);
        }
        if (_pin == null) {
            GovCHVConfiguration config = new GovCHVConfiguration(retryCount, BDialogMode.CARD_VERIFY, this.getMinPINLength(_info), this.getMaxPINLength(_info), _info, this.createTerminalString(_channel), this.getInitPIN(), null, null, this.getClass());
            config.setShowPseudoDisplay(this.pcsc20Features.getVerifyPINStart().valueAsNumber() != 0);
            if (this.pcsc20Features.getVerifyPINStart().valueAsNumber() != 0) {
                config.setShowPseudoDisplay(!TerminalOperationHandler.Util.usePCSCVerifyModifyDirect(this.ctReference, false));
            }
            chvDialog.setConfiguration(config);
        }
        ResponseAPDU res = null;
        if (_pin == null && !this.useKeyboard() && (res = this.terminalHandler.verifyPassword(_info, chvDialog, this)) != null) {
            LOG.debug((Object)("VP RES : " + HexString.hexify(res.getBuffer(), false)));
            LOG.debug((Object)("VP RES : " + APDUCommands.getVerifyErrorMsg(res.sw())));
            if (res.sw() == 25616 || res.sw() == 28160) {
                res = null;
            } else {
                int result = this.evaluateVerifyPasswordResultCode(pinName, retryCount, res.sw());
                return result;
            }
        }
        return this.verifyPasswordReaderClass1(_channel, _info, _pin, retryCount, pinName, chvDialog);
    }

    @Override
    public ResponseAPDU readRecord(CardChannel _channel, int recordNo) throws InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmdAPDU = new CommandAPDU(HexString.parseHexString("00b2" + HexString.hexify(recordNo) + "0400"));
        ResponseAPDU responseAPDU = this.sendCommandAPDU(_channel, cmdAPDU);
        return responseAPDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TransmitResult transmit(TransmitParameter parameter) {
        ArrayList<ResponseAPDU> responseList = null;
        Throwable throwable = null;
        boolean transactionStarted = false;
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            transactionStarted = parameter.isBeginTransaction() ? CardTerminalManager.beginTransaction(this.ctReference) : false;
            CardChannel channel = cardChannelManager.init(this);
            this.resetChannelState(channel);
            responseList = new ArrayList<ResponseAPDU>();
            throwable = null;
            for (TransmitCommand c : parameter.getCommandList()) {
                try {
                    ResponseAPDU response = this.sendCommandAPDU(channel, c.getCommand());
                    List<ResponseAPDU> acceptedResponseList = c.getAcceptedResponseList();
                    if (!CollectionUtil.isNullOrEmpty(acceptedResponseList)) {
                        boolean accepted = false;
                        for (ResponseAPDU r : acceptedResponseList) {
                            if (response.sw() != r.sw()) continue;
                            accepted = true;
                            break;
                        }
                        if (!accepted) {
                            LOG.debug((Object)("not accepted response: " + response));
                            responseList.add(response);
                            throwable = new InternalError("transmission aborted, not accepted response: " + HexUtil.hexify(response.sw()));
                            break;
                        }
                    }
                    responseList.add(response);
                }
                catch (Throwable t) {
                    throwable = t;
                    break;
                }
            }
        }
        finally {
            cardChannelManager.destroy();
            if ((transactionStarted || CardTerminalManager.isTransactionStarted(this.ctReference)) && parameter.isEndTransaction()) {
                CardTerminalManager.endTransaction(this.ctReference, true);
            }
        }
        return new TransmitResult((List<ResponseAPDU>)responseList, throwable);
    }

    @Override
    public final byte[] getICCSN() throws CardTerminalException, ResponseCodeException {
        byte[] result = Card.NO_ICCSN;
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            channel.setState(null);
            this.selectMasterFile(channel);
            this.selectFile(channel, new FileReference(2, "2f02"));
            CommandAPDU command = this.createReadBinaryCommand(0, 20);
            ResponseAPDU response = this.sendCommandAPDU(channel, command);
            if ((response.sw() == 36864 || response.sw() == 25218) && response.data() != null && response.data().length > 0) {
                result = response.data();
                byte[] tmp = new byte[result.length - 2];
                System.arraycopy(result, 2, tmp, 0, tmp.length);
                result = tmp;
            }
        }
        catch (InvalidCardChannelException e) {
            throw e;
        }
        finally {
            cardChannelManager.destroy();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] getRandom() {
        byte[] random = null;
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel cardChannel = cardChannelManager.init(this);
            CommandAPDU getRND = this.createGetRandomCommand();
            ResponseAPDU res = this.sendCommandAPDU(cardChannel, getRND);
            random = res.data();
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
        }
        finally {
            cardChannelManager.destroy();
        }
        return random;
    }

    protected byte[] readFileRaw(String fid, String filenameText) throws IOException {
        int blockSize = 208;
        LOG.debug((Object)("Read " + filenameText));
        CommandAPDU selectEFCardAccess = EPAUtil.commandFromString("00a4020c", fid, null);
        CommandAPDU readLength = EPAUtil.commandFromString("00b00000", null, "08");
        ResponseAPDU response = this.sendCommandAPDU(selectEFCardAccess);
        EPAUtil.logCommand(LOG, "Select " + filenameText, selectEFCardAccess, response);
        response = this.sendCommandAPDU(readLength);
        EPAUtil.logCommand(LOG, "Read length of " + filenameText, readLength, response);
        long l = ASN1Util.getEncodedLength(response.data()).longValue();
        LOG.info((Object)("Length determined as " + l + " bytes."));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while ((long)i < l) {
            int bl = blockSize;
            if (l - (long)i < (long)blockSize) {
                bl = (int)(l - (long)i);
            }
            readLength = EPAUtil.commandFromString("00b0" + HexUtil.hexify((byte)(i / 256)) + HexUtil.hexify((byte)(i % 256)) + HexUtil.hexify((byte)bl));
            response = this.sendCommandAPDU(readLength);
            EPAUtil.logCommand(LOG, "Read " + filenameText, readLength, response);
            baos.write(response.data());
            i += blockSize;
        }
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    protected PCSCCardTerminal getReader(PaceConstants.PaceCapabilityEnum capability) {
        PCSCCardTerminal pcscCT = null;
        Pcsc20Features features = null;
        if (!PCSCCardTerminal.class.isInstance(this.ctReference)) {
            return null;
        }
        pcscCT = (PCSCCardTerminal)this.ctReference;
        features = pcscCT.getPcsc20Features();
        if (!features.isFeatureSupported(32)) {
            return null;
        }
        PaceCapabilities pc = features.getPaceCapabilities();
        if (pc == null) {
            return null;
        }
        List<PaceConstants.PaceCapabilityEnum> pcList = pc.getCapabilitiesList();
        if (pcList == null || pcList.size() == 0 || !pcList.contains(capability)) {
            return null;
        }
        return pcscCT;
    }
}

