/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.basecard.common.pin.PinModifyParameters;
import de.bos_bremen.basecard.common.pin.PinVerifyParameters;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.terminal.BTerminalException;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.basecard.terminal.pcsc.handler.Pcsc20PinStructureHandler;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerFactory;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.AbstractPinStructure;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.PinInformationProvider;
import de.bos_bremen.gov2.jca_provider.ocf.cards.TerminalOperationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.BaseCardUtil;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminal;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Pcsc20TerminalOperationHandler
implements TerminalOperationHandler {
    private static final Log log = LogFactory.getLog(Pcsc20TerminalOperationHandler.class);
    public static final String EMPTY_STRING = "";
    public static final String OS_NAME_LINUX = "linux";
    public static final String OS_NAME_MAC = "mac";
    public static final String SYSTEM_PROPERTY_KEY_OS_NAME = "os.name";
    private Pcsc20Features pcsc20Features = null;
    private String terminalName = null;
    private CardTerminal cardTerminal = null;

    @Override
    public void update(CardTerminal cardTerminal, Pcsc20Features pcsc20features, String terminalName) {
        this.pcsc20Features = PCSCCardTerminal.class.isInstance(cardTerminal) ? ((PCSCCardTerminal)cardTerminal).getPcsc20Features() : pcsc20features;
        this.terminalName = terminalName;
        this.cardTerminal = cardTerminal;
    }

    @Override
    public ResponseAPDU verifyPassword(OCFCertificateInfo info, GovCHVDialog chvDialog, PinInformationProvider pip) throws CardTerminalException, IllegalArgumentException {
        boolean usesCCID = this.usesCCID(info);
        Pcsc20PinStructureHandler handler = Pcsc20PinStructureHandlerFactory.getHandler(this.terminalName);
        log.debug((Object)("verifyPassword Pcsc20PinStructureHandler: " + handler.getClass().getSimpleName()));
        int maxL = pip.getMaxPINLength(info);
        PinEncoder pinEncoder = pip.getPinEncoder(info);
        if (maxL == 0 && PinEncoder.ENCODER_T50 == pinEncoder) {
            maxL = 255;
        } else if (maxL == 0 && (PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK == pinEncoder || PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK == pinEncoder || PinEncoder.ENCODER_BCD == pinEncoder)) {
            maxL = 12;
        }
        ResponseAPDU res = null;
        PinVerifyParameters pvp = BaseCardUtil.createVerifyParameters(info, pip, usesCCID, maxL);
        if (this.cardTerminal instanceof JPCSCCardTerminal) {
            try {
                res = new ResponseAPDU(((JPCSCCardTerminal)this.cardTerminal).pinOperation(chvDialog, pvp));
            }
            catch (BTerminalException e) {
                throw new CardTerminalException("verification failed");
            }
        } else {
            AbstractPinStructure pvs = handler.buildPinOperationStructure(pvp);
            CommandAPDU cmd = new CommandAPDU(pvs.getEncoded());
            res = TerminalOperationHandler.Util.sendTerminalCMD(this.cardTerminal, cmd, chvDialog, true, pip, PCSCCardTerminal.class.isInstance(this.cardTerminal) ? ((PCSCCardTerminal)this.cardTerminal).getPcsc20Features() : this.pcsc20Features);
        }
        return res;
    }

    private boolean usesCCID(OCFCertificateInfo info) {
        String systemNameLower = System.getProperty(SYSTEM_PROPERTY_KEY_OS_NAME, EMPTY_STRING).toLowerCase();
        boolean usesCCID = (systemNameLower.contains(OS_NAME_LINUX) || systemNameLower.contains(OS_NAME_MAC)) && info.getPrivateKey().getCardService().getCardTerminal().getName().startsWith("*");
        return usesCCID;
    }

    @Override
    public ResponseAPDU modifyPassword(OCFCertificateInfo info, GovCHVDialog chvDialog, PinInformationProvider pip, byte[] firstPin, boolean init) throws CardTerminalException, IllegalArgumentException {
        int max;
        boolean usesCCID = this.usesCCID(info);
        Pcsc20PinStructureHandler handler = Pcsc20PinStructureHandlerFactory.getHandler(this.terminalName);
        log.debug((Object)("modifyPassword Pcsc20PinStructureHandler: " + handler.getClass().getSimpleName()));
        int min = Math.max(pip.getMinPINLength(info), 4);
        int n = max = pip.getMaxPINLength(info) == 0 ? 12 : pip.getMaxPINLength(info);
        if (init && pip.getMaxPINLengthInit(info) != null && pip.getMinPINLengthInit(info) != null) {
            min = Math.max(Math.min(pip.getMinPINLength(info), pip.getMinPINLengthInit(info)), 4);
            max = Math.max(max, pip.getMaxPINLengthInit(info));
        }
        ResponseAPDU res = null;
        PinModifyParameters pmp = BaseCardUtil.createPinModifyParameters(info, pip, firstPin, usesCCID, min, max);
        if (this.cardTerminal instanceof JPCSCCardTerminal) {
            try {
                res = new ResponseAPDU(((JPCSCCardTerminal)this.cardTerminal).pinOperation(chvDialog, pmp));
            }
            catch (BTerminalException e) {
                throw new CardTerminalException("modification failed");
            }
        } else {
            AbstractPinStructure pms = handler.buildPinOperationStructure(pmp);
            CommandAPDU cmd = new CommandAPDU(pms.getEncoded());
            res = TerminalOperationHandler.Util.sendTerminalCMD(this.cardTerminal, cmd, chvDialog, false, pip, PCSCCardTerminal.class.isInstance(this.cardTerminal) ? ((PCSCCardTerminal)this.cardTerminal).getPcsc20Features() : this.pcsc20Features);
        }
        return res;
    }

    @Override
    public boolean isStructureForFeatureValid(int controlCode, byte[] controlStructure) throws IllegalArgumentException {
        if (!this.pcsc20Features.isFeatureSupported(controlCode)) {
            throw new IllegalArgumentException("feature not supported: " + controlCode);
        }
        return true;
    }

    @Override
    public byte[] sendTerminalCommand(int controlCode, byte[] controlStructure) throws IllegalArgumentException, CardTerminalException {
        if (!this.isStructureForFeatureValid(controlCode, controlStructure)) {
            throw new IllegalArgumentException("invalid structure for feature");
        }
        if (controlCode == 7 || controlCode == 3 || controlCode == 4) {
            throw new IllegalArgumentException("modification supported by special method");
        }
        if (controlCode == 6 || controlCode == 1 || controlCode == 2) {
            throw new IllegalArgumentException("verification supported by special method");
        }
        return TerminalOperationHandler.Util.sendTerminalCMD(this.cardTerminal, controlCode, controlStructure);
    }
}

