/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.basecard.common.dialog.BTerminalDialog;
import de.bos_bremen.basecard.common.pin.PinVerifyParameters;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.terminal.TerminalParameters;
import de.bos_bremen.basecard.terminal.impl.TerminalParametersImpl;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Constants;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUErrorConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVControl;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.Pcsc20TerminalOperationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.PinInformationProvider;
import de.bos_bremen.gov2.jca_provider.ocf.cards.TerminalOperationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.BaseCardUtil;
import de.bos_bremen.opencard.terminal.bcs.OCFBCSClass3Terminal;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import opencard.core.service.CHVDialog;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GovCSTerminalOperationHandler
implements TerminalOperationHandler,
Pcsc20Constants,
APDUConstants,
APDUErrorConstants {
    private static final Log LOG = LogFactory.getLog(GovCSTerminalOperationHandler.class);
    private Pcsc20TerminalOperationHandler terminalHandler = new Pcsc20TerminalOperationHandler();
    private Pcsc20Features pcsc20Features = null;
    private CardTerminal cardTerminal = null;

    @Override
    public void update(CardTerminal cardTerminal, Pcsc20Features pcsc20features, String terminalName) {
        this.pcsc20Features = PCSCCardTerminal.class.isInstance(cardTerminal) ? ((PCSCCardTerminal)cardTerminal).getPcsc20Features() : pcsc20features;
        this.terminalHandler.update(cardTerminal, this.pcsc20Features, terminalName);
        this.cardTerminal = cardTerminal;
    }

    @Override
    public ResponseAPDU verifyPassword(OCFCertificateInfo certInfo, GovCHVDialog dialog, PinInformationProvider pip) throws CardTerminalException, OperationCancelledException {
        ResponseAPDU res = null;
        if (this.pcsc20Features.getVerifyPINDirect().valueAsNumber() != 0 || this.pcsc20Features.getVerifyPINStart().valueAsNumber() != 0) {
            try {
                LOG.debug((Object)("verifyPassword GovCSTerminalOperationHandler: " + this.terminalHandler.getClass().getSimpleName()));
                res = this.terminalHandler.verifyPassword(certInfo, dialog, pip);
                return res;
            }
            catch (IllegalArgumentException e) {
                res = null;
                LOG.debug((Object)e);
            }
        }
        String prompt = dialog.getPrompt(certInfo.getUsage(), BTerminalDialog.Type.CUR_PIN);
        if (OCFBCSClass3Terminal.class.isInstance(this.cardTerminal)) {
            CardTerminalIOControl terminalControl = new CardTerminalIOControl(0, 60, "0123456789", "\n");
            String encoding = null;
            CommandAPDU c = this.createVerifyPlainPasswordCommandAlternative(certInfo, pip);
            if (pip.getPinEncoder(certInfo) == PinEncoder.ENCODER_T50) {
                encoding = "T.50 Encoding";
            } else if (pip.getPinEncoder(certInfo) == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK) {
                encoding = "Format 2 Pin Block Encoding";
            } else {
                throw new CardTerminalException("not supported pin encoding");
            }
            int maxL = pip.getMaxPINLength(certInfo) == 0 ? 12 : pip.getMaxPINLength(certInfo);
            PinVerifyParameters pvp = BaseCardUtil.createVerifyParameters(certInfo, pip, false, maxL);
            TerminalParametersImpl tp = new TerminalParametersImpl(dialog, pvp, prompt.replaceAll("\n", "\r\n"));
            GovCHVControl control = new GovCHVControl(prompt.replaceAll("\n", "\r\n"), pip.getPinID(certInfo), encoding, 6, terminalControl, (TerminalParameters)tp);
            CHVDialog chvDialog = new CHVDialog(){

                @Override
                public char[] getCHV(int chvNumber) {
                    throw new RuntimeException("pin verification with BCS Class 3 terminal failed");
                }
            };
            return ((GovCS)pip).getCardChannel().sendVerifiedAPDU(c, control, chvDialog);
        }
        CommandAPDU cmd = this.createVerifyPasswordCommandAlternative(prompt, certInfo, false, pip);
        res = TerminalOperationHandler.Util.sendTerminalCMD(this.cardTerminal, cmd, dialog, true, pip, PCSCCardTerminal.class.isInstance(this.cardTerminal) ? ((PCSCCardTerminal)this.cardTerminal).getPcsc20Features() : this.pcsc20Features);
        return res;
    }

    @Override
    public ResponseAPDU modifyPassword(OCFCertificateInfo certInfo, GovCHVDialog dialog, PinInformationProvider pip, byte[] firstPin, boolean init) throws CardTerminalException, InvalidCardChannelException, RetryCounterExpiredException, ResponseCodeException {
        ResponseAPDU res = null;
        if (this.pcsc20Features.getModifyPINDirect().valueAsNumber() != 0 || this.pcsc20Features.getModifyPINStart().valueAsNumber() != 0) {
            try {
                LOG.debug((Object)("modifyPassword GovCSTerminalOperationHandler: " + this.terminalHandler.getClass().getSimpleName()));
                res = this.terminalHandler.modifyPassword(certInfo, dialog, pip, firstPin, init);
                return res;
            }
            catch (IllegalArgumentException e) {
                res = null;
            }
        }
        if (firstPin == null && pip.isCyberJack()) {
            String prompt = dialog.getPrompt(certInfo.getUsage(), BTerminalDialog.Type.CUR_PIN);
            CommandAPDU cmd = this.createChangePasswordCommandAlternative(prompt, certInfo, false, pip);
            LOG.debug((Object)("CHANGE R CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            res = TerminalOperationHandler.Util.sendTerminalCMD(this.cardTerminal, cmd, dialog, false, true, pip, PCSCCardTerminal.class.isInstance(this.cardTerminal) ? ((PCSCCardTerminal)this.cardTerminal).getPcsc20Features() : this.pcsc20Features);
            if (res == null) {
                throw new ResponseCodeException(GovCS.RESOURCES.getString("no_response"));
            }
            if (res.sw() == 26368) {
                LOG.debug((Object)("CHANGE R RES : " + HexString.hexify(res.getBuffer(), false)));
                cmd = this.createChangePasswordCommandAlternative(prompt, certInfo, true, pip);
                LOG.debug((Object)("CHANGE R CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = TerminalOperationHandler.Util.sendTerminalCMD(this.cardTerminal, cmd, dialog, false, true, pip, PCSCCardTerminal.class.isInstance(this.cardTerminal) ? ((PCSCCardTerminal)this.cardTerminal).getPcsc20Features() : this.pcsc20Features);
            }
            LOG.debug((Object)("CHANGE R RES : " + HexString.hexify(res.getBuffer(), false)));
            LOG.debug((Object)("CHANGE R RES : " + APDUCommands.getVerifyErrorMsg(res.sw())));
        }
        return res;
    }

    private CommandAPDU createVerifyPlainPasswordCommandAlternative(OCFCertificateInfo _info, PinInformationProvider pip) {
        PinEncoder _encoder = pip.getPinEncoder(_info);
        byte[] pinBlock = pip.padPin(_info, null);
        LOG.debug((Object)("_key : " + HexString.hexify(_info.getPinID())));
        LOG.debug((Object)("_pinBlockLength : " + (pinBlock == null ? -1 : pinBlock.length)));
        LOG.debug((Object)("_pinBlockFiller : " + pip.getPasswordBlockFiller(_info)));
        LOG.debug((Object)("_encoding : " + _encoder));
        byte[] commandToPerform = new byte[4 + (pinBlock == null ? 0 : pinBlock.length + 1)];
        commandToPerform[0] = 0;
        commandToPerform[1] = 32;
        commandToPerform[2] = 0;
        commandToPerform[3] = _info.getPinID();
        if (pinBlock != null) {
            commandToPerform[4] = (byte)pinBlock.length;
            LOG.debug((Object)("commandToPerform : " + HexString.hexify(commandToPerform, true, false)));
            LOG.debug((Object)("       pinBlock  : " + HexString.hexify(pinBlock, true, false)));
            System.arraycopy(pinBlock, 0, commandToPerform, 5, pinBlock.length);
        }
        return new CommandAPDU(commandToPerform);
    }

    private CommandAPDU createVerifyPasswordCommandAlternative(String _prompt, OCFCertificateInfo _info, boolean _useLC, PinInformationProvider pip) {
        PinEncoder _encoder = pip.getPinEncoder(_info);
        byte[] pinBlock = pip.padPin(_info, null);
        LOG.debug((Object)("_prompt : " + _prompt));
        LOG.debug((Object)("_key : " + HexString.hexify(_info.getPinID())));
        LOG.debug((Object)("_pinBlockLength : " + (pinBlock == null ? -1 : pinBlock.length)));
        LOG.debug((Object)("_pinBlockFiller : " + pip.getPasswordBlockFiller(_info)));
        LOG.debug((Object)("_encoding : " + _encoder));
        byte[] displayTag = null;
        if (_prompt != null && _prompt.length() > 0) {
            displayTag = new byte[]{80, (byte)_prompt.length()};
        }
        byte[] commandToPerform = new byte[8 + (pinBlock == null ? 0 : pinBlock.length + 1) + (_useLC ? 1 : 0)];
        commandToPerform[0] = 82;
        commandToPerform[1] = (byte)(commandToPerform.length - 2);
        commandToPerform[2] = (byte)(_encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK || _encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK ? 2 : 1);
        commandToPerform[3] = _encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK || _encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK ? 7 : 6;
        commandToPerform[4] = 0;
        commandToPerform[5] = 32;
        commandToPerform[6] = 0;
        commandToPerform[7] = _info.getPinID();
        if (pinBlock != null) {
            commandToPerform[8] = (byte)pinBlock.length;
            LOG.debug((Object)("commandToPerform : " + HexString.hexify(commandToPerform, true, false)));
            LOG.debug((Object)("       pinBlock  : " + HexString.hexify(pinBlock, true, false)));
            System.arraycopy(pinBlock, 0, commandToPerform, 9, pinBlock.length);
        }
        int lcByte = (displayTag == null ? 0 : displayTag.length + _prompt.length()) + commandToPerform.length;
        byte[] mktCommand = new byte[]{32, 24, 1, 0, (byte)lcByte};
        CommandAPDU result = new CommandAPDU(mktCommand.length + lcByte);
        result.append(mktCommand);
        if (displayTag != null) {
            result.append(displayTag);
            result.append(_prompt.getBytes());
        }
        result.append(commandToPerform);
        return result;
    }

    private CommandAPDU createChangePasswordCommandAlternative(String _prompt, OCFCertificateInfo _info, boolean _useLC, PinInformationProvider pip) {
        byte[] pinBlock = pip.padPin(_info, null);
        PinEncoder _encoder = pip.getPinEncoder(_info);
        LOG.debug((Object)("_prompt : " + _prompt));
        LOG.debug((Object)("_key : " + HexString.hexify(_info.getPinID())));
        LOG.debug((Object)("_pinBlockLength : " + (pinBlock == null ? -1 : pinBlock.length)));
        LOG.debug((Object)("_pinBlockFiller : " + pip.getPasswordBlockFiller(_info)));
        LOG.debug((Object)("_encoding : " + _encoder));
        byte[] displayTag = null;
        if (_prompt != null && _prompt.length() > 0) {
            displayTag = new byte[]{80, (byte)_prompt.length()};
        }
        byte[] commandToPerform = new byte[9 + 2 * (pinBlock == null ? 0 : pinBlock.length + 1) + (_useLC ? 1 : 0)];
        int index = 0;
        commandToPerform[index++] = 82;
        commandToPerform[index++] = (byte)(commandToPerform.length - 2);
        commandToPerform[index++] = (byte)(_encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK || _encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK ? 2 : 1);
        commandToPerform[index++] = _encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK || _encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK ? 7 : 6;
        commandToPerform[index++] = pinBlock == null ? (byte)0 : (byte)(6 + pinBlock.length);
        commandToPerform[index++] = 0;
        commandToPerform[index++] = 36;
        commandToPerform[index++] = 0;
        commandToPerform[index++] = _info.getPinID();
        if (pinBlock != null) {
            commandToPerform[index++] = (byte)(pinBlock.length * 2);
            LOG.debug((Object)("commandToPerform : " + HexString.hexify(commandToPerform, true, false)));
            LOG.debug((Object)("       pinBlock  : " + HexString.hexify(pinBlock, true, false)));
            System.arraycopy(pinBlock, 0, commandToPerform, index, pinBlock.length);
            System.arraycopy(pinBlock, 0, commandToPerform, index += pinBlock.length, pinBlock.length);
        }
        int lcByte = (displayTag == null ? 0 : displayTag.length + _prompt.length()) + commandToPerform.length;
        byte[] mktCommand = new byte[]{32, 25, 1, 0, (byte)lcByte};
        CommandAPDU result = new CommandAPDU(mktCommand.length + lcByte);
        result.append(mktCommand);
        if (displayTag != null) {
            result.append(displayTag);
            result.append(_prompt.getBytes());
        }
        result.append(commandToPerform);
        return result;
    }

    @Override
    public byte[] sendTerminalCommand(int controlCode, byte[] controlStructure) throws IllegalArgumentException, CardTerminalException {
        return this.terminalHandler.sendTerminalCommand(controlCode, controlStructure);
    }

    @Override
    public boolean isStructureForFeatureValid(int controlCode, byte[] controlStructure) throws IllegalArgumentException {
        return this.terminalHandler.isStructureForFeatureValid(controlCode, controlStructure);
    }
}

