/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Constants;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.CardTerminalManager;
import de.bos_bremen.gov2.jca_provider.ocf.CertificateLoader;
import de.bos_bremen.gov2.jca_provider.ocf.DefaultBaseAlgorithmProviderBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSessionListener;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitCommand;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitParameter;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitResult;
import de.bos_bremen.gov2.jca_provider.ocf.WrongConfirmedNewPinException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUErrorConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.ChannelState;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CryptoCardService;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVConfiguration;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCSTerminalOperationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.PinInformationProvider;
import de.bos_bremen.gov2.jca_provider.ocf.cards.TerminalOperationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epo.OLDEPO;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.CardErrorUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.opencard.terminal.bcs.OCFBCSClass3Terminal;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.security.AlgorithmParameters;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public abstract class GovCS
extends CardService
implements APDUErrorConstants,
APDUConstants,
Pcsc20Constants,
PinInformationProvider,
CryptoCardService {
    public static final String CONTENT_INDICATOR_BASE64_BINARY_CERTIFICATE = "-----BEGIN";
    private static final Log LOG = LogFactory.getLog(GovCS.class);
    public static final Integer MAXIMUM_COUNT_OF_STAPLE_SIGNATURES = 500;
    protected static final CardObjectRegistry CARD_OBJECT_REGISTRY = CardObjectRegistryImpl.getInstance();
    protected static final byte[] PKCS15AID = HexString.parseHexString("a0 00 00 00 63 50 4b 43 53 2d 31 35");
    protected static final ResourceBundle RESOURCES = ResourceBundle.getBundle("de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS");
    public static final int SE_AUTHENTIFY = 2;
    public static final int SE_DECRYPT = 1;
    public static final int SE_SIGN_HASH = 0;
    protected CertificateLoader certLoader;
    protected TerminalOperationHandler terminalHandler = new GovCSTerminalOperationHandler();
    private String terminalName = null;
    protected Vector<Object> certificates = new Vector();
    protected Class<?> chvDialogClass = null;
    protected CardTerminal ctReference = null;
    protected OCFCertificateInfo[] infos = null;
    protected boolean isCyberJack = false;
    protected boolean isCtapiClass3 = false;
    protected boolean keybordAllowed = true;
    protected Object parentWindow = null;
    protected Pcsc20Features pcsc20Features = null;
    protected boolean pinpad = false;
    protected ProgressSessionListener progressSessionListener = null;
    protected SmartCard smartcard = null;
    private Boolean pinpadUsableInitCaseForT50PinOfVariableLength = null;
    private Boolean pinpadUsableChangeCaseForT50PinOfVariableLength = null;
    protected int slotID = 0;
    private CardServiceScheduler scheduler = null;
    private Card card = null;

    public CommandAPDU createPKCS1v15SignExtendedCommand2048(byte[] digestInfo) {
        int blockSize = 257;
        byte[] store = new byte[7 + blockSize + 2];
        Arrays.fill(store, (byte)-1);
        int i = 0;
        store[i++] = 0;
        store[i++] = 42;
        store[i++] = -128;
        store[i++] = -122;
        store[i++] = 0;
        store[i++] = (byte)(blockSize >> 8 & 0xFF);
        store[i++] = (byte)(blockSize >> 0 & 0xFF);
        store[i++] = this.getPaddingIndicator();
        store[i++] = 0;
        store[i++] = 1;
        i += blockSize - 3 - digestInfo.length - 1;
        store[i++] = 0;
        System.arraycopy(digestInfo, 0, store, i, digestInfo.length);
        i += digestInfo.length;
        int resultLength = 256;
        store[i++] = (byte)(resultLength >> 8 & 0xFF);
        store[i] = (byte)(resultLength >> 0 & 0xFF);
        return new CommandAPDU(store);
    }

    public CommandAPDU createPKCS1v15SignShortCommand1024(byte[] digestInfo) {
        int blockSize = 129;
        byte[] store = new byte[5 + blockSize + 1];
        Arrays.fill(store, (byte)-1);
        int i = 0;
        store[i++] = 0;
        store[i++] = 42;
        store[i++] = -128;
        store[i++] = -122;
        store[i++] = (byte)blockSize;
        store[i++] = this.getPaddingIndicator();
        store[i++] = 0;
        store[i++] = 1;
        i += blockSize - 3 - digestInfo.length - 1;
        store[i++] = 0;
        System.arraycopy(digestInfo, 0, store, i, digestInfo.length);
        i += digestInfo.length;
        store[i++] = 0;
        return new CommandAPDU(store);
    }

    protected final AlgorithmProvider<OCFPrivateKey> createAlgorithmProvider(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms) {
        try {
            return DefaultBaseAlgorithmProviderBuilder.createAlgorithmProvider(listKeyAlgorithms);
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            return null;
        }
    }

    protected static char[] toCharArray(byte[] data) {
        return data != null ? new String(data).toCharArray() : null;
    }

    private ResponseAPDU handleOldEPO(CardChannel channel, ResponseAPDU res) throws CardTerminalException {
        if (OLDEPO.class.isInstance(this) && res.data() == null) {
            CommandAPDU cmd = new CommandAPDU(HexUtil.parse("80 86 00 00 80"));
            LOG.debug((Object)("GET RESPONSE SIGN CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            res = channel.sendCommandAPDU(cmd);
            LOG.debug((Object)("GET RESPONSE SIGN RES : " + HexString.hexify(res.getBuffer(), false)));
            if (res.data() != null && res.data().length > 0) {
                res = new ResponseAPDU(ByteUtil.combine(ByteUtil.flip(res.data()), new byte[]{res.sw1(), res.sw2()}));
                LOG.debug((Object)("GET RESPONSE SIGN RES (REVERSED FOR GPK): " + HexString.hexify(res.getBuffer(), false)));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultObject signHashClient(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, ProgressSession session, ResultObject ro, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, CardTerminalException, OperationCancelledException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            this.fireProgressEvent(session, "get connection to the device");
            CardChannel channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!info.isTest()) {
                this.selectFile(channel, info, false);
                this.fireProgressEvent(session, "verify the corresponding password");
                ro.resultCode = this.verifyPassword(channel, info, pin);
            } else {
                ro.setResultCode(36864);
            }
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                ResultObject resultObject = ro;
                return resultObject;
            }
            this.fireProgressEvent(session, "install corresponding security environment");
            ro = this.setSecurityEnvironment(channel, info, 0, hashAlgorithm, algorithmParameters);
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                ResultObject resultObject = ro;
                return resultObject;
            }
            this.fireProgressEvent(session, "sign the given hash value");
            ro = this.signHash(channel, info, hashValue, hashAlgorithm, algorithmParameters);
            this.fireProgressEvent(session, "operation finished!");
            ResultObject resultObject = ro;
            return resultObject;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            LOG.debug((Object)"", (Throwable)e);
            throw e;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    protected void resetCard(CardChannel channel) {
        try {
            LOG.debug((Object)"reset of card");
            this.selectMasterFile(channel);
            CommandAPDU c = new CommandAPDU(HexUtil.parse("0022f301"));
            LOG.debug((Object)("RESET CMD: " + HexUtil.hexify(c.getBytes())));
            ResponseAPDU r = channel.sendCommandAPDU(c);
            LOG.debug((Object)("RESET RSP: " + HexUtil.hexify(r.getBytes())));
            LOG.debug((Object)"reset of card finished");
            ChannelState channelState = this.getChannelState(channel);
            if (channelState != null) {
                channelState.resetCurrentSignCount();
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)("reset of card failed: " + t.getMessage()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultObject signHashServer(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, ProgressSession session, ResultObject ro, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        CardChannel channel = null;
        try {
            this.fireProgressEvent(session, "get connection to the device");
            channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!this.checkChannelState(channel, info)) {
                this.selectFile(channel, info, false);
            }
            boolean loop = true;
            this.fireProgressEvent(session, "install corresponding security environment");
            ro = this.setSecurityEnvironment(channel, info, 0, hashAlgorithm, algorithmParameters);
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                ResultObject resultObject = ro;
                return resultObject;
            }
            while (loop) {
                this.fireProgressEvent(session, "sign the given hash value");
                ro = this.signHash(channel, info, hashValue, hashAlgorithm, algorithmParameters);
                if (ro.getResultCode() == 27010) {
                    this.resetChannelState(channel);
                    try {
                        this.checkSignCounter(channel, false);
                    }
                    catch (MaxSignatureCountReachedException e) {
                        LOG.error((Object)e.getMessage());
                    }
                    this.selectFile(channel, info, false);
                    this.fireProgressEvent(session, "verify the corresponding password");
                    ro.resultCode = this.verifyPassword(channel, info, pin);
                    if (ro.resultCode != 36864) {
                        LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                        ResultObject resultObject = ro;
                        return resultObject;
                    }
                    this.fireProgressEvent(session, "install corresponding security environment");
                    ro = this.setSecurityEnvironment(channel, info, 0, hashAlgorithm, algorithmParameters);
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                        ResultObject resultObject = ro;
                        return resultObject;
                    }
                    loop = true;
                    continue;
                }
                this.fireProgressEvent(session, "operation finished!");
                loop = false;
            }
            ResultObject resultObject = ro;
            return resultObject;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            ResultObject resultObject = ro;
            return resultObject;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    @Override
    public boolean isCyberJack() {
        return this.isCyberJack;
    }

    protected void adjustForPaddingByte(ResultObject ro) {
        byte[] b = (byte[])ro.getResultData();
        byte[] bb = new byte[b.length - 1];
        System.arraycopy(b, 1, bb, 0, bb.length);
        ro.setResultData(bb);
    }

    protected ResultObject authentify(CardChannel channel, OCFCertificateInfo info, byte[] hashValue, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        if (hashValue != null && this.usesASN1HeaderWithAuthentify()) {
            LOG.debug((Object)("usesASN1HeaderWithAuthentify=" + this.usesASN1HeaderWithAuthentify()));
            try {
                hashValue = new DigestInfo(HashAlgorithm.Algorithm.getAlgorithmByName(hashAlgorithm), hashValue).getEncoded();
                LOG.debug((Object)("pkcs#1=" + HexString.hexify(hashValue)));
            }
            catch (Exception ex) {
                LOG.error((Object)"", (Throwable)ex);
            }
        }
        CommandAPDU cmd = this.createAuthentifyCommand(hashValue, algorithmParameters);
        LOG.debug((Object)("AUTH COMMAND : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("AUTH RESULT  : " + (res.getBuffer().length - 2) + " bytes, " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        ResultObject ro = new ResultObject();
        res = this.handleOldEPO(channel, res);
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        this.authentifyAdjust(ro, algorithmParameters);
        return ro;
    }

    public void authentifyAdjust(ResultObject ro, AlgorithmParameters algorithmParameters) {
        this.adjustForPaddingByte(ro);
    }

    protected int changePassword(CardChannel _channel, OCFCertificateInfo _info, char[] _pin, char[] _newPin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, CardTerminalException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        boolean pinpadUsable;
        String pinName = GovCS.getPinNameForInfo(_info);
        int retryCount = -1;
        boolean initCard = false;
        try {
            retryCount = this.getRetryCount(_channel, _info);
        }
        catch (NotYetInitializedException e) {
            initCard = true;
        }
        ResponseAPDU res = null;
        GovCHVDialog chvDialog = null;
        try {
            chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
            chvDialog.setParentWindow(this.parentWindow);
        }
        catch (InstantiationException ex) {
            throw new OperationCancelledException("", CardErrorUtil.getErrorCodeForRetries(retryCount), ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new OperationCancelledException("", CardErrorUtil.getErrorCodeForRetries(retryCount), ex.getMessage(), ex);
        }
        if (_pin == null) {
            GovCHVConfiguration config = new GovCHVConfiguration(retryCount, initCard && (this.getInitPIN() != null || this.usesNullPIN()) ? BDialogMode.CARD_INIT_2 : (initCard ? BDialogMode.CARD_INIT_3 : BDialogMode.CARD_CHANGE), this.getMinPINLength(_info), this.getMaxPINLength(_info), _info, this.createTerminalString(_channel), !this.usesNullPIN() ? this.getInitPIN() : new char[6], this.getMinPINLengthInit(_info), this.getMaxPINLengthInit(_info), this.getClass());
            config.setShowPseudoDisplay(this.pcsc20Features.getModifyPINStart().valueAsNumber() != 0);
            if (this.pcsc20Features.getModifyPINStart().valueAsNumber() != 0) {
                config.setShowPseudoDisplay(!TerminalOperationHandler.Util.usePCSCVerifyModifyDirect(this.ctReference, false));
            }
            chvDialog.setConfiguration(config);
        }
        boolean bl = pinpadUsable = this.getMaxPINLength(_info) == this.getMinPINLength(_info) && this.getPinEncoder(_info) == PinEncoder.ENCODER_T50 && this.getPasswordBlockLength(_info) <= 0;
        if (!pinpadUsable) {
            boolean bl2 = pinpadUsable = initCard ? this.isPinpadUsableInitCaseForT50PinOfVariableLength() : this.isPinpadUsableChangeCaseForT50PinOfVariableLength();
        }
        if (!this.useKeyboard() && _newPin == null && pinpadUsable) {
            byte[] firstPin;
            byte[] byArray = firstPin = _pin != null ? ByteUtil.convert(_pin) : null;
            if (initCard && !this.usesNullPIN()) {
                firstPin = ByteUtil.convert(this.getInitPIN());
            }
            if (initCard && this.usesNullPIN()) {
                firstPin = new byte[6];
                Arrays.fill(firstPin, (byte)0);
            }
            if ((res = this.terminalHandler.modifyPassword(_info, chvDialog, this, firstPin, initCard)) != null) {
                LOG.debug((Object)("VP RES : " + HexString.hexify(res.getBuffer(), false)));
                LOG.debug((Object)("VP RES : " + APDUCommands.getChangePasswordErrorMsg(res.sw())));
                if (res.sw() == 25616 || res.sw() == 28160) {
                    res = null;
                } else {
                    int result = this.evaluateChangePasswordResultCode(pinName, retryCount, res.sw());
                    return result;
                }
            }
        }
        char[] oldPIN = null;
        char[] newPIN = null;
        if (_pin == null || _newPin == null) {
            chvDialog.show();
            int result = chvDialog.getResult();
            if (result == 2) {
                throw new PinInputCancelledException(pinName, CardErrorUtil.getErrorCodeForRetries(retryCount), APDUCommands.getVerifyErrorMsg(0));
            }
            oldPIN = initCard && !ArrayUtil.isNullOrEmpty(this.getInitPIN()) ? this.getInitPIN() : (initCard && this.usesNullPIN() ? new char[6] : chvDialog.getPIN());
            newPIN = chvDialog.getNewPIN();
        } else {
            oldPIN = new char[_pin.length];
            System.arraycopy(_pin, 0, oldPIN, 0, _pin.length);
            newPIN = new char[_newPin.length];
            System.arraycopy(_newPin, 0, newPIN, 0, _newPin.length);
        }
        CommandAPDU cmd = this.createChangePasswordCommand(_info, oldPIN, newPIN);
        LOG.debug((Object)((!initCard ? "CHANGE" : "INIT") + " 1 CMD : " + HexString.hexify(cmd.getBuffer(), 0, Math.min(5, cmd.getBuffer().length), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)((!initCard ? "CHANGE" : "INIT") + " 1 RES : " + HexString.hexify(res.getBuffer(), false)));
        int resultCode = this.evaluateChangePasswordResultCode(pinName, retryCount, res.sw());
        return resultCode;
    }

    public boolean isPinpadUsableInitCaseForT50PinOfVariableLength() {
        if (this.pinpadUsableInitCaseForT50PinOfVariableLength == null || this.useKeyboard()) {
            this.pinpadUsableInitCaseForT50PinOfVariableLength = Boolean.FALSE;
        }
        return this.pinpadUsableInitCaseForT50PinOfVariableLength;
    }

    public boolean isPinpadUsableChangeCaseForT50PinOfVariableLength() {
        if (this.pinpadUsableChangeCaseForT50PinOfVariableLength == null || this.useKeyboard()) {
            this.pinpadUsableChangeCaseForT50PinOfVariableLength = Boolean.FALSE;
        }
        return this.pinpadUsableChangeCaseForT50PinOfVariableLength;
    }

    protected int changePassword(CardChannel _channel, CardPin _cardPin, char[] _pin, char[] _newPin) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, CardTerminalException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        boolean pinpadUsable;
        String pinName = GovCS.getPinName(_cardPin);
        int retryCount = -1;
        boolean initCard = false;
        try {
            retryCount = _cardPin.getRetries(_channel);
        }
        catch (NotYetInitializedException e) {
            initCard = true;
        }
        ResponseAPDU res = null;
        GovCHVDialog chvDialog = null;
        try {
            chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
            chvDialog.setParentWindow(this.parentWindow);
        }
        catch (InstantiationException ex) {
            throw new OperationCancelledException("", -1, ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new OperationCancelledException("", -1, ex.getMessage(), ex);
        }
        CardPinOCFCertificateInfo cpInfo = new CardPinOCFCertificateInfo(_cardPin);
        if (_pin == null) {
            GovCHVConfiguration config = new GovCHVConfiguration(retryCount, initCard && (this.getInitPIN() != null || this.usesNullPIN()) ? BDialogMode.CARD_INIT_2 : (initCard ? BDialogMode.CARD_INIT_3 : BDialogMode.CARD_CHANGE), this.getMinPINLength(cpInfo), this.getMaxPINLength(cpInfo), cpInfo, this.createTerminalString(_channel), !this.usesNullPIN() ? this.getInitPIN() : new char[6], this.getMinPINLengthInit(cpInfo), this.getMaxPINLengthInit(cpInfo), this.getClass());
            config.setShowPseudoDisplay(this.pcsc20Features.getModifyPINStart().valueAsNumber() != 0);
            if (this.pcsc20Features.getModifyPINStart().valueAsNumber() != 0) {
                config.setShowPseudoDisplay(!TerminalOperationHandler.Util.usePCSCVerifyModifyDirect(this.ctReference, false));
            }
            chvDialog.setConfiguration(config);
        }
        boolean bl = pinpadUsable = this.getMaxPINLength(cpInfo) == this.getMinPINLength(cpInfo) && this.getPinEncoder(cpInfo) == PinEncoder.ENCODER_T50 && this.getPasswordBlockLength(cpInfo) <= 0;
        if (!pinpadUsable) {
            boolean bl2 = pinpadUsable = initCard ? this.isPinpadUsableInitCaseForT50PinOfVariableLength() : this.isPinpadUsableChangeCaseForT50PinOfVariableLength();
        }
        if (!this.useKeyboard() && _newPin == null && pinpadUsable) {
            byte[] firstPin;
            byte[] byArray = firstPin = _pin != null ? ByteUtil.convert(_pin) : null;
            if (initCard && !this.usesNullPIN()) {
                firstPin = ByteUtil.convert(this.getInitPIN());
            }
            if (initCard && this.usesNullPIN()) {
                firstPin = new byte[6];
                Arrays.fill(firstPin, (byte)0);
            }
            if ((res = this.terminalHandler.modifyPassword(cpInfo, chvDialog, this, firstPin, initCard)) != null) {
                LOG.debug((Object)("VP RES : " + HexString.hexify(res.getBuffer(), false)));
                LOG.debug((Object)("VP RES : " + APDUCommands.getChangePasswordErrorMsg(res.sw())));
                if (res.sw() == 25616 || res.sw() == 28160) {
                    res = null;
                } else {
                    int result = this.evaluateChangePasswordResultCode(pinName, retryCount, res.sw());
                    return result;
                }
            }
        }
        char[] oldPIN = null;
        char[] newPIN = null;
        if (_pin == null || _newPin == null) {
            chvDialog.show();
            int result = chvDialog.getResult();
            if (result == 2) {
                throw new PinInputCancelledException(GovCS.getPinName(_cardPin), -1, APDUCommands.getVerifyErrorMsg(0));
            }
            oldPIN = initCard && !ArrayUtil.isNullOrEmpty(this.getInitPIN()) ? this.getInitPIN() : (initCard && this.usesNullPIN() ? new char[6] : chvDialog.getPIN());
            newPIN = chvDialog.getNewPIN();
        } else {
            oldPIN = new char[_pin.length];
            System.arraycopy(_pin, 0, oldPIN, 0, _pin.length);
            newPIN = new char[_newPin.length];
            System.arraycopy(_newPin, 0, newPIN, 0, _newPin.length);
        }
        CommandAPDU cmd = this.createChangePasswordCommand(cpInfo, oldPIN, newPIN);
        LOG.debug((Object)((!initCard ? "CHANGE" : "INIT") + " 1 CMD : " + HexString.hexify(cmd.getBuffer(), 0, Math.min(5, cmd.getBuffer().length), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)((!initCard ? "CHANGE" : "INIT") + " 1 RES : " + HexString.hexify(res.getBuffer(), false)));
        int resultCode = this.evaluateChangePasswordResultCode(pinName, retryCount, res.sw());
        return resultCode;
    }

    protected boolean checkChannelState(CardChannel _channel, OCFCertificateInfo _info) {
        return this.getChannelState(_channel).getInfo() == _info;
    }

    protected CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -122;
        store[3] = -128;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    protected abstract Card createCardInt(Terminal var1, int var2);

    protected abstract OCFCertificateInfo[] createCertificateInfos();

    protected CommandAPDU createChangePasswordCommand(OCFCertificateInfo _info, char[] _oldPIN, char[] _newPIN) {
        byte[] oldPIN = this.getPaddedPIN(_info, _oldPIN);
        if (oldPIN == null) {
            oldPIN = new byte[6];
        }
        byte[] newPIN = this.getPaddedPIN(_info, _newPIN);
        byte[] commandBytes = new byte[4 + (oldPIN != null && newPIN != null ? 1 + oldPIN.length + newPIN.length : 0)];
        int index = 0;
        commandBytes[index++] = 0;
        commandBytes[index++] = 36;
        commandBytes[index++] = (byte)(_oldPIN == null ? 1 : 0);
        commandBytes[index++] = _info.getPinID();
        if (oldPIN != null && newPIN != null) {
            commandBytes[index++] = (byte)(oldPIN.length + newPIN.length);
            System.arraycopy(oldPIN, 0, commandBytes, index, oldPIN.length);
            System.arraycopy(newPIN, 0, commandBytes, index += oldPIN.length, newPIN.length);
        }
        return new CommandAPDU(commandBytes);
    }

    protected CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters) {
        GISOCommandAPDU giso = new GISOCommandAPDU((byte)0, (Byte)42, (Byte)-128, (Byte)-122, ByteUtil.combine(new byte[]{_paddingIndicator}, _encryptedBytes), (Integer)0);
        return giso;
    }

    protected CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters, OCFCertificateInfo info) {
        return this.createDecryptCommand(_encryptedBytes, _paddingIndicator, algorithmParameters);
    }

    protected CommandAPDU createGetRandomCommand() {
        byte[] store = new byte[]{0, -124, 0, 0, 24};
        return new CommandAPDU(store);
    }

    protected abstract CommandAPDU createMSECommand(CardChannel var1, OCFCertificateInfo var2, int var3, String var4, AlgorithmParameters var5) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException;

    protected CommandAPDU createReadBinaryCommand(int _offset, int _length) {
        return APDUCommands.createReadBinaryCommand(_offset, _length);
    }

    protected CommandAPDU createSelectMasterFile() {
        return new CommandAPDU(HexString.parseHexString("00 a4 00 0c"));
    }

    protected CommandAPDU createSelectMasterFile1() {
        return new CommandAPDU(HexString.parseHexString("00 a4 00 0c 02 3f 00"));
    }

    protected CommandAPDU createSelectMasterFile2() {
        return new CommandAPDU(HexString.parseHexString("00 a4 00 00 00"));
    }

    protected CommandAPDU createSignHashCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters, OCFCertificateInfo info) {
        return this.createSignHashCommand(_hashValue, algorithmParameters);
    }

    protected CommandAPDU createSignHashCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[5 + (_hashValue == null ? 0 : 1 + _hashValue.length)];
        store[0] = 0;
        store[1] = 42;
        store[2] = -98;
        store[3] = -102;
        if (_hashValue != null) {
            store[4] = (byte)_hashValue.length;
            System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        }
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    protected String createTerminalString(CardChannel _channel) {
        Object result = "";
        try {
            CardTerminal ct = _channel == null ? this.getCardTerminal() : _channel.getCardTerminal();
            result = (String)result + ct.getName();
            if (ct.getAddress() != null && ct.getAddress().length() > 0) {
                result = (String)result + " (" + ct.getAddress() + ")";
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)("just trace: " + t.getMessage()));
        }
        return result;
    }

    protected CommandAPDU createVerifyPasswordCommand(OCFCertificateInfo _info, char[] _pin) {
        byte[] pin = this.getPaddedPIN(_info, _pin);
        byte[] commandBytes = new byte[4 + (pin == null ? 0 : 1 + pin.length)];
        int index = 0;
        commandBytes[index++] = 0;
        commandBytes[index++] = 32;
        commandBytes[index++] = 0;
        commandBytes[index++] = _info.getPinID();
        if (pin != null) {
            commandBytes[index++] = (byte)pin.length;
            System.arraycopy(pin, 0, commandBytes, index, pin.length);
        }
        return new CommandAPDU(commandBytes);
    }

    protected ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        CommandAPDU cmd = this.createDecryptCommand(_encryptedBytes, this.getPaddingIndicator(), algorithmParameters, _info);
        LOG.debug((Object)("DECRYPT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("DECRYPT RESULT : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        ResultObject ro = new ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        return ro;
    }

    protected int evaluateChangePasswordResultCode(String pinName, Integer retries, int _resultcode) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, WrongConfirmedNewPinException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        if (_resultcode != 36864) {
            String errorMessage = APDUCommands.getChangePasswordErrorMsg(_resultcode);
            if (_resultcode == 25601) {
                throw new PinInputCancelledException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 27013) {
                throw new NotYetInitializedException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 25603) {
                throw new PinInputTooShortException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 25604) {
                throw new PinInputTooLongException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 25602) {
                throw new WrongConfirmedNewPinException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 25600) {
                throw new PinInputTimeoutException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 25344 || (_resultcode & 0xFFF0) == 25536 && (_resultcode & 0xF) > 0) {
                throw new WrongPinException(pinName, _resultcode, APDUCommands.getChangePasswordErrorMsg(_resultcode));
            }
            if (_resultcode == 27011 || (_resultcode & 0xFFF0) == 25536 && (_resultcode & 0xF) == 0) {
                throw new RetryCounterExpiredException(pinName, _resultcode, errorMessage);
            }
            throw new OperationCancelledException(pinName, _resultcode, "card operation failed");
        }
        return _resultcode;
    }

    protected int evaluateVerifyPasswordResultCode(String pinName, Integer retries, int _resultcode) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputTimeoutException, PinInputTooLongException, PinInputTooShortException, PinInputCancelledException, OperationCancelledException {
        if (_resultcode != 36864) {
            String errorMessage = APDUCommands.getVerifyErrorMsg(_resultcode);
            if (_resultcode == 25601) {
                throw new PinInputCancelledException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 27013) {
                throw new NotYetInitializedException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 25603) {
                throw new PinInputTooShortException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 25604) {
                throw new PinInputTooLongException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 25600) {
                throw new PinInputTimeoutException(pinName, _resultcode, errorMessage);
            }
            if (_resultcode == 25344 || (_resultcode & 0xFFF0) == 25536 && (_resultcode & 0xF) > 0) {
                throw new WrongPinException(pinName, _resultcode, APDUCommands.getChangePasswordErrorMsg(_resultcode));
            }
            if (_resultcode == 27011 || (_resultcode & 0xFFF0) == 25536 && (_resultcode & 0xF) == 0) {
                throw new RetryCounterExpiredException(pinName, _resultcode, errorMessage);
            }
            throw new OperationCancelledException(pinName, _resultcode, "card operation failed");
        }
        return _resultcode;
    }

    public static int getAlternativeResultCode(Integer retries, int _resultcode) {
        if (retries == null) {
            return _resultcode;
        }
        return CardErrorUtil.getErrorCodeForRetries(retries);
    }

    protected void fireProgressEvent(ProgressSession session, String message) {
        if (this.progressSessionListener != null) {
            session.increaseCurrentStep();
            session.setProgressMessage(message);
            this.progressSessionListener.progressSessionUpdate(session);
        }
    }

    protected ChannelState getChannelState(CardChannel _channel) {
        Object s = _channel.getState();
        if (ChannelState.class.isInstance(s)) {
            return (ChannelState)s;
        }
        ChannelState state = new ChannelState();
        if (OCFCertificateInfo.class.isInstance(s)) {
            state.setInfo((OCFCertificateInfo)s);
        } else if (s != null) {
            state.setExtra(s);
        }
        _channel.setState(state);
        return state;
    }

    protected abstract byte[] getHistoricals();

    protected char[] getInitPIN() {
        return null;
    }

    protected abstract String getIssuerConstant();

    protected int getMaximumChunkSize() {
        return 240;
    }

    protected final OCFCertificateInfo[] getOCFCertificateInfos() {
        if (this.infos == null) {
            Card card = CardObjectRegistryImpl.getInstance().getCard(super.getCard());
            if (card != null) {
                this.infos = card.getAllCertificates();
                StringBuffer sb = new StringBuffer();
                sb.append("Keys/Files:\n");
                if (this.infos != null && this.infos.length > 0) {
                    for (OCFCertificateInfo oi : this.infos) {
                        sb.append(oi.getNameString() + "\n");
                    }
                }
                LOG.debug((Object)sb.toString());
            } else {
                LOG.error((Object)(this.getClass().getName() + " has created no card: fix it - GovCS"));
            }
            if (this.infos == null) {
                LOG.error((Object)(this.getClass().getName() + " has created got no infos: fix it - GovCS"));
                this.infos = this.createCertificateInfos();
            }
        }
        if (this.infos == null) {
            return new OCFCertificateInfo[0];
        }
        OCFCertificateInfo[] result = new OCFCertificateInfo[this.infos.length];
        System.arraycopy(this.infos, 0, result, 0, this.infos.length);
        return result;
    }

    protected String getOSName() {
        return "(v.0.9b)";
    }

    @Override
    public byte[] padPin(OCFCertificateInfo _info, char[] _pin) {
        return this.getPaddedPIN(_info, _pin);
    }

    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        int i;
        int blockLength = this.getPasswordBlockLength(_info);
        if (blockLength == -1 && (_pin == null || _pin.length == 0)) {
            return null;
        }
        byte[] result = new byte[blockLength == -1 ? _pin.length : blockLength];
        if (_pin != null) {
            for (i = 0; i < _pin.length; ++i) {
                result[i] = (byte)_pin[i];
            }
        }
        byte filler = this.getPasswordBlockFiller(_info);
        while (i < blockLength) {
            result[i] = filler;
            ++i;
        }
        return result;
    }

    protected byte getPaddingIndicator() {
        return -127;
    }

    protected int getRetryCount(CardChannel _channel, CardPin pin) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException, PinDeactivatedException {
        return -1;
    }

    protected abstract int getRetryCount(CardChannel var1, OCFCertificateInfo var2) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException, PinDeactivatedException;

    protected boolean historicalsEquals(byte[] _historicals) {
        if (_historicals == null || _historicals.length == 0) {
            return false;
        }
        if (_historicals.length != 10) {
            return false;
        }
        if (_historicals[0] != 0) {
            return false;
        }
        if (_historicals[1] != 100) {
            return false;
        }
        if (_historicals[4] != 2) {
            return false;
        }
        if (_historicals[6] != 49) {
            return false;
        }
        if (_historicals[7] != -128) {
            return false;
        }
        if (_historicals[8] != -112) {
            return false;
        }
        return _historicals[9] == 0;
    }

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        this.smartcard = smartcard;
        this.slotID = scheduler.getSlotChannel().getSlotNumber();
        this.scheduler = scheduler;
    }

    public final void close(CardTerminalEvent ctEvent) {
        try {
            this.scheduler.cardInserted(ctEvent);
        }
        catch (Exception exception) {
        }
        finally {
            this.scheduler = null;
        }
    }

    protected boolean isIssuerReadRequired() {
        return false;
    }

    protected synchronized boolean isInitialized(CardChannel _channel, CardPin _pin) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        String pinName = GovCS.getPinName(_pin);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_pin.getPinID());
        LOG.debug((Object)("INIT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("INIT RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err == 27011) {
            throw new RetryCounterExpiredException(pinName, err, APDUCommands.getVerifyErrorMsg(err));
        }
        return err != 27013;
    }

    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        String pinName = GovCS.getPinNameForInfo(_info);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        LOG.debug((Object)("INIT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("INIT RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err == 27011) {
            throw new RetryCounterExpiredException(pinName, err, APDUCommands.getVerifyErrorMsg(err));
        }
        return err != 27013;
    }

    protected ResultObject readCertificate(CardChannel _channel, OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        this.selectFile(_channel, _info, true);
        return this.readSelectedFile(_channel, 0, 2048);
    }

    protected ResultObject readFile(CardChannel _channel, FileEntry _fileEntry) throws ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        this.selectFile(_channel, _fileEntry, true);
        return this.readSelectedFile(_channel, 0, 2048);
    }

    protected String readIssuerFromATR(CardChannel _channel) {
        return this.readIssuerFromATR(_channel, 7);
    }

    protected String readIssuerFromATR(CardChannel _channel, int bytes) {
        try {
            String result;
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            int err = 36864;
            boolean tryGetData = false;
            cmd = this.createSelectMasterFile();
            if (cmd != null) {
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    tryGetData = true;
                }
                if ((err = res.sw()) != 36864) {
                    tryGetData = true;
                }
            }
            if ((res = _channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 a4 02 0c 02 2f 02")))) == null) {
                tryGetData = true;
            }
            if ((err = res.sw()) != 36864) {
                tryGetData = true;
            }
            if (tryGetData) {
                cmd = new CommandAPDU(HexString.parseHexString("00 ca 01 80 00"));
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                err = res.sw();
                if (err != 36864) {
                    throw new ResponseCodeException(err, APDUCommands.getReadBinaryErrorMsg(err));
                }
                if (res.data() != null && res.data().length > 1 && res.data()[res.data().length - 1] == 0) {
                    return HexString.hexify(ByteUtil.subbytes(res.data(), 0, res.data().length - 1));
                }
                return HexString.hexify(res.data());
            }
            cmd = this.createReadBinaryCommand(0, bytes);
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            err = res.sw();
            if (err != 36864) {
                throw new ResponseCodeException(err, APDUCommands.getReadBinaryErrorMsg(err));
            }
            String string = result = res.data() == null ? null : HexString.hexify(res.data(), false);
            if (res.data() != null && res.data().length > 1 && res.data()[res.data().length - 1] == 0 && result != null) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
        catch (Throwable ex) {
            LOG.debug((Object)("readIssuer failed: " + ex.getMessage()));
            return null;
        }
    }

    protected String readCIATokenInfoFromCard(CardChannel _channel) {
        return this.readApplicationFileFromCard(_channel, "A0 00 00 02 45 53 69 67 6E", "50 32");
    }

    protected String readCIAEFDIR(CardChannel _channel) {
        return this.readApplicationFileFromCard(_channel, "A0 00 00 02 45 53 69 67 6E", "43 20");
    }

    protected String readPKCS15TokenInfoFromCard(CardChannel _channel) {
        return this.readApplicationFileFromCard(_channel, "a0 00 00 00 63 50 4b 43 53 2d 31 35", "50 32");
    }

    protected byte[] readPKCS15ODF(CardChannel _channel) {
        return this.readApplicationFileBytesFromCard(_channel, "a0 00 00 00 63 50 4b 43 53 2d 31 35", "50 31");
    }

    protected String readPKCS15EFDIR(CardChannel _channel) {
        return this.readApplicationFileFromCard(_channel, "a0 00 00 00 63 50 4b 43 53 2d 31 35", "43 20");
    }

    protected String readMFFileFromCard(CardChannel _channel, String fid) {
        try {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            int err = 36864;
            cmd = this.createSelectMasterFile();
            if (cmd != null) {
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    return "";
                }
                err = res.sw();
                if (err != 36864) {
                    return "";
                }
            }
            return this.readFileFromCard(_channel, fid);
        }
        catch (Throwable ex) {
            LOG.error((Object)"", ex);
            return null;
        }
    }

    protected String readApplicationFileFromCard(CardChannel _channel, String aid, String fid) {
        try {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            int err = 36864;
            cmd = this.createSelectMasterFile();
            if (cmd != null) {
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    return "";
                }
                err = res.sw();
                if (err != 36864) {
                    return "";
                }
            }
            String lAid = aid.replaceAll(" ", "").toLowerCase();
            res = _channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString(String.format("00a4040c0%h" + lAid, lAid.length() / 2))));
            if (res == null) {
                return "";
            }
            err = res.sw();
            if (err != 36864) {
                return "";
            }
            return this.readFileFromCard(_channel, fid);
        }
        catch (Throwable ex) {
            LOG.error((Object)"", ex);
            return null;
        }
    }

    protected byte[] readApplicationFileBytesFromCard(CardChannel _channel, String aid, String fid) {
        try {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            int err = 36864;
            cmd = this.createSelectMasterFile();
            if (cmd != null) {
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    return null;
                }
                err = res.sw();
                if (err != 36864) {
                    return null;
                }
            }
            String lAid = aid.replaceAll(" ", "").toLowerCase();
            res = _channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString(String.format("00a4040c0%h" + lAid, lAid.length() / 2))));
            if (res == null) {
                return null;
            }
            err = res.sw();
            if (err != 36864) {
                return null;
            }
            return this.readFileBytesFromCard(_channel, fid);
        }
        catch (Throwable ex) {
            LOG.error((Object)"", ex);
            return null;
        }
    }

    protected String readFileFromCard(CardChannel _channel, String fid) {
        byte[] data = this.readFileBytesFromCard(_channel, fid);
        String result = data == null ? null : new String(data);
        return result;
    }

    protected byte[] readFileBytesFromCard(CardChannel _channel, String fid) {
        try {
            String lFid = fid.replaceAll(" ", "").toLowerCase();
            ResponseAPDU res = _channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString(String.format("00a4020c02" + lFid, lFid.length() / 2))));
            if (res == null) {
                return null;
            }
            int err = res.sw();
            if (err != 36864) {
                return null;
            }
            CommandAPDU cmd = this.createReadBinaryCommand(0, 240);
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            err = res.sw();
            if (err != 36864 && (err & 0x6200) != 25088) {
                throw new ResponseCodeException(err, APDUCommands.getReadBinaryErrorMsg(err));
            }
            return res.data();
        }
        catch (Throwable ex) {
            LOG.error((Object)"", ex);
            return null;
        }
    }

    protected ResultObject readBase64BinaryCerFile(CardChannel _channel) throws InvalidCardChannelException, CardTerminalException {
        ResultObject ro = new ResultObject();
        ro.setResultCode(25218);
        ro.setResultData(null);
        return ro;
    }

    protected ResultObject readSelectedFile(CardChannel _channel, int _offset, int _length) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        boolean ignoreErrorCode;
        byte[] readBytes;
        int fileSize;
        ResponseAPDU res;
        block13: {
            CommandAPDU cmd = this.createReadBinaryCommand(0, 10);
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            int err = res.sw();
            if (err == 25218) {
                ResultObject ro = new ResultObject();
                ro.setResultCode(25218);
                ro.setResultData(null);
                return ro;
            }
            byte[] responseData = res.data();
            if (responseData == null || responseData.length < 5) {
                throw new IllegalArgumentException(RESOURCES.getString("insufficient_data") + HexString.hexify(responseData, false));
            }
            if (Arrays.equals(CONTENT_INDICATOR_BASE64_BINARY_CERTIFICATE.getBytes(), ByteUtil.subbytes(responseData, 0, CONTENT_INDICATOR_BASE64_BINARY_CERTIFICATE.length()))) {
                LOG.debug((Object)"not ASN.1 code file content - base64 binary coding, not really recommended");
                return this.readBase64BinaryCerFile(_channel);
            }
            fileSize = 0;
            if (responseData[0] != -1 && (responseData[1] & 0xFFFFFF80) == -128) {
                int length = responseData[1] & 0x7F;
                length = Math.min(length, 2);
                LOG.debug((Object)("fst 10 bytes: " + HexString.hexify(responseData)));
                for (int j = 0; j < length; ++j) {
                    fileSize <<= 8;
                    fileSize += responseData[2 + j] & 0xFF;
                }
                fileSize += 2 + length;
            }
            if (fileSize == 0) {
                return null;
            }
            LOG.debug((Object)("cert size: " + fileSize));
            boolean readFully = _length == 2048;
            readBytes = new byte[readFully ? fileSize : _length];
            int chunkSize = Math.min(readBytes.length, this.getMaximumChunkSize());
            int offset = _offset;
            ignoreErrorCode = false;
            do {
                byte[] buffer;
                if ((res = _channel.sendCommandAPDU(cmd = this.createReadBinaryCommand(offset, chunkSize))) == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                err = res.sw();
                if (err != 36864) {
                    if (err == 27270) {
                        ignoreErrorCode = true;
                        break block13;
                    }
                    if (err != 27392 && err != 25218) break block13;
                }
                if ((buffer = res.data()) == null) break block13;
                System.arraycopy(buffer, 0, readBytes, offset, buffer.length);
                if ((offset += buffer.length) == readBytes.length) break block13;
                chunkSize = Math.min(readBytes.length - offset, this.getMaximumChunkSize());
            } while (err != 25218 && err != 27392);
            LOG.debug((Object)"pricicely when it means to ...");
            ignoreErrorCode = true;
        }
        ResultObject ro = new ResultObject();
        ro.setResultCode(ignoreErrorCode ? 36864 : res.sw());
        ro.setResultData(readBytes);
        String hashString = "- no hash generated -";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1", "BC");
            hashString = HexUtil.hexify(md.digest(readBytes));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOG.debug((Object)("cert size: " + fileSize));
        LOG.debug((Object)("read bytes length: " + readBytes.length));
        LOG.debug((Object)("sha1 of read bytes: " + hashString));
        return ro;
    }

    public ResponseAPDU readSelectedFileChunked(CardChannel _channel) {
        LOG.debug((Object)"reading file chunked...");
        ResponseAPDU res = null;
        try {
            ByteArrayOutputStream baos;
            boolean ignoreErrorCode;
            block8: {
                int chunkSize = this.getMaximumChunkSize();
                int offset = 0;
                CommandAPDU cmd = null;
                int err = 36864;
                ignoreErrorCode = false;
                baos = new ByteArrayOutputStream();
                do {
                    byte[] buffer;
                    if ((res = _channel.sendCommandAPDU(cmd = this.createReadBinaryCommand(offset, chunkSize))) == null) {
                        throw new ResponseCodeException(RESOURCES.getString("no_response"));
                    }
                    err = res.sw();
                    if (err != 36864) {
                        if (err == 27270) {
                            ignoreErrorCode = true;
                            break block8;
                        }
                        if (err != 27392 && err != 25218) break block8;
                    }
                    if ((buffer = res.data()) == null) break block8;
                    baos.write(buffer, 0, buffer.length);
                    offset += buffer.length;
                } while (err != 25218 && err != 27392);
                LOG.debug((Object)"pricicely when it means to ...");
                ignoreErrorCode = true;
            }
            if (ignoreErrorCode) {
                baos.write(HexUtil.parse(HexUtil.hexify(36864)));
            } else {
                baos.write(new byte[]{res.sw1(), res.sw2()});
            }
            return new ResponseAPDU(baos.toByteArray());
        }
        catch (Exception e) {
            LOG.debug((Object)("error reading binary data chunked: " + e.getMessage()));
            res = new ResponseAPDU(HexUtil.parse(HexUtil.hexify(25218)));
            return res;
        }
    }

    protected void selectFile(CardChannel _channel, FileEntry _fileEntry, boolean _selectFile) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        this.selectMasterFile(_channel);
        if (_fileEntry.getDirectory() != null) {
            this.selectSubDirectory(_channel, _fileEntry.getDirectory());
        }
        if (_selectFile) {
            this.selectFile(_channel, _fileEntry.getFile());
        }
    }

    protected void selectFile(CardChannel _channel, FileReference _file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (_file == null) {
            return;
        }
        CommandAPDU cmd = APDUCommands.createSelectCommand(_file.referenceType, 12, _file.reference, 1024);
        LOG.debug((Object)("SELECT FILE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT FILE RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
    }

    protected void selectFile(CardChannel _channel, OCFCertificateInfo _info, boolean _selectFile) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        this.selectMasterFile(_channel);
        if (_info != null) {
            if (_info.getDirectory() != null) {
                this.selectSubDirectory(_channel, _info.getDirectory());
            }
            if (_selectFile) {
                this.selectFile(_channel, _info.getFile());
            }
        }
        this.setChannelState(_channel, _info);
    }

    protected void selectMasterFile(CardChannel _channel) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (this.ctReference != null && !this.ctReference.isCardPresent(this.slotID)) {
            return;
        }
        CommandAPDU cmd = this.createSelectMasterFile();
        if (cmd == null) {
            return;
        }
        LOG.debug((Object)("SELECT MF CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT MF RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864 && err != 25220) {
            cmd = this.createSelectMasterFile1();
            if (cmd == null) {
                return;
            }
            LOG.debug((Object)("SELECT MF CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            LOG.debug((Object)("SELECT MF RES : " + HexString.hexify(res.getBuffer(), false)));
            err = res.sw();
            if (err != 36864 && err != 25220) {
                cmd = this.createSelectMasterFile2();
                if (cmd == null) {
                    return;
                }
                LOG.debug((Object)("SELECT MF CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                LOG.debug((Object)("SELECT MF RES : " + HexString.hexify(res.getBuffer(), false)));
                err = res.sw();
                if (err != 36864 && err != 25220) {
                    throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
                }
            }
        }
    }

    protected void selectSubDirectory(CardChannel _channel, FileReference _directory) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (_directory == null) {
            return;
        }
        CommandAPDU cmd = APDUCommands.createSelectCommand(_directory.referenceType, 12, _directory.reference, 1024);
        LOG.debug((Object)("SELECT SUB DIR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT SUB DIR RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
    }

    protected void setChannelState(CardChannel _channel, Object o) {
        this.getChannelState(_channel).setExtra(o);
    }

    protected void setChannelState(CardChannel _channel, OCFCertificateInfo _info) {
        if (this.isMultiSign() && OCFProvider.Settings.getInstance().isServerEnvironmentActive() || this.isStapleSign() && OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && CardTerminalManager.isTransactionStarted(this.ctReference)) {
            this.getChannelState(_channel).setInfo(_info);
        }
    }

    @Override
    protected final void allocateCardChannel() throws InvalidCardChannelException {
        super.allocateCardChannel();
    }

    @Override
    protected final void releaseCardChannel() throws InvalidCardChannelException {
        this.releaseCardChannel(true);
    }

    protected final void releaseCardChannel(boolean resetChannelState) throws InvalidCardChannelException {
        try {
            if (resetChannelState && !CardTerminalManager.isTransactionStarted(this.ctReference) && (this.isStapleSign() && OCFProvider.Settings.getInstance().isStapleSignatureEnabled() || this.isMultiSign() && OCFProvider.Settings.getInstance().isServerEnvironmentActive())) {
                this.reset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.releaseCardChannel();
    }

    protected ResultObject setSecurityEnvironment(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException {
        LOG.debug((Object)"entered");
        ResultObject ro = new ResultObject();
        CommandAPDU cmdMSO = this.createMSECommand(_channel, _info, _type, _hashAlgorithm, algorithmParameters);
        if (cmdMSO == null) {
            ro.setResultCode(36864);
            return ro;
        }
        LOG.debug((Object)("MSE " + _type + " CMD : " + HexString.hexify(cmdMSO.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmdMSO);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("MSE " + _type + " RES : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getManageSecurityEnvironmentErrorMsg(res.sw()));
        }
        return ro;
    }

    protected ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        boolean hashValuePresent = _hashValue != null;
        LOG.debug((Object)("hash/digestInfo present: " + hashValuePresent));
        if (hashValuePresent) {
            boolean digestInfo = true;
            if (digestInfo) {
                try {
                    CardExecutionSignAuthenticateParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                    Boolean digestInfoTmp = parameterSpec.isDigestInfoUsed();
                    if (digestInfoTmp != null) {
                        digestInfo &= digestInfoTmp.booleanValue();
                    } else {
                        LOG.debug((Object)("usesASN1HeaderWithSignHash=" + this.usesASN1HeaderWithSignHash()));
                        digestInfo &= this.usesASN1HeaderWithSignHash();
                    }
                }
                catch (InvalidParameterSpecException e) {
                    LOG.debug((Object)e);
                    digestInfo &= this.usesASN1HeaderWithSignHash();
                }
            }
            LOG.debug((Object)("using hash: " + !digestInfo));
            LOG.debug((Object)("using DigestInfo: " + digestInfo));
            if (digestInfo) {
                try {
                    _hashValue = new DigestInfo(HashAlgorithm.Algorithm.getAlgorithmByName(_hashAlgorithm), _hashValue).getEncoded();
                    LOG.debug((Object)("pkcs#1=" + HexString.hexify(_hashValue)));
                }
                catch (Exception ex) {
                    LOG.error((Object)"", (Throwable)ex);
                }
            }
        }
        CommandAPDU cmd = this.createSignHashCommand(_hashValue, algorithmParameters, _info);
        LOG.debug((Object)("SIGN CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SIGN RES  : " + HexString.hexify(res.getBuffer(), false)));
        ResultObject ro = new ResultObject();
        res = this.handleOldEPO(_channel, res);
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        return ro;
    }

    public static byte[] createMessageDigestInfo(AlgorithmIdentifier algorithmIdentifier, byte[] _hashValue) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)algorithmIdentifier);
        v.add((ASN1Encodable)new DEROctetString(_hashValue));
        return new DERSequence(v).getEncoded();
    }

    protected boolean useKeyboard() {
        return !this.hasPinPad() || this.isKeybordAllowed();
    }

    protected boolean usesASN1HeaderWithAuthentify() {
        return false;
    }

    protected boolean usesASN1HeaderWithSignHash() {
        return true;
    }

    protected boolean usesNullPIN() {
        return false;
    }

    protected int verifyPassword(CardChannel _channel, OCFCertificateInfo _info, char[] _pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        return this.verifyPassword(_channel, _info, _pin, null);
    }

    protected int verifyPassword(CardChannel _channel, OCFCertificateInfo _info, char[] _pin, Integer retryCount) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        LOG.info((Object)("hasPinPad: " + this.hasPinPad()));
        LOG.info((Object)("isKeyBoardAllowed: " + this.isKeybordAllowed()));
        LOG.info((Object)("useKeyboard: " + this.useKeyboard()));
        String pinName = GovCS.getPinNameForInfo(_info);
        if (retryCount == null) {
            if (!this.isKeyInitialized(_channel, _info)) {
                throw new NotYetInitializedException(pinName, 27013, APDUCommands.getVerifyErrorMsg(27013));
            }
            retryCount = this.getRetryCount(_channel, _info);
            if (retryCount == 0) {
                throw new RetryCounterExpiredException(pinName, 27011, APDUCommands.getVerifyErrorMsg(27011));
            }
        }
        GovCHVDialog chvDialog = null;
        try {
            chvDialog = (GovCHVDialog)this.chvDialogClass.newInstance();
            chvDialog.setParentWindow(this.parentWindow);
        }
        catch (InstantiationException ex) {
            throw new OperationCancelledException("", CardErrorUtil.getErrorCodeForRetries(retryCount), ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new OperationCancelledException("", CardErrorUtil.getErrorCodeForRetries(retryCount), ex.getMessage(), ex);
        }
        if (_pin == null) {
            GovCHVConfiguration config = new GovCHVConfiguration(retryCount, BDialogMode.CARD_VERIFY, this.getMinPINLength(_info), this.getMaxPINLength(_info), _info, this.createTerminalString(_channel), this.getInitPIN(), null, null, this.getClass());
            config.setShowPseudoDisplay(this.pcsc20Features.getVerifyPINStart().valueAsNumber() != 0);
            if (this.pcsc20Features.getVerifyPINStart().valueAsNumber() != 0) {
                config.setShowPseudoDisplay(!TerminalOperationHandler.Util.usePCSCVerifyModifyDirect(this.ctReference, false));
            }
            chvDialog.setConfiguration(config);
        }
        ResponseAPDU res = null;
        if (_pin == null && !this.useKeyboard() && (res = this.terminalHandler.verifyPassword(_info, chvDialog, this)) != null) {
            LOG.debug((Object)("VP RES : " + HexString.hexify(res.getBuffer(), false)));
            LOG.debug((Object)("VP RES : " + APDUCommands.getVerifyErrorMsg(res.sw())));
            if (res.sw() == 25616 || res.sw() == 28160) {
                res = null;
            } else {
                int result = this.evaluateVerifyPasswordResultCode(pinName, retryCount, res.sw());
                return result;
            }
        }
        return this.verifyPasswordReaderClass1(_channel, _info, _pin, retryCount, pinName, chvDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int verifyPasswordReaderClass1(CardChannel _channel, OCFCertificateInfo _info, char[] _pin, Integer retryCount, String pinName, GovCHVDialog chvDialog) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        ResponseAPDU res;
        block7: {
            char[] pin = null;
            CommandAPDU cmd = null;
            try {
                if (_pin == null) {
                    chvDialog.show();
                    int result = chvDialog.getResult();
                    if (result == 2) {
                        throw new PinInputCancelledException(pinName, CardErrorUtil.getErrorCodeForRetries(retryCount), APDUCommands.getVerifyErrorMsg(0));
                    }
                    pin = chvDialog.getPIN();
                } else {
                    pin = new char[_pin.length];
                    System.arraycopy(_pin, 0, pin, 0, pin.length);
                }
                cmd = this.createVerifyPasswordCommand(_info, pin);
                LOG.debug((Object)("VP CMD : " + HexString.hexify(cmd.getBuffer(), 0, Math.min(5, cmd.getBuffer().length), false)));
                res = _channel.sendCommandAPDU(cmd);
                LOG.debug((Object)("VP RES : " + (res == null ? null : HexString.hexify(res.getBuffer(), false))));
                if (pin == null) break block7;
            }
            catch (Throwable throwable) {
                if (pin == null) throw throwable;
                int i = 0;
                while (i < pin.length) {
                    pin[i] = '\u0000';
                    ++i;
                }
                throw throwable;
            }
            for (int i = 0; i < pin.length; ++i) {
                pin[i] = '\u0000';
            }
        }
        if (res != null) return this.evaluateVerifyPasswordResultCode(pinName, retryCount, res.sw());
        throw new ResponseCodeException(RESOURCES.getString("no_response"));
    }

    public static String getPinNameForInfo(OCFCertificateInfo _info) {
        String pinName = _info != null && _info.getPin() != null ? _info.getPin().getName() : "";
        return pinName;
    }

    public static String getPinName(CardPin _pin) {
        String pinName = _pin != null ? _pin.getName() : "";
        return pinName;
    }

    public void analizeCardTerminal(CardTerminal _ct, boolean _keyboardAllowed) throws CardTerminalException {
        this.ctReference = _ct;
        this.terminalName = _ct.getName().toLowerCase();
        LOG.debug((Object)("terminal : " + this.terminalName));
        this.isCyberJack = this.terminalName.indexOf("cyberjack") != -1 && this.terminalName.indexOf("e-com") != -1;
        this.isCtapiClass3 = OCFBCSClass3Terminal.class.isInstance(_ct);
        if (_ct instanceof PCSCCardTerminal) {
            PCSCCardTerminal terminal = (PCSCCardTerminal)_ct;
            this.pcsc20Features = terminal.getPcsc20Features();
        } else {
            this.pcsc20Features = Pcsc20Features.createEmptyPCSC20Features();
        }
        if (this.pcsc20Features == null) {
            this.pcsc20Features = Pcsc20Features.createEmptyPCSC20Features();
        }
        this.terminalHandler.update(_ct, this.pcsc20Features, this.terminalName);
        this.setHasPinPad(this.isCtapiClass3 || this.pcsc20Features.getVerifyPINStart().valueAsNumber() != 0 || this.pcsc20Features.getVerifyPINDirect().valueAsNumber() != 0);
        if (_ct.getName().toLowerCase().contains("sdi 010") || _ct.getName().toLowerCase().contains("sdi010") || _ct.getName().toLowerCase().contains("sdi011")) {
            this.setHasPinPad(false);
        }
        this.setKeyboardAllowed(_keyboardAllowed);
        LOG.debug((Object)("card : " + this));
        LOG.debug((Object)("terminal: " + this.pcsc20Features));
    }

    @Override
    public synchronized ResultObject authentify(CardKey _key, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, CardTerminalException, OperationCancelledException {
        return this.authentify(_key.getInfo(), _hashValue, _pin, _hashAlgorithm, algorithmParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultObject authentify(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, CardTerminalException {
        boolean multiAuthenticateEnabled = this.isTransactionStarted() && this.isMultiAuthenticate(_info);
        LOG.debug((Object)("multi authentication enabled: " + multiAuthenticateEnabled));
        CardChannelManager cardChannelManager = new CardChannelManager();
        ProgressSession session = new ProgressSession(3);
        session.setStepCount(6);
        session.setProgressMessage("init authentification operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        ResultObject ro = new ResultObject();
        ChannelState state = null;
        AuthenticationChannelState astate = null;
        try {
            CardChannel channel;
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("get connection to the device");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            if ((state = (ChannelState)(channel = cardChannelManager.init(this)).getState()) == null) {
                state = new ChannelState();
                state.setMaximumCountOfSignatures(null);
                state.setExtra(null);
                channel.setState(state);
            }
            astate = (AuthenticationChannelState)((Object)state.getExtra());
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("select application on card");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            if ((astate = this.updateAuthenticationChannelState(channel, multiAuthenticateEnabled, AuthenticationChannelState.PRE_SELECTION_DONE)) == null || AuthenticationChannelState.PRE_SELECTION_DONE == astate) {
                this.selectFile(channel, _info, false);
            }
            astate = this.updateAuthenticationChannelState(channel, multiAuthenticateEnabled, AuthenticationChannelState.POST_SELECTION_DONE);
            if (!_info.isTest()) {
                if (this.progressSessionListener != null) {
                    session.increaseCurrentStep();
                    session.setProgressMessage("verify the corresponding password");
                    this.progressSessionListener.progressSessionUpdate(session);
                }
                if ((astate = this.updateAuthenticationChannelState(channel, multiAuthenticateEnabled, AuthenticationChannelState.PRE_PASSWORD_VERIFIED)) == null || AuthenticationChannelState.PRE_PASSWORD_VERIFIED == astate) {
                    ro.resultCode = this.verifyPassword(channel, _info, _pin);
                }
                astate = this.updateAuthenticationChannelState(channel, multiAuthenticateEnabled, AuthenticationChannelState.POST_PASSWORD_VERIFIED);
            } else {
                ro.setResultCode(36864);
            }
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                ResultObject resultObject = ro;
                return resultObject;
            }
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("install corresponding security environment");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            if ((astate = this.updateAuthenticationChannelState(channel, multiAuthenticateEnabled, AuthenticationChannelState.PRE_SECURITY_ENVIRONMENT_PREPARED)) == null || AuthenticationChannelState.PRE_SECURITY_ENVIRONMENT_PREPARED == astate) {
                ro = this.setSecurityEnvironment(channel, _info, 2, _hashAlgorithm, algorithmParameters);
            }
            astate = this.updateAuthenticationChannelState(channel, multiAuthenticateEnabled, AuthenticationChannelState.POST_SECURITY_ENVIRONMENT_PREPARED);
            if (ro.getResultCode() != 36864) {
                ResultObject resultObject = ro;
                return resultObject;
            }
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("sign the given hash value");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            if ((astate = this.updateAuthenticationChannelState(channel, multiAuthenticateEnabled, AuthenticationChannelState.AUTHENTICATION)) == null || AuthenticationChannelState.AUTHENTICATION == astate) {
                ro = this.authentify(channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
            }
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("operation finished!");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            if (36864 != ro.resultCode) {
                this.resetCard(channel);
            }
            ResultObject resultObject = ro;
            return resultObject;
        }
        catch (WrongPinException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            throw e;
        }
        catch (NotYetInitializedException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            throw e;
        }
        catch (PinInputTooShortException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            throw e;
        }
        catch (PinInputTooLongException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            throw e;
        }
        catch (PinInputTimeoutException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            throw e;
        }
        catch (PinInputCancelledException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            throw e;
        }
        catch (OperationCancelledException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            throw e;
        }
        catch (ResponseCodeException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            throw e;
        }
        catch (CardTerminalException e) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            LOG.debug((Object)"", (Throwable)e);
            throw e;
        }
        catch (Throwable ex) {
            astate = this.updateAuthenticationChannelState(cardChannelManager.getCardChannel(), multiAuthenticateEnabled, AuthenticationChannelState.getErrorState(astate));
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            if (astate == AuthenticationChannelState.ERROR_PASSWORD_VERIFIED) {
                this.resetCard(cardChannelManager.getCardChannel());
                this.reset();
            }
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    private AuthenticationChannelState updateAuthenticationChannelState(CardChannel channel, boolean multiAuthenticateEnabled, AuthenticationChannelState nextAuthenticationChannelState) {
        Object channelStateObject = channel.getState();
        AuthenticationChannelState astate = null;
        if (channelStateObject instanceof ChannelState) {
            astate = AuthenticationChannelState.getNextState(multiAuthenticateEnabled, nextAuthenticationChannelState);
            if (astate == null) {
                return astate;
            }
            ChannelState channelState = (ChannelState)channelStateObject;
            Object extra = channelState.getExtra();
            if (AuthenticationChannelState.AUTHENTICATION == extra) {
                astate = AuthenticationChannelState.AUTHENTICATION;
            }
            channelState.setExtra((Object)astate);
        }
        return astate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int changePassword(OCFCertificateInfo _info, char[] _pin, char[] _newPIN) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        ProgressSession session = new ProgressSession(5);
        session.setStepCount(6);
        session.setProgressMessage("change password operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        try {
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("get connection to the device");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            CardChannel channel = cardChannelManager.init(this);
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("select application on card");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            this.selectFile(channel, _info, false);
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("verify and change the password");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            int result = this.changePassword(channel, _info, _pin, _newPIN);
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("operation finished!");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            int n = result;
            return n;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (WrongConfirmedNewPinException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            int n = 0;
            return n;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            int n = 0;
            return n;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int changePassword(CardPin _cardPin, char[] _pin, char[] _newPIN) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        ProgressSession session = new ProgressSession(5);
        session.setStepCount(6);
        session.setProgressMessage("change password operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        try {
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("get connection to the device");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            CardChannel channel = cardChannelManager.init(this);
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("select application on card");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            this.selectFile(channel, _cardPin.getParentApplication().getFileEntry(), false);
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("verify and change the password");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            int result = this.changePassword(channel, _cardPin, _pin, _newPIN);
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("operation finished!");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            int n = result;
            return n;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (WrongConfirmedNewPinException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            int n = 0;
            return n;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            int n = 0;
            return n;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    public final Card getCardObject() {
        return this.card;
    }

    public final Card createCard(CardTerminalEvent ctEvent) {
        try {
            Card card;
            Terminal terminal = CardObjectRegistryImpl.getInstance().getTerminal(ctEvent.getCardTerminal());
            this.card = card = this.createCardInt(terminal, ctEvent.getSlotID());
            return card;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public synchronized ResultObject decrypt(CardKey _key, byte[] _encryptedBytes, char[] _pin, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        return this.decrypt(_key.getInfo(), _encryptedBytes, _pin, algorithmParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultObject decrypt(OCFCertificateInfo _info, byte[] _encryptedBytes, char[] _pin, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        ProgressSession session = new ProgressSession(3);
        session.setStepCount(6);
        session.setProgressMessage("init authentification operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        ResultObject ro = new ResultObject();
        try {
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("get connection to the device");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            CardChannel channel = cardChannelManager.init(this);
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("select application on card");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            this.selectFile(channel, _info, false);
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("verify the corresponding password");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            if (!_info.isTest()) {
                ro.resultCode = this.verifyPassword(channel, _info, _pin);
                if (ro.getResultCode() != 36864) {
                    LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                    ResultObject resultObject = ro;
                    return resultObject;
                }
            } else {
                ro.setResultCode(36864);
            }
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("install corresponding security environment");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            if ((ro = this.setSecurityEnvironment(channel, _info, 1, null, algorithmParameters)).getResultCode() != 36864) {
                ResultObject resultObject = ro;
                return resultObject;
            }
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("decrypt the given session key");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            ro = this.decrypt(channel, _info, _encryptedBytes, algorithmParameters);
            if (this.progressSessionListener != null) {
                session.increaseCurrentStep();
                session.setProgressMessage("operation finished!");
                this.progressSessionListener.progressSessionUpdate(session);
            }
            ResultObject resultObject = ro;
            return resultObject;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            ResultObject resultObject = ro;
            return resultObject;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCFCertificateInfo[] getAllCertificates() {
        HashMap<CallSite, Object> certificateReadCache = new HashMap<CallSite, Object>();
        Vector<Object> vector = this.certificates;
        synchronized (vector) {
            if (this.certificates.isEmpty()) {
                OCFCertificateInfo[] infos = this.getOCFCertificateInfos();
                int attrCertCount = 0;
                for (int i = 0; i < infos.length; ++i) {
                    attrCertCount += infos[i].getAttributeCertificateFileEntries() != null ? infos[i].getAttributeCertificateFileEntries().length : 0;
                }
                ProgressSession session = new ProgressSession(6);
                session.setStepCount(infos.length + attrCertCount);
                session.setProgressMessage("read certificates");
                if (this.progressSessionListener != null) {
                    this.progressSessionListener.progressSessionWillStart(session);
                    this.progressSessionListener.progressSessionStarted(session);
                }
                CardChannelManager cardChannelManager = new CardChannelManager();
                try {
                    CardChannel channel = cardChannelManager.init(this);
                    if (PCSCCardTerminal.class.isInstance(channel.getCardTerminal())) {
                        this.pcsc20Features = ((PCSCCardTerminal)channel.getCardTerminal()).getPcsc20Features();
                    }
                    for (int i = 0; i < infos.length; ++i) {
                        OCFCertificateInfo info = infos[i];
                        ResultObject ro = null;
                        session.setProgressMessage(info.getFile() + " (" + info.getChainEntry() + ")");
                        if (this.progressSessionListener != null) {
                            this.progressSessionListener.progressSessionUpdate(session);
                        }
                        try {
                            FileEntry[] attrCertFiles;
                            String certificateFileCacheKey = HexUtil.hexify(info.getDirectory().reference) + HexUtil.hexify(info.getFile().reference);
                            if (!certificateReadCache.containsKey(certificateFileCacheKey)) {
                                ro = this.readCertificate(channel, info);
                            } else {
                                LOG.debug((Object)"using cached certificate");
                                ro = new ResultObject();
                                Object cacheValue = certificateReadCache.get(certificateFileCacheKey);
                                if (Integer.class.isInstance(cacheValue)) {
                                    ro.resultCode = (Integer)Integer.class.cast(cacheValue);
                                    ro.setResultData(null);
                                } else if (byte[].class.isInstance(cacheValue)) {
                                    ro.setResultCode(36864);
                                    ro.setResultData(cacheValue);
                                }
                            }
                            if (ro == null || ro.resultData == null) continue;
                            if (!certificateReadCache.containsKey(certificateFileCacheKey)) {
                                if (ro.resultCode == 36864) {
                                    certificateReadCache.put((CallSite)((Object)certificateFileCacheKey), ro.resultData);
                                } else {
                                    certificateReadCache.put((CallSite)((Object)certificateFileCacheKey), ro.resultCode);
                                }
                            }
                            if (ro.getResultCode() != 36864) {
                                LOG.debug((Object)(HexString.hexify(ro.getResultCode()) + " -> " + APDUCommands.getReadBinaryErrorMsg(ro.getResultCode())));
                                continue;
                            }
                            Certificate c = null;
                            if (this.certLoader != null) {
                                LOG.debug((Object)("creating certificate: " + info.getNameString()));
                                c = this.certLoader.loadCertificate((byte[])ro.resultData);
                            } else {
                                c = APDUCommands.createCertificate((byte[])ro.resultData);
                            }
                            if (c != null) {
                                info.setX509Certificate((X509Certificate)c);
                                this.certificates.add(info);
                                LOG.debug((Object)("actual : " + c.getEncoded().length));
                            }
                            if ((attrCertFiles = infos[i].getAttributeCertificateFileEntries()) == null || attrCertFiles.length <= 0) continue;
                            LOG.debug((Object)("reading attribute certificates: " + attrCertFiles.length));
                            ResultObject tmpRO = null;
                            ArrayList<Certificate> certList = new ArrayList<Certificate>();
                            ArrayList<byte[]> certByteArrayList = new ArrayList<byte[]>();
                            for (int j = 0; j < attrCertFiles.length; ++j) {
                                FileEntry fileEntry = attrCertFiles[j];
                                session.setProgressMessage(fileEntry.getFile() + " (Attribute Certificate " + (j + 1) + " / " + attrCertFiles.length + ")");
                                if (this.progressSessionListener != null) {
                                    this.progressSessionListener.progressSessionUpdate(session);
                                }
                                if ((tmpRO = this.readFile(channel, fileEntry)) == null) continue;
                                if (tmpRO.resultCode != 36864) {
                                    LOG.debug((Object)(HexString.hexify(tmpRO.resultCode) + " -> " + APDUCommands.getReadBinaryErrorMsg(tmpRO.resultCode)));
                                    continue;
                                }
                                certByteArrayList.add((byte[])tmpRO.resultData);
                                c = null;
                                c = this.certLoader != null ? this.certLoader.loadCertificate((byte[])tmpRO.resultData) : APDUCommands.createCertificate((byte[])tmpRO.resultData, true);
                                if (c == null) continue;
                                LOG.debug((Object)("add attribute certificate: " + c.getEncoded().length));
                                certList.add(c);
                            }
                            LOG.debug((Object)("setting attribute certificate: " + certList.size()));
                            Certificate[] certs = certList.toArray(new Certificate[certList.size()]);
                            info.setAttributeCertificates(certs);
                            LOG.debug((Object)("setting attribute certificate byte arrays: " + certByteArrayList.size()));
                            byte[][] certByteArrays = (byte[][])certByteArrayList.toArray((T[])new byte[certByteArrayList.size()][]);
                            info.setAttributeCertificatesByteArrays(certByteArrays);
                            continue;
                        }
                        catch (ResponseCodeException ex) {
                            LOG.debug((Object)("file not found : " + HexString.hexify(info.getDirectory().reference) + " : " + HexString.hexify(info.getFile().reference) + " (" + ex.getLocalizedMessage() + ")"));
                            continue;
                        }
                        catch (Throwable ex) {
                            LOG.debug((Object)"", ex);
                            continue;
                        }
                        finally {
                            session.increaseCurrentStep();
                            if (this.progressSessionListener != null) {
                                this.progressSessionListener.progressSessionUpdate(session);
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    LOG.debug((Object)ex);
                }
                finally {
                    cardChannelManager.destroy();
                    for (int i = session.getCurrentStep(); i < session.getStepCount(); ++i) {
                        session.increaseCurrentStep();
                    }
                    session.setProgressMessage(null);
                    if (this.progressSessionListener != null) {
                        this.progressSessionListener.progressSessionWillStop(session);
                        this.progressSessionListener.progressSessionStopped(session);
                    }
                }
            }
            OCFCertificateInfo[] result = new OCFCertificateInfo[this.certificates.size()];
            this.certificates.toArray(result);
            return result;
        }
    }

    public abstract List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo var1);

    public CardTerminal getCardTerminal() {
        return this.ctReference;
    }

    public String getDisplayName() {
        return "";
    }

    public byte[] getICCSN() throws CardTerminalException, ResponseCodeException {
        byte[] result = Card.NO_ICCSN;
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            channel.setState(null);
            this.selectMasterFile(channel);
            this.selectFile(channel, new FileReference(2, "2f02"));
            CommandAPDU command = this.createReadBinaryCommand(0, 20);
            ResponseAPDU response = channel.sendCommandAPDU(command);
            if ((response.sw() == 36864 || response.sw() == 25218) && response.data() != null && response.data().length > 0) {
                result = response.data();
                byte[] tmp = new byte[result.length - 2];
                System.arraycopy(result, 2, tmp, 0, tmp.length);
                result = tmp;
            }
        }
        catch (InvalidCardChannelException e) {
            throw e;
        }
        finally {
            cardChannelManager.destroy();
        }
        return result;
    }

    public final String getICCSNAsHexString() throws CardTerminalException, ResponseCodeException {
        String result = "";
        byte[] efgdoBytes = this.getICCSN();
        if (efgdoBytes != Card.NO_ICCSN) {
            result = HexString.hexify(efgdoBytes).trim().replaceAll(" ", "");
        }
        return result;
    }

    public String getIndentifier() {
        return new String(this.getHistoricals()) + this.getIssuerConstant();
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return 12;
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        return 6;
    }

    @Override
    public byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return 0;
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_T50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getRandom() {
        byte[] random = null;
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel cardChannel = cardChannelManager.init(this);
            CommandAPDU getRND = this.createGetRandomCommand();
            ResponseAPDU res = cardChannel.sendCommandAPDU(getRND);
            random = res.data();
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
        }
        finally {
            cardChannelManager.destroy();
        }
        return random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getRetryCount(OCFCertificateInfo _info) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        if (!this.checkExecuteRetryCountKeyInitialized(_info)) {
            return -1;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel cardChannel = cardChannelManager.init(this);
            this.selectFile(cardChannel, _info, false);
            int n = this.getRetryCount(cardChannel, _info);
            return n;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            int n = -1;
            return n;
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    protected boolean checkExecuteRetryCountKeyInitialized(OCFCertificateInfo _info) {
        if (_info.getX509Certificate() == null) {
            return false;
        }
        return (!this.isMultiSign() || !OCFProvider.Settings.getInstance().isServerEnvironmentActive()) && (!this.isStapleSign() || !OCFProvider.Settings.getInstance().isStapleSignatureEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getRetryCount(CardPin _pin) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        if (_pin == null) {
            return -1;
        }
        if (OCFProvider.Settings.getInstance().isServerEnvironmentActive() || this.isStapleSign()) {
            return -1;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            this.selectFile(channel, _pin.getParentApplication().getFileEntry(), false);
            int n = this.getRetryCount(channel, _pin);
            return n;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (Throwable ex) {
            LOG.debug((Object)("Unexpected Exception - value of retry counter unknown: " + ex.getMessage()));
            int n = -1;
            return n;
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    public Integer getStapleSignCounter() {
        return null;
    }

    public String getStrongestHashAlgorithmName(OCFCertificateInfo _info) {
        List<String> algorithmNames = this.getAvailableHashAlgorithmNames(_info);
        if (algorithmNames.isEmpty()) {
            return null;
        }
        return algorithmNames.get(algorithmNames.size() - 1);
    }

    public String getTerminalString() {
        return this.createTerminalString(this.getCardChannel());
    }

    public boolean hasPinPad() {
        return this.pinpad;
    }

    public synchronized int initPassword(CardPin _pin, char[] _transportPin, char[] _newPIN) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        return this.changePassword(_pin, _transportPin, _newPIN);
    }

    public synchronized int initPassword(OCFCertificateInfo _info, char[] _transportPin, char[] _newPIN) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException, PinDeactivatedException {
        return this.changePassword(_info, _transportPin, _newPIN);
    }

    public boolean isKeybordAllowed() {
        return this.keybordAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isKeyInitialized(OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException {
        if (!this.checkExecuteRetryCountKeyInitialized(_info)) {
            return true;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            this.selectFile(channel, _info, false);
            boolean bl = this.isKeyInitialized(channel, _info);
            return bl;
        }
        catch (ResponseCodeException ex) {
            throw ex;
        }
        catch (CardTerminalException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isInitialized(CardPin _pin) throws ResponseCodeException, CardTerminalException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            this.selectFile(channel, _pin.getParentApplication().getFileEntry(), false);
            boolean bl = this.isInitialized(channel, _pin);
            return bl;
        }
        catch (ResponseCodeException ex) {
            throw ex;
        }
        catch (CardTerminalException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    public final boolean beginTransaction() {
        return CardTerminalManager.beginTransaction(this.ctReference);
    }

    public final boolean isTransactionStarted() {
        return CardTerminalManager.isTransactionStarted(this.ctReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endTransaction(boolean transactionStarted) {
        CardChannelManager cm = new CardChannelManager();
        try {
            if (transactionStarted && (this.isStapleSign() && OCFProvider.Settings.getInstance().isStapleSignatureEnabled() || this.isMultiSign() && OCFProvider.Settings.getInstance().isServerEnvironmentActive())) {
                CardChannel channel = cm.init(this, false, true);
                if (this.isResetAuthenticationRequired(channel)) {
                    this.resetAuthentication(channel);
                }
                this.resetCard(channel);
                this.reset();
                cm.destroy();
            } else if (transactionStarted) {
                CardChannel channel = cm.init(this, false, true);
                if (this.isResetAuthenticationRequired(channel)) {
                    this.resetAuthentication(channel);
                    this.resetCard(channel);
                    this.reset();
                }
                cm.destroy();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("failed to end transaction normally: " + e.getMessage()), (Throwable)e);
        }
        finally {
            CardTerminalManager.endTransaction(this.ctReference, transactionStarted);
        }
    }

    protected boolean isResetAuthenticationRequired(CardChannel channel) {
        AuthenticationChannelState acs;
        Object channelStateExtraObject;
        Object channelStateObject = channel.getState();
        return channelStateObject instanceof ChannelState && (channelStateExtraObject = ((ChannelState)channelStateObject).getExtra()) instanceof AuthenticationChannelState && (acs = (AuthenticationChannelState)((Object)channelStateExtraObject)).isPasswordVerified();
    }

    protected void resetAuthentication(CardChannel channel) {
        try {
            this.selectMasterFile(channel);
        }
        catch (Exception e) {
            throw new RuntimeException("reset failed: " + e.getMessage(), e);
        }
        finally {
            channel.setState(null);
        }
    }

    public boolean isMultiSign() {
        return false;
    }

    public final boolean isMultiAuthenticate(CardKey key) {
        return key == null ? false : this.isMultiAuthenticate(key.getInfo());
    }

    public boolean isMultiAuthenticate(OCFCertificateInfo info) {
        return false;
    }

    public boolean isStapleSign() {
        return false;
    }

    public ResponseAPDU readRecord(CardChannel _channel, int recordNo) throws InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmdAPDU = new CommandAPDU(HexString.parseHexString("00b2" + HexString.hexify(recordNo) + "0400"));
        ResponseAPDU responseAPDU = _channel.sendCommandAPDU(cmdAPDU);
        return responseAPDU;
    }

    public final boolean isCardPresent() {
        boolean result = false;
        try {
            result = this.ctReference.isCardPresent(this.slotID);
        }
        catch (CardTerminalException e) {
            LOG.debug((Object)"no able check card is present for reset");
            result = false;
        }
        return result;
    }

    public void reset() {
        if (!this.isCardPresent()) {
            return;
        }
        LOG.debug((Object)"no reset implemented");
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            cardChannelManager.init(this);
            this.resetChannelState(cardChannelManager.getCardChannel());
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    public void setCertLoader(CertificateLoader _certLoader) {
        this.certLoader = _certLoader;
    }

    public void setGovCHVDialog(Class _chvDialogClass) {
        this.chvDialogClass = _chvDialogClass;
    }

    public void setHasPinPad(boolean flag) {
        this.pinpad = flag;
    }

    public void setKeyboardAllowed(boolean flag) {
        LOG.info((Object)("changing keyboard allowed: " + flag));
        LOG.info((Object)("before-hasPinPad: " + this.hasPinPad()));
        LOG.info((Object)("before-isKeyBoardAllowed: " + this.isKeybordAllowed()));
        LOG.info((Object)("before-useKeyboard: " + this.useKeyboard()));
        this.keybordAllowed = flag;
        LOG.info((Object)("after-hasPinPad: " + this.hasPinPad()));
        LOG.info((Object)("after-isKeyBoardAllowed: " + this.isKeybordAllowed()));
        LOG.info((Object)("after-useKeyboard: " + this.useKeyboard()));
    }

    public void setParentWindow(Object _parentWindow) {
        this.parentWindow = _parentWindow;
    }

    public synchronized void setProgressSessionListener(ProgressSessionListener _progressSessionListener) {
        this.progressSessionListener = _progressSessionListener;
    }

    @Override
    public synchronized ResultObject signHash(CardKey _key, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        return this.signHash(_key.getInfo(), _hashValue, _pin, _hashAlgorithm, algorithmParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ResultObject signHash(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (this.getAvailableHashAlgorithmNames(_info).indexOf(_hashAlgorithm) < 0) {
            throw new ResponseCodeException(65535, "hash algorithm not supported by card: " + _hashAlgorithm, new NoSuchAlgorithmException("OperationCancelledException"));
        }
        ProgressSession session = new ProgressSession(2);
        session.setStepCount(6);
        session.setProgressMessage("init sign hash operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        CardChannelManager cm = new CardChannelManager();
        try {
            cm.init(this, true, false);
            boolean localTransaction = cm.isTransactionLocallyStarted();
            try {
                this.checkSignCounter(null, localTransaction);
            }
            catch (MaxSignatureCountReachedException e) {
                cm.allocate();
                this.resetCard(cm.getCardChannel());
                throw e;
            }
            ResultObject ro = new ResultObject();
            ro = OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && this.isStapleSign() || OCFProvider.Settings.getInstance().isServerEnvironmentActive() && this.isMultiSign() ? this.signHashServer(_info, _hashValue, _pin, _hashAlgorithm, session, ro, algorithmParameters) : this.signHashClient(_info, _hashValue, _pin, _hashAlgorithm, session, ro, algorithmParameters);
            if (ro.getResultCode() == 36864) {
                try {
                    this.increaseAndCheckSignCounter(null, localTransaction);
                }
                catch (MaxSignatureCountReachedException e) {
                    cm.allocate();
                    this.resetCard(cm.getCardChannel());
                }
            }
            ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cm.destroy();
        }
    }

    public static boolean isStapleSign(GovCS cs) {
        OCFProvider.Settings settings = OCFProvider.Settings.getInstance();
        return cs.isMultiSign() && settings.isStapleSignatureEnabled() && !settings.isServerEnvironmentActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSignCounter(CardChannel cc, boolean locallyTransactionStarted) throws MaxSignatureCountReachedException {
        if (!locallyTransactionStarted && this.isStapleSign()) {
            CardChannelManager cm = new CardChannelManager();
            try {
                ChannelState cs;
                CardChannel ccc = cc;
                if (ccc == null) {
                    ccc = cm.init(this, false, true);
                }
                if ((cs = this.getChannelState(ccc)).getMaximumCountOfSignatures() == null) {
                    Integer max = this.getStapleSignCounter();
                    if (max != null && max > 1) {
                        max = max - 1;
                    }
                    cs.setMaximumCountOfSignatures(max);
                }
                cs.checkCountOfSignatures();
            }
            finally {
                cm.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseAndCheckSignCounter(CardChannel cc, boolean locallyTransactionStarted) throws MaxSignatureCountReachedException {
        if (!locallyTransactionStarted && this.isStapleSign()) {
            CardChannelManager cm = new CardChannelManager();
            try {
                CardChannel ccc = cc;
                if (ccc == null) {
                    ccc = cm.init(this, false, true);
                }
                ChannelState cs = this.getChannelState(ccc);
                cs.increaseAndCheckCountOfSignatures();
            }
            finally {
                cm.destroy();
            }
        }
    }

    @Override
    public String toString() {
        String result = this.getDisplayName() + " " + this.getOSName() + " [";
        CardTerminal ct = this.getCardTerminal();
        if (ct != null) {
            Object ctresult = "ct[";
            ctresult = (String)ctresult + "name=" + ct.getName();
            ctresult = (String)ctresult + ", type=" + ct.getType();
            ctresult = (String)ctresult + ", address=" + ct.getAddress();
            ctresult = (String)ctresult + "]";
            result = result + (String)ctresult;
        }
        result = result + (ct == null ? "" : ",") + "]";
        return result;
    }

    public synchronized int verifyPassword(CardPin _cardPin, char[] _pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, CardTerminalException, OperationCancelledException {
        return this.verifyPassword(_cardPin.getInfos()[0], _pin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int verifyPassword(OCFCertificateInfo _info, char[] _pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, CardTerminalException, OperationCancelledException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            this.selectFile(channel, _info, false);
            int n = this.verifyPassword(channel, _info, _pin);
            return n;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.debug((Object)"", e);
            int n = 0;
            return n;
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmitResult transmit(TransmitParameter parameter) {
        ArrayList<ResponseAPDU> responseList = null;
        Throwable throwable = null;
        boolean transactionStarted = false;
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            transactionStarted = parameter.isBeginTransaction() ? CardTerminalManager.beginTransaction(this.ctReference) : false;
            CardChannel channel = cardChannelManager.init(this);
            this.resetChannelState(channel);
            responseList = new ArrayList<ResponseAPDU>();
            throwable = null;
            for (TransmitCommand c : parameter.getCommandList()) {
                try {
                    ResponseAPDU response = channel.sendCommandAPDU(c.getCommand());
                    List<ResponseAPDU> acceptedResponseList = c.getAcceptedResponseList();
                    if (!CollectionUtil.isNullOrEmpty(acceptedResponseList)) {
                        boolean accepted = false;
                        for (ResponseAPDU r : acceptedResponseList) {
                            if (response.sw() != r.sw()) continue;
                            accepted = true;
                            break;
                        }
                        if (!accepted) {
                            LOG.debug((Object)("not accepted response: " + response));
                            responseList.add(response);
                            throwable = new InternalError("transmission aborted, not accepted response: " + HexUtil.hexify(response.sw()));
                            break;
                        }
                    }
                    responseList.add(response);
                }
                catch (Throwable t) {
                    throwable = t;
                    break;
                }
            }
        }
        finally {
            cardChannelManager.destroy();
            if ((transactionStarted || CardTerminalManager.isTransactionStarted(this.ctReference)) && parameter.isEndTransaction()) {
                CardTerminalManager.endTransaction(this.ctReference, true);
            }
        }
        return new TransmitResult((List<ResponseAPDU>)responseList, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void resetChannelState(CardChannel channel) {
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel cardChannel = cardChannelManager.init(this);
            this.internalResetChannelState(cardChannel);
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    private final void internalResetChannelState(CardChannel channel) {
        if (channel.getState() != null) {
            LOG.debug((Object)"channel state reset");
            ChannelState cs = this.getChannelState(channel);
            if (cs != null) {
                cs.setInfo(null);
                cs.setExtra(null);
                cs.resetCurrentSignCount();
            }
            channel.setState(null);
        }
    }

    @Override
    public char[] getInitPin(OCFCertificateInfo _info) {
        return this.getInitPIN();
    }

    @Override
    public boolean isInitialized(OCFCertificateInfo _info) throws CardTerminalException, ResponseCodeException {
        return this.isKeyInitialized(_info);
    }

    @Override
    public boolean usesNullPin(OCFCertificateInfo _info) {
        return this.usesNullPIN();
    }

    public int getSlotID() {
        return this.slotID;
    }

    @Override
    public final byte getPinID(OCFCertificateInfo _info) {
        return _info.getPinID();
    }

    @Override
    public Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        return null;
    }

    @Override
    public Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        return null;
    }

    public CardContactMode getCardContactMode() {
        return CardContactMode.CONTACT;
    }

    public void postInitializeCard() {
    }

    protected boolean areHistoricalsValid(byte[] historicals) {
        return historicals != null && historicals.length > 0;
    }

    protected static enum AuthenticationChannelState {
        PRE_SELECTION_DONE(false),
        POST_SELECTION_DONE(false),
        PRE_PASSWORD_VERIFIED(false),
        POST_PASSWORD_VERIFIED(true),
        PRE_SECURITY_ENVIRONMENT_PREPARED(true),
        POST_SECURITY_ENVIRONMENT_PREPARED(true),
        AUTHENTICATION(true),
        ERROR(false),
        ERROR_PASSWORD_VERIFIED(true);

        private final boolean passwordVerified;

        private AuthenticationChannelState(boolean passwordVerified) {
            this.passwordVerified = passwordVerified;
        }

        public boolean isPasswordVerified() {
            return this.passwordVerified;
        }

        public static AuthenticationChannelState getErrorState(AuthenticationChannelState currentAuthenticationChannelState) {
            if (currentAuthenticationChannelState == null) {
                return null;
            }
            if (currentAuthenticationChannelState.isPasswordVerified()) {
                return ERROR_PASSWORD_VERIFIED;
            }
            return ERROR;
        }

        public static AuthenticationChannelState getNextState(boolean multiAuthenticateEnabled, AuthenticationChannelState nextAuthenticationChannelState) {
            if (multiAuthenticateEnabled) {
                return nextAuthenticationChannelState;
            }
            return null;
        }
    }

    public static enum CardContactMode {
        CONTACT(false),
        RFID_CONTACTLESS(true);

        private boolean contactless = false;

        public boolean isContactless() {
            return this.contactless;
        }

        private CardContactMode(boolean contactless) {
            this.contactless = contactless;
        }
    }

    public class CardPinOCFCertificateInfo
    extends OCFCertificateInfo {
        private CardPin pin = null;

        public CardPinOCFCertificateInfo(CardPin pin) {
            this.pin = pin;
        }

        @Override
        public byte getPinID() {
            return this.pin.getPinID();
        }
    }

    public static class ResultObject {
        private int resultCode = 36864;
        private Object resultData = null;

        public String toString() {
            return HexString.hexify((byte[])this.resultData, false) + Integer.toHexString(this.resultCode);
        }

        public int getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(int resultCode) {
            this.resultCode = resultCode;
        }

        public Object getResultData() {
            return this.resultData;
        }

        public void setResultData(Object resultData) {
            this.resultData = resultData;
        }
    }
}

