/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.common.ClassUtil;
import de.bos_bremen.common.StringUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.DefaultGovCHVDialog;
import java.util.List;

public final class GovCHVDialogProvider {
    public static final String SYSTEM_PROPERTY_KEY_PIN_GUI_ENABLED = "PIN_GUI_ENABLED";
    public static final boolean DEFAULT_KEY_PIN_GUI_ENABLED = true;
    private Class<? extends GovCHVDialog> dialogClass = DefaultGovCHVDialog.class;
    private static GovCHVDialogProvider SINGLETON = null;
    private boolean pinGuiEnabled = true;

    public final boolean isPinGuiEnabled() {
        return this.pinGuiEnabled;
    }

    public final void setPinGuiEnabled(boolean pinGuiEnabled) {
        this.pinGuiEnabled = pinGuiEnabled;
    }

    private GovCHVDialogProvider() {
        String sysPropPinGuiEnabled = System.getProperty(SYSTEM_PROPERTY_KEY_PIN_GUI_ENABLED);
        if (!StringUtil.isNullOrEmpty(sysPropPinGuiEnabled) && Boolean.FALSE.toString().equals(sysPropPinGuiEnabled.toLowerCase())) {
            this.pinGuiEnabled = false;
        }
    }

    public static synchronized GovCHVDialogProvider getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new GovCHVDialogProvider();
        }
        return SINGLETON;
    }

    public Class<? extends GovCHVDialog> getDialogClass() {
        return this.dialogClass;
    }

    public void setDialogClass(Class<? extends GovCHVDialog> dialogClass) {
        this.dialogClass = dialogClass;
    }

    public void setDialogClass(String dialogClassname) throws IllegalArgumentException {
        if (dialogClassname == null) {
            return;
        }
        try {
            Class<?> c = Class.forName(dialogClassname);
            List<Class<?>> interfaceList = ClassUtil.getAllInterfaces(c);
            if (!interfaceList.contains(GovCHVDialog.class)) {
                throw new IllegalArgumentException("wrong type of class not implementing expected interfaces GovCHVDialog and EnhancedGovCHVDialog specified");
            }
            this.dialogClass = c;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("class not found: " + dialogClassname, e);
        }
    }
}

