/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GDCardHelper {
    private GDCardHelper() {
    }

    public static void analyzeAlg(ResponseAPDU res, Map<String, String> mapAlgorithm, List<String> listAlg, List<String> listAlgSig, List<String> listAlgDest, boolean sig) {
        if (mapAlgorithm == null || mapAlgorithm.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> e : mapAlgorithm.entrySet()) {
            if (ByteUtil.indexOf(res.data(), HexString.parseHexString(e.getKey())) < 0) continue;
            String value = e.getValue();
            if (listAlg != null && !listAlg.contains(value)) {
                listAlg.add(value);
            }
            if (listAlgDest != null && !listAlgDest.contains(value)) {
                listAlgDest.add(value);
            }
            if (listAlgSig == null || !sig || listAlgSig.contains(value)) continue;
            listAlgSig.add(value);
        }
    }

    public static class CheckAlgAnalyzer {
        private static final Log LOG = LogFactory.getLog(CheckAlgAnalyzer.class);
        private final GovCS govCS;
        private final String aid;
        private final Map<String, String> mapAlgSigPKCS1V15;
        private final Map<String, String> mapAlgSigPKCS1PSS;
        private final Map<String, String> mapAlgSigDINSIG;
        private final Map<String, String> mapAlgSigECDSA;
        private final Map<String, String> mapAlgAut;
        private final Map<String, String> mapAlgEnc;
        protected List<String> listAlgs = new ArrayList<String>();
        protected List<String> listAlgSig = new ArrayList<String>();
        protected List<String> listAlgSigPKCS1V15 = new ArrayList<String>();
        protected List<String> listAlgSigPKCS1PSS = new ArrayList<String>();
        protected List<String> listAlgSigDINSIG = new ArrayList<String>();
        protected List<String> listAlgSigECDSA = new ArrayList<String>();
        protected List<String> listAlgAut = new ArrayList<String>();
        protected List<String> listAlgEnc = new ArrayList<String>();
        private AsymmetricKeyIdentifier asymmetricKeyIdentifier;

        public CheckAlgAnalyzer(GovCS govCS, String aid, Map<String, String> mapAlgSigPKCS1V15, Map<String, String> mapAlgSigPKCS1PSS, Map<String, String> mapAlgSigDINSIG, Map<String, String> mapAlgAut, Map<String, String> mapAlgEnc, AsymmetricKeyIdentifier asymmetricKeyIdentifier) {
            this(govCS, aid, mapAlgSigPKCS1V15, mapAlgSigPKCS1PSS, mapAlgSigDINSIG, new HashMap<String, String>(), mapAlgAut, mapAlgEnc, asymmetricKeyIdentifier);
        }

        public CheckAlgAnalyzer(GovCS govCS, String aid, Map<String, String> mapAlgSigPKCS1V15, Map<String, String> mapAlgSigPKCS1PSS, Map<String, String> mapAlgSigDINSIG, Map<String, String> mapAlgSigECDSA, Map<String, String> mapAlgAut, Map<String, String> mapAlgEnc, AsymmetricKeyIdentifier asymmetricKeyIdentifier) {
            this.govCS = govCS;
            this.aid = aid.replaceAll(" ", "");
            this.mapAlgSigPKCS1V15 = mapAlgSigPKCS1V15;
            this.mapAlgSigPKCS1PSS = mapAlgSigPKCS1PSS;
            this.mapAlgSigDINSIG = mapAlgSigDINSIG;
            this.mapAlgSigECDSA = mapAlgSigECDSA;
            this.mapAlgAut = mapAlgAut;
            this.mapAlgEnc = mapAlgEnc;
            this.asymmetricKeyIdentifier = asymmetricKeyIdentifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkAlgSuppport(byte keyRecordNoMin, byte keyRecordNoMax) {
            CardChannelManager cardChannelManager = new CardChannelManager();
            boolean result = true;
            try {
                CardChannel channel = cardChannelManager.init(this.govCS);
                for (int i = keyRecordNoMin; i <= keyRecordNoMax; ++i) {
                    result &= this.checkAlgSuppport(channel, (byte)i, true, i == keyRecordNoMin);
                }
            }
            catch (Exception e) {
                result = false;
            }
            finally {
                if (cardChannelManager.getCardChannel() != null) {
                    try {
                        this.govCS.selectMasterFile(cardChannelManager.getCardChannel());
                    }
                    catch (Exception exception) {}
                    cardChannelManager.destroy();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkAlgSuppport(byte keyRecordNo) {
            CardChannelManager cardChannelManager = new CardChannelManager();
            try {
                CardChannel channel = cardChannelManager.init(this.govCS);
                boolean bl = this.checkAlgSuppport(channel, keyRecordNo, true, true);
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                if (cardChannelManager.getCardChannel() != null) {
                    try {
                        this.govCS.selectMasterFile(cardChannelManager.getCardChannel());
                    }
                    catch (Exception exception) {}
                    cardChannelManager.destroy();
                }
            }
            return false;
        }

        public void dumpAlgorithms() {
            LOG.debug((Object)("PKCS#1 supported: " + !this.listAlgSigPKCS1V15.isEmpty()));
            LOG.debug((Object)("digest algorithms PKCS#1, v1.5: " + this.listAlgSigPKCS1V15));
            LOG.debug((Object)("PKCS#1-PSS supported: " + !this.listAlgSigPKCS1PSS.isEmpty()));
            LOG.debug((Object)("digest algorithms PKCS#1, PSS: " + this.listAlgSigPKCS1PSS));
            LOG.debug((Object)("DINSIG supported: " + !this.listAlgSigDINSIG.isEmpty()));
            LOG.debug((Object)("digest algorithms DINSIG/ISO 9796-2rnd: " + this.listAlgSigDINSIG));
            LOG.debug((Object)("ECDSA supported: " + !this.listAlgSigECDSA.isEmpty()));
            LOG.debug((Object)("digest algorithms ECDSA: " + this.listAlgSigECDSA));
            LOG.debug((Object)("digest algorithms signature: " + this.listAlgSig));
            LOG.debug((Object)("authentication supported: " + !this.listAlgAut.isEmpty()));
            LOG.debug((Object)("digest algorithms authentication: " + this.listAlgAut));
        }

        public boolean checkAlgSuppport(CardChannel channel, byte keyRecordNo, boolean sig, boolean select) {
            try {
                LOG.debug((Object)("analyze key record no #" + HexUtil.hexify(keyRecordNo) + " at #" + this.aid));
                CommandAPDU cmd = null;
                ResponseAPDU res = null;
                if (select) {
                    String cmdSelectHex = "00a4040c" + HexUtil.hexify(this.aid.length() / 2) + this.aid;
                    LOG.debug((Object)("select CMD: " + cmdSelectHex));
                    cmd = new CommandAPDU(HexString.parseHexString(cmdSelectHex));
                    res = channel.sendCommandAPDU(cmd);
                    if (res == null || res.sw() != 36864) {
                        return false;
                    }
                    cmd = new CommandAPDU(HexString.parseHexString("00a4020c020013"));
                    res = channel.sendCommandAPDU(cmd);
                    if (res == null || res.sw() != 36864) {
                        return false;
                    }
                }
                if ((res = channel.sendCommandAPDU(cmd = new CommandAPDU(HexString.parseHexString("00b2" + HexUtil.hexify(keyRecordNo) + "0400")))) == null || res.sw() != 36864) {
                    LOG.debug((Object)"--record failed to read");
                    return false;
                }
                if (res.data() != null) {
                    if (!this.asymmetricKeyIdentifier.isAsymmetricKey(res.data())) {
                        LOG.debug((Object)"skip record related to symmetric key or other informations");
                        return true;
                    }
                    LOG.debug((Object)("record data:\n" + HexUtil.dump(res.data())));
                    if (sig) {
                        GDCardHelper.analyzeAlg(res, this.mapAlgSigDINSIG, this.listAlgs, this.listAlgSig, this.listAlgSigDINSIG, sig);
                        GDCardHelper.analyzeAlg(res, this.mapAlgSigPKCS1V15, this.listAlgs, this.listAlgSig, this.listAlgSigPKCS1V15, sig);
                        GDCardHelper.analyzeAlg(res, this.mapAlgSigPKCS1PSS, this.listAlgs, this.listAlgSig, this.listAlgSigPKCS1PSS, sig);
                        GDCardHelper.analyzeAlg(res, this.mapAlgSigECDSA, this.listAlgs, this.listAlgSig, this.listAlgSigECDSA, sig);
                    }
                    GDCardHelper.analyzeAlg(res, this.mapAlgAut, this.listAlgs, null, this.listAlgAut, false);
                    GDCardHelper.analyzeAlg(res, this.mapAlgEnc, this.listAlgs, null, this.listAlgEnc, false);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public List<String> getListAlgs() {
            return this.listAlgs;
        }

        public List<String> getListAlgSig() {
            return this.listAlgSig;
        }

        public List<String> getListAlgSigPKCS1V15() {
            return this.listAlgSigPKCS1V15;
        }

        public List<String> getListAlgSigPKCS1PSS() {
            return this.listAlgSigPKCS1PSS;
        }

        public List<String> getListAlgSigDINSIG() {
            return this.listAlgSigDINSIG;
        }

        public List<String> getListAlgSigECDSA() {
            return this.listAlgSigECDSA;
        }

        public List<String> getListAlgAut() {
            return this.listAlgAut;
        }

        public List<String> getListAlgEnc() {
            return this.listAlgEnc;
        }
    }

    public static interface AsymmetricKeyIdentifier {
        public boolean isAsymmetricKey(byte[] var1);
    }
}

