/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUConstants;
import opencard.core.util.HexString;

public class FileReference
implements APDUConstants {
    public final byte referenceType;
    public final byte[] reference;

    public FileReference(byte _referenceType, String _reference) {
        if (_reference == null) {
            throw new NullPointerException("the file reference must not be null");
        }
        this.reference = HexString.parseHexString(_reference);
        this.referenceType = _referenceType;
    }

    private static String typeToString(int _type) {
        switch (_type) {
            case 0: {
                return "SELECT_P1_MASTER_FILE";
            }
            case 1: {
                return "SELECT_P1_CHILD_DIRECTORY";
            }
            case 2: {
                return "SELECT_P1_CHILD_FILE";
            }
            case 3: {
                return "SELECT_P1_PARENT_DIRECTORY";
            }
            case 4: {
                return "SELECT_P1_VIA_FILENAME";
            }
            case 8: {
                return "SELECT_P1_VIA_PATH_ABSOLUTE";
            }
            case 9: {
                return "SELECT_P1_VIA_PATH_RELATIVE";
            }
        }
        return "TYPE_UNKNOWN";
    }

    public String toString() {
        return "FileReference[" + FileReference.typeToString(this.referenceType) + ", " + HexString.hexify(this.reference, false) + "]";
    }
}

