/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCSEIDFactory;
import de.bos_bremen.gov2.jca_provider.ocf.cards.base.DefaultEGK;
import de.bos_bremen.gov2.jca_provider.ocf.cards.base.DefaultHBA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50BWPKI42;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50DRV2IDCard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50DRV2MultiSign;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50DTrust31Multicard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50DTrust31Multicard100;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50DTrust31Standard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50DTrust34Multicard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50DTrust34Standard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS50EALight;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS54DTrust41Multicard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS54DTrust41Multicard100;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS54DTrust41Standard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS54DTrust44MulticardSeal;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS54DTrust44StandardSeal;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS60DRV3IDCard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS60DTrust51Multicard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS60DTrust51Multicard100;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS60DTrust51Standard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS60DTrust54Multicard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.cardos.CardOS60DTrust54Standard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epo.EPO;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epo.EPO3;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epo.EPO3_03;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epo.OLDEPO;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.MultiSignBTCQuoVadis;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.MultiSignEIDVQuoVadis;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.MultiSignSuisseIDQuoVadis;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.MultiSignSuisseIDTestSwisscom;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.QuoVadisToken;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseIDPost;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseIDQuoVadis;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseIDSwisscom;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseIDTestPost1;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseIDTestPost2;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseIDTestSwisscom;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.at.ATrustV2Card;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.bg.InfoNotary;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.fi.FinEID21;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.fr.certinomis.Certinomis;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.it.infocert.InfoCert;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gematik.EHBAg2;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gp.JCOP211BNotkBea;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gp.JCOP231BNotkV2GP;
import de.bos_bremen.gov2.jca_provider.ocf.cards.micardo.MICARDOv21r1_DTrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.seccos.SECCOS_HVB;
import de.bos_bremen.gov2.jca_provider.ocf.cards.seccos.STrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.seccos.VR10;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.DTrust2k;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.DTrust2kMS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43BA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43_2;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43_ms;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43b;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.TCTrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.TCTrustUnlimited;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.HBA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30BNotkCARD;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30DGNService;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30SignTrustMCARD;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30SignTrustMCARD100;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30SignTrustStandard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32BNotkCARD;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32DGNService;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32DatevStandard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32SignTrustMCARD;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32SignTrustMCARD100;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS32SignTrustStandard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS34BA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS34DTrust30Advanced;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS34DTrust30Batch;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS34DTrust30MultiCard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS34DTrust30Standard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS34DatevV3;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35BNotKV3Multi;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35BNotKV3Staple;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35DGNBusiness;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35DGNHPCsingle;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35DGNHPCstaple;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35DGNSprint;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35DGNZODHPC;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35SignTrustV3M100;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35SignTrustV3MCARD;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35SignTrustV3Standard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS37DGN40;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS37DGN40Test;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS_ATrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS_TCTrust;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.HessenPKI10NetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.HessenPKI20NetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.HessenPKIBOSNetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.HessenPKINetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.NetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.NetKey30M;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.NiedersachsenDOINetKey30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOS30SC20;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOS30SC20M;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOS30SC20MRFID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOS30SC20RFID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOS30SC30;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOS30SC30M;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOS30SC30MRFID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOS30SC30RFID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_Datev_PKS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_SignTrust_PKS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_TeleSec_NetKey;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_TeleSec_NetKeyE4;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_TeleSec_NetKeyOld;
import de.bos_bremen.gov2.jca_provider.ocf.cards.tcos.TCOSv2r3_TeleSec_PKS;
import de.bos_bremen.java.pcsc.EnhancedJPCSCReaderState;
import de.bos_bremen.jni.pcsc.PCSCReaderState;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DefaultCardServiceFactory
extends CardServiceFactory {
    private static final String SYSTEM_PROPERTY_KEY_TEST_CH = "SYSTEM_PROPERTY_KEY_TEST_CH";
    protected static final Log LOG = LogFactory.getLog(GovCSEIDFactory.class);
    protected final Map<CardType, GovCS> mcardCardServices = new LinkedHashMap<CardType, GovCS>();

    protected DefaultCardServiceFactory() {
        this(true);
    }

    protected DefaultCardServiceFactory(boolean useDefaultCards) {
        if (useDefaultCards) {
            DefaultCardServiceFactory.addDefaultCards(this.mcardCardServices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultCards(Map<CardType, GovCS> mcardCardServices) {
        Map<CardType, GovCS> map = mcardCardServices;
        synchronized (map) {
            if (mcardCardServices.isEmpty()) {
                int n = CardType.UNSUPPORTED.getType() + 1;
                try {
                    GovCS gcs = (GovCS)Class.forName("de.bos_bremen.gov2.jca_provider.ocf.cards.debug.ZCxxZeitControlBasicCardDebug").newInstance();
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, gcs);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOS30SC30());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOS30SC30RFID());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOS30SC30M());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOS30SC30MRFID());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS60DRV3IDCard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS60DTrust51Multicard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS60DTrust51Multicard100());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS60DTrust51Standard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS60DTrust54Multicard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS60DTrust54Standard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new Siemensv43BA());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new EPA());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOSv2r3_TeleSec_PKS());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOSv2r3_Datev_PKS());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOSv2r3_SignTrust_PKS());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOSv2r3_TeleSec_NetKey());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOSv2r3_TeleSec_NetKeyE4());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOSv2r3_TeleSec_NetKeyOld());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOS30SC20());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOS30SC20RFID());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOS30SC20M());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCOS30SC20MRFID());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new MICARDOv21r1_DTrust());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SECCOS_HVB());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new Siemensv43());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new Siemensv43_2());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS_TCTrust());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS_ATrust());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new STrust());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new VR10());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new Siemensv43_ms());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new DTrust2kMS());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new DTrust2k());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS30SignTrustStandard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS30SignTrustMCARD());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS30BNotkCARD());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS30SignTrustMCARD100());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS30DGNService());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS30());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS32SignTrustStandard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS32DatevStandard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS32SignTrustMCARD100());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS32SignTrustMCARD());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS32BNotkCARD());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new NetKey30());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new HessenPKI10NetKey30());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new HessenPKI20NetKey30());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new HessenPKIBOSNetKey30());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new HessenPKINetKey30());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new NiedersachsenDOINetKey30());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new NetKey30M());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new Siemensv43b());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new FinEID21());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCTrustUnlimited());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new TCTrust());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new InfoNotary());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS34BA());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS34DTrust30Standard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS34DTrust30Advanced());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS34DTrust30Batch());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS34DTrust30MultiCard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS34DatevV3());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35SignTrustV3Standard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35SignTrustV3M100());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35SignTrustV3MCARD());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35BNotKV3Staple());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35BNotKV3Multi());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS50DRV2IDCard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS50DRV2MultiSign());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS50DTrust31Standard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS50DTrust31Multicard100());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS50DTrust31Multicard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS50DTrust34Standard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS50DTrust34Multicard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS50BWPKI42());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS50EALight());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS32DGNService());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new HBA());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new DefaultHBA());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new DefaultEGK());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new EPO());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new EPO3());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new EPO3_03());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new OLDEPO());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new ATrustV2Card());
                if (System.getProperty(SYSTEM_PROPERTY_KEY_TEST_CH) != null) {
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SuisseIDTestSwisscom());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new MultiSignSuisseIDTestSwisscom());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SuisseIDQuoVadis());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new QuoVadisToken());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SuisseIDTestPost1());
                } else {
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SuisseIDSwisscom());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SuisseIDQuoVadis());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new MultiSignSuisseIDQuoVadis());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SuisseIDPost());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SuisseIDTestPost1());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SuisseIDTestPost2());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new SuisseIDTestSwisscom());
                    DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new MultiSignSuisseIDTestSwisscom());
                }
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new Certinomis());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new InfoCert());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new MultiSignEIDVQuoVadis());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new MultiSignBTCQuoVadis());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35DGNHPCstaple());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35DGNHPCsingle());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35DGNZODHPC());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35DGNBusiness());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS35DGNSprint());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new JCOP211BNotkBea());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new JCOP231BNotkV2GP());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS54DTrust41Multicard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS54DTrust41Multicard100());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS54DTrust41Standard());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS54DTrust44MulticardSeal());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new CardOS54DTrust44StandardSeal());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS37DGN40());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new StarCOS37DGN40Test());
                DefaultCardServiceFactory.addSingleCard(mcardCardServices, n++, new EHBAg2());
            }
        }
    }

    private static CardType addSingleCard(Map<CardType, GovCS> mcardCardServices, int n, GovCS gcs) {
        CardType ct = new CardType(n);
        ct.setInfo(gcs.toString());
        mcardCardServices.put(ct, gcs);
        return ct;
    }

    @Override
    protected CardType getCardType(CardID _cardId, CardServiceScheduler _scheduler) throws CardTerminalException {
        byte[] historicals = _cardId.getHistoricals();
        char[] atr = new char[Math.max(_cardId.getATR().length, 30) * 3];
        Arrays.fill(atr, ' ');
        String s = HexString.hexify(_cardId.getATR());
        System.arraycopy(s.toCharArray(), 0, atr, 0, s.length());
        LOG.debug((Object)("ATR: " + HexString.hexify(_cardId.getATR()) + " / Historicals: " + HexString.hexify(historicals)));
        LOG.debug((Object)(new String(atr) + "/Historicals: " + HexString.hexify(historicals)));
        CardType result = CardType.UNSUPPORTED;
        String issuer = null;
        for (Map.Entry<CardType, GovCS> entry : this.mcardCardServices.entrySet()) {
            GovCS cardService = entry.getValue();
            CardType cardType = entry.getKey();
            LOG.info((Object)("checking: " + cardService));
            if (!cardService.historicalsEquals(historicals)) continue;
            if (issuer == null || cardService.isIssuerReadRequired()) {
                CardChannel channel = null;
                try {
                    channel = _scheduler.allocateCardChannel(null, true);
                }
                catch (CardTerminalException ex) {
                    LOG.debug((Object)"", (Throwable)ex);
                }
                try {
                    JPCSCCardTerminal pcscCT;
                    PCSCReaderState cardStatus;
                    CardTerminal ct = channel.getCardTerminal();
                    if (ct instanceof JPCSCCardTerminal && (cardStatus = (pcscCT = (JPCSCCardTerminal)ct).getCardStatus(0L)) instanceof EnhancedJPCSCReaderState) {
                        EnhancedJPCSCReaderState enhancedCardStatus = (EnhancedJPCSCReaderState)cardStatus;
                        LOG.debug((Object)("Protocol: T" + (enhancedCardStatus.getProtocolValue() - 1)));
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)"Protocol: detection failed");
                }
                if (channel != null) {
                    issuer = cardService.readIssuerFromATR(channel);
                    if (issuer != null) {
                        String s2 = null;
                        try {
                            s2 = new String(HexUtil.parse(issuer));
                            if (s2.isEmpty()) {
                                s2 = null;
                            } else {
                                boolean printable = Pattern.matches("[0-9a-zA-Z" + Pattern.quote(" ") + Pattern.quote(".") + Pattern.quote(":") + Pattern.quote("-") + Pattern.quote("(") + Pattern.quote(")") + "]*", s2);
                                if (!printable) {
                                    s2 = null;
                                }
                            }
                        }
                        catch (Exception e) {
                            s2 = null;
                        }
                        LOG.debug((Object)(cardService.getClass().getSimpleName() + "-ISSUER: " + issuer + (String)(s2 != null ? "\n(" + s2 + ")" : "")));
                    }
                    try {
                        _scheduler.releaseCardChannel(channel);
                    }
                    catch (InvalidCardChannelException ex) {
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                }
            }
            if (cardService.getIssuerConstant() != null && !cardService.getIssuerConstant().equals(issuer)) continue;
            LOG.debug((Object)("SUPPORTED CARD FOUND: " + cardService.getClass().getSimpleName()));
            result = cardType;
            break;
        }
        if (result == CardType.UNSUPPORTED) {
            LOG.debug((Object)"UNSUPPORTED CARD!!!");
        }
        return result;
    }

    @Override
    protected Enumeration getClasses(CardType _cardType) {
        GovCS o = this.mcardCardServices.get(_cardType);
        return new SingleEnumeration(o == null ? null : o.getClass());
    }

    public static class SingleEnumeration
    implements Enumeration {
        private Object o = null;

        public SingleEnumeration(Object _o) {
            this.o = _o;
        }

        @Override
        public boolean hasMoreElements() {
            return this.o != null;
        }

        public Object nextElement() {
            Object oo = this.o;
            this.o = null;
            return oo;
        }
    }
}

