/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelState {
    private static final Log LOG = LogFactory.getLog(ChannelState.class);
    private OCFCertificateInfo info = null;
    private Object extra = null;
    private Integer maximumCountOfSignatures = null;
    private Integer currentCountOfSignatures = null;

    public final Integer getMaximumCountOfSignatures() {
        return this.maximumCountOfSignatures;
    }

    public final void setMaximumCountOfSignatures(Integer maximumCountOfSignatures) {
        if (OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && !OCFProvider.Settings.getInstance().isServerEnvironmentActive()) {
            this.maximumCountOfSignatures = maximumCountOfSignatures;
        }
    }

    public final void increaseAndCheckCountOfSignatures() throws MaxSignatureCountReachedException {
        if (this.maximumCountOfSignatures != null) {
            this.getCurrentCountOfSignatures();
            this.currentCountOfSignatures = this.currentCountOfSignatures + 1;
            this.checkCountOfSignatures();
        }
    }

    public final void checkCountOfSignatures() throws MaxSignatureCountReachedException {
        if (this.maximumCountOfSignatures != null) {
            this.getCurrentCountOfSignatures();
            if (this.currentCountOfSignatures > this.maximumCountOfSignatures) {
                this.currentCountOfSignatures = 0;
                this.info.setAdditionalMessage("Die maximale Anzahl von Signaturen wurde erreicht.<br/>Bitte PIN f\u00fcr weitere Signaturen erneut eingeben!");
                this.info = null;
                this.extra = null;
                LOG.info((Object)"maximum count of signatures reached: for further signatures PIN must be entered again!");
                throw new MaxSignatureCountReachedException();
            }
        }
    }

    public final Integer getCurrentCountOfSignatures() {
        if (this.maximumCountOfSignatures != null && this.currentCountOfSignatures == null) {
            this.currentCountOfSignatures = 0;
        }
        return this.currentCountOfSignatures;
    }

    public final void resetCurrentSignCount() {
        this.currentCountOfSignatures = null;
    }

    public OCFCertificateInfo getInfo() {
        return this.info;
    }

    public void setInfo(OCFCertificateInfo info) {
        this.info = info;
    }

    public Object getExtra() {
        return this.extra;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }
}

