/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class CardPerformanceSettings {
    private static final String SLASH = "/";
    public static final String FILENAME_PERFOMANCE_SETTINGS = "cardPerformanceSettings.xml";
    public static final List<String> PEFORMANCE_SETTINGS_SEARCH_DIRECTORIES = Collections.unmodifiableList(Arrays.asList(".", System.getProperty("user.home")));
    public static final String BOOLEAN_TRUE = Boolean.TRUE.toString();
    public static final String BOOLEAN_FALSE = Boolean.FALSE.toString();
    public static final boolean DEFAULT_BOOLEAN_VALUE = true;
    private static CardPerformanceSettings SINGLETON = null;
    private Properties properties = new Properties();

    private CardPerformanceSettings() {
        this.loadSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        InputStream is = this.getClass().getResourceAsStream("/cardPerformanceSettings.xml");
        if (is == null) {
            File f = null;
            for (String dir : PEFORMANCE_SETTINGS_SEARCH_DIRECTORIES) {
                f = new File(dir + File.separator + FILENAME_PERFOMANCE_SETTINGS);
                if (!f.exists() || !f.isFile() || !f.canRead()) continue;
                try {
                    is = new FileInputStream(f);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
        }
        if (is != null) {
            try {
                this.properties.loadFromXML(is);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static synchronized CardPerformanceSettings getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new CardPerformanceSettings();
        }
        return SINGLETON;
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, null);
    }

    public boolean getBooleanProperty(String key, String defaultValue) throws IllegalArgumentException {
        if (defaultValue != null && !BOOLEAN_TRUE.equals(defaultValue) && !BOOLEAN_FALSE.equals(defaultValue)) {
            throw new IllegalArgumentException("illegal default value: '" + defaultValue + "', '" + BOOLEAN_TRUE + "' or '" + BOOLEAN_FALSE + "' expected");
        }
        String propertyValue = this.properties.getProperty(key, defaultValue);
        return propertyValue != null ? BOOLEAN_TRUE.equals(propertyValue) : true;
    }
}

