/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;

public class CardChannelManager {
    private GovCS cs = null;
    private CardChannel cardChannel = null;
    private boolean localAllocated = false;
    private boolean localTransactionStarted = false;
    private boolean resetChannelStateOnRelease = true;

    public synchronized CardChannel init(GovCS cs) {
        return this.init(cs, true, true);
    }

    public synchronized CardChannel init(GovCS cs, boolean transaction, boolean allocate) throws InvalidCardChannelException {
        this.cs = cs;
        if (transaction) {
            this.beginTransaction();
        }
        if (allocate) {
            this.allocate();
        }
        return this.cardChannel;
    }

    public final CardChannel getCardChannel() {
        return this.cardChannel;
    }

    public synchronized void allocate() throws InvalidCardChannelException {
        if (this.cs == null) {
            return;
        }
        this.cardChannel = this.cs.getCardChannel();
        if (this.cardChannel == null) {
            this.localAllocated = true;
            try {
                this.cs.allocateCardChannel();
                this.cardChannel = this.cs.getCardChannel();
            }
            catch (InvalidCardChannelException e) {
                this.destroyInt(e);
            }
        }
    }

    private void destroyInt(InvalidCardChannelException e) throws InvalidCardChannelException {
        this.localAllocated = false;
        this.localTransactionStarted = false;
        this.cardChannel = null;
        this.cs = null;
        if (e != null) {
            throw e;
        }
    }

    public synchronized void destroy() throws InvalidCardChannelException {
        this.release(true);
    }

    public synchronized void release() throws InvalidCardChannelException {
        this.release(false);
    }

    public synchronized boolean isResetChannelStateOnRelease() {
        return this.resetChannelStateOnRelease;
    }

    public synchronized void setResetChannelStateOnRelease(boolean resetChannelStateOnRelease) {
        this.resetChannelStateOnRelease = resetChannelStateOnRelease;
    }

    public synchronized void release(boolean destroy) throws InvalidCardChannelException {
        try {
            if (this.cs == null) {
                return;
            }
            try {
                this.endTransactionInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.localAllocated && this.cardChannel != null) {
                try {
                    this.cs.releaseCardChannel(this.resetChannelStateOnRelease);
                }
                catch (InvalidCardChannelException e) {
                    this.destroyInt(e);
                }
            }
        }
        finally {
            if (destroy) {
                this.destroyInt(null);
            }
        }
    }

    public synchronized boolean isTransactionLocallyStarted() {
        return this.localTransactionStarted;
    }

    public synchronized void beginTransaction() {
        if (this.cs == null) {
            return;
        }
        this.beginTransactionInt();
    }

    private void beginTransactionInt() {
        this.localTransactionStarted = this.cs.beginTransaction();
    }

    public synchronized void endTransaction() {
        if (this.cs == null) {
            return;
        }
        this.endTransactionInt();
    }

    private void endTransactionInt() {
        this.cs.endTransaction(this.localTransactionStarted);
    }
}

