/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards;

import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUErrorConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Set;
import opencard.core.terminal.CommandAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class APDUCommands
implements APDUErrorConstants,
APDUConstants {
    private static final Log LOG = LogFactory.getLog(APDUCommands.class);
    private static final ResourceBundle resources = ResourceBundle.getBundle(APDUCommands.class.getName());

    private APDUCommands() {
    }

    public static String getLocalizedErrorMessage(int _errorCode) {
        if ((_errorCode & 0xFFF0) == 25536) {
            int left = _errorCode - 25536;
            String result = resources.getString("APDUCommands.0");
            result = result.replaceFirst("RETRYCOUNT", String.valueOf(left));
            return result;
        }
        switch (_errorCode) {
            case 25985: {
                return resources.getString("APDUCommands.2");
            }
            case 26368: {
                return resources.getString("APDUCommands.3");
            }
            case 27271: {
                return resources.getString("APDUCommands.4");
            }
            case 27010: {
                return resources.getString("APDUCommands.5");
            }
            case 27012: {
                return resources.getString("APDUCommands.6");
            }
            case 27013: {
                return resources.getString("APDUCommands.7");
            }
            case 27014: {
                return resources.getString("APDUCommands.8");
            }
            case 27120: {
                return resources.getString("APDUCommands.9");
            }
            case 27264: {
                return resources.getString("APDUCommands.10");
            }
            case 27266: {
                return resources.getString("APDUCommands.11");
            }
            case 27270: {
                return resources.getString("APDUCommands.12");
            }
            case 26112: {
                return resources.getString("APDUCommands.13");
            }
            case 27015: {
                return resources.getString("APDUCommands.14");
            }
            case 27016: {
                return resources.getString("APDUCommands.15");
            }
            case 27272: {
                return resources.getString("APDUCommands.16");
            }
            case 0: 
            case 25601: {
                return resources.getString("APDUCommands.17");
            }
            case 25602: {
                return resources.getString("APDUCommands.18");
            }
            case 25762: {
                return resources.getString("APDUCommands.19");
            }
            case 27011: {
                return resources.getString("APDUCommands.20");
            }
            case 25218: {
                return resources.getString("APDUCommands.21");
            }
            case 27009: {
                return resources.getString("APDUCommands.22");
            }
            case 27392: {
                return resources.getString("APDUCommands.23");
            }
            case 27267: {
                return resources.getString("APDUCommands.24");
            }
            case 28160: {
                return resources.getString("APDUCommands.40");
            }
            case 27904: {
                return resources.getString("APDUCommands.41");
            }
            case 27136: {
                return resources.getString("APDUCommands.42");
            }
            case 27265: {
                return resources.getString("APDUCommands.43");
            }
            case 25603: 
            case 25604: {
                return resources.getString("APDUCommands.44");
            }
        }
        byte[] buffer = new byte[]{(byte)(_errorCode >> 8 & 0xFF), (byte)(_errorCode & 0xFF)};
        return HexString.hexify(buffer);
    }

    public static String getSelectErrorMsg(int _errorNmbr) {
        return APDUCommands.getLocalizedErrorMessage(_errorNmbr);
    }

    public static String getManageSecurityEnvironmentErrorMsg(int _errorNmbr) {
        return APDUCommands.getLocalizedErrorMessage(_errorNmbr);
    }

    public static String getPerformSecurityOperationErrorMsg(int _errorNmbr) {
        return APDUCommands.getLocalizedErrorMessage(_errorNmbr);
    }

    public static String getVerifyErrorMsg(int errorNmbr) {
        if (27013 == errorNmbr || 25281 == errorNmbr || 25287 == errorNmbr) {
            return resources.getString("APDUCommands.25");
        }
        if (27272 == errorNmbr) {
            return resources.getString("APDUCommands.26");
        }
        return APDUCommands.getLocalizedErrorMessage(errorNmbr);
    }

    public static String getReadBinaryErrorMsg(int _errorNmbr) {
        return APDUCommands.getLocalizedErrorMessage(_errorNmbr);
    }

    public static String getChangePasswordErrorMsg(int errorNmbr) {
        if (27013 == errorNmbr || 25281 == errorNmbr || 25287 == errorNmbr) {
            return resources.getString("APDUCommands.27");
        }
        if (27272 == errorNmbr) {
            return resources.getString("APDUCommands.26");
        }
        if (27264 == errorNmbr) {
            return resources.getString("APDUCommands.28");
        }
        if (25602 == errorNmbr) {
            return resources.getString("APDUCommands.45");
        }
        return APDUCommands.getLocalizedErrorMessage(errorNmbr);
    }

    public static CommandAPDU createSelectCommand(int _selectionType, int _replyType, byte[] _dataField, int _expectedReplySize) {
        if (_replyType != 0 && _replyType != 4 && _replyType != 8 && _replyType != 12) {
            throw new IllegalArgumentException(resources.getString("APDUCommands.35") + _replyType);
        }
        boolean hasData = _dataField != null;
        int dataLength = hasData ? _dataField.length + 1 : 0;
        boolean hasLC = _expectedReplySize != 1024;
        byte[] buffer = new byte[4 + dataLength + (hasLC ? 1 : 0)];
        buffer[0] = 0;
        buffer[1] = -92;
        buffer[2] = (byte)_selectionType;
        buffer[3] = (byte)_replyType;
        if (hasData) {
            buffer[4] = (byte)_dataField.length;
            System.arraycopy(_dataField, 0, buffer, 5, _dataField.length);
        }
        if (hasLC) {
            buffer[buffer.length - 1] = (byte)_expectedReplySize;
        }
        return new CommandAPDU(buffer);
    }

    public static CommandAPDU createMSEforDecryption(byte[] _keyID) {
        int index = 0;
        byte[] data = new byte[5 + _keyID.length];
        data[index++] = -124;
        data[index++] = (byte)_keyID.length;
        System.arraycopy(_keyID, 0, data, 2, _keyID.length);
        index += _keyID.length;
        data[index++] = -128;
        data[index++] = 1;
        data[index] = 16;
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)-63, (byte)-72, data);
    }

    public static CommandAPDU createManageSecurityEnvironmentCommand(byte para1, byte para2, byte[] dataField) {
        byte[] store = new byte[dataField == null ? 4 : dataField.length + 5];
        store[0] = 0;
        store[1] = 34;
        store[2] = para1;
        store[3] = para2;
        if (dataField != null) {
            store[4] = (byte)dataField.length;
            System.arraycopy(dataField, 0, store, 5, dataField.length);
        }
        return new CommandAPDU(store);
    }

    public static CommandAPDU createGetRetryCounterCommand(byte _pinID) {
        byte[] store = new byte[]{0, 32, 0, _pinID};
        return new CommandAPDU(store);
    }

    public static CommandAPDU createReadRecordCommand(int _index) {
        byte[] store = new byte[]{0, -78, (byte)_index, 4, 0};
        return new CommandAPDU(store);
    }

    public static CommandAPDU createReadBinaryCommand(int _offset, int _length) {
        byte[] store = new byte[]{0, -80, (byte)((_offset & 0xFF00) >> 8), (byte)(_offset & 0xFF), (byte)_length};
        return new CommandAPDU(store);
    }

    public static CommandAPDU createChangePasswordCommand_ReinerSCT(String _prompt, byte _pinID) {
        byte[] displayTag = null;
        if (_prompt != null && _prompt.length() > 0) {
            displayTag = new byte[]{80, (byte)_prompt.length()};
        }
        byte[] commandToPerform = new byte[]{82, 7, 1, 6, 0, 0, 36, 0, _pinID};
        int lcByte = (displayTag == null ? 0 : displayTag.length + _prompt.length()) + commandToPerform.length;
        byte[] mktCommand = new byte[]{32, 25, 1, 0, (byte)lcByte};
        CommandAPDU result = new CommandAPDU(mktCommand.length + lcByte);
        result.append(mktCommand);
        if (displayTag != null) {
            result.append(displayTag);
            result.append(_prompt.getBytes());
        }
        result.append(commandToPerform);
        return result;
    }

    public static X509Certificate createCertificate(byte[] _x509data, boolean attributeCertificate) throws CertificateException {
        return APDUCommands.createCertificate(_x509data, true, true);
    }

    public static X509Certificate createCertificate(byte[] _x509data) throws CertificateException {
        return APDUCommands.createCertificate(_x509data, true, false);
    }

    private static X509Certificate createCertificate(final byte[] _x509data, boolean _first, boolean attributeCertificate) throws CertificateException {
        if (attributeCertificate) {
            return new X509Certificate(){

                @Override
                public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
                }

                @Override
                public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
                }

                @Override
                public int getBasicConstraints() {
                    return 0;
                }

                @Override
                public Principal getIssuerDN() {
                    return null;
                }

                @Override
                public boolean[] getIssuerUniqueID() {
                    return null;
                }

                @Override
                public boolean[] getKeyUsage() {
                    return null;
                }

                @Override
                public Date getNotAfter() {
                    return null;
                }

                @Override
                public Date getNotBefore() {
                    return null;
                }

                @Override
                public BigInteger getSerialNumber() {
                    return null;
                }

                @Override
                public String getSigAlgName() {
                    return null;
                }

                @Override
                public String getSigAlgOID() {
                    return null;
                }

                @Override
                public byte[] getSigAlgParams() {
                    return null;
                }

                @Override
                public byte[] getSignature() {
                    return null;
                }

                @Override
                public Principal getSubjectDN() {
                    return null;
                }

                @Override
                public boolean[] getSubjectUniqueID() {
                    return null;
                }

                @Override
                public byte[] getTBSCertificate() throws CertificateEncodingException {
                    return null;
                }

                @Override
                public int getVersion() {
                    return 0;
                }

                @Override
                public byte[] getEncoded() throws CertificateEncodingException {
                    return _x509data;
                }

                @Override
                public PublicKey getPublicKey() {
                    return null;
                }

                @Override
                public String toString() {
                    return "AttributeCertificate:\n" + HexString.dump(_x509data);
                }

                @Override
                public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
                }

                @Override
                public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
                }

                @Override
                public Set<String> getCriticalExtensionOIDs() {
                    return null;
                }

                @Override
                public byte[] getExtensionValue(String oid) {
                    return null;
                }

                @Override
                public Set<String> getNonCriticalExtensionOIDs() {
                    return null;
                }

                @Override
                public boolean hasUnsupportedCriticalExtension() {
                    return false;
                }
            };
        }
        ByteArrayInputStream bais = null;
        CertificateFactory factory = null;
        try {
            bais = new ByteArrayInputStream(_x509data);
            factory = CertificateFactory.getInstance("X509");
            return (X509Certificate)factory.generateCertificate(bais);
        }
        catch (CertificateException certificateException) {
            try {
                bais = new ByteArrayInputStream(_x509data);
                factory = CertificateFactory.getInstance("X509", "BC");
                X509Certificate x509Certificate = (X509Certificate)factory.generateCertificate(bais);
                return x509Certificate;
            }
            catch (CertificateException ex) {
                if (!_first) {
                    LOG.debug((Object)ex.getMessage());
                    throw ex;
                }
                byte[] storage = new byte[_x509data.length - 9];
                System.arraycopy(_x509data, 9, storage, 0, storage.length);
                X509Certificate x509Certificate = APDUCommands.createCertificate(storage, false, false);
                return x509Certificate;
            }
            catch (Throwable ex) {
                LOG.debug((Object)"", ex);
                CertificateException cex = new CertificateException(ex.getMessage());
                cex.setStackTrace(ex.getStackTrace());
                throw cex;
            }
            finally {
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

