/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.asn1.epa;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.ASN1Encoder;
import de.bos_bremen.common.asn1.ASN1Path;
import de.bos_bremen.common.asn1.ASN1PathType;
import de.bos_bremen.common.asn1.AbstractASN1Encoder;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.constants.OIDConstants;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;

public class SecurityInfos
extends AbstractASN1Encoder
implements OIDConstants {
    private List<PACEInfo> paceInfoList = null;
    private List<PACEDomainParameterInfo> paceDomainParameterInfoList = null;
    private List<ChipAuthenticationInfo> chipAuthenticationInfoList = null;
    private List<ChipAuthenticationDomainParameterInfo> chipAuthenticationDomainParameterInfoList = null;
    private List<ChipAuthenticationPublicKeyInfo> chipAuthenticationPublicKeyInfoList = null;
    private List<TerminalAuthenticationInfo> terminalAuthenticationList = null;
    private List<RestrictedIdentificationInfo> restrictedIdentificationInfoList = null;
    private RestrictedIdentificationDomainParameterInfo restrictedIdentificationDomainParameterInfo = null;
    private CardInfoLocator cardInfoLocator = null;
    private EIDSecurityInfo eIDSecurityInfo = null;
    private PrivilegedTerminalInfo privilegedTerminalInfo = null;
    private static final Map<Integer, X9ECParameters> DOMAIN_PARAMETER_MAP = new HashMap<Integer, X9ECParameters>();
    public static final int MIN_DOMAIN_PARAMETER_ID = 8;
    public static final int MAX_DOMAIN_PARAMETER_ID = 18;

    public SecurityInfos() {
    }

    public SecurityInfos(byte[] bytes) throws IOException {
        super(bytes);
    }

    @Override
    public ASN1 getChildElementByPath(ASN1Path part) throws IOException {
        if (!SecurityInfosPath.class.isInstance(part)) {
            throw new IllegalArgumentException("only EFCardAccessPart permitted");
        }
        return super.getChildElementByPath(part);
    }

    public ASN1 getEFCardAccessPart(SecurityInfosPath part) throws IOException {
        return super.getChildElementByPath(part);
    }

    @Override
    public ASN1 decode(ASN1 asn1) {
        if (asn1 == null) {
            return null;
        }
        super.copy(asn1);
        return this;
    }

    @Override
    protected void update() throws IllegalStateException, IllegalArgumentException {
        super.update();
        if (this.paceInfoList == null) {
            try {
                this.paceInfoList = new ArrayList<PACEInfo>();
                this.paceDomainParameterInfoList = new ArrayList<PACEDomainParameterInfo>();
                this.chipAuthenticationInfoList = new ArrayList<ChipAuthenticationInfo>();
                this.chipAuthenticationDomainParameterInfoList = new ArrayList<ChipAuthenticationDomainParameterInfo>();
                this.chipAuthenticationPublicKeyInfoList = new ArrayList<ChipAuthenticationPublicKeyInfo>();
                this.terminalAuthenticationList = new ArrayList<TerminalAuthenticationInfo>();
                this.restrictedIdentificationInfoList = new ArrayList<RestrictedIdentificationInfo>();
                for (ASN1 a : this.getChildElementsByTag(SecurityInfosPath.SECURITY_INFO.getTag())) {
                    OID oid = (OID)a.getChildElementByPath(SecurityInfosPath.SECURITY_INFO_PROTOCOL);
                    if (oid.equals(OID_PACE_DH_GM_3DES_CBC_CBC) || oid.equals(OID_PACE_DH_GM_AES_CBC_CMAC_128) || oid.equals(OID_PACE_DH_GM_AES_CBC_CMAC_192) || oid.equals(OID_PACE_DH_GM_AES_CBC_CMAC_256) || oid.equals(OID_PACE_ECDH_GM_3DES_CBC_CBC) || oid.equals(OID_PACE_ECDH_GM_AES_CBC_CMAC_128) || oid.equals(OID_PACE_ECDH_GM_AES_CBC_CMAC_192) || oid.equals(OID_PACE_ECDH_GM_AES_CBC_CMAC_256) || oid.equals(OID_PACE_DH_IM_3DES_CBC_CBC) || oid.equals(OID_PACE_DH_IM_AES_CBC_CMAC_128) || oid.equals(OID_PACE_DH_IM_AES_CBC_CMAC_192) || oid.equals(OID_PACE_DH_IM_AES_CBC_CMAC_256) || oid.equals(OID_PACE_ECDH_IM_3DES_CBC_CBC) || oid.equals(OID_PACE_ECDH_IM_AES_CBC_CMAC_128) || oid.equals(OID_PACE_ECDH_IM_AES_CBC_CMAC_192) || oid.equals(OID_PACE_ECDH_IM_AES_CBC_CMAC_256)) {
                        this.paceInfoList.add(new PACEInfo(a.getEncoded()));
                        continue;
                    }
                    if (oid.equals(OID_PACE_DH_GM) || oid.equals(OID_PACE_ECDH_GM)) {
                        this.paceDomainParameterInfoList.add(new PACEDomainParameterInfo(a.getEncoded()));
                        continue;
                    }
                    if (oid.equals(OID_CA_DH_3DES_CBC_CBC) || oid.equals(OID_CA_DH_AES_CBC_CMAC_128) || oid.equals(OID_CA_DH_AES_CBC_CMAC_192) || oid.equals(OID_CA_DH_AES_CBC_CMAC_256) || oid.equals(OID_CA_ECDH_3DES_CBC_CBC) || oid.equals(OID_CA_ECDH_AES_CBC_CMAC_128) || oid.equals(OID_CA_ECDH_AES_CBC_CMAC_192) || oid.equals(OID_CA_ECDH_AES_CBC_CMAC_256)) {
                        this.chipAuthenticationInfoList.add(new ChipAuthenticationInfo(a.getEncoded()));
                        continue;
                    }
                    if (oid.equals(OID_CA_DH) || oid.equals(OID_CA_ECDH)) {
                        this.chipAuthenticationDomainParameterInfoList.add(new ChipAuthenticationDomainParameterInfo(a.getEncoded()));
                        continue;
                    }
                    if (oid.equals(OID_PK_DH) || oid.equals(OID_PK_ECDH)) {
                        this.chipAuthenticationPublicKeyInfoList.add(new ChipAuthenticationPublicKeyInfo(a.getEncoded()));
                        continue;
                    }
                    if (oid.equals(OID_TA)) {
                        this.terminalAuthenticationList.add(new TerminalAuthenticationInfo(a.getEncoded()));
                        continue;
                    }
                    if (oid.equals(OID_RI_DH_SHA_1) || oid.equals(OID_RI_DH_SHA_224) || oid.equals(OID_RI_DH_SHA_256) || oid.equals(OID_RI_ECDH_SHA_1) || oid.equals(OID_RI_ECDH_SHA_224) || oid.equals(OID_RI_ECDH_SHA_256)) {
                        this.restrictedIdentificationInfoList.add(new RestrictedIdentificationInfo(a.getEncoded()));
                        continue;
                    }
                    if (oid.equals(OID_RI_DH) || oid.equals(OID_RI_ECDH)) {
                        this.restrictedIdentificationDomainParameterInfo = new RestrictedIdentificationDomainParameterInfo(a.getEncoded());
                        continue;
                    }
                    if (oid.equals(OID_CIL)) {
                        if (this.cardInfoLocator == null) {
                            this.cardInfoLocator = new CardInfoLocator(a.getEncoded());
                            continue;
                        }
                        throw new IllegalArgumentException("incorrect ASN.1 object");
                    }
                    if (oid.equals(OID_ESI)) {
                        this.eIDSecurityInfo = new EIDSecurityInfo(a.getEncoded());
                        continue;
                    }
                    if (!oid.equals(OID_PTI)) continue;
                    this.privilegedTerminalInfo = new PrivilegedTerminalInfo(a.getEncoded());
                }
            }
            catch (IOException e) {
                this.paceInfoList = null;
                this.paceDomainParameterInfoList = null;
                this.chipAuthenticationInfoList = null;
                this.chipAuthenticationDomainParameterInfoList = null;
                this.chipAuthenticationPublicKeyInfoList = null;
                this.terminalAuthenticationList = null;
                this.restrictedIdentificationInfoList = null;
                throw new IllegalArgumentException("incompatible ASN.1 object");
            }
        }
    }

    public List<PACEInfo> getPACEInfo() {
        return this.paceInfoList;
    }

    public List<PACEDomainParameterInfo> getPACEDomainParameterInfo() {
        return this.paceDomainParameterInfoList;
    }

    public List<ChipAuthenticationInfo> getChipAuthenticationInfo() {
        return this.chipAuthenticationInfoList;
    }

    public List<ChipAuthenticationDomainParameterInfo> getChipAuthenticationDomainParameterInfo() {
        return this.chipAuthenticationDomainParameterInfoList;
    }

    public List<ChipAuthenticationPublicKeyInfo> getChipAuthenticationPublicKeyInfo() {
        return this.chipAuthenticationPublicKeyInfoList;
    }

    public List<TerminalAuthenticationInfo> getTerminalAuthenticationInfo() {
        return this.terminalAuthenticationList;
    }

    public List<RestrictedIdentificationInfo> getRestrictedIdentificationInfo() {
        return this.restrictedIdentificationInfoList;
    }

    public RestrictedIdentificationDomainParameterInfo getRestrictedIdentificationDomainParameterInfo() {
        return this.restrictedIdentificationDomainParameterInfo;
    }

    public CardInfoLocator getCardInfoLocator() {
        return this.cardInfoLocator;
    }

    public EIDSecurityInfo getEIDSecurityInfo() {
        return this.eIDSecurityInfo;
    }

    public PrivilegedTerminalInfo getPrivilegedTerminalInfo() {
        return this.privilegedTerminalInfo;
    }

    public static Map<Integer, X9ECParameters> getDomainParameterMap() {
        return Collections.unmodifiableMap(DOMAIN_PARAMETER_MAP);
    }

    static {
        DOMAIN_PARAMETER_MAP.put(8, SECNamedCurves.getByName((String)"secp192r1"));
        DOMAIN_PARAMETER_MAP.put(9, TeleTrusTNamedCurves.getByName((String)"brainpoolp192r1"));
        DOMAIN_PARAMETER_MAP.put(10, SECNamedCurves.getByName((String)"secp224r1"));
        DOMAIN_PARAMETER_MAP.put(11, TeleTrusTNamedCurves.getByName((String)"brainpoolp224r1"));
        DOMAIN_PARAMETER_MAP.put(12, SECNamedCurves.getByName((String)"secp256r1"));
        DOMAIN_PARAMETER_MAP.put(13, TeleTrusTNamedCurves.getByName((String)"brainpoolp256r1"));
        DOMAIN_PARAMETER_MAP.put(14, TeleTrusTNamedCurves.getByName((String)"brainpoolp320r1"));
        DOMAIN_PARAMETER_MAP.put(15, SECNamedCurves.getByName((String)"secp384r1"));
        DOMAIN_PARAMETER_MAP.put(16, TeleTrusTNamedCurves.getByName((String)"brainpoolp384r1"));
        DOMAIN_PARAMETER_MAP.put(17, TeleTrusTNamedCurves.getByName((String)"brainpoolp512r1"));
        DOMAIN_PARAMETER_MAP.put(18, SECNamedCurves.getByName((String)"secp521r1"));
    }

    public static class SecurityInfosPath
    extends ASN1Path {
        public static final SecurityInfosPath EF_CARD_ACCESS = new SecurityInfosPath("EF_CARD_ACCESS", "31", 0, null, SecurityInfos.class);
        static final SecurityInfosPath SECURITY_INFO = new SecurityInfosPath("SECURITY_INFO", "30", 0, null);
        public static final SecurityInfosPath SECURITY_INFO_PROTOCOL = new SecurityInfosPath("SECURITY_INFO_PROTOCOL", "06", 0, (ASN1Path)SECURITY_INFO, OID.class);
        public static final SecurityInfosPath TERMINAL_AUTHENTICATION_INFO = new SecurityInfosPath("TERMINAL_AUTHENTICATION_INFO", "30", 0, null);
        public static final SecurityInfosPath TERMINAL_AUTHENTICATION_INFO_VERSION = new SecurityInfosPath("TERMINAL_AUTHENTICATION_INFO_VERSION", "02", 0, (ASN1Path)TERMINAL_AUTHENTICATION_INFO);
        public static final SecurityInfosPath TERMINAL_AUTHENTICATION_INFO_EFCVCA = new SecurityInfosPath("TERMINAL_AUTHENTICATION_INFO_EFCVCA", "02", 1, (ASN1Path)TERMINAL_AUTHENTICATION_INFO);
        public static final SecurityInfosPath CHIP_AUTHENTICATION_INFO = new SecurityInfosPath("CHIP_AUTHENTICATION_INFO", "30", 0, null);
        public static final SecurityInfosPath CHIP_AUTHENTICATION_INFO_VERSION = new SecurityInfosPath("CHIP_AUTHENTICATION_INFO_VERSION", "02", 0, (ASN1Path)CHIP_AUTHENTICATION_INFO);
        public static final SecurityInfosPath CHIP_AUTHENTICATION_INFO_KEY_ID = new SecurityInfosPath("CHIP_AUTHENTICATION_KEY_ID", "02", 1, (ASN1Path)CHIP_AUTHENTICATION_INFO);
        private static final SecurityInfosPath PACE_INFO = new SecurityInfosPath("PACE_INFO", "30", 0, null);
        public static final SecurityInfosPath PACE_INFO_VERSION = new SecurityInfosPath("PACE_INFO_VERSION", "02", 0, (ASN1Path)PACE_INFO);
        public static final SecurityInfosPath PACE_INFO_PARAMETER_ID = new SecurityInfosPath("PACE_INFO_PARAMETER_ID", "02", 1, (ASN1Path)PACE_INFO);
        private static final SecurityInfosPath PRIVILEGED_TERMINAL_INFO = new SecurityInfosPath("PRIVILEGED_TERMINAL_INFO", "30", 0, null);
        public static final SecurityInfosPath PRIVILEGED_TERMINAL_INFO_PT_INFOS = new SecurityInfosPath("PRIVILEGED_TERMINAL_INFO_PT_INFOS", "31", 0, (ASN1Path)PRIVILEGED_TERMINAL_INFO);
        private static final SecurityInfosPath CARD_INFO_LOCATOR = new SecurityInfosPath("CARD_INFO_LOCATOR", "30", 0, null);
        public static final SecurityInfosPath CARD_INFO_LOCATOR_URL = new SecurityInfosPath("CARD_INFO_LOCATOR_URL", "16", 0, (ASN1Path)CARD_INFO_LOCATOR);
        public static final SecurityInfosPath CARD_INFO_LOCATOR_EFCARDINFO = new SecurityInfosPath("CARD_INFO_LOCATOR_EFCARDINFO", "30", 0, (ASN1Path)CARD_INFO_LOCATOR);
        private static final SecurityInfosPath CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO = new SecurityInfosPath("CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO", "30", 0, null);
        public static final SecurityInfosPath CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO_DOMAIN_PARAMETER = new SecurityInfosPath("CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO_DOMAIN_PARAMETER", "30", 0, (ASN1Path)CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO);
        public static final SecurityInfosPath CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO_KEY_ID = new SecurityInfosPath("CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO_KEY_ID", "02", 0, (ASN1Path)CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO);
        private static final SecurityInfosPath PACE_DOMAIN_PARAMETER_INFO = new SecurityInfosPath("PACE_DOMAIN_PARAMETER_INFO", "30", 0, null);
        public static final SecurityInfosPath PACE_DOMAIN_PARAMETER_INFO_DOMAIN_PARAMETER = new SecurityInfosPath("PACE_DOMAIN_PARAMETER_INFO_DOMAIN_PARAMETER", "30", 0, (ASN1Path)PACE_DOMAIN_PARAMETER_INFO);
        public static final SecurityInfosPath PACE_DOMAIN_PARAMETER_INFO_PARAMETER_ID = new SecurityInfosPath("PACE_DOMAIN_PARAMETER_INFO_PARAMETER_ID", "02", 0, (ASN1Path)PACE_DOMAIN_PARAMETER_INFO);
        private static final SecurityInfosPath CHIP_AUTHENTICATION_PUBLIC_KEY_INFO = new SecurityInfosPath("CHIP_AUTHENTICATION_PUBLIC_KEY_INFO", "30", 0, null);
        public static final SecurityInfosPath CHIP_AUTHENTICATION_PUBLIC_KEY_INFO_CHIP_AUTHENTICATION_PUBLIC_KEY = new SecurityInfosPath("CHIP_AUTHENTICATION_PUBLIC_KEY_INFO_PUBLIC KEY", "30", 0, (ASN1Path)CHIP_AUTHENTICATION_PUBLIC_KEY_INFO);
        public static final SecurityInfosPath CHIP_AUTHENTICATION_PUBLIC_KEY_INFO_KEY_ID = new SecurityInfosPath("CHIP_AUTHENTICATION_PUBLIC_KEY_INFO_KEY_ID", "02", 0, (ASN1Path)CHIP_AUTHENTICATION_PUBLIC_KEY_INFO);
        private static final SecurityInfosPath SUBJECT_PUBLIC_KEY_INFO = new SecurityInfosPath("SUBJECT_PUBLIC_KEY_INFO", "30", 0, null);
        public static final SecurityInfosPath SUBJECT_PUBLIC_KEY_INFO_ALGORITHM = new SecurityInfosPath("SUBJECT_PUBLIC_KEY_INFO_ALGORITHM", "30", 0, (ASN1Path)SUBJECT_PUBLIC_KEY_INFO);
        public static final SecurityInfosPath SUBJECT_PUBLIC_KEY_INFO_SUBJECT_PUBLIC_KEY = new SecurityInfosPath("SUBJECT_PUBLIC_KEY_INFO_SUBJECT_PUBLIC KEY", "03", 0, (ASN1Path)SUBJECT_PUBLIC_KEY_INFO);
        private static final SecurityInfosPath ALGORITHM_IDENTIFIER = new SecurityInfosPath("ALGORITHM_IDENTIFIER", "30", 0, null);
        public static final SecurityInfosPath ALGORITHM_IDENTIFIER_ALGORITHM = new SecurityInfosPath("ALGORITHM_IDENTIFIER_ALGORITHM", "06", 0, (ASN1Path)ALGORITHM_IDENTIFIER);
        public static final SecurityInfosPath ALGORITHM_IDENTIFIER_PARAMETERS = new SecurityInfosPath("ALGORITHM_IDENTIFIER_PARAMETERS", "30", 0, (ASN1Path)ALGORITHM_IDENTIFIER);
        public static final SecurityInfosPath ALGORITHM_IDENTIFIER_PARAMETER_ID = new SecurityInfosPath("ALGORITHM_IDENTIFIER_PARAMETER_ID", "02", 0, (ASN1Path)ALGORITHM_IDENTIFIER);
        private static final SecurityInfosPath RESTRICTED_IDENTIFICATION_INFO = new SecurityInfosPath("RESTRICTED_IDENTIFICATION_INFO", "30", 0, null);
        public static final SecurityInfosPath RESTRICTED_IDENTIFICATION_INFO_PARAMS = new SecurityInfosPath("RESTRICTED_IDENTIFICATION_INFO_PARAMS", "30", 0, (ASN1Path)RESTRICTED_IDENTIFICATION_INFO);
        public static final SecurityInfosPath RESTRICTED_IDENTIFICATION_INFO_MAXKEYLEN = new SecurityInfosPath("RESTRICTED_IDENTIFICATION_INFO_MAXKEYLEN", "02", 0, (ASN1Path)RESTRICTED_IDENTIFICATION_INFO);
        private static final SecurityInfosPath RESTRICTED_IDENTIFICATION_DOMAIN_PARAMETER_INFO = new SecurityInfosPath("RESTRICTED_IDENTIFICATION_DOMAIN_PARAMETER_INFO", "30", 0, null);
        public static final SecurityInfosPath RESTRICTED_IDENTIFICATION_DOMAIN_PARAMETER_INFO_DOMAIN_PARAMETER = new SecurityInfosPath("RESTRICTED_IDENTIFICATION_DOMAIN_PARAMETER_INFO_DOMAIN_PARAMETER", "30", 0, (ASN1Path)RESTRICTED_IDENTIFICATION_DOMAIN_PARAMETER_INFO);
        private static final SecurityInfosPath PROTOCOL_PARAMS = new SecurityInfosPath("PROTOCOL_PARAMS", "30", 0, null);
        public static final SecurityInfosPath PROTOCOL_PARAMS_VERSION = new SecurityInfosPath("PROTOCOL_PARAMS_VERSION", "02", 0, (ASN1Path)PROTOCOL_PARAMS);
        public static final SecurityInfosPath PROTOCOL_PARAMS_KEYID = new SecurityInfosPath("PROTOCOL_PARAMS_KEYID", "02", 1, (ASN1Path)PROTOCOL_PARAMS);
        public static final SecurityInfosPath PROTOCOL_PARAMS_AUTHORIZEDONLY = new SecurityInfosPath("PROTOCOL_PARAMS_AUTHORIZEDONLY", "01", 0, (ASN1Path)PROTOCOL_PARAMS);
        public static final SecurityInfosPath EID_SECURITY_INFO = new SecurityInfosPath("EID_SECURITY_INFO", "30", 0, null);
        public static final SecurityInfosPath EID_SECURITY_INFO_OBJECT = new SecurityInfosPath("EID_SECURITY_INFO_OBJECT", "30", 0, (ASN1Path)EID_SECURITY_INFO);
        public static final SecurityInfosPath EID_SECURITY_INFO_OBJECT_HASH_ALG = new SecurityInfosPath("EID_SECURITY_INFO_OBJECT_HASH_ALG", "30", 0, (ASN1Path)EID_SECURITY_INFO_OBJECT);
        public static final SecurityInfosPath EID_SECURITY_INFO_OBJECT_HASH_VALUES = new SecurityInfosPath("EID_SECURITY_INFO_OBJECT_HASH_VALUES", "30", 1, (ASN1Path)EID_SECURITY_INFO_OBJECT);
        public static final SecurityInfosPath EID_SECURITY_INFO_VERSION = new SecurityInfosPath("EID_SECURITY_INFO_VERSION", "30", 1, (ASN1Path)EID_SECURITY_INFO);
        public static final SecurityInfosPath EID_SECURITY_INFO_VERSION_EID = new SecurityInfosPath("EID_SECURITY_INFO_VERSION_EID", "13", 0, (ASN1Path)EID_SECURITY_INFO_VERSION);
        public static final SecurityInfosPath EID_SECURITY_INFO_VERSION_UNICODE = new SecurityInfosPath("EID_SECURITY_INFO_VERSION_UNICODE", "13", 1, (ASN1Path)EID_SECURITY_INFO_VERSION);
        public static final SecurityInfosPath DATA_GROUP_HASH = new SecurityInfosPath("DATA_GROUP_HASH", "30", 0, null);
        public static final SecurityInfosPath DATA_GROUP_HASH_NUMBER = new SecurityInfosPath("DATA_GROUP_HASH_NUMBER", "02", 0, (ASN1Path)DATA_GROUP_HASH);
        public static final SecurityInfosPath DATA_GROUP_HASH_VALUE = new SecurityInfosPath("DATA_GROUP_HASH_VALUE", "04", 0, (ASN1Path)DATA_GROUP_HASH);

        public SecurityInfosPath(String name, String tagByteString, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass) throws IllegalArgumentException {
            super(name, tagByteString, index, parent, encoderClass);
        }

        public SecurityInfosPath(String name, BigInteger tag, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass) throws IllegalArgumentException {
            super(name, tag, index, parent, encoderClass, ASN1PathType.NO_INFORMATION);
        }

        public SecurityInfosPath(String name, BigInteger tag, int index, ASN1Path parent) {
            super(name, tag, index, parent);
        }

        public SecurityInfosPath(String name, byte[] tagBytes, int index, ASN1Path parent, Class<? extends ASN1Encoder> encoderClass) throws IllegalArgumentException {
            super(name, tagBytes, index, parent, encoderClass);
        }

        public SecurityInfosPath(String name, byte[] tagBytes, int index, ASN1Path parent) {
            super(name, tagBytes, index, parent);
        }

        public SecurityInfosPath(String name, String tagByteString, int index, ASN1Path parent) {
            super(name, tagByteString, index, parent);
        }
    }

    public class CardInfoLocator
    extends SecurityInfo {
        public CardInfoLocator(byte[] bytes) throws IOException {
            super(bytes);
        }

        public ASN1 getURL() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.CARD_INFO_LOCATOR_URL);
        }

        public ASN1 getEFCardInfo() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.CARD_INFO_LOCATOR_EFCARDINFO);
        }

        @Override
        public String toString() {
            Object result = "CardInfoLocator: ";
            ASN1 efCardInfo = null;
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + "\n-- url " + HexUtil.hexify(this.getURL().getValue());
                efCardInfo = this.getEFCardInfo();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + "\n-- maxKeyLen " + (efCardInfo != null ? HexUtil.hexify(efCardInfo.getValue()) : "not given");
            return result;
        }
    }

    public class PrivilegedTerminalInfo
    extends SecurityInfo {
        private SecurityInfos privilegedTerminalInfos;

        public PrivilegedTerminalInfo(byte[] bytes) throws IOException {
            super(bytes);
            this.privilegedTerminalInfos = null;
            byte[] innerInfos = super.getChildElementByPath(SecurityInfosPath.PRIVILEGED_TERMINAL_INFO_PT_INFOS).getEncoded();
            SecurityInfos result = new SecurityInfos(innerInfos);
            this.privilegedTerminalInfos = (SecurityInfos)result.decode(result);
        }

        public SecurityInfos getPrivilegedTerminalInfos() {
            return this.privilegedTerminalInfos;
        }

        @Override
        public String toString() {
            Object result = "PrivilegedTerminalInfo: ";
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + "\n-- privilegedTerminalInfos " + this.getPrivilegedTerminalInfos();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            return result;
        }
    }

    public class EIDVersionInfo
    extends ASN1 {
        public EIDVersionInfo(byte[] bytes) throws IOException {
            super(bytes);
        }

        public ASN1 getEIDVersion() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.EID_SECURITY_INFO_VERSION_EID);
        }

        public ASN1 getUnicodeVersion() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.EID_SECURITY_INFO_VERSION_UNICODE);
        }

        @Override
        public String toString() {
            Object result = "\n-- EIDVersionInfo: ";
            try {
                result = (String)result + "\n---- eIDVersion " + HexUtil.hexify(this.getEIDVersion().getValue());
                result = (String)result + "\n---- unicodeVersion " + HexUtil.hexify(this.getUnicodeVersion().getValue());
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            return result;
        }
    }

    public class DataGroupHash
    extends ASN1 {
        public DataGroupHash(byte[] bytes) throws IOException {
            super(bytes);
        }

        public ASN1 getDataGroupNumber() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.DATA_GROUP_HASH_NUMBER);
        }

        public ASN1 getDataGroupHashValue() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.DATA_GROUP_HASH_VALUE);
        }

        @Override
        public String toString() {
            Object result = "\n---- dataGroupHash: ";
            try {
                result = (String)result + "\n------ dataGroupNumber " + HexUtil.hexify(this.getDataGroupNumber().getValue());
                result = (String)result + "\n------ dataGroupHashValue " + HexUtil.hexify(this.getDataGroupHashValue().getValue());
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            return result;
        }
    }

    public class EIDSecurityObject
    extends ASN1 {
        private AlgorithmIdentifier hashAlgorithm;
        private List<DataGroupHash> dataGroupHashValues;

        public EIDSecurityObject(byte[] bytes) throws IOException {
            super(bytes);
            this.hashAlgorithm = null;
            this.dataGroupHashValues = null;
        }

        public AlgorithmIdentifier getHashAlgorithm() throws IOException {
            if (this.hashAlgorithm == null) {
                this.hashAlgorithm = new AlgorithmIdentifier(super.getChildElementByPath(SecurityInfosPath.EID_SECURITY_INFO_OBJECT_HASH_ALG).getEncoded());
            }
            return this.hashAlgorithm;
        }

        public List<DataGroupHash> getDataGroupHashValues() throws IOException {
            if (this.dataGroupHashValues == null) {
                this.dataGroupHashValues = new ArrayList<DataGroupHash>();
                ASN1 sequence = new ASN1(super.getChildElementByPath(SecurityInfosPath.EID_SECURITY_INFO_OBJECT_HASH_VALUES));
                for (ASN1 child : sequence.getChildElements()) {
                    this.dataGroupHashValues.add(new DataGroupHash(child.getEncoded()));
                }
            }
            return this.dataGroupHashValues;
        }

        @Override
        public String toString() {
            Object result = "\n-- EIDSecurityObject: ";
            try {
                result = (String)result + "\n---- hashAlgorithm " + HexUtil.hexify(this.getHashAlgorithm().getValue());
                for (DataGroupHash hash : this.getDataGroupHashValues()) {
                    result = (String)result + hash;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            return result;
        }
    }

    public class EIDSecurityInfo
    extends SecurityInfo {
        private EIDSecurityObject eidSecurityObject;
        private EIDVersionInfo eidVersionInfo;

        public EIDSecurityInfo(byte[] bytes) throws IOException {
            super(bytes);
            this.eidSecurityObject = null;
            this.eidVersionInfo = null;
        }

        public EIDSecurityObject getEIDSecurityObject() throws IOException {
            if (this.eidSecurityObject == null) {
                this.eidSecurityObject = new EIDSecurityObject(super.getChildElementByPath(SecurityInfosPath.EID_SECURITY_INFO_OBJECT).getEncoded());
            }
            return this.eidSecurityObject;
        }

        public EIDVersionInfo getEIDVersionInfo() throws IOException {
            if (this.eidVersionInfo == null) {
                this.eidVersionInfo = new EIDVersionInfo(super.getChildElementByPath(SecurityInfosPath.EID_SECURITY_INFO_VERSION).getEncoded());
            }
            return this.eidVersionInfo;
        }

        @Override
        public String toString() {
            Object result = "eIDSecurityInfo: ";
            EIDVersionInfo versionInfo = null;
            try {
                result = (String)result + this.getEIDSecurityObject();
                versionInfo = this.getEIDVersionInfo();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + (versionInfo != null ? versionInfo : "");
            return result;
        }
    }

    public class ProtocolParams
    extends ASN1 {
        public ProtocolParams(byte[] bytes) throws IOException {
            super(bytes);
        }

        public ASN1 getVersion() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.PROTOCOL_PARAMS_VERSION);
        }

        public ASN1 getKeyID() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.PROTOCOL_PARAMS_KEYID);
        }

        public ASN1 getAuthorizedOnly() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.PROTOCOL_PARAMS_AUTHORIZEDONLY);
        }

        @Override
        public String toString() {
            Object result = "\n-- ProtocolParams: ";
            try {
                result = (String)result + "\n---- version " + HexUtil.hexify(this.getVersion().getValue());
                result = (String)result + "\n---- keyID " + HexUtil.hexify(this.getKeyID().getValue());
                result = (String)result + "\n---- authorizedOnly " + HexUtil.hexify(this.getAuthorizedOnly().getValue());
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            return result;
        }
    }

    public class RestrictedIdentificationInfo
    extends SecurityInfo {
        private ProtocolParams params;

        public RestrictedIdentificationInfo(byte[] bytes) throws IOException {
            super(bytes);
            this.params = null;
        }

        public ASN1 getMaxKeyLen() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.RESTRICTED_IDENTIFICATION_INFO_MAXKEYLEN);
        }

        public ProtocolParams getParams() throws IOException {
            if (this.params == null) {
                this.params = new ProtocolParams(super.getChildElementByPath(SecurityInfosPath.RESTRICTED_IDENTIFICATION_INFO_PARAMS).getEncoded());
            }
            return this.params;
        }

        @Override
        public String toString() {
            Object result = "RestrictedIdentificationInfo: ";
            ASN1 maxKeyLen = null;
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + this.getParams();
                maxKeyLen = this.getMaxKeyLen();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + "\n-- maxKeyLen " + (maxKeyLen != null ? HexUtil.hexify(maxKeyLen.getValue()) : "not given");
            return result;
        }
    }

    public class TerminalAuthenticationInfo
    extends SecurityInfo {
        public TerminalAuthenticationInfo(byte[] bytes) throws IOException {
            super(bytes);
        }

        public ASN1 getVersion() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.TERMINAL_AUTHENTICATION_INFO_VERSION);
        }

        public ASN1 getEFCVCA() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.TERMINAL_AUTHENTICATION_INFO_EFCVCA);
        }

        @Override
        public String toString() {
            Object result = "TerminalAuthenticationInfo: ";
            ASN1 efCVCA = null;
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + "\n-- version " + HexUtil.hexify(this.getVersion().getValue());
                efCVCA = this.getEFCVCA();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + "\n-- efCVCA " + (efCVCA != null ? HexUtil.hexify(efCVCA.getValue()) : "not given");
            return result;
        }
    }

    public class ChipAuthenticationDomainParameterInfo
    extends DomainParameterInfo {
        public ChipAuthenticationDomainParameterInfo(byte[] bytes) throws IOException {
            super(bytes);
        }

        @Override
        public AlgorithmIdentifier getDomainParameter() throws IOException {
            if (this.domainParameter == null) {
                this.domainParameter = new AlgorithmIdentifier(super.getChildElementByPath(SecurityInfosPath.CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO_DOMAIN_PARAMETER).getEncoded());
            }
            return this.domainParameter;
        }

        public ASN1 getKeyID() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.CHIP_AUTHENTICATION_DOMAIN_PARAMETER_INFO_KEY_ID);
        }

        @Override
        public String toString() {
            Object result = "ChipAuthenticationDomainParameterInfo: ";
            ASN1 keyID = null;
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + this.getDomainParameter();
                keyID = this.getKeyID();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + "\n-- key ID " + (keyID != null ? HexUtil.hexify(keyID.getValue()) : "not given");
            return result;
        }
    }

    public class RestrictedIdentificationDomainParameterInfo
    extends DomainParameterInfo {
        public RestrictedIdentificationDomainParameterInfo(byte[] bytes) throws IOException {
            super(bytes);
        }

        @Override
        public AlgorithmIdentifier getDomainParameter() throws IOException {
            if (this.domainParameter == null) {
                this.domainParameter = new AlgorithmIdentifier(super.getChildElementByPath(SecurityInfosPath.RESTRICTED_IDENTIFICATION_DOMAIN_PARAMETER_INFO_DOMAIN_PARAMETER).getEncoded());
            }
            return this.domainParameter;
        }

        @Override
        public String toString() {
            Object result = "RestrictedIdentificationDomainParameterInfo: ";
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + this.getDomainParameter();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            return result;
        }
    }

    public abstract class DomainParameterInfo
    extends SecurityInfo
    implements GeneralDomainParameterInfo {
        protected AlgorithmIdentifier domainParameter;

        public DomainParameterInfo(byte[] bytes) throws IOException {
            super(bytes);
            this.domainParameter = null;
        }

        public abstract AlgorithmIdentifier getDomainParameter() throws IOException;
    }

    public static class StandardDomainParameterInfo
    implements GeneralDomainParameterInfo {
        private Integer dpiID = null;

        public StandardDomainParameterInfo(Integer dpiID) throws IllegalArgumentException {
            AssertUtil.notNull(dpiID, "domain parameter ID");
            if (dpiID < 8 || dpiID > 18) {
                throw new IllegalArgumentException("unknown domain parameter ID");
            }
            this.dpiID = dpiID;
        }

        public Integer getdpiID() {
            return this.dpiID;
        }
    }

    public static interface GeneralDomainParameterInfo {
    }

    public static class AlgorithmIdentifier
    extends ASN1 {
        public AlgorithmIdentifier(byte[] bytes) throws IOException {
            super(bytes);
        }

        public ASN1 getAlgorithm() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.ALGORITHM_IDENTIFIER_ALGORITHM);
        }

        public ASN1 getParameters() throws IOException {
            ASN1 result = super.getChildElementByPath(SecurityInfosPath.ALGORITHM_IDENTIFIER_PARAMETERS);
            if (result == null) {
                result = super.getChildElementByPath(SecurityInfosPath.ALGORITHM_IDENTIFIER_PARAMETER_ID);
            }
            return result;
        }

        @Override
        public String toString() {
            Object result = "\n-- AlgorithmIdentifier: ";
            ASN1 parameters = null;
            try {
                result = (String)result + "\n---- algorithm " + HexUtil.hexify(this.getAlgorithm().getValue());
                parameters = this.getParameters();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + "\n---- parameters " + (parameters != null ? HexUtil.hexify(parameters.getValue()) : "not given");
            return result;
        }
    }

    public class SubjectPublicKeyInfo
    extends ASN1 {
        private AlgorithmIdentifier algorithm;

        public SubjectPublicKeyInfo(byte[] bytes) throws IOException {
            super(bytes);
            this.algorithm = null;
        }

        public AlgorithmIdentifier getAlgorithm() throws IOException {
            if (this.algorithm == null) {
                this.algorithm = new AlgorithmIdentifier(super.getChildElementByPath(SecurityInfosPath.SUBJECT_PUBLIC_KEY_INFO_ALGORITHM).getEncoded());
            }
            return this.algorithm;
        }

        public ASN1 getSubjectPublicKey() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.SUBJECT_PUBLIC_KEY_INFO_SUBJECT_PUBLIC_KEY);
        }

        @Override
        public String toString() {
            Object result = "\n-- SubjectPublicKeyInfo: ";
            try {
                result = (String)result + this.getAlgorithm();
                result = (String)result + "\n---- public key: " + HexUtil.hexify(this.getSubjectPublicKey().getValue());
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            return result;
        }
    }

    public class ChipAuthenticationPublicKeyInfo
    extends SecurityInfo {
        private SubjectPublicKeyInfo chipAuthenticationPublicKey;

        public ChipAuthenticationPublicKeyInfo(byte[] bytes) throws IOException {
            super(bytes);
            this.chipAuthenticationPublicKey = null;
        }

        public SubjectPublicKeyInfo getChipAuthenticationPublicKey() throws IOException {
            if (this.chipAuthenticationPublicKey == null) {
                this.chipAuthenticationPublicKey = new SubjectPublicKeyInfo(super.getChildElementByPath(SecurityInfosPath.CHIP_AUTHENTICATION_PUBLIC_KEY_INFO_CHIP_AUTHENTICATION_PUBLIC_KEY).getEncoded());
            }
            return this.chipAuthenticationPublicKey;
        }

        public ASN1 getKeyID() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.CHIP_AUTHENTICATION_PUBLIC_KEY_INFO_KEY_ID);
        }

        @Override
        public String toString() {
            Object result = "ChipAuthenticationPublicKeyInfo: ";
            ASN1 keyID = null;
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + this.getChipAuthenticationPublicKey();
                keyID = this.getKeyID();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + "\n-- key ID " + (keyID != null ? HexUtil.hexify(keyID.getValue()) : "not given");
            return result;
        }
    }

    public class ChipAuthenticationInfo
    extends SecurityInfo {
        public ChipAuthenticationInfo(byte[] bytes) throws IOException {
            super(bytes);
        }

        public ASN1 getVersion() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.CHIP_AUTHENTICATION_INFO_VERSION);
        }

        public ASN1 getKeyID() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.CHIP_AUTHENTICATION_INFO_KEY_ID);
        }

        @Override
        public String toString() {
            Object result = "ChipAuthenticationInfo: ";
            ASN1 keyID = null;
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + "\n-- version " + HexUtil.hexify(this.getVersion().getValue());
                keyID = this.getKeyID();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + "\n-- key ID " + (keyID != null ? HexUtil.hexify(keyID.getValue()) : "not given");
            return result;
        }
    }

    public class PACEDomainParameterInfo
    extends DomainParameterInfo {
        public PACEDomainParameterInfo(byte[] bytes) throws IOException {
            super(bytes);
        }

        @Override
        public AlgorithmIdentifier getDomainParameter() throws IOException {
            if (this.domainParameter == null) {
                this.domainParameter = new AlgorithmIdentifier(super.getChildElementByPath(SecurityInfosPath.PACE_DOMAIN_PARAMETER_INFO_DOMAIN_PARAMETER).getEncoded());
            }
            return this.domainParameter;
        }

        public ASN1 getParameterID() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.PACE_DOMAIN_PARAMETER_INFO_PARAMETER_ID);
        }

        @Override
        public String toString() {
            Object result = "PACEDomainParameterInfo: ";
            ASN1 parameterID = null;
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + this.getDomainParameter();
                parameterID = this.getParameterID();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + "\n-- parameter ID " + (parameterID != null ? HexUtil.hexify(parameterID.getValue()) : "not given");
            return result;
        }
    }

    public class PACEInfo
    extends SecurityInfo {
        public PACEInfo(byte[] bytes) throws IOException {
            super(bytes);
        }

        public ASN1 getVersion() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.PACE_INFO_VERSION);
        }

        public ASN1 getParameterID() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.PACE_INFO_PARAMETER_ID);
        }

        @Override
        public String toString() {
            Object result = "\nPACEInfo: ";
            ASN1 parameterID = null;
            try {
                result = (String)result + "\n-- protocol " + HexUtil.hexify(this.getProtocol().getValue());
                result = (String)result + "\n-- version " + HexUtil.hexify(this.getVersion().getValue());
                parameterID = this.getParameterID();
            }
            catch (IOException e) {
                throw new IllegalStateException("can not convert to String");
            }
            result = (String)result + "\n-- parameter ID " + (parameterID != null ? HexUtil.hexify(parameterID.getValue()) : "not given");
            return result;
        }
    }

    abstract class SecurityInfo
    extends ASN1 {
        public SecurityInfo(byte[] bytes) throws IOException {
            super(bytes);
        }

        public final ASN1 getProtocol() throws IOException {
            return super.getChildElementByPath(SecurityInfosPath.SECURITY_INFO_PROTOCOL);
        }
    }
}

