/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc;

import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.ChatCategory;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.ChatTerminalType;
import java.util.ArrayList;
import java.util.List;

enum ChatOption {
    AUT_READ_DG01(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read Document Type", true, 3, 1),
    AUT_READ_DG02(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read IssuingState", true, 3, 2),
    AUT_READ_DG03(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read DateOfExpiry", true, 3, 4),
    AUT_READ_DG04(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read GivenNames", true, 3, 8),
    AUT_READ_DG05(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read FamilyNames", true, 3, 16),
    AUT_READ_DG06(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read ReligousAndArtisticNames", true, 3, 32),
    AUT_READ_DG07(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read AcademiceTitle", true, 3, 64),
    AUT_READ_DG08(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read DateOfBirth", true, 3, -128),
    AUT_READ_DG09(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read PlaceOfBirth", true, 2, 1),
    AUT_READ_DG0A(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read Nationality", true, 2, 2),
    AUT_READ_DG0B(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read Sex", true, 2, 4),
    AUT_READ_DG0C(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read OptionalDataR", true, 2, 8),
    AUT_READ_DG0D(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read RFU1", true, 2, 16),
    AUT_READ_DG0E(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read RFU2", true, 2, 32),
    AUT_READ_DG0F(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read RFU3", true, 2, 64),
    AUT_READ_DG10(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read RFU4", true, 2, -128),
    AUT_READ_DG11(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read PlaceOfResidence", true, 1, 1),
    AUT_READ_DG12(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read CommunityID", true, 1, 2),
    AUT_READ_DG13(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read ResidencePermitI", true, 1, 4),
    AUT_READ_DG14(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read ResidencePermitII", true, 1, 8),
    AUT_READ_DG15(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.READ, "Read OptionalDataRW", true, 1, 16),
    AUT_WRITE_DG11(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.WRITE, "Write DG17 (eID): Place Of Residence", true, 0, 32),
    AUT_WRITE_DG12(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.WRITE, "Write DG18 (eID): Community ID", true, 0, 16),
    AUT_WRITE_DG13(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.WRITE, "Write ResidencePermitI", true, 0, 8),
    AUT_WRITE_DG14(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.WRITE, "Write DG20 (eID): Residence Permit II", true, 0, 4),
    AUT_WRITE_DG15(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.WRITE, "Write DG21 (eID): Optional Data RW", true, 0, 2),
    AUT_AGE_VERIFICATION(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.OTHER, "Age Verification", true, 4, 1),
    AUT_COMMUNITY_ID_VERIFICATION(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.OTHER, "Community ID Identification", true, 4, 2),
    AUT_INSTALL_CERTIFICATE(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.OTHER, "Install Certificate", true, 4, 64),
    AUT_INSTALL_QUALIFIED_CERTIFICATE(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.OTHER, "Install Qualified Certificate", true, 4, -128),
    AUT_INSTALL_PIN_MANAGEMENT(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.OTHER, "PIN Management", true, 4, 32),
    AUT_CAN_ALLOWED(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.OTHER, "CAN allowed", true, 4, 16),
    AUT_RESTRICTED_IDENTIFICATION(ChatTerminalType.AUTHENTICATION_TERMINAL, ChatCategory.OTHER, "Restricted Identification", true, 4, 4);

    private ChatTerminalType terminalType = null;
    private ChatCategory category = null;
    private String description = null;
    private boolean defaultSelected = false;
    private int byteIndex = -1;
    private byte byteMask = 0;

    private ChatOption(ChatTerminalType terminalType, ChatCategory category, String description, boolean defaultSelected, int byteIndex, byte byteMask) {
        this.description = description;
        this.terminalType = terminalType;
        this.category = category;
        this.defaultSelected = defaultSelected;
        this.byteIndex = byteIndex;
        this.byteMask = byteMask;
    }

    public static List<ChatOption> getOptions(ChatTerminalType terminalType) {
        ArrayList<ChatOption> result = new ArrayList<ChatOption>();
        for (ChatOption tmp : ChatOption.values()) {
            if (terminalType != tmp.getTerminalType()) continue;
            result.add(tmp);
        }
        return result;
    }

    public static List<ChatOption> getOptions(ChatTerminalType terminalType, ChatCategory chatCategory) {
        ArrayList<ChatOption> result = new ArrayList<ChatOption>();
        for (ChatOption tmp : ChatOption.values()) {
            if (terminalType != tmp.getTerminalType() || chatCategory != tmp.getCategory()) continue;
            result.add(tmp);
        }
        return result;
    }

    public ChatTerminalType getTerminalType() {
        return this.terminalType;
    }

    public ChatCategory getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefaultSelected() {
        return this.defaultSelected;
    }

    public int getByteIndex() {
        return this.byteIndex;
    }

    public byte getByteMask() {
        return this.byteMask;
    }
}

