/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.CertificateDescription;
import de.bos_bremen.common.asn1.cvc.CertificateHolderAuthorizationTemplate;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import de.bos_bremen.common.asn1.cvc.ECCVCertificate;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.CVCKeyPairBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.CertificateRequest;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.CertificateRequestPath;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.xml.CertificateRequestInputType;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.xml.CertificateRequestOutputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.SignatureHandler;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.LocalCertAndKeyProvider;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import org.bouncycastle.jce.provider.JCEECPublicKey;

public class CertificateRequestGenerator {
    private static final String COUNTER_CHARSET = "9876543210";

    private CertificateRequestGenerator() {
    }

    public static CertificateRequestResponse generateRequest(ECCVCertificate oldCVC, ECCVCertificate rootCVC, CertificateDescription description, AdditionalData additionalData, boolean requestWithDescriptionHash) throws InvalidKeyException, IllegalArgumentException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException, SignatureException, InvalidKeySpecException, IOException {
        return CertificateRequestGenerator.generateRequest(oldCVC, null, rootCVC, description, additionalData, requestWithDescriptionHash);
    }

    public static CertificateRequestResponse generateRequest(ECCVCertificate oldCVC, byte[] oldPrivKey, ECCVCertificate rootCVC, CertificateDescription description, AdditionalData additionalData, boolean requestWithDescriptionHash) throws IllegalArgumentException, IOException, SignatureException {
        AssertUtil.notNull(rootCVC, "root CVC CA");
        if (oldCVC == null) {
            AssertUtil.notNull(additionalData, "additional data");
            AssertUtil.notNullOrEmpty(additionalData.getCertificateHolderReference(), "CHR of additional data");
            AssertUtil.notNull(additionalData.getCertificateHolderAuthorizationTemplate(), "CHAT of additional data");
        }
        CertificateRequest cr = CertificateRequestGenerator.createCleanRequest(rootCVC);
        String oldCHR = null;
        if (oldCVC != null) {
            try {
                oldCHR = new String(oldCVC.getChildElementByPath(ECCVCPath.HOLDER_REFERENCE).getValue());
            }
            catch (Exception e) {
                IOException ioe = new IOException("Error in reading CHR from old certificate, possibly corrupted");
                ioe.initCause(e);
                throw ioe;
            }
        }
        String newCHR = null;
        if (additionalData != null) {
            newCHR = additionalData.getCertificateHolderReference();
        }
        if (newCHR == null && oldCHR != null) {
            newCHR = CertificateRequestGenerator.increaseCHR(oldCHR);
        }
        CertificateRequestGenerator.setHolderReference(cr, newCHR);
        if (oldCVC != null) {
            CertificateRequestGenerator.copyOldExtensions(oldCVC, cr);
        }
        CertificateRequestGenerator.setCertificateDescription(cr, rootCVC, description);
        KeyPair keypair = CertificateRequestGenerator.setSignature(cr, rootCVC, newCHR, oldCVC == null);
        CertificateHolderAuthorizationTemplate chat = null;
        if (additionalData != null) {
            chat = additionalData.getCertificateHolderAuthorizationTemplate();
        }
        if (oldCVC != null) {
            try {
                ASN1 oldCHAT = oldCVC.getChildElementByPath(ECCVCPath.CERTIFICATE_HOLDER_AUTHORIZATION_TEMPLATE);
                chat = chat != null ? chat : (CertificateHolderAuthorizationTemplate)new CertificateHolderAuthorizationTemplate().decode(oldCHAT);
            }
            catch (Exception e) {
                IOException ioe = new IOException("Error in reading CHAT from old certificate, possibly corrupted");
                ioe.initCause(e);
                throw ioe;
            }
        }
        CertificateRequest nCR = cr;
        if (oldCVC == null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(cr.getChildElementByPath(CertificateRequestPath.CV_CERTIFICATE).getEncoded());
            nCR = new CertificateRequest(bais);
        } else {
            byte[] oldCHRBytes = oldCHR.getBytes();
            ASN1 outerCAR = new ASN1(CertificateRequestPath.OUTER_CA_REFERENCE.getTag().toByteArray(), oldCHRBytes);
            nCR.addChildElement(outerCAR, nCR);
            CertificateRequestGenerator.setOuterSignature(nCR, oldPrivKey, oldCHR, new OID(oldCVC.getChildElementByPath(ECCVCPath.PUBLIC_KEY_OID).getEncoded()));
        }
        return new CertificateRequestResponseImpl(description, chat, nCR, keypair.getPrivate() != null ? keypair.getPrivate().getEncoded() : null);
    }

    private static void copyOldExtensions(ECCVCertificate oldCVC, CertificateRequest cr) throws IOException {
        try {
            ASN1 previousCertExtensions = oldCVC.getChildElementByPath(ECCVCPath.CERTIFICATE_EXTENSIONS);
            ASN1 body = cr.getChildElementByPath(CertificateRequestPath.CV_CERTIFICATE_BODY);
            ASN1 rootExtensions = cr.getChildElementByPath(CertificateRequestPath.CERTIFICATE_EXTENSIONS);
            body.removeChildElement(rootExtensions, cr);
            if (previousCertExtensions != null) {
                body.addChildElement(previousCertExtensions, cr);
            }
        }
        catch (IOException e) {
            IOException ioe = new IOException("copying extensions from old certificate to request failed");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static void setOuterSignature(CertificateRequest ncr, byte[] oldPrivKey, String oldPrivKeyAlias, OID sigAlg) throws SignatureException {
        AssertUtil.notNull(ncr, "certificate request");
        AssertUtil.notNull(sigAlg, "signature algorithm");
        if (!(oldPrivKey != null && oldPrivKey.length != 0 || oldPrivKeyAlias != null && oldPrivKeyAlias.length() != 0)) {
            throw new IllegalArgumentException("one of oldPrivKey and oldPrivKeyAlias must contain a value");
        }
        try {
            if (oldPrivKey != null && oldPrivKey.length > 0) {
                LocalCertAndKeyProvider.getInstance().addKey(oldPrivKeyAlias, oldPrivKey);
            }
            ncr.signRequest(oldPrivKeyAlias, sigAlg, oldPrivKey != null && oldPrivKey.length > 0);
        }
        catch (Exception e) {
            throw new SignatureException("setting outer signature failed", e);
        }
    }

    public static CertificateRequestOutputType generateRequest(CertificateRequestInputType input) throws IllegalArgumentException, IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException, InvalidKeySpecException {
        AssertUtil.notNull(input, "input");
        AssertUtil.notNullOrEmpty(input.getRootCVC(), "root certificate");
        byte[] oldCVCBytes = input.getOldCVC();
        ECCVCertificate oldCVC = null;
        if (oldCVCBytes != null) {
            oldCVC = new ECCVCertificate(input.getOldCVC());
        }
        ECCVCertificate rootCVC = new ECCVCertificate(input.getRootCVC());
        byte[] descBytes = input.getCertificateDescription();
        CertificateDescription certDesc = null;
        if (descBytes != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(descBytes);
            certDesc = new CertificateDescription(bais);
        }
        byte[] chatBytes = input.getAdditionalData().getChat();
        CertificateHolderAuthorizationTemplate chat = null;
        if (chatBytes != null) {
            ASN1 chatASN1 = new ASN1(chatBytes);
            chat = new CertificateHolderAuthorizationTemplate();
            chat.decode(chatASN1);
        }
        AdditionalData addData = new AdditionalData(input.getAdditionalData().getChr(), input.getAdditionalData().getCar(), chat);
        Boolean hash = input.isWithDescriptionHash();
        CertificateRequestResponse resp = CertificateRequestGenerator.generateRequest(oldCVC, input.getOldPrivateKey(), rootCVC, certDesc, addData, hash != null ? hash : false);
        CertificateRequestOutputType output = new CertificateRequestOutputType();
        output.setRequest(resp.getCertificateRequest().getEncoded());
        output.setPrivateKey(resp.getPKCS8PrivateKey());
        output.setChat(resp.getCertificateHolderAuthorizationTemplate().getEncoded());
        CertificateDescription cd = resp.getCertificateDescription();
        if (cd != null) {
            output.setCertDescription(cd.getEncoded());
        }
        return output;
    }

    private static CertificateRequest createCleanRequest(ECCVCertificate rootCert) throws IOException {
        ASN1 asn1 = new ASN1(rootCert);
        try {
            asn1.getChildElementByPath(ECCVCPath.CV_CERTIFICATE_BODY).removeChildElement(asn1.getChildElementByPath(ECCVCPath.CA_REFERENCE), asn1);
            asn1.getChildElementByPath(ECCVCPath.CV_CERTIFICATE_BODY).removeChildElement(asn1.getChildElementByPath(ECCVCPath.EFFECTIVE_DATE), asn1);
            asn1.getChildElementByPath(ECCVCPath.CV_CERTIFICATE_BODY).removeChildElement(asn1.getChildElementByPath(ECCVCPath.EXPIRATION_DATE), asn1);
            asn1.getChildElementByPath(ECCVCPath.CV_CERTIFICATE_BODY).removeChildElement(asn1.getChildElementByPath(ECCVCPath.CERTIFICATE_HOLDER_AUTHORIZATION_TEMPLATE), asn1);
            return new CertificateRequest(asn1.getEncoded());
        }
        catch (Exception e) {
            IOException ioe = new IOException("Creating clean request failed - probably given root certificate corrupted");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static void setHolderReference(CertificateRequest cr, String chr) throws IOException {
        try {
            cr.getRequestPart(CertificateRequestPath.HOLDER_REFERENCE).setValueBytes(chr.getBytes(), cr);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Setting holder reference failed");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static KeyPair setSignature(CertificateRequest cr, ECCVCertificate root, String chr, boolean replace) throws IOException {
        try {
            KeyPair kp = CVCKeyPairBuilder.generateKeyPair(root, chr, replace);
            cr.signCVCBody(kp.getPublic(), chr);
            CertificateRequestGenerator.checkSignature(cr.getChildElements()[0]);
            return kp;
        }
        catch (Exception e) {
            IOException ioe = new IOException("setting signature failed");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static String increaseCHR(String oldCHR) {
        String identifier = oldCHR.substring(0, oldCHR.length() - 5);
        String counter = oldCHR.substring(oldCHR.length() - 5);
        return identifier + CertificateRequestGenerator.increase(counter, counter.length() - 1);
    }

    private static String increase(String str, int position) {
        if ("99999".equals(str)) {
            return "00001";
        }
        int index = COUNTER_CHARSET.indexOf(str.charAt(position));
        if (str.length() == 1) {
            if (index > 0) {
                return COUNTER_CHARSET.substring(index - 1, index);
            }
            return COUNTER_CHARSET.substring(COUNTER_CHARSET.length() - 1);
        }
        if (index > 0) {
            return str.substring(0, str.length() - 1) + COUNTER_CHARSET.substring(index - 1, index);
        }
        return CertificateRequestGenerator.increase(str.substring(0, str.length() - 1), position - 1) + COUNTER_CHARSET.substring(COUNTER_CHARSET.length() - 1);
    }

    private static void setCertificateDescription(CertificateRequest cr, ECCVCertificate rootCVC, CertificateDescription cd) throws IOException {
        if (cd == null) {
            return;
        }
        AssertUtil.notNull(cr, "certificate request");
        AssertUtil.notNull(rootCVC, "root CVC");
        try {
            ASN1 oid1 = cr.getChildElementByPath(CertificateRequestPath.DISCRETIONARY_DATA_FIRST_OID);
            ASN1 oid2 = cr.getChildElementByPath(CertificateRequestPath.DISCRETIONARY_DATA_SECOND_OID);
            if (oid1 != null && Arrays.equals(oid1.getEncoded(), new OID("0.4.0.127.0.7.3.1.3.1").getEncoded())) {
                ASN1 hash = new ASN1(CertificateRequestPath.DISCRETIONARY_DATA_FIRST_HASH.getTag().toByteArray(), CertificateDescription.hashCertDescription(rootCVC, cd));
                cr.getChildElementByPath(CertificateRequestPath.EXTENSIONS_DISCRETIONARY_DATA_FIRST).replaceChildElement(cr.getChildElementByPath(CertificateRequestPath.DISCRETIONARY_DATA_FIRST_HASH), hash, cr);
            } else if (oid2 != null && Arrays.equals(oid2.getEncoded(), new OID("0.4.0.127.0.7.3.1.3.1").getEncoded())) {
                ASN1 hash = new ASN1(CertificateRequestPath.DISCRETIONARY_DATA_SECOND_HASH.getTag().toByteArray(), CertificateDescription.hashCertDescription(rootCVC, cd));
                cr.getChildElementByPath(CertificateRequestPath.EXTENSIONS_DISCRETIONARY_DATA_SECOND).replaceChildElement(cr.getChildElementByPath(CertificateRequestPath.DISCRETIONARY_DATA_SECOND_HASH), hash, cr);
            } else if (oid1 != null) {
                ASN1 dd = new ASN1(CertificateRequestPath.EXTENSIONS_DISCRETIONARY_DATA_SECOND.getTag().toByteArray(), new byte[0]);
                ASN1 ddoid = new ASN1(CertificateRequestPath.DISCRETIONARY_DATA_SECOND_OID.getTag().toByteArray(), new OID("0.4.0.127.0.7.3.1.3.1").getValue());
                ASN1 ddhash = new ASN1(CertificateRequestPath.DISCRETIONARY_DATA_SECOND_HASH.getTag().toByteArray(), CertificateDescription.hashCertDescription(rootCVC, cd));
                dd.addChildElement(ddoid, dd);
                dd.addChildElement(ddhash, dd);
                cr.getChildElementByPath(CertificateRequestPath.CERTIFICATE_EXTENSIONS).addChildElement(dd, cr);
            } else {
                cr.getChildElementByPath(CertificateRequestPath.CV_CERTIFICATE_BODY).removeChildElement(cr.getChildElementByPath(CertificateRequestPath.CERTIFICATE_EXTENSIONS), cr);
                ASN1 dd = new ASN1(CertificateRequestPath.EXTENSIONS_DISCRETIONARY_DATA_FIRST.getTag().toByteArray(), new byte[0]);
                ASN1 ddoid = new ASN1(CertificateRequestPath.DISCRETIONARY_DATA_FIRST_OID.getTag().toByteArray(), new OID("0.4.0.127.0.7.3.1.3.1").getValue());
                ASN1 ddhash = new ASN1(CertificateRequestPath.DISCRETIONARY_DATA_FIRST_HASH.getTag().toByteArray(), CertificateDescription.hashCertDescription(rootCVC, cd));
                dd.addChildElement(ddoid, dd);
                dd.addChildElement(ddhash, dd);
                ASN1 ce = new ASN1(CertificateRequestPath.CERTIFICATE_EXTENSIONS.getTag().toByteArray(), dd.getEncoded());
                cr.getChildElementByPath(CertificateRequestPath.CV_CERTIFICATE_BODY).addChildElement(ce, cr);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("setting certificate description failed");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static void checkSignature(ASN1 cr) throws IOException, FileNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        ASN1 sig = cr.getChildElementsByDTagBytes(HexUtil.parse("5f37"))[0];
        ASN1 body = cr.getChildElementsByDTagBytes(HexUtil.parse("7f4e"))[0];
        ASN1 pub = body.getChildElementsByDTagBytes(HexUtil.parse("7f49"))[0];
        JCEECPublicKey pk = EPAUtil.createKeyFromASN1EPA(pub);
        Signature s = null;
        try {
            s = SignatureHandler.createSignature(new OID(pub.getChildElementsByTag((short)6)[0].getEncoded()));
        }
        catch (Throwable t) {
            s = Signature.getInstance("SHA256withCVC-ECDSA", "BC");
        }
        s.initVerify((PublicKey)pk);
        s.update(body.getEncoded());
        if (!s.verify(sig.getValue())) {
            throw new SignatureException("signature not verified correctly");
        }
    }

    private static class CertificateRequestResponseImpl
    implements CertificateRequestResponse {
        private CertificateDescription cd = null;
        private CertificateHolderAuthorizationTemplate chat = null;
        private CertificateRequest cr = null;
        private byte[] key = null;

        public CertificateRequestResponseImpl(CertificateDescription cd, CertificateHolderAuthorizationTemplate chat, CertificateRequest cr, byte[] key) {
            this.cd = cd;
            this.chat = chat;
            this.cr = cr;
            this.key = key;
        }

        @Override
        public CertificateDescription getCertificateDescription() {
            return this.cd;
        }

        @Override
        public CertificateHolderAuthorizationTemplate getCertificateHolderAuthorizationTemplate() {
            return this.chat;
        }

        @Override
        public CertificateRequest getCertificateRequest() {
            return this.cr;
        }

        @Override
        public byte[] getPKCS8PrivateKey() {
            return this.key;
        }
    }

    public static interface CertificateRequestResponse {
        public CertificateRequest getCertificateRequest();

        public CertificateDescription getCertificateDescription();

        public byte[] getPKCS8PrivateKey();

        public CertificateHolderAuthorizationTemplate getCertificateHolderAuthorizationTemplate();
    }

    public static class AdditionalData {
        private String chr = null;
        private String car = null;
        private CertificateHolderAuthorizationTemplate chat = null;

        public AdditionalData(String chr, String car, CertificateHolderAuthorizationTemplate chat) {
            this.chr = chr;
            this.car = car;
            this.chat = chat;
        }

        public String getCertificateAuthorizationReference() {
            return this.car;
        }

        public CertificateHolderAuthorizationTemplate getCertificateHolderAuthorizationTemplate() {
            return this.chat;
        }

        public String getCertificateHolderReference() {
            return this.chr;
        }
    }
}

