/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.cvc.CertificateDescription;
import de.bos_bremen.common.asn1.cvc.CertificateDescriptionPath;
import de.bos_bremen.common.asn1.cvc.CertificateHolderAuthorizationTemplate;
import de.bos_bremen.common.swing.SwingUtil;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.CertificateRequest;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.CertificateRequestGenerator;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.CertificateRequestPath;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.ChatCategory;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.ChatOption;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.ChatTerminalType;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.xml.AdditionalDataType;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.xml.CertificateRequestInputType;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.xml.CertificateRequestOutputType;
import de.bos_bremen.gov2.jca_provider.service.ServiceRegistry;
import de.bos_bremen.gov2.jca_provider.service.hsm.HSMServiceFactory;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMConfiguration;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMCredentials;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMException;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.xml.sax.SAXException;

public class CertificateRequestDialog {
    private static HSMService hsm = null;

    public static void main(String[] args) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        int selectedHSM = CertificateRequestDialog.showSelectDialog();
        try {
            hsm = ServiceRegistry.Util.getServiceRegistry().getService(HSMServiceFactory.class).getHSMService(selectedHSM);
        }
        catch (HSMException e) {
            JOptionPane.showMessageDialog(null, "Connection to HSM could not be established: " + e.getMessage(), "Error", 0);
            System.exit(0);
        }
        if (selectedHSM == 2 && !CertificateRequestDialog.showLoginDialog()) {
            System.exit(0);
        }
        try {
            CertificateRequestDialog.showDialog();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static int showSelectDialog() {
        final ArrayList retValue = new ArrayList(1);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(1, 2));
        final JButton hsmButton = new JButton("Use Utimaco HSM");
        final JButton noHSMButton = new JButton("Work without HSM");
        hsmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                retValue.clear();
                retValue.add(2);
                Color c = hsmButton.getBackground();
                hsmButton.setBackground(Color.LIGHT_GRAY);
                if (c != Color.LIGHT_GRAY) {
                    noHSMButton.setBackground(c);
                }
            }
        });
        mainPanel.add(hsmButton);
        noHSMButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                retValue.clear();
                retValue.add(1);
                Color c = noHSMButton.getBackground();
                if (c != Color.LIGHT_GRAY) {
                    hsmButton.setBackground(c);
                }
                noHSMButton.setBackground(Color.LIGHT_GRAY);
            }
        });
        mainPanel.add(noHSMButton);
        JOptionPane.showMessageDialog(null, mainPanel, "Please select HSM", 1);
        return (Integer)retValue.get(0);
    }

    private static boolean showLoginDialog() {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(8, 5));
        mainPanel.add(new JLabel());
        mainPanel.add(new JLabel("Name"));
        mainPanel.add(new JLabel("Password"));
        mainPanel.add(new JLabel("Key File"));
        mainPanel.add(new JLabel());
        mainPanel.add(new JLabel("Key Manager 1"));
        JTextField km1 = new JTextField(10);
        mainPanel.add(km1);
        JPasswordField pwd1 = new JPasswordField(10);
        mainPanel.add(pwd1);
        final JTextField km1FileField = new JTextField(10);
        mainPanel.add(km1FileField);
        JButton selectkm1File = new JButton("select");
        mainPanel.add(selectkm1File);
        selectkm1File.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    km1FileField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
        mainPanel.add(new JLabel("Key Manager 2"));
        JTextField km2 = new JTextField(10);
        mainPanel.add(km2);
        JPasswordField pwd2 = new JPasswordField(10);
        mainPanel.add(pwd2);
        final JTextField km2FileField = new JTextField(10);
        mainPanel.add(km2FileField);
        JButton selectkm2File = new JButton("select");
        mainPanel.add(selectkm2File);
        selectkm2File.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    km2FileField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
        mainPanel.add(new JLabel("User 1"));
        JTextField user1 = new JTextField(10);
        mainPanel.add(user1);
        JPasswordField pwdu1 = new JPasswordField(10);
        mainPanel.add(pwdu1);
        final JTextField user1FileField = new JTextField(10);
        mainPanel.add(user1FileField);
        JButton selectUser1File = new JButton("select");
        mainPanel.add(selectUser1File);
        selectUser1File.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    user1FileField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
        mainPanel.add(new JLabel("User 2"));
        JTextField user2 = new JTextField(10);
        mainPanel.add(user2);
        JPasswordField pwdu2 = new JPasswordField(10);
        mainPanel.add(pwdu2);
        final JTextField user2FileField = new JTextField(10);
        mainPanel.add(user2FileField);
        JButton selectUser2File = new JButton("select");
        mainPanel.add(selectUser2File);
        selectUser2File.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    user2FileField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
        for (int i = 0; i < 5; ++i) {
            mainPanel.add(new JLabel());
        }
        mainPanel.add(new JLabel("HSM IP"));
        JTextField hsmIP = new JTextField(10);
        mainPanel.add(hsmIP);
        mainPanel.add(new JLabel());
        mainPanel.add(new JLabel("Key Validity"));
        JTextField keyVal = new JTextField(10);
        mainPanel.add(keyVal);
        mainPanel.add(new JLabel("Key Prefix"));
        JTextField hsmkeyPref = new JTextField(10);
        mainPanel.add(hsmkeyPref);
        mainPanel.add(new JLabel());
        mainPanel.add(new JLabel("Key Entity"));
        JTextField hsmKeyEnt = new JTextField(10);
        mainPanel.add(hsmKeyEnt);
        int answer = JOptionPane.showOptionDialog(null, mainPanel, "Please input HSM config data", 2, 3, null, null, null);
        if (answer == 0) {
            try {
                HSMCredentials km1Cred = null;
                km1Cred = !"".equals(km1FileField.getText()) ? new HSMCredentials(km1.getText(), km1FileField.getText(), new String(pwd1.getPassword())) : new HSMCredentials(km1.getText(), new String(pwd1.getPassword()));
                HSMCredentials km2Cred = null;
                if (!"".equals(km2.getText())) {
                    km2Cred = !"".equals(km2FileField.getText()) ? new HSMCredentials(km2.getText(), km2FileField.getText(), new String(pwd2.getPassword())) : new HSMCredentials(km2.getText(), new String(pwd2.getPassword()));
                }
                HSMCredentials user1Cred = null;
                user1Cred = !"".equals(user1FileField.getText()) ? new HSMCredentials(user1.getText(), user1FileField.getText(), new String(pwdu1.getPassword())) : new HSMCredentials(user1.getText(), new String(pwdu1.getPassword()));
                HSMCredentials user2Cred = null;
                if (!"".equals(user2.getText())) {
                    user2Cred = !"".equals(user2FileField.getText()) ? new HSMCredentials(user2.getText(), user2FileField.getText(), new String(pwdu2.getPassword())) : new HSMCredentials(user2.getText(), new String(pwdu2.getPassword()));
                }
                int keyValidity = !"".equals(keyVal.getText()) ? Integer.parseInt(keyVal.getText()) : 60;
                HSMConfiguration hsmConfig = new HSMConfiguration(hsmIP.getText(), hsmkeyPref.getText(), hsmKeyEnt.getText(), keyValidity, km1Cred, km2Cred, user1Cred, user2Cred);
                hsm.init(hsmConfig);
                JOptionPane.showMessageDialog(null, "Login accepted", "Success", 1);
                return true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Login failed", "Error", 0);
                return false;
            }
        }
        return false;
    }

    private static void storeData(CertificateRequestInputType crit, CertificateRequestOutputType crot) throws IOException {
        ASN1 asn1 = new ASN1(crot.getRequest());
        CertificateRequest cr = new CertificateRequest(asn1.getValue());
        ASN1 chrASN1 = cr.getChildElementByPath(CertificateRequestPath.HOLDER_REFERENCE);
        if (chrASN1 == null) {
            cr = new CertificateRequest(asn1.getEncoded());
            chrASN1 = cr.getChildElementByPath(CertificateRequestPath.HOLDER_REFERENCE);
        }
        AssertUtil.notNull(chrASN1, "corrupted input data");
        String chr = new String(chrASN1.getValue());
        File file = new File(chr);
        file.mkdir();
        Date date = new Date(System.currentTimeMillis());
        String dateStr = "_" + chr + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(date);
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.xml");
            Marshaller marshaller = jc.createMarshaller();
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = null;
            schema = sf.newSchema(new File("certificateRequest.xsd"));
            marshaller.setSchema(schema);
            marshaller.marshal((Object)new JAXBElement(new QName("http://www.bos_bremen.de/CertificateRequest", "certRequestInput"), CertificateRequestInputType.class, (Object)crit), new File(chr + "/crInputData" + dateStr + ".xml"));
            marshaller.marshal((Object)new JAXBElement(new QName("http://www.bos_bremen.de/CertificateRequest", "certRequestOutput"), CertificateRequestOutputType.class, (Object)crot), new File(chr + "/crOutputData" + dateStr + ".xml"));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        byte[] pkBytes = crot.getPrivateKey();
        if (pkBytes != null) {
            try (FileOutputStream fos0 = new FileOutputStream(chr + "/PrivateKey" + dateStr + ".pkcs8");){
                fos0.write(crot.getPrivateKey());
                fos0.flush();
            }
        }
        try (FileOutputStream fos1 = new FileOutputStream(chr + "/CR_AwT" + dateStr + ".bin");){
            fos1.write(crot.getRequest());
            fos1.flush();
        }
        byte[] cdBytes = crot.getCertDescription();
        if (cdBytes != null) {
            try (FileOutputStream fos2 = new FileOutputStream(chr + "/CertDescription" + dateStr + ".bin");){
                fos2.write(cdBytes);
                fos2.flush();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(cdBytes);
            CertificateDescription cd = new CertificateDescription(bais);
            ASN1 plainText = cd.getCertificateDescriptionPart(CertificateDescriptionPath.TERMS_OF_USAGE_PLAIN_TEXT);
            if (plainText != null) {
                try (FileOutputStream fos = new FileOutputStream(chr + "/TermsOfUsage" + dateStr + ".txt");){
                    fos.write(plainText.getValue());
                    fos.flush();
                }
            }
        }
    }

    private static void showDialog() throws UnsupportedOperationException, IllegalArgumentException, IOException {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel labelPanel = CertificateRequestDialog.createLabelPanel();
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridLayout(11, 1));
        JTextField rootCertField = new JTextField(10);
        rootCertField.setEditable(false);
        ArrayList<File> rootCertFile = new ArrayList<File>(1);
        inputPanel.add(rootCertField);
        JTextField oldCertField = new JTextField();
        oldCertField.setEditable(false);
        ArrayList<File> oldCertFile = new ArrayList<File>(1);
        inputPanel.add(oldCertField);
        JTextField oldKeyField = new JTextField();
        oldKeyField.setEditable(false);
        ArrayList<File> oldKeyFile = new ArrayList<File>(1);
        inputPanel.add(oldKeyField);
        JTextField chrField = new JTextField();
        inputPanel.add(chrField);
        JTextField carField = new JTextField();
        inputPanel.add(carField);
        JTextField chatMatrix = new JTextField();
        inputPanel.add(chatMatrix);
        JTextField cdsnField = new JTextField();
        inputPanel.add(cdsnField);
        JTextField cdsuField = new JTextField();
        inputPanel.add(cdsuField);
        JTextArea cdtuField = new JTextArea(3, 20);
        JScrollPane scrollPane = new JScrollPane(cdtuField);
        inputPanel.add(scrollPane);
        JTextField cdruField = new JTextField();
        inputPanel.add(cdruField);
        JTextField commCertField = new JTextField();
        commCertField.setEditable(false);
        ArrayList<File> commCertFile = new ArrayList<File>();
        inputPanel.add(commCertField);
        JPanel editPanel = CertificateRequestDialog.createEditPanel(mainPanel, rootCertField, rootCertFile, oldCertField, oldCertFile, oldKeyField, oldKeyFile, chatMatrix, commCertField, commCertFile);
        mainPanel.add((Component)labelPanel, "West");
        mainPanel.add((Component)inputPanel, "Center");
        mainPanel.add((Component)editPanel, "East");
        while (true) {
            String car;
            CertificateRequestInputType crit = null;
            boolean ok = false;
            int execute = JOptionPane.showOptionDialog(null, mainPanel, "Please input data for certificate request", 2, 3, null, null, null);
            if (2 == execute) {
                System.exit(0);
            }
            if (0 != execute) continue;
            String chr = chrField.getText();
            if (ok = CertificateRequestDialog.checkSetup(mainPanel, rootCertFile, oldCertFile, chatMatrix, ok, chr, car = carField.getText())) {
                crit = new CertificateRequestInputType();
                CertificateRequestDialog.processAdditonalData(chatMatrix, crit, chr, car);
                CertificateRequestDialog.readSetRootCertFile(rootCertFile, crit);
                CertificateRequestDialog.processCommonCerts(cdsnField, cdsuField, cdtuField, cdruField, commCertFile, crit);
                CertificateRequestDialog.readSetOldCertFile(oldCertFile, crit);
                CertificateRequestDialog.readSetOldKeyFile(oldKeyFile, crit);
            }
            CertificateRequestDialog.processCertificateRequest(oldCertField, oldCertFile, oldKeyField, oldKeyFile, chrField, commCertField, commCertFile, crit);
        }
    }

    public static boolean checkSetup(JPanel mainPanel, List<File> rootCertFile, List<File> oldCertFile, JTextField chatMatrix, boolean ok, String chr, String car) {
        if (rootCertFile.size() != 1) {
            JOptionPane.showMessageDialog(mainPanel, "Root certificate must be set", "Error", 0);
        } else if (oldCertFile.size() != 1 && (chr == null || chr.length() == 0)) {
            JOptionPane.showMessageDialog(mainPanel, "Either old certificate or Certificate Holder Reference must be set", "Error", 0);
        } else if (oldCertFile.isEmpty() && (chatMatrix.getText() == null || chatMatrix.getText().isEmpty())) {
            JOptionPane.showMessageDialog(mainPanel, "For an initial request, the Certificate Holder Authorization Template is requested", "Error", 0);
        } else if (CertificateRequestDialog.checkStringNotNullOrEmpty(chr) && (chr.length() < 10 || chr.length() > 16)) {
            JOptionPane.showMessageDialog(mainPanel, "Certificate Holder Reference must have a length from 10 to 16", "Error", 0);
        } else if (CertificateRequestDialog.checkStringNotNullOrEmpty(car) && (car.length() < 10 || car.length() > 16)) {
            JOptionPane.showMessageDialog(mainPanel, "Certification Authority Reference must have a length from 10 to 16", "Error", 0);
        } else {
            return CertificateRequestDialog.checkProceed(mainPanel, ok, chr, car);
        }
        return ok;
    }

    private static boolean checkProceed(JPanel mainPanel, boolean ok, String chr, String car) {
        String seqNo;
        boolean error = false;
        if (chr.length() > 0) {
            seqNo = chr.substring(chr.length() - 5);
            for (char x : seqNo.toCharArray()) {
                if (Character.isLetterOrDigit(x)) continue;
                JOptionPane.showMessageDialog(mainPanel, "Certificate Holder Reference must have an alphanumeric sequence number (last 5 characters)", "Error", 0);
                error = true;
                break;
            }
        }
        if (!error && car != null && car.length() > 0) {
            seqNo = car.substring(car.length() - 5);
            for (char x : seqNo.toCharArray()) {
                if (Character.isLetterOrDigit(x)) continue;
                JOptionPane.showMessageDialog(mainPanel, "Certification Authority Reference must have an alphanumeric sequence number (last 5 characters)", "Error", 0);
                error = true;
                break;
            }
        }
        if (!error) {
            return true;
        }
        return ok;
    }

    public static void processCertificateRequest(JTextField oldCertField, List<File> oldCertFile, JTextField oldKeyField, List<File> oldKeyFile, JTextField chrField, JTextField commCertField, List<File> commCertFile, CertificateRequestInputType crit) {
        if (crit != null) {
            CertificateRequestOutputType crot = CertificateRequestDialog.generateRequest(crit);
            CertificateRequestDialog.storeRequest(crit, crot);
            JOptionPane.showMessageDialog(null, "The request has been successfully created.", "Success", 1);
            oldCertField.setText("");
            oldCertFile.clear();
            oldKeyField.setText("");
            oldKeyFile.clear();
            chrField.setText("");
            commCertField.setText("");
            commCertFile.clear();
        }
    }

    public static void storeRequest(CertificateRequestInputType crit, CertificateRequestOutputType crot) {
        try {
            CertificateRequestDialog.storeData(crit, crot);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error in writing output: " + e.getMessage() + "\nOutput files may be corrupted or not even existing", "Error", 0);
            System.exit(0);
        }
    }

    public static CertificateRequestOutputType generateRequest(CertificateRequestInputType crit) {
        CertificateRequestOutputType crot = null;
        try {
            crot = CertificateRequestGenerator.generateRequest(crit);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in generating request: " + e.getMessage(), "Error", 0);
            System.exit(0);
        }
        return crot;
    }

    public static void processAdditonalData(JTextField chatMatrix, CertificateRequestInputType crit, String chr, String car) {
        CertificateHolderAuthorizationTemplate template = null;
        byte[] bytes = HexUtil.parse(chatMatrix.getText());
        if (!ArrayUtil.isNullOrEmpty(bytes)) {
            try {
                template = new CertificateHolderAuthorizationTemplate();
                template.decode(bytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AdditionalDataType adt = new AdditionalDataType();
        adt.setChat(template != null ? template.getEncoded() : null);
        if (CertificateRequestDialog.checkStringNotNullOrEmpty(chr)) {
            adt.setChr(chr.toUpperCase(Locale.ENGLISH));
        }
        if (CertificateRequestDialog.checkStringNotNullOrEmpty(car)) {
            adt.setCar(car.toUpperCase(Locale.ENGLISH));
        }
        crit.setAdditionalData(adt);
    }

    public static void readSetRootCertFile(List<File> rootCertFile, CertificateRequestInputType crit) {
        if (rootCertFile.size() == 1) {
            try {
                byte[] rootCertBytes = CertificateRequestDialog.readFileToByteArray(rootCertFile.get(0));
                crit.setRootCVC(rootCertBytes);
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(null, "Reading root certificate file failed", "Error", 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processCommonCerts(JTextField cdsnField, JTextField cdsuField, JTextArea cdtuField, JTextField cdruField, List<File> commCertFile, CertificateRequestInputType crit) throws IOException, UnsupportedEncodingException {
        ArrayList<byte[]> commCerts = null;
        if (!commCertFile.isEmpty()) {
            commCerts = new ArrayList<byte[]>(commCertFile.size());
            for (File f : commCertFile) {
                byte[] commCertBytes = CertificateRequestDialog.readFileToByteArray(f);
                commCerts.add(commCertBytes);
            }
        }
        String cdsnText = cdsnField.getText();
        String cdsuText = cdsuField.getText();
        String sep = "\n";
        String cdtuText = cdtuField.getText().replaceAll(sep, "\r\n");
        String cdruText = cdruField.getText();
        if (CertificateRequestDialog.checkStringNotNullOrEmpty(cdsnText) || CertificateRequestDialog.checkStringNotNullOrEmpty(cdsuText) || CertificateRequestDialog.checkStringNotNullOrEmpty(cdtuText) || CertificateRequestDialog.checkStringNotNullOrEmpty(cdruText) || commCerts != null) {
            try {
                CertificateDescription cd = new CertificateDescription("0.4.0.127.0.7.3.1.3.1.1", "", null, cdsnText != null ? cdsnText : "", CertificateRequestDialog.checkStringNotNullOrEmpty(cdsuText) ? cdsuText : null, CertificateDescriptionPath.TERMS_OF_USAGE_PLAIN_TEXT, CertificateRequestDialog.checkStringNotNullOrEmpty(cdtuText) ? cdtuText.getBytes("UTF-8") : new byte[]{}, CertificateRequestDialog.checkStringNotNullOrEmpty(cdruText) ? cdruText : null, commCerts, commCerts != null ? crit.getRootCVC() : null);
                crit.setCertificateDescription(cd.getEncoded());
            }
            catch (NoSuchProviderException noSuchProviderException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
    }

    private static boolean checkStringNotNullOrEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    private static void readSetOldKeyFile(List<File> oldKeyFile, CertificateRequestInputType crit) {
        if (oldKeyFile.size() == 1) {
            try {
                byte[] oldPrivateKeyBytes = CertificateRequestDialog.readFileToByteArray(oldKeyFile.get(0));
                crit.setOldPrivateKey(oldPrivateKeyBytes);
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(null, "Reading old key file failed", "Error", 0);
            }
        }
    }

    private static void readSetOldCertFile(List<File> oldCertFile, CertificateRequestInputType crit) {
        if (oldCertFile.size() == 1) {
            try {
                byte[] oldCertBytes = CertificateRequestDialog.readFileToByteArray(oldCertFile.get(0));
                crit.setOldCVC(oldCertBytes);
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(null, "Reading old certificate file failed", "Error", 0);
            }
        }
    }

    private static JPanel createEditPanel(JPanel mainPanel, JTextField rootCertField, List<File> rootCertFile, JTextField oldCertField, List<File> oldCertFile, JTextField oldKeyField, List<File> oldKeyFile, final JTextField chatMatrix, JTextField commCertField, List<File> commCertFile) {
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridLayout(11, 1));
        CertificateRequestDialog.createSelectRootCertButton(mainPanel, rootCertField, rootCertFile, editPanel);
        CertificateRequestDialog.createSelectOldCertButton(mainPanel, oldCertField, oldCertFile, editPanel);
        CertificateRequestDialog.createSelectOldKeyButton(mainPanel, oldKeyField, oldKeyFile, editPanel);
        editPanel.add(new JLabel());
        editPanel.add(new JLabel());
        JButton editChatMatrix = new JButton("edit");
        editPanel.add(editChatMatrix);
        editChatMatrix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel editMainPanel = new JPanel();
                editMainPanel.setLayout(new BorderLayout());
                JComboBox<ChatTerminalType> cb = new JComboBox<ChatTerminalType>(ChatTerminalType.values());
                cb.setRenderer(this.createChatTerminalTypeRenderer());
                editMainPanel.add(cb, "North");
                JPanel[] panels = new JPanel[ChatTerminalType.values().length];
                JScrollPane scr = new JScrollPane(20, 31);
                for (int i = 0; i < panels.length; ++i) {
                    Object co2;
                    List<ChatOption> optionsList = ChatOption.getOptions(ChatTerminalType.values()[i]);
                    HashSet<ChatCategory> categorySet = new HashSet<ChatCategory>();
                    if (!optionsList.isEmpty()) {
                        for (Object co2 : optionsList) {
                            if (categorySet.contains((Object)co2.getCategory())) continue;
                            categorySet.add(co2.getCategory());
                        }
                    }
                    panels[i] = new JPanel();
                    panels[i].setLayout(new GridLayout(!optionsList.isEmpty() ? Math.max(10, optionsList.size() + 5 + categorySet.size()) : 0, 1));
                    if (optionsList.isEmpty()) continue;
                    JButton resetToDefaultsTop = new JButton("reset to defaults");
                    resetToDefaultsTop.addActionListener(this.createResetToDefaultsTopActionListener(scr));
                    panels[i].add(resetToDefaultsTop);
                    co2 = optionsList.iterator();
                    while (co2.hasNext()) {
                        ChatOption chatOption = (ChatOption)((Object)co2.next());
                        JCheckBox chb = new JCheckBox(chatOption.getDescription(), chatOption.isDefaultSelected());
                        chb.putClientProperty("chatOption", (Object)chatOption);
                        panels[i].add(chb);
                    }
                    JButton resetToDefaultsBottom = new JButton("reset to defaults");
                    resetToDefaultsBottom.addActionListener(this.createResetToDefaultsBottomAchtionListener(scr));
                    panels[i].add(resetToDefaultsBottom);
                    JButton selectAll = new JButton("select all");
                    selectAll.addActionListener(this.createSelectAllActionListener(scr));
                    panels[i].add(selectAll);
                    JButton selectNone = new JButton("select none");
                    selectNone.addActionListener(this.createSelectNoneActionListener(scr));
                    panels[i].add(selectNone);
                    JButton selectOpposite = new JButton("select opposite");
                    selectOpposite.addActionListener(this.createSelectOppositeActionListener(scr));
                    panels[i].add(selectOpposite);
                    if (categorySet.size() > 1 && categorySet.contains((Object)ChatCategory.READ)) {
                        JButton selectRead = new JButton("select read");
                        selectRead.addActionListener(this.createSelectReadActionListener(scr));
                        panels[i].add(selectRead);
                    }
                    if (categorySet.size() > 1 && categorySet.contains((Object)ChatCategory.WRITE)) {
                        JButton selectWrite = new JButton("select write");
                        selectWrite.addActionListener(this.createSelectWriteActionListener(scr));
                        panels[i].add(selectWrite);
                    }
                    if (categorySet.size() <= 1 || !categorySet.contains((Object)ChatCategory.OTHER)) continue;
                    JButton selectOther = new JButton("select other");
                    selectOther.addActionListener(this.createSelectOtherActionListener(scr));
                    panels[i].add(selectOther);
                }
                cb.putClientProperty("panels", panels);
                scr.add(panels[0]);
                scr.putClientProperty("currentPanel", panels[0]);
                cb.addItemListener(this.createChatTerminalTypeItemListener(editMainPanel, cb, scr));
                Dimension d = new Dimension(400, 250);
                scr.setMinimumSize(d);
                scr.setPreferredSize(d);
                scr.setSize(d);
                editMainPanel.add(scr);
                int execute = JOptionPane.showOptionDialog(null, editMainPanel, "Specify Chat Matrix", 2, 3, null, null, null);
                if (0 == execute) {
                    ChatTerminalType terminalType = (ChatTerminalType)((Object)cb.getSelectedItem());
                    byte[] chatMatrixBytes = new byte[terminalType.getByteMatrixCount()];
                    Arrays.fill(chatMatrixBytes, (byte)0);
                    JPanel p = (JPanel)scr.getClientProperty("currentPanel");
                    if (p.getComponentCount() > 1) {
                        for (Component c : p.getComponents()) {
                            if (!JCheckBox.class.isInstance(c)) continue;
                            JCheckBox chb = (JCheckBox)c;
                            ChatOption co = (ChatOption)((Object)chb.getClientProperty("chatOption"));
                            if (!chb.isSelected()) continue;
                            ByteUtil.setBits(chatMatrixBytes, co.getByteIndex(), co.getByteMask());
                        }
                    }
                    try {
                        chatMatrix.setText(HexUtil.hexify(((ChatTerminalType)((Object)cb.getSelectedItem())).getOid() != null ? CertificateHolderAuthorizationTemplate.createFromOIDAndChatMatrix(((ChatTerminalType)((Object)cb.getSelectedItem())).getOid(), chatMatrixBytes).getEncoded() : null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            private ItemListener createChatTerminalTypeItemListener(final JPanel editMainPanel, final JComboBox<ChatTerminalType> cb, final JScrollPane scr) {
                return new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        SwingUtil.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                scr.remove((JPanel)scr.getClientProperty("currentPanel"));
                                JPanel p = ((JPanel[])cb.getClientProperty("panels"))[cb.getSelectedIndex()];
                                scr.add((Component)p, 0);
                                scr.setViewportView(p);
                                scr.putClientProperty("currentPanel", p);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JDialog d = (JDialog)SwingUtilities.getRoot(editMainPanel);
                                        SwingUtilities.updateComponentTreeUI(d);
                                    }
                                });
                            }
                        });
                    }
                };
            }

            private ActionListener createSelectOtherActionListener(final JScrollPane scr) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JPanel p = (JPanel)scr.getClientProperty("currentPanel");
                        if (p.getComponentCount() > 1) {
                            for (Component c : p.getComponents()) {
                                JCheckBox chb;
                                if (!JCheckBox.class.isInstance(c)) continue;
                                ChatOption co = (ChatOption)((Object)(chb = (JCheckBox)c).getClientProperty("chatOption"));
                                chb.setSelected(ChatCategory.OTHER == co.getCategory());
                            }
                        }
                    }
                };
            }

            private ActionListener createSelectWriteActionListener(final JScrollPane scr) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JPanel p = (JPanel)scr.getClientProperty("currentPanel");
                        if (p.getComponentCount() > 1) {
                            for (Component c : p.getComponents()) {
                                JCheckBox chb;
                                if (!JCheckBox.class.isInstance(c)) continue;
                                ChatOption co = (ChatOption)((Object)(chb = (JCheckBox)c).getClientProperty("chatOption"));
                                chb.setSelected(ChatCategory.WRITE == co.getCategory());
                            }
                        }
                    }
                };
            }

            private ActionListener createSelectReadActionListener(final JScrollPane scr) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JPanel p = (JPanel)scr.getClientProperty("currentPanel");
                        if (p.getComponentCount() > 1) {
                            for (Component c : p.getComponents()) {
                                JCheckBox chb;
                                if (!JCheckBox.class.isInstance(c)) continue;
                                ChatOption co = (ChatOption)((Object)(chb = (JCheckBox)c).getClientProperty("chatOption"));
                                chb.setSelected(ChatCategory.READ == co.getCategory());
                            }
                        }
                    }
                };
            }

            private ActionListener createSelectOppositeActionListener(final JScrollPane scr) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JPanel p = (JPanel)scr.getClientProperty("currentPanel");
                        if (p.getComponentCount() > 1) {
                            for (Component c : p.getComponents()) {
                                JCheckBox chb;
                                if (!JCheckBox.class.isInstance(c)) continue;
                                chb.setSelected(!(chb = (JCheckBox)c).isSelected());
                            }
                        }
                    }
                };
            }

            private ActionListener createSelectNoneActionListener(final JScrollPane scr) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JPanel p = (JPanel)scr.getClientProperty("currentPanel");
                        if (p.getComponentCount() > 1) {
                            for (Component c : p.getComponents()) {
                                if (!JCheckBox.class.isInstance(c)) continue;
                                JCheckBox chb = (JCheckBox)c;
                                chb.setSelected(false);
                            }
                        }
                    }
                };
            }

            private ActionListener createSelectAllActionListener(final JScrollPane scr) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JPanel p = (JPanel)scr.getClientProperty("currentPanel");
                        if (p.getComponentCount() > 1) {
                            for (Component c : p.getComponents()) {
                                if (!JCheckBox.class.isInstance(c)) continue;
                                JCheckBox chb = (JCheckBox)c;
                                chb.setSelected(true);
                            }
                        }
                    }
                };
            }

            private ActionListener createResetToDefaultsTopActionListener(final JScrollPane scr) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JPanel p = (JPanel)scr.getClientProperty("currentPanel");
                        if (p.getComponentCount() > 1) {
                            for (Component c : p.getComponents()) {
                                if (!JCheckBox.class.isInstance(c)) continue;
                                JCheckBox chb = (JCheckBox)c;
                                ChatOption co = (ChatOption)((Object)chb.getClientProperty("chatOption"));
                                chb.setSelected(co.isDefaultSelected());
                            }
                        }
                    }
                };
            }

            private ActionListener createResetToDefaultsBottomAchtionListener(final JScrollPane scr) {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JPanel p = (JPanel)scr.getClientProperty("currentPanel");
                        if (p.getComponentCount() > 1) {
                            for (Component c : p.getComponents()) {
                                if (!JCheckBox.class.isInstance(c)) continue;
                                JCheckBox chb = (JCheckBox)c;
                                ChatOption co = (ChatOption)((Object)chb.getClientProperty("chatOption"));
                                chb.setSelected(co.isDefaultSelected());
                            }
                        }
                    }
                };
            }

            private DefaultListCellRenderer createChatTerminalTypeRenderer() {
                return new DefaultListCellRenderer(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        if (ChatTerminalType.class.isInstance(value) && JLabel.class.isInstance(c)) {
                            ((JLabel)c).setText(((ChatTerminalType)((Object)value)).getDescription());
                        }
                        return c;
                    }
                };
            }
        });
        editPanel.add(new JLabel());
        editPanel.add(new JLabel());
        editPanel.add(new JLabel());
        editPanel.add(new JLabel());
        CertificateRequestDialog.createSelectCommonCertsButton(mainPanel, commCertField, commCertFile, editPanel);
        return editPanel;
    }

    private static void createSelectCommonCertsButton(final JPanel mainPanel, final JTextField commCertField, final List<File> commCertFile, JPanel editPanel) {
        JButton selectCommCerts = new JButton("select");
        editPanel.add(selectCommCerts);
        selectCommCerts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setMultiSelectionEnabled(true);
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    commCertFile.clear();
                    commCertFile.addAll(Arrays.asList(chooser.getSelectedFiles()));
                    Object selectedFiles = "";
                    for (File f : chooser.getSelectedFiles()) {
                        selectedFiles = (String)selectedFiles + f.getPath() + ",";
                    }
                    if (((String)selectedFiles).endsWith(",")) {
                        selectedFiles = ((String)selectedFiles).substring(0, ((String)selectedFiles).length() - 1);
                    }
                    commCertField.setText((String)selectedFiles);
                }
            }
        });
    }

    private static void createSelectRootCertButton(final JPanel mainPanel, final JTextField rootCertField, final List<File> rootCertFile, JPanel editPanel) {
        JButton selectRootCert = new JButton("select");
        editPanel.add(selectRootCert);
        selectRootCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    rootCertFile.clear();
                    rootCertFile.add(chooser.getSelectedFile());
                    rootCertField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
    }

    private static void createSelectOldCertButton(final JPanel mainPanel, final JTextField oldCertField, final List<File> oldCertFile, JPanel editPanel) {
        JButton selectOldCert = new JButton("select");
        editPanel.add(selectOldCert);
        selectOldCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    oldCertFile.clear();
                    oldCertFile.add(chooser.getSelectedFile());
                    oldCertField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
    }

    private static void createSelectOldKeyButton(final JPanel mainPanel, final JTextField oldKeyField, final List<File> oldKeyFile, JPanel editPanel) {
        JButton selectOldKey = new JButton("select");
        editPanel.add(selectOldKey);
        selectOldKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    oldKeyFile.clear();
                    oldKeyFile.add(chooser.getSelectedFile());
                    oldKeyField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
    }

    private static JPanel createLabelPanel() {
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(11, 1));
        labelPanel.add(new JLabel("Root Certificate (always required): "));
        labelPanel.add(new JLabel("Old Certificate (required for follow-up requests): "));
        labelPanel.add(new JLabel("Old Private Key (required if not connected to HSM containing the key, only for follow-up requests): "));
        labelPanel.add(new JLabel("Certificate Holder Reference (required for initial, optional for follow-up): "));
        labelPanel.add(new JLabel("Certification Authority Reference (optional): "));
        labelPanel.add(new JLabel("Certificate Holder Authorization Template - (HexString - required for initial, optional for follow-up): "));
        labelPanel.add(new JLabel("Certificate Description - subjectName (optional):"));
        labelPanel.add(new JLabel("Certificate Description - subjectURL (optional):"));
        labelPanel.add(new JLabel("Certificate Description - termsOfUsage (optional):"));
        labelPanel.add(new JLabel("Certificate Description - redirectURL (optional):"));
        labelPanel.add(new JLabel("Certificate Description - communication certificates (optional):"));
        return labelPanel;
    }

    private static byte[] readFileToByteArray(File f) throws IllegalArgumentException, IOException {
        AssertUtil.notNull(f, "file");
        long fileLength = f.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("file too long for single byte array");
        }
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] target = new byte[(int)fileLength];
            int offset = 0;
            int bytesRead = 0;
            while ((long)offset < fileLength && bytesRead != -1) {
                bytesRead = fis.read(target, offset, (int)fileLength - offset);
                offset += bytesRead;
            }
            if (bytesRead == -1 && (long)offset != fileLength - 1L) {
                throw new IOException("error in reading file");
            }
            byte[] byArray = target;
            return byArray;
        }
    }
}

