/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.ASN1Path;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.OIDPublicKey;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.CertificateRequestPath;
import de.bos_bremen.gov2.jca_provider.service.ServiceRegistry;
import de.bos_bremen.gov2.jca_provider.service.hsm.HSMServiceFactory;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.BOSHSMSimulatorService;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMException;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMService;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;

public class CertificateRequest
extends ASN1 {
    public CertificateRequest(CertificateRequest asn1) throws NullPointerException {
        super(asn1);
        this.check();
    }

    public CertificateRequest(byte[] valueBytes) throws IOException {
        super(CertificateRequestPath.AUTHENTICATION.getTag().toByteArray(), valueBytes);
        this.check();
    }

    public CertificateRequest(InputStream stream) throws IOException {
        super(stream);
        this.check();
    }

    public CertificateRequest(InputStream stream, boolean close) throws IOException {
        super(stream, close);
        this.check();
    }

    private void check() {
        if (!Arrays.equals(CertificateRequestPath.AUTHENTICATION.getTag().toByteArray(), this.getDTagBytes()) && !Arrays.equals(CertificateRequestPath.CV_CERTIFICATE.getTag().toByteArray(), this.getDTagBytes())) {
            throw new IllegalArgumentException("ASN.1 does not represent a certificate request");
        }
    }

    @Override
    public ASN1 getChildElementByPath(ASN1Path part) throws IOException {
        if (!CertificateRequestPath.class.isInstance(part)) {
            throw new IllegalArgumentException("only CertificateRequestPath permitted");
        }
        return super.getChildElementByPath(part);
    }

    public ASN1 getRequestPart(CertificateRequestPath path) throws IOException {
        return super.getChildElementByPath(path);
    }

    @Override
    public ASN1 decode(byte[] bytes) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        CertificateRequest result = new CertificateRequest(bytes);
        super.decode(result);
        return this;
    }

    public void signCVCBody(PublicKey publicKey, String alias) throws UnsupportedOperationException, IllegalArgumentException, IOException, UnrecoverableKeyException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, CertificateException, SignatureException, InvalidKeySpecException, HSMException {
        AssertUtil.notNull(publicKey, "public key");
        AssertUtil.notNullOrEmpty(alias, "alias");
        if (!OIDPublicKey.class.isInstance(publicKey)) {
            throw new IllegalArgumentException("only " + OIDPublicKey.class + " permitted");
        }
        this.setCVCPublicKey(publicKey);
        byte[] body = ByteUtil.copy(this.getChildElementByPath(CertificateRequestPath.CV_CERTIFICATE_BODY).getEncoded());
        HSMService hsm = ServiceRegistry.Util.getServiceRegistry().getService(HSMServiceFactory.class).getHSMService();
        byte[] signed = hsm.sign(alias, ((OIDPublicKey)((Object)publicKey)).getOID(), body);
        this.setCVCSignature(signed);
    }

    private void setCVCPublicKey(PublicKey publicKey) throws UnsupportedOperationException, IOException, IllegalArgumentException {
        AssertUtil.notNull(publicKey, "public key");
        if (!OIDPublicKey.class.isInstance(publicKey)) {
            throw new IllegalArgumentException("only " + OIDPublicKey.class + " permitted");
        }
        this.getChildElementByPath(CertificateRequestPath.CV_CERTIFICATE_BODY).replaceChildElement(this.getChildElementByPath(CertificateRequestPath.PUBLIC_KEY), new ASN1(((OIDPublicKey)((Object)publicKey)).getEncodedWithOID()), this);
    }

    private void setCVCSignature(byte[] signature) throws UnsupportedOperationException, IOException, IllegalArgumentException {
        AssertUtil.notNullOrEmpty(signature, "signature");
        this.getChildElementByPath(CertificateRequestPath.CV_CERTIFICATE).removeChildElement(this.getChildElementByPath(CertificateRequestPath.SIGNATURE), this);
        this.getChildElementByPath(CertificateRequestPath.CV_CERTIFICATE).addChildElement(new ASN1(CertificateRequestPath.SIGNATURE.getTag().toByteArray(), signature), this);
    }

    public void signRequest(String oldPrivKeyAlias, OID algOID, boolean useGivenKey) throws IllegalArgumentException, UnsupportedOperationException, IOException, UnrecoverableKeyException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, CertificateException, SignatureException, InvalidKeySpecException, HSMException {
        AssertUtil.notNullOrEmpty(oldPrivKeyAlias, "alias of private key for signing");
        AssertUtil.notNull(algOID, "OID of signature algorithm");
        byte[] combinedBytes = null;
        for (ASN1 asn1 : this.getChildElementList()) {
            combinedBytes = ByteUtil.combine(combinedBytes, asn1.getEncoded());
        }
        HSMService hsm = null;
        hsm = useGivenKey ? (HSMService)ServiceRegistry.Util.getServiceRegistry().getService(BOSHSMSimulatorService.class) : ServiceRegistry.Util.getServiceRegistry().getService(HSMServiceFactory.class).getHSMService();
        byte[] signed = hsm.sign(oldPrivKeyAlias, algOID, combinedBytes);
        this.setOuterSignature(signed);
    }

    private void setOuterSignature(byte[] signature) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        AssertUtil.notNullOrEmpty(signature, "signature");
        this.removeChildElement(this.getChildElementByPath(CertificateRequestPath.OUTER_SIGNATURE), this);
        this.addChildElement(new ASN1(CertificateRequestPath.SIGNATURE.getTag().toByteArray(), signature), this);
    }

    @Override
    public boolean isSequence() {
        return true;
    }
}

