/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc;

import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import de.bos_bremen.common.asn1.cvc.ECCVCertificate;
import de.bos_bremen.common.constants.OIDConstants;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.cvc.OIDPublicKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyHandlerEC;
import de.bos_bremen.gov2.jca_provider.service.ServiceRegistry;
import de.bos_bremen.gov2.jca_provider.service.hsm.HSMServiceFactory;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMException;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMService;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class CVCKeyPairBuilder {
    public static KeyPair generateKeyPair(ECCVCertificate cert, String alias, boolean replace) throws IllegalArgumentException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException, KeyStoreException, CertificateException, HSMException {
        KeyHandlerEC kh = null;
        String algorithm = null;
        ECParameterSpec spec = null;
        HSMService hsm = ServiceRegistry.Util.getServiceRegistry().getService(HSMServiceFactory.class).getHSMService();
        if (cert == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        OID oid = (OID)cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_OID);
        if (!(oid.equals(OIDConstants.OID_TA_ECDSA_SHA_1) || oid.equals(OIDConstants.OID_TA_ECDSA_SHA_224) || oid.equals(OIDConstants.OID_TA_ECDSA_SHA_256))) {
            throw new UnsupportedOperationException("other algorithms not supported at this time");
        }
        kh = new KeyHandlerEC();
        algorithm = "EC";
        spec = KeyHandlerEC.parameterSpecFromCVC(cert, ECParameterSpec.class);
        KeyPair kp = hsm.generateKeyPair(algorithm, (AlgorithmParameterSpec)spec, alias, replace);
        OIDPublicKeyImpl pk = new OIDPublicKeyImpl(kp.getPublic(), kh, oid);
        return new KeyPair(pk, kp.getPrivate());
    }
}

